/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.List;
import jline.ConsoleReader;
import jline.Terminal;
import jline.WindowsTerminal;
import org.python.constantine.platform.Errno;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.InteractiveConsole;

public class JLineConsole
extends InteractiveConsole {
    protected ConsoleReader reader;
    private boolean windows;
    protected static final String CTRL_Z = "\u001a";
    private static final List<String> SUSPENDED_STRERRORS = Arrays.asList(Errno.EINTR.description(), Errno.EIO.description());

    public JLineConsole() {
        this(null);
    }

    public JLineConsole(PyObject locals) {
        this(locals, "<stdin>");
        try {
            File historyFile = new File(System.getProperty("user.home"), ".jline-jython.history");
            this.reader.getHistory().setHistoryFile(historyFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public JLineConsole(PyObject locals, String filename) {
        super(locals, filename, true);
        System.setProperty("jline.UnixTerminal.input.encoding", "ISO-8859-1");
        System.setProperty("jline.WindowsTerminal.input.encoding", "ISO-8859-1");
        Terminal.setupTerminal();
        try {
            FileInputStream input = new FileInputStream(FileDescriptor.in);
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), "ISO-8859-1");
            this.reader = new ConsoleReader(input, output, this.getBindings());
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.windows = this.reader.getTerminal() instanceof WindowsTerminal;
    }

    protected InputStream getBindings() {
        String userBindings = new File(System.getProperty("user.home"), ".jlinebindings.properties").getAbsolutePath();
        File bindingsFile = new File(System.getProperty("jline.keybindings", userBindings));
        try {
            if (bindingsFile.isFile()) {
                try {
                    return new FileInputStream(bindingsFile);
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return this.getClass().getResourceAsStream("jline-keybindings.properties");
    }

    public String raw_input(PyObject prompt) {
        String line = null;
        String promptString = prompt.toString();
        while (true) {
            try {
                line = this.reader.readLine(promptString);
            }
            catch (IOException ioe) {
                if (!this.fromSuspend(ioe)) {
                    throw Py.IOError(ioe);
                }
                try {
                    this.reader.getTerminal().initializeTerminal();
                }
                catch (Exception e2) {
                    throw Py.IOError(e2.getMessage());
                }
                promptString = "";
                continue;
            }
            break;
        }
        if (this.isEOF(line)) {
            throw Py.EOFError("");
        }
        return line;
    }

    private boolean fromSuspend(IOException ioe) {
        return !this.windows && SUSPENDED_STRERRORS.contains(ioe.getMessage());
    }

    private boolean isEOF(String line) {
        return line == null || this.windows && CTRL_Z.equals(line);
    }
}

