/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.SyspathArchive;
import org.python.core.util.RelativeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyspathJavaLoader
extends ClassLoader {
    private static final char SLASH_CHAR = '/';

    @Override
    public InputStream getResourceAsStream(String res) {
        Py.writeDebug("resource", "trying resource: " + res);
        PySystemState sys = Py.getSystemState();
        ClassLoader classLoader = sys.getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(res);
        }
        classLoader = Thread.currentThread().getContextClassLoader();
        InputStream ret = classLoader != null ? classLoader.getResourceAsStream(res) : ClassLoader.getSystemResourceAsStream(res);
        if (ret != null) {
            return ret;
        }
        if (res.charAt(0) == '/') {
            res = res.substring(1);
        }
        String entryRes = res;
        if (File.separatorChar != '/') {
            res = res.replace('/', File.separatorChar);
            entryRes = entryRes.replace(File.separatorChar, '/');
        }
        PyList path = sys.path;
        for (int i2 = 0; i2 < path.__len__(); ++i2) {
            PyObject entry = SyspathJavaLoader.replacePathItem(sys, i2, path);
            if (entry instanceof SyspathArchive) {
                SyspathArchive archive = (SyspathArchive)entry;
                ZipEntry ze = archive.getEntry(entryRes);
                if (ze == null) continue;
                try {
                    return archive.getInputStream(ze);
                }
                catch (IOException e2) {
                    continue;
                }
            }
            String dir2 = sys.getPath(entry.__str__().toString());
            try {
                return new BufferedInputStream(new FileInputStream(new File(dir2, res)));
            }
            catch (IOException e3) {
                // empty catch block
            }
        }
        return null;
    }

    static PyObject replacePathItem(PySystemState sys, int idx, PyList paths) {
        PyObject path = paths.__getitem__(idx);
        if (path instanceof SyspathArchive) {
            return path;
        }
        try {
            path = new SyspathArchive(sys.getPath(path.toString()));
        }
        catch (Exception e2) {
            return path;
        }
        paths.__setitem__(idx, path);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        PySystemState sys = Py.getSystemState();
        ClassLoader classLoader = sys.getClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e2) {
            try {
                return Class.forName(name, true, ClassLoader.getSystemClassLoader());
            }
            catch (ClassNotFoundException e3) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            Class<?> c2 = this.findLoadedClass(name);
            if (c2 != null) {
                return c2;
            }
            PyList path = sys.path;
            for (int i2 = 0; i2 < path.__len__(); ++i2) {
                void nread;
                void var13_21;
                void fis;
                int ze;
                Object entry222222;
                PyObject pyObject = SyspathJavaLoader.replacePathItem(sys, i2, path);
                if (pyObject instanceof SyspathArchive) {
                    SyspathArchive syspathArchive = (SyspathArchive)pyObject;
                    entry222222 = name.replace('.', '/') + ".class";
                    ZipEntry archive = syspathArchive.getEntry((String)entry222222);
                    if (archive == null) continue;
                    try {
                        InputStream entryname = syspathArchive.getInputStream(archive);
                        ze = (int)archive.getSize();
                    }
                    catch (IOException exc) {
                        continue;
                    }
                }
                Object size = fis.__str__().toString();
                entry222222 = this.getFile((String)size, name);
                if (entry222222 == null) continue;
                try {
                    ze = (int)((File)entry222222).length();
                    FileInputStream file = new FileInputStream((File)entry222222);
                }
                catch (FileNotFoundException dir2) {
                    continue;
                }
                catch (SecurityException dir2) {
                    continue;
                }
                size = new byte[var13_21];
                for (int entry222222 = 0; entry222222 < var13_21; entry222222 += nread.read((byte[])size, entry222222, (int)(var13_21 - entry222222))) {
                }
                nread.close();
                Class<?> buffer = this.loadClassFromBytes(name, (byte[])size);
                try {
                    nread.close();
                }
                catch (IOException e4) {
                    // empty catch block
                }
                return buffer;
                catch (IOException size23232232322) {
                    void var12_20;
                    try {
                        var12_20.close();
                    }
                    catch (IOException size23232232322) {}
                    continue;
                    catch (Throwable throwable) {
                        try {
                            var12_20.close();
                        }
                        catch (IOException e5) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    private File getFile(String dir2, String name) {
        String accum = "";
        boolean first = true;
        StringTokenizer t = new StringTokenizer(name, ".");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (!first) {
                accum = accum + File.separator;
            }
            accum = accum + token;
            first = false;
        }
        return new RelativeFile(dir2, accum + ".class");
    }

    private Class<?> loadClassFromBytes(String name, byte[] data) {
        Class<?> c2 = this.defineClass(name, data, 0, data.length);
        this.resolveClass(c2);
        Compiler.compileClass(c2);
        return c2;
    }
}

