/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyType;
import org.python.core.PyXRange$PyExposer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="xrange", base=PyObject.class, isBaseType=false)
public class PyXRange
extends PySequence {
    public static final PyType TYPE;
    private int start;
    private int step;
    private int len;

    public PyXRange(int ihigh) {
        this(0, ihigh, 1);
    }

    public PyXRange(int ilow, int ihigh) {
        this(ilow, ihigh, 1);
    }

    public PyXRange(int ilow, int ihigh, int istep) {
        super(TYPE);
        if (istep == 0) {
            throw Py.ValueError("xrange() arg 3 must not be zero");
        }
        int n2 = istep > 0 ? PyXRange.getLenOfRange(ilow, ihigh, istep) : PyXRange.getLenOfRange(ihigh, ilow, -istep);
        if (n2 < 0) {
            throw Py.OverflowError("xrange() result has too many items");
        }
        this.start = ilow;
        this.len = n2;
        this.step = istep;
    }

    @ExposedNew
    static final PyObject xrange___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        int ihigh;
        int istep;
        ArgParser ap = new ArgParser("xrange", args, keywords, new String[]{"ilow", "ihigh", "istep"}, 1);
        ap.noKeywords();
        int ilow = 0;
        boolean bl = true;
        if (args.length == 1) {
            istep = ap.getInt(0);
        } else {
            ilow = ap.getInt(0);
            istep = ap.getInt(1);
            ihigh = ap.getInt(2, 1);
        }
        return new PyXRange(ilow, istep, ihigh);
    }

    static int getLenOfRange(int lo, int hi, int step) {
        int n2 = 0;
        if (lo < hi) {
            long diff = (long)hi - (long)lo - 1L;
            n2 = (int)(diff / (long)step + 1L);
        }
        return n2;
    }

    public int __len__() {
        return this.xrange___len__();
    }

    final int xrange___len__() {
        return this.len;
    }

    public PyObject __getitem__(PyObject index) {
        return this.xrange___getitem__(index);
    }

    final PyObject xrange___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("xrange object index out of range");
        }
        return ret;
    }

    public PyObject xrange___iter__() {
        return this.seq___iter__();
    }

    protected PyObject pyget(int i2) {
        return Py.newInteger(this.start + i2 % this.len * this.step);
    }

    protected PyObject getslice(int start, int stop, int step) {
        return null;
    }

    protected PyObject repeat(int howmany) {
        return null;
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void rtn;
        int n2 = this.start + this.len * this.step;
        String stop = this.start == 0 && this.step == 1 ? String.format("xrange(%d)", n2) : (this.step == 1 ? String.format("xrange(%d, %d)", this.start, (int)rtn) : String.format("xrange(%d, %d, %d)", this.start, (int)rtn, this.step));
        return stop;
    }

    static {
        PyType.addBuilder(PyXRange.class, new PyXRange$PyExposer());
        TYPE = PyType.fromClass(PyXRange.class);
    }
}

