/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyStringMap
extends PyObject {
    private final ConcurrentMap<Object, PyObject> table;

    public PyStringMap() {
        this(4);
    }

    public PyStringMap(int capacity) {
        this.table = new ConcurrentHashMap<Object, PyObject>(capacity, 0.75f, 2);
    }

    public PyStringMap(Map<Object, PyObject> map) {
        this.table = Generic.concurrentMap();
        this.table.putAll(map);
    }

    public PyStringMap(PyObject[] elements) {
        this(elements.length);
        for (int i2 = 0; i2 < elements.length; i2 += 2) {
            this.__setitem__(elements[i2], elements[i2 + 1]);
        }
    }

    @Override
    public int __len__() {
        return this.table.size();
    }

    @Override
    public boolean __nonzero__() {
        return this.table.size() != 0;
    }

    @Override
    public PyObject __finditem__(String key) {
        if (key == null) {
            return null;
        }
        return (PyObject)this.table.get(key);
    }

    @Override
    public PyObject __finditem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__finditem__(((PyString)key).internedString());
        }
        return (PyObject)this.table.get(key);
    }

    public PyObject __getitem__(String key) {
        PyObject o2 = this.__finditem__(key);
        if (null == o2) {
            throw Py.KeyError("'" + key + "'");
        }
        return o2;
    }

    @Override
    public PyObject __getitem__(PyObject key) {
        if (key instanceof PyString) {
            return this.__getitem__(((PyString)key).internedString());
        }
        PyObject o2 = this.__finditem__(key);
        if (null == o2) {
            throw Py.KeyError("'" + key.toString() + "'");
        }
        return o2;
    }

    @Override
    public PyObject __iter__() {
        return this.iterkeys();
    }

    @Override
    public void __setitem__(String key, PyObject value) {
        if (value == null) {
            this.table.remove(key);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        if (value == null) {
            this.table.remove(PyStringMap.pyToKey(key));
        } else if (key instanceof PyString) {
            this.__setitem__(((PyString)key).internedString(), value);
        } else {
            this.table.put(key, value);
        }
    }

    @Override
    public void __delitem__(String key) {
        Object ret = this.table.remove(key);
        if (ret == null) {
            throw Py.KeyError(key);
        }
    }

    @Override
    public void __delitem__(PyObject key) {
        if (key instanceof PyString) {
            this.__delitem__(((PyString)key).internedString());
        } else {
            Object ret = this.table.remove(key);
            if (ret == null) {
                throw Py.KeyError(key.toString());
            }
        }
    }

    public void clear() {
        this.table.clear();
    }

    @Override
    public String toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "{...}";
        }
        StringBuilder buf = new StringBuilder("{");
        for (Map.Entry entry : this.table.entrySet()) {
            Object key = entry.getKey();
            if (key instanceof String) {
                buf.append(new PyString((String)key).__repr__().toString());
            } else {
                buf.append(((PyObject)key).__repr__().toString());
            }
            buf.append(": ");
            buf.append(((PyObject)entry.getValue()).__repr__().toString());
            buf.append(", ");
        }
        if (buf.length() > 1) {
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append("}");
        ts.exitRepr(this);
        return buf.toString();
    }

    @Override
    public int __cmp__(PyObject other) {
        int bn;
        if (!(other instanceof PyStringMap) && !(other instanceof PyDictionary)) {
            return -2;
        }
        int an = this.__len__();
        if (an < (bn = other.__len__())) {
            return -1;
        }
        if (an > bn) {
            return 1;
        }
        PyList akeys = this.keys();
        PyList bkeys = null;
        bkeys = other instanceof PyStringMap ? ((PyStringMap)other).keys() : ((PyDictionary)other).keys();
        akeys.sort();
        bkeys.sort();
        for (int i2 = 0; i2 < bn; ++i2) {
            PyObject bvalue;
            PyObject bkey;
            PyObject akey = akeys.pyget(i2);
            int c2 = akey._cmp(bkey = bkeys.pyget(i2));
            if (c2 != 0) {
                return c2;
            }
            PyObject avalue = this.__finditem__(akey);
            c2 = avalue._cmp(bvalue = other.__finditem__(bkey));
            if (c2 == 0) continue;
            return c2;
        }
        return 0;
    }

    public boolean has_key(String key) {
        return this.table.containsKey(key);
    }

    public boolean has_key(PyObject key) {
        return this.table.containsKey(PyStringMap.pyToKey(key));
    }

    public PyObject get(PyObject key, PyObject default_object) {
        PyObject o2 = this.__finditem__(key);
        if (o2 == null) {
            return default_object;
        }
        return o2;
    }

    public PyObject get(PyObject key) {
        return this.get(key, Py.None);
    }

    public PyStringMap copy() {
        return new PyStringMap(this.table);
    }

    public void update(PyObject[] args, String[] keywords) {
        int nargs = args.length - keywords.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, "update", 0, 1);
        }
        if (nargs == 1) {
            PyObject arg = args[0];
            if (arg.__findattr__("keys") != null) {
                this.merge(arg);
            } else {
                this.mergeFromSeq(arg);
            }
        }
        for (int i2 = 0; i2 < keywords.length; ++i2) {
            this.__setitem__(keywords[i2], args[nargs + i2]);
        }
    }

    private void merge(PyObject other) {
        if (other instanceof PyStringMap) {
            this.table.putAll(((PyStringMap)other).table);
        } else if (other instanceof PyDictionary) {
            this.mergeFromKeys(other, ((PyDictionary)other).keys());
        } else {
            this.mergeFromKeys(other, other.invoke("keys"));
        }
    }

    private void mergeFromKeys(PyObject other, PyObject keys) {
        for (PyObject key : keys.asIterable()) {
            this.__setitem__(key, other.__getitem__(key));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeFromSeq(PyObject other) {
        PyObject i2;
        PyObject pairs = other.__iter__();
        boolean bl = false;
        while ((i2 = pairs.__iternext__()) != null) {
            void pair;
            try {
                i2 = PySequence.fastSequence(i2, "");
            }
            catch (PyException pye) {
                if (pye.match(Py.TypeError)) {
                    throw Py.TypeError(String.format("cannot convert dictionary update sequence element #%d to a sequence", (int)pair));
                }
                throw pye;
            }
            int n2 = i2.__len__();
            if (n2 != 2) {
                throw Py.ValueError(String.format("dictionary update sequence element #%d has length %d; 2 is required", (int)pair, n2));
            }
            this.__setitem__(i2.__getitem__(0), i2.__getitem__(1));
            ++pair;
        }
    }

    public PyObject setdefault(PyObject key) {
        return this.setdefault(key, Py.None);
    }

    public PyObject setdefault(PyObject key, PyObject failobj) {
        Object internedKey = key instanceof PyString ? ((PyString)key).internedString() : key;
        PyObject oldValue = this.table.putIfAbsent(internedKey, failobj);
        if (oldValue == null) {
            return failobj;
        }
        return oldValue;
    }

    public PyObject popitem() {
        Iterator it = this.table.entrySet().iterator();
        if (!it.hasNext()) {
            throw Py.KeyError("popitem(): dictionary is empty");
        }
        PyTuple tuple = this.itemTuple(it.next());
        it.remove();
        return tuple;
    }

    public PyObject pop(PyObject key) {
        if (this.table.size() == 0) {
            throw Py.KeyError("pop(): dictionary is empty");
        }
        return this.pop(key, null);
    }

    public PyObject pop(PyObject key, PyObject failobj) {
        PyObject value = (PyObject)this.table.remove(PyStringMap.pyToKey(key));
        if (value == null) {
            if (failobj == null) {
                throw Py.KeyError(key.__repr__().toString());
            }
            return failobj;
        }
        return value;
    }

    public PyList items() {
        return new PyList(this.iteritems());
    }

    private PyTuple itemTuple(Map.Entry<Object, PyObject> entry) {
        return new PyTuple(PyStringMap.keyToPy(entry.getKey()), entry.getValue());
    }

    public PyList keys() {
        PyObject[] keyArray = new PyObject[this.table.size()];
        int i2 = 0;
        for (Object key : this.table.keySet()) {
            keyArray[i2++] = PyStringMap.keyToPy(key);
        }
        return new PyList(keyArray);
    }

    public PyList values() {
        return new PyList(this.table.values());
    }

    public PyObject iteritems() {
        return new ItemsIter(this.table.entrySet());
    }

    public PyObject iterkeys() {
        return new KeysIter(this.table.keySet());
    }

    public PyObject itervalues() {
        return new ValuesIter(this.table.values());
    }

    private static PyObject keyToPy(Object objKey) {
        if (objKey instanceof String) {
            return PyString.fromInterned((String)objKey);
        }
        return (PyObject)objKey;
    }

    private static Object pyToKey(PyObject pyKey) {
        if (pyKey instanceof PyString) {
            return ((PyString)pyKey).internedString();
        }
        return pyKey;
    }

    @Override
    public int hashCode() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemsIter
    extends StringMapIter<Map.Entry<Object, PyObject>> {
        public ItemsIter(Set<Map.Entry<Object, PyObject>> s) {
            super(s);
        }

        @Override
        public PyObject stringMapNext() {
            return PyStringMap.this.itemTuple((Map.Entry)this.iterator.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysIter
    extends StringMapIter<Object> {
        public KeysIter(Set<Object> s) {
            super(s);
        }

        @Override
        protected PyObject stringMapNext() {
            return PyStringMap.keyToPy(this.iterator.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIter
    extends StringMapIter<PyObject> {
        public ValuesIter(Collection<PyObject> c2) {
            super(c2);
        }

        @Override
        public PyObject stringMapNext() {
            return (PyObject)this.iterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class StringMapIter<T>
    extends PyIterator {
        protected final Iterator<T> iterator;
        private final int size;

        public StringMapIter(Collection<T> c2) {
            this.iterator = c2.iterator();
            this.size = c2.size();
        }

        @Override
        public PyObject __iternext__() {
            if (PyStringMap.this.table.size() != this.size) {
                throw Py.RuntimeError("dictionary changed size during iteration");
            }
            if (!this.iterator.hasNext()) {
                return null;
            }
            return this.stringMapNext();
        }

        protected abstract PyObject stringMapNext();
    }
}

