/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString$PyExposer;
import org.python.core.PyStringDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StringFormatter;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.ucnhashAPI;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="str")
public class PyString
extends PyBaseString {
    public static final PyType TYPE;
    protected String string;
    protected transient boolean interned = false;
    private static char[] hexdigit;
    private static ucnhashAPI pucnHash;

    public PyString() {
        this(TYPE, "");
    }

    public PyString(PyType subType, String string) {
        super(subType);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PyString from null!");
        }
        this.string = string;
    }

    public PyString(String string) {
        this(TYPE, string);
    }

    public PyString(char c2) {
        this(TYPE, String.valueOf(c2));
    }

    PyString(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    public static PyString fromInterned(String interned) {
        PyString str = new PyString(TYPE, interned);
        str.interned = true;
        return str;
    }

    @ExposedNew
    static final PyObject str_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("str", args, keywords, new String[]{"object"}, 0);
        PyObject S = ap.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyString("");
            }
            return new PyString(S.__str__().toString());
        }
        if (S == null) {
            return new PyStringDerived(subtype, "");
        }
        return new PyStringDerived(subtype, S.__str__().toString());
    }

    public int[] toCodePoints() {
        int n2 = this.string.length();
        int[] codePoints = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            codePoints[i2] = this.string.charAt(i2);
        }
        return codePoints;
    }

    public String substring(int start, int end) {
        return this.string.substring(start, end);
    }

    @Override
    public PyString __str__() {
        return this.str___str__();
    }

    final PyString str___str__() {
        if (this.getClass() == PyString.class) {
            return this;
        }
        return new PyString(this.string);
    }

    @Override
    public PyUnicode __unicode__() {
        return new PyUnicode(this);
    }

    @Override
    public int __len__() {
        return this.str___len__();
    }

    final int str___len__() {
        return this.string.length();
    }

    @Override
    public String toString() {
        return this.string;
    }

    public String internedString() {
        if (this.interned) {
            return this.string;
        }
        this.string = this.string.intern();
        this.interned = true;
        return this.string;
    }

    @Override
    public PyString __repr__() {
        return this.str___repr__();
    }

    final PyString str___repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.string, true));
    }

    public static String encode_UnicodeEscape(String str, boolean use_quotes) {
        int size = str.length();
        StringBuilder v = new StringBuilder(str.length());
        char quote = '\u0000';
        if (use_quotes) {
            quote = str.indexOf(39) >= 0 && str.indexOf(34) == -1 ? (char)'\"' : '\'';
            v.append(quote);
        }
        int i2 = 0;
        while (size-- > 0) {
            char ch = str.charAt(i2++);
            if (use_quotes && (ch == quote || ch == '\\')) {
                v.append('\\');
                v.append(ch);
                continue;
            }
            if (ch >= '\ud800' && ch < '\udc00') {
                char ch2 = str.charAt(i2++);
                --size;
                if (ch2 >= '\udc00' && ch2 <= '\udfff') {
                    int ucs = ((ch & 0x3FF) << 10 | ch2 & 0x3FF) + 65536;
                    v.append('\\');
                    v.append('U');
                    v.append(hexdigit[ucs >> 28 & 0xF]);
                    v.append(hexdigit[ucs >> 24 & 0xF]);
                    v.append(hexdigit[ucs >> 20 & 0xF]);
                    v.append(hexdigit[ucs >> 16 & 0xF]);
                    v.append(hexdigit[ucs >> 12 & 0xF]);
                    v.append(hexdigit[ucs >> 8 & 0xF]);
                    v.append(hexdigit[ucs >> 4 & 0xF]);
                    v.append(hexdigit[ucs & 0xF]);
                    continue;
                }
                --i2;
                ++size;
            }
            if (ch >= '\u0100') {
                v.append('\\');
                v.append('u');
                v.append(hexdigit[ch >> 12 & 0xF]);
                v.append(hexdigit[ch >> 8 & 0xF]);
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            if (ch == '\t') {
                v.append("\\t");
                continue;
            }
            if (ch == '\n') {
                v.append("\\n");
                continue;
            }
            if (ch == '\r') {
                v.append("\\r");
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                v.append('\\');
                v.append('x');
                v.append(hexdigit[ch >> 4 & 0xF]);
                v.append(hexdigit[ch & 0xF]);
                continue;
            }
            v.append(ch);
        }
        if (use_quotes) {
            v.append(quote);
        }
        return v.toString();
    }

    public static String decode_UnicodeEscape(String str, int start, int end, String errors, boolean unicode) {
        StringBuilder v = new StringBuilder(end - start);
        int s = start;
        while (s < end) {
            char ch = str.charAt(s);
            if (ch != '\\') {
                v.append(ch);
                ++s;
                continue;
            }
            int loopStart = s++;
            if (s == end) {
                s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, s + 1, "\\ at end of string");
                continue;
            }
            ch = str.charAt(s++);
            switch (ch) {
                case '\n': {
                    break;
                }
                case '\\': {
                    v.append('\\');
                    break;
                }
                case '\'': {
                    v.append('\'');
                    break;
                }
                case '\"': {
                    v.append('\"');
                    break;
                }
                case 'b': {
                    v.append('\b');
                    break;
                }
                case 'f': {
                    v.append('\f');
                    break;
                }
                case 't': {
                    v.append('\t');
                    break;
                }
                case 'n': {
                    v.append('\n');
                    break;
                }
                case 'r': {
                    v.append('\r');
                    break;
                }
                case 'v': {
                    v.append('\u000b');
                    break;
                }
                case 'a': {
                    v.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int x = Character.digit(ch, 8);
                    for (int j2 = 0; j2 < 2 && s < end && (ch = str.charAt(s)) >= '0' && ch <= '7'; ++j2, ++s) {
                        x = (x << 3) + Character.digit(ch, 8);
                    }
                    v.append((char)x);
                    break;
                }
                case 'x': {
                    s = PyString.hexescape(v, errors, 2, s, str, end, "truncated \\xXX");
                    break;
                }
                case 'u': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('u');
                        break;
                    }
                    s = PyString.hexescape(v, errors, 4, s, str, end, "truncated \\uXXXX");
                    break;
                }
                case 'U': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('U');
                        break;
                    }
                    s = PyString.hexescape(v, errors, 8, s, str, end, "truncated \\UXXXXXXXX");
                    break;
                }
                case 'N': {
                    if (!unicode) {
                        v.append('\\');
                        v.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject mod2 = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(mod2 = mod2.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            throw Py.UnicodeError("Unicode names not loaded");
                        }
                    }
                    if (str.charAt(s) == '{') {
                        int startName;
                        int endBrace;
                        int maxLen = pucnHash.getCchMax();
                        for (endBrace = startName = s + 1; endBrace < end && str.charAt(endBrace) != '}' && endBrace - startName <= maxLen; ++endBrace) {
                        }
                        if (endBrace != end && str.charAt(endBrace) == '}') {
                            int value = pucnHash.getValue(str, startName, endBrace);
                            if (PyString.storeUnicodeCharacter(value, v)) {
                                s = endBrace + 1;
                                break;
                            }
                            s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, endBrace + 1, "illegal Unicode character");
                            break;
                        }
                        s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, endBrace, "malformed \\N character escape");
                        break;
                    }
                    s = codecs.insertReplacementAndGetResume(v, errors, "unicodeescape", str, loopStart, s + 1, "malformed \\N character escape");
                    break;
                }
                default: {
                    v.append('\\');
                    v.append(str.charAt(s - 1));
                }
            }
        }
        return v.toString();
    }

    private static int hexescape(StringBuilder partialDecode, String errors, int digits, int hexDigitStart, String str, int size, String errorMessage) {
        int i2;
        if (hexDigitStart + digits > size) {
            return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, size, errorMessage);
        }
        int x = 0;
        for (i2 = 0; i2 < digits; ++i2) {
            char c2 = str.charAt(hexDigitStart + i2);
            int d2 = Character.digit(c2, 16);
            if (d2 == -1) {
                return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i2 + 1, errorMessage);
            }
            x = x << 4 & 0xFFFFFFF0;
            if (c2 >= '0' && c2 <= '9') {
                x += c2 - 48;
                continue;
            }
            if (c2 >= 'a' && c2 <= 'f') {
                x += 10 + c2 - 97;
                continue;
            }
            x += 10 + c2 - 65;
        }
        if (PyString.storeUnicodeCharacter(x, partialDecode)) {
            return hexDigitStart + i2;
        }
        return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i2 + 1, "illegal Unicode character");
    }

    private static boolean storeUnicodeCharacter(int value, StringBuilder partialDecode) {
        if (value < 0 || value >= 55296 && value <= 57343) {
            return false;
        }
        if (value <= 0x10FFFF) {
            partialDecode.appendCodePoint(value);
            return true;
        }
        return false;
    }

    final PyObject str___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("string index out of range");
        }
        return ret;
    }

    final PyObject str___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final int str___cmp__(PyObject other) {
        if (!(other instanceof PyString)) {
            return -2;
        }
        int c2 = this.string.compareTo(((PyString)other).string);
        return c2 < 0 ? -1 : (c2 > 0 ? 1 : 0);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject str___eq__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.equals(s) ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final PyObject str___ne__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.equals(s) ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.str___lt__(other);
    }

    final PyObject str___lt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.str___le__(other);
    }

    final PyObject str___le__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) <= 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.str___gt__(other);
    }

    final PyObject str___gt__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) > 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.str___ge__(other);
    }

    final PyObject str___ge__(PyObject other) {
        String s = PyString.coerce(other);
        if (s == null) {
            return null;
        }
        return this.string.compareTo(s) >= 0 ? Py.True : Py.False;
    }

    private static String coerce(PyObject o2) {
        if (o2 instanceof PyString) {
            return o2.toString();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.str___hash__();
    }

    final int str___hash__() {
        return this.string.hashCode();
    }

    public byte[] toBytes() {
        return StringUtil.toBytes(this.string);
    }

    @Override
    public Object __tojava__(Class<?> c2) {
        if (c2.isAssignableFrom(String.class)) {
            return this.string;
        }
        if ((c2 == Character.TYPE || c2 == Character.class) && this.string.length() == 1) {
            return new Character(this.string.charAt(0));
        }
        if (c2.isArray()) {
            if (c2.getComponentType() == Byte.TYPE) {
                return this.toBytes();
            }
            if (c2.getComponentType() == Character.TYPE) {
                return this.string.toCharArray();
            }
        }
        if (c2.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    protected PyObject pyget(int i2) {
        return Py.newString(this.string.charAt(i2));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        if (step == 1) {
            return this.fromSubstring(start, stop);
        }
        int n2 = PyString.sliceLength(start, stop, step);
        char[] new_chars = new char[n2];
        int j2 = 0;
        int i2 = start;
        while (j2 < n2) {
            new_chars[j2++] = this.string.charAt(i2);
            i2 += step;
        }
        return this.createInstance(new String(new_chars), true);
    }

    public PyString createInstance(String str) {
        return new PyString(str);
    }

    protected PyString createInstance(String str, boolean isBasic) {
        return new PyString(str);
    }

    @Override
    public boolean __contains__(PyObject o2) {
        return this.str___contains__(o2);
    }

    final boolean str___contains__(PyObject o2) {
        if (!(o2 instanceof PyString)) {
            throw Py.TypeError("'in <string>' requires string as left operand");
        }
        PyString other = (PyString)o2;
        return this.string.indexOf(other.string) >= 0;
    }

    @Override
    protected PyObject repeat(int count) {
        int s;
        if (count < 0) {
            count = 0;
        }
        if ((long)(s = this.string.length()) * (long)count > Integer.MAX_VALUE) {
            throw Py.OverflowError("max str len is 2147483647");
        }
        char[] new_chars = new char[s * count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.string.getChars(0, s, new_chars, i2 * s);
        }
        return this.createInstance(new String(new_chars));
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.str___mul__(o2);
    }

    final PyObject str___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.str___rmul__(o2);
    }

    final PyObject str___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.str___add__(other);
    }

    final PyObject str___add__(PyObject other) {
        if (other instanceof PyUnicode) {
            return this.decode().__add__(other);
        }
        if (other instanceof PyString) {
            PyString otherStr = (PyString)other;
            return new PyString(this.string.concat(otherStr.string));
        }
        return null;
    }

    final PyTuple str___getnewargs__() {
        return new PyTuple(new PyString(this.string));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.str___getnewargs__();
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.str___mod__(other);
    }

    public PyObject str___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.string, false);
        return fmt.format(other);
    }

    @Override
    public PyObject __int__() {
        try {
            return Py.newInteger(this.atoi(10));
        }
        catch (PyException e2) {
            if (e2.match(Py.OverflowError)) {
                return this.atol(10);
            }
            throw e2;
        }
    }

    @Override
    public PyObject __long__() {
        return this.atol(10);
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    @Override
    public PyObject __pos__() {
        throw Py.TypeError("bad operand type for unary +");
    }

    @Override
    public PyObject __neg__() {
        throw Py.TypeError("bad operand type for unary -");
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyComplex __complex__() {
        int s;
        boolean got_re = false;
        boolean got_im = false;
        boolean done = false;
        boolean sw_error = false;
        int n2 = this.string.length();
        for (s = 0; s < n2 && Character.isSpaceChar(this.string.charAt(s)); ++s) {
        }
        if (s == n2) {
            throw Py.ValueError("empty string for complex()");
        }
        double z = -1.0;
        double x = 0.0;
        double y = 0.0;
        int sign = 1;
        block7: do {
            char c2 = this.string.charAt(s);
            switch (c2) {
                case '-': {
                    sign = -1;
                }
                case '+': {
                    if (done || s + 1 == n2) {
                        sw_error = true;
                        break;
                    }
                    if (Character.isDigit(c2 = this.string.charAt(++s)) || c2 == 'J' || c2 == 'j') continue block7;
                    sw_error = true;
                    break;
                }
                case 'J': 
                case 'j': {
                    if (got_im || done) {
                        sw_error = true;
                        break;
                    }
                    y = z < 0.0 ? (double)sign : (double)sign * z;
                    got_im = true;
                    done = got_re;
                    sign = 1;
                    ++s;
                    break;
                }
                case ' ': {
                    while (s < n2 && Character.isSpaceChar(this.string.charAt(s))) {
                        ++s;
                    }
                    if (s == n2) continue block7;
                    sw_error = true;
                    break;
                }
                default: {
                    boolean digit_or_dot;
                    boolean bl = digit_or_dot = c2 == '.' || Character.isDigit(c2);
                    if (!digit_or_dot) {
                        sw_error = true;
                        break;
                    }
                    int end = this.endDouble(this.string, s);
                    z = Double.valueOf(this.string.substring(s, end));
                    if (z == Double.POSITIVE_INFINITY) {
                        throw Py.ValueError(String.format("float() out of range: %.150s", this.string));
                    }
                    s = end;
                    if (s < n2 && ((c2 = this.string.charAt(s)) == 'J' || c2 == 'j')) continue block7;
                    if (got_re) {
                        sw_error = true;
                        break;
                    }
                    x = (double)sign * z;
                    got_re = true;
                    done = got_im;
                    z = -1.0;
                    sign = 1;
                }
            }
        } while (s < n2 && !sw_error);
        if (sw_error) {
            throw Py.ValueError("malformed string for complex() " + this.string.substring(s));
        }
        return new PyComplex(x, y);
    }

    private int endDouble(String string, int s) {
        int n2 = string.length();
        while (s < n2) {
            char c2;
            if (Character.isDigit(c2 = string.charAt(s++)) || c2 == '.') continue;
            if ((c2 == 'e' || c2 == 'E') && s < n2) {
                c2 = string.charAt(s);
                if (c2 != '+' && c2 != '-') continue;
                ++s;
                continue;
            }
            return s - 1;
        }
        return s;
    }

    public String lower() {
        return this.str_lower();
    }

    final String str_lower() {
        return this.string.toLowerCase();
    }

    public String upper() {
        return this.str_upper();
    }

    final String str_upper() {
        return this.string.toUpperCase();
    }

    public String title() {
        return this.str_title();
    }

    final String str_title() {
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        boolean previous_is_cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = chars[i2];
            chars[i2] = previous_is_cased ? Character.toLowerCase(ch) : Character.toTitleCase(ch);
            previous_is_cased = Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isTitleCase(ch);
        }
        return new String(chars);
    }

    public String swapcase() {
        return this.str_swapcase();
    }

    final String str_swapcase() {
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (Character.isUpperCase(c2)) {
                chars[i2] = Character.toLowerCase(c2);
                continue;
            }
            if (!Character.isLowerCase(c2)) continue;
            chars[i2] = Character.toUpperCase(c2);
        }
        return new String(chars);
    }

    public String strip() {
        return this.str_strip(null);
    }

    public String strip(String sep) {
        return this.str_strip(sep);
    }

    final String str_strip(String sep) {
        int end;
        int start;
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        if (sep == null) {
            for (start = 0; start < n2 && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n2 && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        if (sep == null) {
            for (end = n2 - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        if (end >= start) {
            return end < n2 - 1 || start > 0 ? this.string.substring(start, end + 1) : this.string;
        }
        return "";
    }

    public String lstrip() {
        return this.str_lstrip(null);
    }

    public String lstrip(String sep) {
        return this.str_lstrip(sep);
    }

    final String str_lstrip(String sep) {
        int start;
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        if (sep == null) {
            for (start = 0; start < n2 && Character.isWhitespace(chars[start]); ++start) {
            }
        } else {
            while (start < n2 && sep.indexOf(chars[start]) >= 0) {
                ++start;
            }
        }
        return start > 0 ? this.string.substring(start, n2) : this.string;
    }

    public String rstrip(String sep) {
        return this.str_rstrip(sep);
    }

    final String str_rstrip(String sep) {
        int end;
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        if (sep == null) {
            for (end = n2 - 1; end >= 0 && Character.isWhitespace(chars[end]); --end) {
            }
        } else {
            while (end >= 0 && sep.indexOf(chars[end]) >= 0) {
                --end;
            }
        }
        return end < n2 - 1 ? this.string.substring(0, end + 1) : this.string;
    }

    public PyList split() {
        return this.str_split(null, -1);
    }

    public PyList split(String sep) {
        return this.str_split(sep, -1);
    }

    public PyList split(String sep, int maxsplit) {
        return this.str_split(sep, maxsplit);
    }

    final PyList str_split(String sep, int maxsplit) {
        if (sep != null) {
            if (sep.length() == 0) {
                throw Py.ValueError("empty separator");
            }
            return this.splitfields(sep, maxsplit);
        }
        PyList list = new PyList();
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        if (maxsplit < 0) {
            maxsplit = n2;
        }
        int index = 0;
        for (int splits = 0; index < n2 && splits < maxsplit; ++splits) {
            while (index < n2 && Character.isWhitespace(chars[index])) {
                ++index;
            }
            if (index == n2) break;
            int start = index;
            while (index < n2 && !Character.isWhitespace(chars[index])) {
                ++index;
            }
            list.append(this.fromSubstring(start, index));
        }
        while (index < n2 && Character.isWhitespace(chars[index])) {
            ++index;
        }
        if (index < n2) {
            list.append(this.fromSubstring(index, n2));
        }
        return list;
    }

    public PyList rsplit() {
        return this.str_rsplit(null, -1);
    }

    public PyList rsplit(String sep) {
        return this.str_rsplit(sep, -1);
    }

    public PyList rsplit(String sep, int maxsplit) {
        return this.str_rsplit(sep, maxsplit);
    }

    final PyList str_rsplit(String sep, int maxsplit) {
        int i2;
        if (sep != null) {
            if (sep.length() == 0) {
                throw Py.ValueError("empty separator");
            }
            PyList list = this.rsplitfields(sep, maxsplit);
            list.reverse();
            return list;
        }
        PyList list = new PyList();
        char[] chars = this.string.toCharArray();
        if (maxsplit < 0) {
            maxsplit = chars.length;
        }
        int splits = 0;
        for (i2 = chars.length - 1; i2 > -1 && Character.isWhitespace(chars[i2]); --i2) {
        }
        if (i2 == -1) {
            return list;
        }
        while (splits < maxsplit) {
            int nextWsChar;
            while (i2 > -1 && Character.isWhitespace(chars[i2])) {
                --i2;
            }
            if (i2 == -1) break;
            for (nextWsChar = i2; nextWsChar > -1 && !Character.isWhitespace(chars[nextWsChar]); --nextWsChar) {
            }
            if (nextWsChar == -1) break;
            ++splits;
            list.add(this.fromSubstring(nextWsChar + 1, i2 + 1));
            i2 = nextWsChar;
        }
        while (i2 > -1 && Character.isWhitespace(chars[i2])) {
            --i2;
        }
        if (i2 > -1) {
            list.add(this.fromSubstring(0, i2 + 1));
        }
        list.reverse();
        return list;
    }

    public PyTuple partition(PyObject sepObj) {
        return this.str_partition(sepObj);
    }

    final PyTuple str_partition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        if (!(sepObj instanceof PyString)) {
            throw Py.TypeError("expected a character buffer object");
        }
        String sep = ((PyString)sepObj).string;
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.string.indexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.string.length()));
        }
        return new PyTuple(this, Py.EmptyString, Py.EmptyString);
    }

    final PyTuple unicodePartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.string;
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.indexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(this, emptyUnicode, emptyUnicode);
    }

    public PyTuple rpartition(PyObject sepObj) {
        return this.str_rpartition(sepObj);
    }

    final PyTuple str_rpartition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        if (!(sepObj instanceof PyString)) {
            throw Py.TypeError("expected a character buffer object");
        }
        String sep = ((PyString)sepObj).string;
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.string.lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.string.length()));
        }
        return new PyTuple(Py.EmptyString, Py.EmptyString, this);
    }

    final PyTuple unicodeRpartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.string;
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(emptyUnicode, emptyUnicode, this);
    }

    private PyList splitfields(String sep, int maxsplit) {
        int index;
        PyList list = new PyList();
        int length = this.string.length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        int lastbreak = 0;
        int splits = 0;
        int sepLength = sep.length();
        if (sep.length() == 0 && maxsplit != 0) {
            index = this.string.indexOf(sep, lastbreak);
            list.append(this.fromSubstring(lastbreak, index));
            ++splits;
        }
        while (splits < maxsplit && (index = this.string.indexOf(sep, lastbreak)) != -1) {
            if (sep.length() == 0) {
                ++index;
            }
            ++splits;
            list.append(this.fromSubstring(lastbreak, index));
            lastbreak = index + sepLength;
        }
        if (lastbreak <= length) {
            list.append(this.fromSubstring(lastbreak, length));
        }
        return list;
    }

    private PyList rsplitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        int length = this.string.length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        int lastbreak = length;
        int index = length;
        int sepLength = sep.length();
        for (int splits = 0; index > 0 && splits < maxsplit; ++splits) {
            int i2 = this.string.lastIndexOf(sep, index - sepLength);
            if (i2 == index) {
                i2 -= sepLength;
            }
            if (i2 < 0) break;
            list.append(this.fromSubstring(i2 + sepLength, lastbreak));
            lastbreak = i2;
            index = i2;
        }
        list.append(this.fromSubstring(0, lastbreak));
        return list;
    }

    public PyList splitlines() {
        return this.str_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.str_splitlines(keepends);
    }

    final PyList str_splitlines(boolean keepends) {
        PyList list = new PyList();
        char[] chars = this.string.toCharArray();
        int n2 = chars.length;
        int j2 = 0;
        int i2 = 0;
        while (i2 < n2) {
            while (i2 < n2 && chars[i2] != '\n' && chars[i2] != '\r' && Character.getType(chars[i2]) != 13) {
                ++i2;
            }
            int eol = i2;
            if (i2 < n2) {
                i2 = chars[i2] == '\r' && i2 + 1 < n2 && chars[i2 + 1] == '\n' ? (i2 += 2) : ++i2;
                if (keepends) {
                    eol = i2;
                }
            }
            list.append(this.fromSubstring(j2, eol));
            j2 = i2;
        }
        if (j2 < n2) {
            list.append(this.fromSubstring(j2, n2));
        }
        return list;
    }

    protected PyString fromSubstring(int begin, int end) {
        return this.createInstance(this.string.substring(begin, end), true);
    }

    public int index(String sub) {
        return this.str_index(sub, 0, null);
    }

    public int index(String sub, int start) {
        return this.str_index(sub, start, null);
    }

    public int index(String sub, int start, int end) {
        return this.str_index(sub, start, Py.newInteger(end));
    }

    final int str_index(String sub, int start, PyObject end) {
        int index = this.str_find(sub, start, end);
        if (index == -1) {
            throw Py.ValueError("substring not found in string.index");
        }
        return index;
    }

    public int rindex(String sub) {
        return this.str_rindex(sub, 0, null);
    }

    public int rindex(String sub, int start) {
        return this.str_rindex(sub, start, null);
    }

    public int rindex(String sub, int start, int end) {
        return this.str_rindex(sub, start, Py.newInteger(end));
    }

    final int str_rindex(String sub, int start, PyObject end) {
        int index = this.str_rfind(sub, start, end);
        if (index == -1) {
            throw Py.ValueError("substring not found in string.rindex");
        }
        return index;
    }

    public int count(String sub) {
        return this.str_count(sub, 0, null);
    }

    public int count(String sub, int start) {
        return this.str_count(sub, start, null);
    }

    public int count(String sub, int start, int end) {
        return this.str_count(sub, start, Py.newInteger(end));
    }

    final int str_count(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int n2 = sub.length();
        if (n2 == 0) {
            if (start > this.string.length()) {
                return 0;
            }
            return indices[1] - indices[0] + 1;
        }
        int count = 0;
        while (true) {
            int index = this.string.indexOf(sub, indices[0]);
            indices[0] = index + n2;
            if (indices[0] > indices[1] || index == -1) break;
            ++count;
        }
        return count;
    }

    public int find(String sub) {
        return this.str_find(sub, 0, null);
    }

    public int find(String sub, int start) {
        return this.str_find(sub, start, null);
    }

    public int find(String sub, int start, int end) {
        return this.str_find(sub, start, Py.newInteger(end));
    }

    final int str_find(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int index = this.string.indexOf(sub, indices[0]);
        if (index < start || index > indices[1]) {
            return -1;
        }
        return index;
    }

    public int rfind(String sub) {
        return this.str_rfind(sub, 0, null);
    }

    public int rfind(String sub, int start) {
        return this.str_rfind(sub, start, null);
    }

    public int rfind(String sub, int start, int end) {
        return this.str_rfind(sub, start, Py.newInteger(end));
    }

    final int str_rfind(String sub, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        int index = this.string.lastIndexOf(sub, indices[1] - sub.length());
        if (index < start) {
            return -1;
        }
        return index;
    }

    public double atof() {
        StringBuilder s = null;
        int n2 = this.string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (ch == '\u0000') {
                throw Py.ValueError("null byte in argument for float()");
            }
            if (!Character.isDigit(ch)) continue;
            if (s == null) {
                s = new StringBuilder(this.string);
            }
            int val = Character.digit(ch, 10);
            s.setCharAt(i2, Character.forDigit(val, 10));
        }
        String sval = this.string;
        if (s != null) {
            sval = s.toString();
        }
        try {
            String lowSval = sval.toLowerCase();
            if (lowSval.equals("nan")) {
                return Double.NaN;
            }
            if (lowSval.equals("inf")) {
                return Double.POSITIVE_INFINITY;
            }
            if (lowSval.equals("-inf")) {
                return Double.NEGATIVE_INFINITY;
            }
            if (lowSval.endsWith("d") || lowSval.endsWith("f")) {
                throw new NumberFormatException("format specifiers not allowed");
            }
            return Double.valueOf(sval);
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for __float__: " + this.string);
        }
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int base) {
        int b2;
        if (base != 0 && base < 2 || base > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        int e2 = this.string.length();
        for (b2 = 0; b2 < e2 && Character.isWhitespace(this.string.charAt(b2)); ++b2) {
        }
        while (e2 > b2 && Character.isWhitespace(this.string.charAt(e2 - 1))) {
            --e2;
        }
        char sign = '\u0000';
        if (b2 < e2) {
            sign = this.string.charAt(b2);
            if (sign == '-' || sign == '+') {
                ++b2;
                while (b2 < e2 && Character.isWhitespace(this.string.charAt(b2))) {
                    ++b2;
                }
            }
            if ((base == 0 || base == 16) && this.string.charAt(b2) == '0') {
                if (b2 < e2 - 1 && Character.toUpperCase(this.string.charAt(b2 + 1)) == 'X') {
                    base = 16;
                    b2 += 2;
                } else if (base == 0) {
                    base = 8;
                }
            }
        }
        if (base == 0) {
            base = 10;
        }
        String s = this.string;
        if (b2 > 0 || e2 < this.string.length()) {
            s = this.string.substring(b2, e2);
        }
        try {
            BigInteger bi = sign == '-' ? new BigInteger("-" + s, base) : new BigInteger(s, base);
            if (bi.compareTo(PyInteger.maxInt) > 0 || bi.compareTo(PyInteger.minInt) < 0) {
                throw Py.OverflowError("long int too large to convert to int");
            }
            return bi.intValue();
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base + ": " + this.string);
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base + ": " + this.string);
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int base) {
        int b2;
        String str = this.string;
        int e2 = str.length();
        for (b2 = 0; b2 < e2 && Character.isWhitespace(str.charAt(b2)); ++b2) {
        }
        while (e2 > b2 && Character.isWhitespace(str.charAt(e2 - 1))) {
            --e2;
        }
        char sign = '\u0000';
        if (b2 < e2) {
            sign = this.string.charAt(b2);
            if (sign == '-' || sign == '+') {
                ++b2;
                while (b2 < e2 && Character.isWhitespace(str.charAt(b2))) {
                    ++b2;
                }
            }
            if ((base == 0 || base == 16) && this.string.charAt(b2) == '0') {
                if (b2 < e2 - 1 && Character.toUpperCase(this.string.charAt(b2 + 1)) == 'X') {
                    base = 16;
                    b2 += 2;
                } else if (base == 0) {
                    base = 8;
                }
            }
        }
        if (base == 0) {
            base = 10;
        }
        if (base < 2 || base > 36) {
            throw Py.ValueError("invalid base for long literal:" + base);
        }
        if (base < 22 && e2 > b2 && (str.charAt(e2 - 1) == 'L' || str.charAt(e2 - 1) == 'l')) {
            --e2;
        }
        if (b2 > 0 || e2 < str.length()) {
            str = str.substring(b2, e2);
        }
        try {
            BigInteger bi = null;
            bi = sign == '-' ? new BigInteger("-" + str, base) : new BigInteger(str, base);
            return new PyLong(bi);
        }
        catch (NumberFormatException exc) {
            if (this instanceof PyUnicode) {
                throw Py.UnicodeEncodeError("decimal", "codec can't encode character", 0, 0, "invalid decimal Unicode string");
            }
            throw Py.ValueError("invalid literal for long() with base " + base + ": " + this.string);
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for long() with base " + base + ": " + this.string);
        }
    }

    private static String padding(int n2, char pad) {
        char[] chars = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            chars[i2] = pad;
        }
        return new String(chars);
    }

    private static char parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return ' ';
        }
        if (fillchar.length() != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.charAt(0);
    }

    public String ljust(int width) {
        return this.str_ljust(width, null);
    }

    public String ljust(int width, String padding) {
        return this.str_ljust(width, padding);
    }

    final String str_ljust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("ljust", fillchar);
        int n2 = width - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        return this.string + PyString.padding(n2, pad);
    }

    public String rjust(int width) {
        return this.str_rjust(width, null);
    }

    final String str_rjust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("rjust", fillchar);
        int n2 = width - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        return PyString.padding(n2, pad) + this.string;
    }

    public String center(int width) {
        return this.str_center(width, null);
    }

    final String str_center(int width, String fillchar) {
        char pad = PyString.parse_fillchar("center", fillchar);
        int n2 = width - this.string.length();
        if (n2 <= 0) {
            return this.string;
        }
        int half = n2 / 2;
        if (n2 % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        return PyString.padding(half, pad) + this.string + PyString.padding(n2 - half, pad);
    }

    public String zfill(int width) {
        return this.str_zfill(width);
    }

    final String str_zfill(int width) {
        char start;
        String s = this.string;
        int n2 = s.length();
        if (n2 >= width) {
            return s;
        }
        char[] chars = new char[width];
        int nzeros = width - n2;
        int i2 = 0;
        int sStart = 0;
        if (n2 > 0 && ((start = s.charAt(0)) == '+' || start == '-')) {
            chars[0] = start;
            ++i2;
            ++nzeros;
            sStart = 1;
        }
        while (i2 < nzeros) {
            chars[i2] = 48;
            ++i2;
        }
        s.getChars(sStart, s.length(), chars, i2);
        return new String(chars);
    }

    public String expandtabs() {
        return this.str_expandtabs(8);
    }

    public String expandtabs(int tabsize) {
        return this.str_expandtabs(tabsize);
    }

    final String str_expandtabs(int tabsize) {
        String s = this.string;
        StringBuilder buf = new StringBuilder((int)((double)s.length() * 1.5));
        char[] chars = s.toCharArray();
        int n2 = chars.length;
        int position = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (c2 == '\t') {
                int spaces = tabsize - position % tabsize;
                position += spaces;
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                continue;
            }
            if (c2 == '\n' || c2 == '\r') {
                position = -1;
            }
            buf.append(c2);
            ++position;
        }
        return buf.toString();
    }

    public String capitalize() {
        return this.str_capitalize();
    }

    final String str_capitalize() {
        if (this.string.length() == 0) {
            return this.string;
        }
        String first = this.string.substring(0, 1).toUpperCase();
        return first.concat(this.string.substring(1).toLowerCase());
    }

    final PyString str_replace(PyObject oldPiece, PyObject newPiece, PyObject maxsplit) {
        if (!(oldPiece instanceof PyString) || !(newPiece instanceof PyString)) {
            throw Py.TypeError("str or unicode required for replace");
        }
        return this.replace((PyString)oldPiece, (PyString)newPiece, maxsplit == null ? -1 : maxsplit.asInt());
    }

    protected PyString replace(PyString oldPiece, PyString newPiece, int maxsplit) {
        int len = this.string.length();
        int old_len = oldPiece.string.length();
        if (len == 0) {
            if (maxsplit == -1 && old_len == 0) {
                return this.createInstance(newPiece.string, true);
            }
            return this.createInstance(this.string, true);
        }
        if (old_len == 0 && newPiece.string.length() != 0 && maxsplit != 0) {
            int i2;
            StringBuilder buffer = new StringBuilder();
            buffer.append(newPiece.string);
            for (i2 = 0; i2 < len && (i2 < maxsplit - 1 || maxsplit == -1); ++i2) {
                buffer.append(this.string.charAt(i2));
                buffer.append(newPiece.string);
            }
            buffer.append(this.string.substring(i2));
            return this.createInstance(buffer.toString(), true);
        }
        if (maxsplit == -1) {
            maxsplit = old_len == 0 ? len + 1 : len;
        }
        return newPiece.join(this.splitfields(oldPiece.string, maxsplit));
    }

    public PyString join(PyObject seq) {
        return this.str_join(seq);
    }

    final PyString str_join(PyObject obj) {
        int i2;
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return Py.EmptyString;
        }
        if (seqLen == 1 && ((item = seq.pyget(0)).getType() == TYPE || item.getType() == PyUnicode.TYPE)) {
            return (PyString)item;
        }
        long size = 0L;
        int sepLen = this.string.length();
        for (i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string, %.80s found", i2, item.getType().fastGetName()));
            }
            if (item instanceof PyUnicode) {
                return this.unicodeJoin(seq);
            }
            if (i2 != 0) {
                size += (long)sepLen;
            }
            if ((size += (long)((PyString)item).string.length()) <= Integer.MAX_VALUE) continue;
            throw Py.OverflowError("join() result is too long for a Python string");
        }
        StringBuilder buf = new StringBuilder((int)size);
        for (i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (i2 != 0) {
                buf.append(this.string);
            }
            buf.append(((PyString)item).string);
        }
        return new PyString(buf.toString());
    }

    /*
     * WARNING - void declaration
     */
    final PyUnicode unicodeJoin(PyObject obj) {
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return new PyUnicode();
        }
        if (seqLen == 1 && (item = seq.pyget(0)).getType() == PyUnicode.TYPE) {
            return (PyUnicode)item;
        }
        String sep = null;
        if (seqLen > 1) {
            if (this instanceof PyUnicode) {
                sep = this.string;
            } else {
                sep = ((PyUnicode)this.decode()).string;
                seqLen = seq.__len__();
            }
        }
        long size = 0L;
        int sepLen = this.string.length();
        StringBuilder buf = new StringBuilder();
        int n2 = 0;
        while (n2 < seqLen) {
            void itemString;
            item = seq.pyget(n2);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string or Unicode, %.80s found", n2, item.getType().fastGetName()));
            }
            if (!(item instanceof PyUnicode)) {
                item = ((PyString)item).decode();
                seqLen = seq.__len__();
            }
            String i2 = ((PyUnicode)item).string;
            if (itemString != false) {
                size += (long)sepLen;
                buf.append(sep);
            }
            if ((size += (long)i2.length()) > Integer.MAX_VALUE) {
                throw Py.OverflowError("join() result is too long for a Python string");
            }
            buf.append(i2);
            ++itemString;
        }
        return new PyUnicode(buf.toString());
    }

    public boolean startswith(PyObject prefix) {
        return this.str_startswith(prefix, 0, null);
    }

    public boolean startswith(PyObject prefix, int offset) {
        return this.str_startswith(prefix, offset, null);
    }

    public boolean startswith(PyObject prefix, int start, int end) {
        return this.str_startswith(prefix, start, Py.newInteger(end));
    }

    final boolean str_startswith(PyObject prefix, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        if (prefix instanceof PyString) {
            String strPrefix = ((PyString)prefix).string;
            if (indices[1] - indices[0] < strPrefix.length()) {
                return false;
            }
            return this.string.startsWith(strPrefix, indices[0]);
        }
        if (prefix instanceof PyTuple) {
            PyObject[] prefixes = ((PyTuple)prefix).getArray();
            for (int i2 = 0; i2 < prefixes.length; ++i2) {
                if (!(prefixes[i2] instanceof PyString)) {
                    throw Py.TypeError("expected a character buffer object");
                }
                String strPrefix = ((PyString)prefixes[i2]).string;
                if (indices[1] - indices[0] < strPrefix.length() || !this.string.startsWith(strPrefix, indices[0])) continue;
                return true;
            }
            return false;
        }
        throw Py.TypeError("expected a character buffer object or tuple");
    }

    public boolean endswith(PyObject suffix) {
        return this.str_endswith(suffix, 0, null);
    }

    public boolean endswith(PyObject suffix, int start) {
        return this.str_endswith(suffix, start, null);
    }

    public boolean endswith(PyObject suffix, int start, int end) {
        return this.str_endswith(suffix, start, Py.newInteger(end));
    }

    final boolean str_endswith(PyObject suffix, int start, PyObject end) {
        int[] indices = this.translateIndices(start, end);
        String substr = this.string.substring(indices[0], indices[1]);
        if (suffix instanceof PyString) {
            return substr.endsWith(((PyString)suffix).string);
        }
        if (suffix instanceof PyTuple) {
            PyObject[] suffixes = ((PyTuple)suffix).getArray();
            for (int i2 = 0; i2 < suffixes.length; ++i2) {
                if (!(suffixes[i2] instanceof PyString)) {
                    throw Py.TypeError("expected a character buffer object");
                }
                if (!substr.endsWith(((PyString)suffixes[i2]).string)) continue;
                return true;
            }
            return false;
        }
        throw Py.TypeError("expected a character buffer object or tuple");
    }

    protected int[] translateIndices(int start, PyObject end) {
        int iEnd = end == null ? this.string.length() : end.asInt();
        int n2 = this.string.length();
        if (iEnd < 0) {
            if ((iEnd = n2 + iEnd) < 0) {
                iEnd = 0;
            }
        } else if (iEnd > n2) {
            iEnd = n2;
        }
        if (start < 0 && (start = n2 + start) < 0) {
            start = 0;
        }
        if (start > iEnd) {
            start = iEnd;
        }
        return new int[]{start, iEnd};
    }

    public String translate(String table) {
        return this.str_translate(table, null);
    }

    public String translate(String table, String deletechars) {
        return this.str_translate(table, deletechars);
    }

    final String str_translate(String table, String deletechars) {
        if (table.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuilder buf = new StringBuilder(this.string.length());
        for (int i2 = 0; i2 < this.string.length(); ++i2) {
            char c2 = this.string.charAt(i2);
            if (deletechars != null && deletechars.indexOf(c2) >= 0) continue;
            try {
                buf.append(table.charAt(c2));
                continue;
            }
            catch (IndexOutOfBoundsException e2) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return buf.toString();
    }

    public String translate(PyObject table) {
        StringBuilder v = new StringBuilder(this.string.length());
        for (int i2 = 0; i2 < this.string.length(); ++i2) {
            char ch = this.string.charAt(i2);
            PyInteger w = Py.newInteger(ch);
            PyObject x = table.__finditem__(w);
            if (x == null) {
                v.append(ch);
                continue;
            }
            if (x instanceof PyInteger) {
                int value = ((PyInteger)x).getValue();
                v.append((char)value);
                continue;
            }
            if (x == Py.None) continue;
            if (x instanceof PyString) {
                if (x.__len__() != 1) {
                    throw new PyException(Py.NotImplementedError, "1-n mappings are currently not implemented");
                }
                v.append(x.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return v.toString();
    }

    public boolean islower() {
        return this.str_islower();
    }

    final boolean str_islower() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return Character.isLowerCase(this.string.charAt(0));
        }
        boolean cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                return false;
            }
            if (cased || !Character.isLowerCase(ch)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isupper() {
        return this.str_isupper();
    }

    final boolean str_isupper() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return Character.isUpperCase(this.string.charAt(0));
        }
        boolean cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (Character.isLowerCase(ch) || Character.isTitleCase(ch)) {
                return false;
            }
            if (cased || !Character.isUpperCase(ch)) continue;
            cased = true;
        }
        return cased;
    }

    public boolean isalpha() {
        return this.str_isalpha();
    }

    final boolean str_isalpha() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return Character.isLetter(this.string.charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (Character.isLetter(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isalnum() {
        return this.str_isalnum();
    }

    final boolean str_isalnum() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return this._isalnum(this.string.charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (this._isalnum(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isalnum(char ch) {
        return Character.isLetterOrDigit(ch) || Character.getType(ch) == 10;
    }

    public boolean isdecimal() {
        return this.str_isdecimal();
    }

    final boolean str_isdecimal() {
        int n2 = this.string.length();
        if (n2 == 1) {
            char ch = this.string.charAt(0);
            return this._isdecimal(ch);
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (this._isdecimal(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isdecimal(char ch) {
        return Character.getType(ch) == 9;
    }

    public boolean isdigit() {
        return this.str_isdigit();
    }

    final boolean str_isdigit() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return Character.isDigit(this.string.charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isnumeric() {
        return this.str_isnumeric();
    }

    final boolean str_isnumeric() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return this._isnumeric(this.string.charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (this._isnumeric(ch)) continue;
            return false;
        }
        return true;
    }

    private boolean _isnumeric(char ch) {
        int type = Character.getType(ch);
        return type == 9 || type == 10 || type == 11;
    }

    public boolean istitle() {
        return this.str_istitle();
    }

    final boolean str_istitle() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return Character.isTitleCase(this.string.charAt(0)) || Character.isUpperCase(this.string.charAt(0));
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (Character.isUpperCase(ch) || Character.isTitleCase(ch)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(ch)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    public boolean isspace() {
        return this.str_isspace();
    }

    final boolean str_isspace() {
        int n2 = this.string.length();
        if (n2 == 1) {
            return Character.isWhitespace(this.string.charAt(0));
        }
        if (n2 == 0) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public boolean isunicode() {
        return this.str_isunicode();
    }

    final boolean str_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        int n2 = this.string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.string.charAt(i2);
            if (ch <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public String encode() {
        return this.str_encode(null, null);
    }

    public String encode(String encoding) {
        return this.str_encode(encoding, null);
    }

    public String encode(String encoding, String errors) {
        return this.str_encode(encoding, errors);
    }

    final String str_encode(String encoding, String errors) {
        return codecs.encode(this, encoding, errors);
    }

    public PyObject decode() {
        return this.str_decode(null, null);
    }

    public PyObject decode(String encoding) {
        return this.str_decode(encoding, null);
    }

    public PyObject decode(String encoding, String errors) {
        return this.str_decode(encoding, errors);
    }

    final PyObject str_decode(String encoding, String errors) {
        return codecs.decode(this, encoding, errors);
    }

    @Override
    public String asString(int index) throws PyObject.ConversionException {
        return this.string;
    }

    @Override
    public String asString() {
        return this.string;
    }

    @Override
    public int asInt() {
        PyType type = this.getType();
        if (type == TYPE || type == PyUnicode.TYPE || type.lookup("__int__") == null) {
            throw Py.TypeError("an integer is required");
        }
        return super.asInt();
    }

    @Override
    public String asName(int index) throws PyObject.ConversionException {
        return this.internedString();
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "cannot concatenate ''{1}'' and ''{2}'' objects";
        }
        return super.unsupportedopMessage(op, o2);
    }

    static {
        PyType.addBuilder(PyString.class, new PyString$PyExposer());
        TYPE = PyType.fromClass(PyString.class);
        hexdigit = "0123456789abcdef".toCharArray();
        pucnHash = null;
    }
}

