/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyList$PyExposer;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="list", base=PyObject.class)
public class PyList
extends PySequenceList
implements List {
    public static final PyType TYPE;
    private final List<PyObject> list;
    public volatile int gListAllocatedStatus = -1;

    public PyList() {
        this(TYPE);
    }

    public PyList(PyType type) {
        super(type);
        this.list = Generic.list();
    }

    private PyList(List list, boolean convert) {
        super(TYPE);
        if (!convert) {
            this.list = list;
        } else {
            this.list = Generic.list();
            for (Object o2 : list) {
                this.add(o2);
            }
        }
    }

    public PyList(PyType type, PyObject[] elements) {
        super(type);
        this.list = new ArrayList<PyObject>(Arrays.asList(elements));
    }

    public PyList(PyType type, Collection c2) {
        super(type);
        this.list = new ArrayList<PyObject>(c2.size());
        for (Object o2 : c2) {
            this.add(o2);
        }
    }

    public PyList(PyObject[] elements) {
        this(TYPE, elements);
    }

    public PyList(Collection c2) {
        this(TYPE, c2);
    }

    public PyList(PyObject o2) {
        this(TYPE);
        for (PyObject item : o2.asIterable()) {
            this.list.add(item);
        }
    }

    public static PyList fromList(List<PyObject> list) {
        return new PyList(list, false);
    }

    List<PyObject> getList() {
        return Collections.unmodifiableList(this.list);
    }

    private static List<PyObject> listify(Iterator<PyObject> iter) {
        List<PyObject> list = Generic.list();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public PyList(Iterator<PyObject> iter) {
        this(TYPE, PyList.listify(iter));
    }

    @ExposedNew
    final void list___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("list", args, kwds, new String[]{"sequence"}, 0);
        PyObject seq = ap.getPyObject(0, null);
        this.clear();
        if (seq == null) {
            return;
        }
        if (seq instanceof PyList) {
            this.list.addAll(((PyList)seq).list);
        } else if (seq instanceof PyTuple) {
            this.list.addAll(((PyTuple)seq).getList());
        } else {
            for (PyObject item : seq.asIterable()) {
                this.append(item);
            }
        }
    }

    @Override
    public int __len__() {
        return this.list___len__();
    }

    final synchronized int list___len__() {
        return this.size();
    }

    @Override
    protected void del(int i2) {
        this.remove(i2);
    }

    @Override
    protected void delRange(int start, int stop) {
        this.remove(start, stop);
    }

    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (value instanceof PyList) {
            if (value == this) {
                value = new PyList((PySequence)value);
            }
            this.setslicePyList(start, stop, step, (PyList)value);
        } else if (value instanceof PySequence) {
            this.setsliceIterator(start, stop, step, value.asIterable().iterator());
        } else if (value != null && !(value instanceof List)) {
            value = new PyList(value);
            this.setsliceIterator(start, stop, step, value.asIterable().iterator());
        } else {
            List valueList = (List)value.__tojava__(List.class);
            if (valueList != null && valueList != Py.NoConversion) {
                this.setsliceList(start, stop, step, valueList);
            }
        }
    }

    private final void setsliceList(int start, int stop, int step, List value) {
        int n2 = PyList.sliceLength(start, stop, step);
        if (this.list instanceof ArrayList) {
            ((ArrayList)this.list).ensureCapacity(start + n2);
        }
        ListIterator src = value.listIterator();
        int j2 = start;
        while (src.hasNext()) {
            this.set(j2, src.next());
            j2 += step;
        }
    }

    private final void setsliceIterator(int start, int stop, int step, Iterator<PyObject> iter) {
        if (step == 1) {
            ArrayList<PyObject> insertion = new ArrayList<PyObject>();
            if (iter != null) {
                while (iter.hasNext()) {
                    insertion.add(iter.next());
                }
            }
            this.list.subList(start, stop).clear();
            this.list.addAll(start, insertion);
        } else {
            int size = this.list.size();
            int j2 = start;
            while (iter.hasNext()) {
                PyObject item = iter.next();
                if (j2 >= size) {
                    this.list.add(item);
                } else {
                    this.list.set(j2, item);
                }
                j2 += step;
            }
        }
    }

    private final void setslicePyList(int start, int stop, int step, PyList other) {
        if (step == 1) {
            this.list.subList(start, stop).clear();
            this.list.addAll(start, other.list);
        } else {
            int size = this.list.size();
            ListIterator<PyObject> iter = other.list.listIterator();
            int j2 = start;
            while (iter.hasNext()) {
                PyObject item = (PyObject)iter.next();
                if (j2 >= size) {
                    this.list.add(item);
                } else {
                    this.list.set(j2, item);
                }
                j2 += step;
            }
        }
    }

    @Override
    protected synchronized PyObject repeat(int count) {
        if (count < 0) {
            count = 0;
        }
        int size = this.size();
        int newSize = size * count;
        if (count != 0 && newSize / count != size) {
            throw Py.MemoryError("");
        }
        PyObject[] elements = this.list.toArray(new PyObject[size]);
        PyObject[] newList = new PyObject[newSize];
        for (int i2 = 0; i2 < count; ++i2) {
            System.arraycopy(elements, 0, newList, i2 * size, size);
        }
        return new PyList(newList);
    }

    final synchronized PyObject list___ne__(PyObject o2) {
        return this.seq___ne__(o2);
    }

    final synchronized PyObject list___eq__(PyObject o2) {
        return this.seq___eq__(o2);
    }

    final synchronized PyObject list___lt__(PyObject o2) {
        return this.seq___lt__(o2);
    }

    final synchronized PyObject list___le__(PyObject o2) {
        return this.seq___le__(o2);
    }

    final synchronized PyObject list___gt__(PyObject o2) {
        return this.seq___gt__(o2);
    }

    final synchronized PyObject list___ge__(PyObject o2) {
        return this.seq___ge__(o2);
    }

    @Override
    public PyObject __imul__(PyObject o2) {
        return this.list___imul__(o2);
    }

    final synchronized PyObject list___imul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        int count = o2.asIndex(Py.OverflowError);
        int size = this.size();
        if (size == 0 || count == 1) {
            return this;
        }
        if (count < 1) {
            this.clear();
            return this;
        }
        if (size > Integer.MAX_VALUE / count) {
            throw Py.MemoryError("");
        }
        int newSize = size * count;
        if (this.list instanceof ArrayList) {
            ((ArrayList)this.list).ensureCapacity(newSize);
        }
        ArrayList<PyObject> oldList = new ArrayList<PyObject>(this.list);
        for (int i2 = 1; i2 < count; ++i2) {
            this.list.addAll(oldList);
        }
        this.gListAllocatedStatus = this.__len__();
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.list___mul__(o2);
    }

    final synchronized PyObject list___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.list___rmul__(o2);
    }

    final synchronized PyObject list___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject o2) {
        return this.list___add__(o2);
    }

    final synchronized PyObject list___add__(PyObject o2) {
        Object oList;
        PyList sum = null;
        if (o2 instanceof PySequenceList && !(o2 instanceof PyTuple)) {
            if (o2 instanceof PyList) {
                List<PyObject> oList2 = ((PyList)o2).list;
                ArrayList<PyObject> newList = new ArrayList<PyObject>(this.list.size() + oList2.size());
                newList.addAll(this.list);
                newList.addAll(oList2);
                sum = PyList.fromList(newList);
            }
        } else if (!(o2 instanceof PySequenceList) && (oList = o2.__tojava__(List.class)) != Py.NoConversion && oList != null) {
            List otherList = (List)oList;
            sum = new PyList();
            sum.list_extend(this);
            Iterator i2 = otherList.iterator();
            while (i2.hasNext()) {
                sum.add(i2.next());
            }
        }
        return sum;
    }

    @Override
    public PyObject __radd__(PyObject o2) {
        return this.list___radd__(o2);
    }

    final synchronized PyObject list___radd__(PyObject o2) {
        PyList sum = null;
        if (o2 instanceof PySequence) {
            return null;
        }
        Object oList = o2.__tojava__(List.class);
        if (oList != Py.NoConversion && oList != null) {
            sum = new PyList();
            sum.addAll((Collection)((List)oList));
            sum.extend(this);
        }
        return sum;
    }

    final synchronized boolean list___contains__(PyObject o2) {
        return this.object___contains__(o2);
    }

    final synchronized void list___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final synchronized void list___setitem__(PyObject o2, PyObject def) {
        this.seq___setitem__(o2, def);
    }

    final synchronized PyObject list___getitem__(PyObject o2) {
        PyObject ret = this.seq___finditem__(o2);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o2);
        }
        return ret;
    }

    @Override
    public PyObject __iter__() {
        return this.list___iter__();
    }

    public synchronized PyObject list___iter__() {
        return new PyFastSequenceIter(this);
    }

    final synchronized PyObject list___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final synchronized void list___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final synchronized void list___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate list (not \"{2}\") to list";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public String toString() {
        return this.list_toString();
    }

    final synchronized String list_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuilder buf = new StringBuilder("[");
        int length = this.size();
        int i2 = 0;
        for (PyObject item : this.list) {
            buf.append(item.__repr__().toString());
            if (i2 < length - 1) {
                buf.append(", ");
            }
            ++i2;
        }
        buf.append("]");
        ts.exitRepr(this);
        return buf.toString();
    }

    public void append(PyObject o2) {
        this.list_append(o2);
    }

    final synchronized void list_append(PyObject o2) {
        this.pyadd(o2);
        this.gListAllocatedStatus = this.__len__();
    }

    public int count(PyObject o2) {
        return this.list_count(o2);
    }

    final synchronized int list_count(PyObject o2) {
        int count = 0;
        for (PyObject item : this.list) {
            if (!item.equals(o2)) continue;
            ++count;
        }
        return count;
    }

    public int index(PyObject o2) {
        return this.index(o2, 0);
    }

    public int index(PyObject o2, int start) {
        return this.list_index(o2, start, this.size());
    }

    public int index(PyObject o2, int start, int stop) {
        return this.list_index(o2, start, stop);
    }

    final synchronized int list_index(PyObject o2, PyObject start, PyObject stop) {
        int startInt = start == null ? 0 : PySlice.calculateSliceIndex(start);
        int stopInt = stop == null ? this.size() : PySlice.calculateSliceIndex(stop);
        return this.list_index(o2, startInt, stopInt);
    }

    final synchronized int list_index(PyObject o2, int start, int stop) {
        return this._index(o2, "list.index(x): x not in list", start, stop);
    }

    final synchronized int list_index(PyObject o2, int start) {
        return this._index(o2, "list.index(x): x not in list", start, this.size());
    }

    final synchronized int list_index(PyObject o2) {
        return this._index(o2, "list.index(x): x not in list", 0, this.size());
    }

    private int _index(PyObject o2, String message, int start, int stop) {
        int validStart;
        int validStop = this.boundToSequence(stop);
        int i2 = validStart = this.boundToSequence(start);
        if (validStart <= validStop) {
            try {
                for (PyObject item : this.list.subList(validStart, validStop)) {
                    if (item.equals(o2)) {
                        return i2;
                    }
                    ++i2;
                }
            }
            catch (ConcurrentModificationException ex) {
                throw Py.ValueError(message);
            }
        }
        throw Py.ValueError(message);
    }

    public void insert(int index, PyObject o2) {
        this.list_insert(index, o2);
    }

    final synchronized void list_insert(int index, PyObject o2) {
        if (index < 0) {
            index = Math.max(0, this.size() + index);
        }
        if (index > this.size()) {
            index = this.size();
        }
        this.pyadd(index, o2);
        this.gListAllocatedStatus = this.__len__();
    }

    public void remove(PyObject o2) {
        this.list_remove(o2);
    }

    final synchronized void list_remove(PyObject o2) {
        this.del(this._index(o2, "list.remove(x): x not in list", 0, this.size()));
        this.gListAllocatedStatus = this.__len__();
    }

    public void reverse() {
        this.list_reverse();
    }

    final synchronized void list_reverse() {
        Collections.reverse(this.list);
        this.gListAllocatedStatus = this.__len__();
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n2) {
        return this.list_pop(n2);
    }

    final synchronized PyObject list_pop(int n2) {
        int length = this.size();
        if (length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n2 < 0) {
            n2 += length;
        }
        if (n2 < 0 || n2 >= length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject v = this.list.remove(n2);
        return v;
    }

    public void extend(PyObject o2) {
        this.list_extend(o2);
    }

    final synchronized void list_extend(PyObject o2) {
        if (o2 instanceof PyList) {
            this.list.addAll(((PyList)o2).list);
        } else {
            for (PyObject item : o2.asIterable()) {
                this.list.add(item);
            }
        }
        this.gListAllocatedStatus = this.__len__();
    }

    @Override
    public PyObject __iadd__(PyObject o2) {
        return this.list___iadd__(o2);
    }

    final synchronized PyObject list___iadd__(PyObject o2) {
        PyObject it;
        PyType oType = o2.getType();
        if (oType == TYPE || oType == PyTuple.TYPE || this == o2) {
            this.extend(PyList.fastSequence(o2, "argument must be iterable"));
            return this;
        }
        try {
            it = o2.__iter__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.TypeError)) {
                throw pye;
            }
            return null;
        }
        this.extend(it);
        return this;
    }

    final synchronized void list_sort(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("list", args, kwds, new String[]{"cmp", "key", "reverse"}, 0);
        PyObject cmp = ap.getPyObject(0, Py.None);
        PyObject key = ap.getPyObject(1, Py.None);
        PyObject reverse = ap.getPyObject(2, Py.False);
        this.sort(cmp, key, reverse);
    }

    public void sort(PyObject cmp, PyObject key, PyObject reverse) {
        boolean bReverse = reverse.__nonzero__();
        if (key == Py.None || key == null) {
            if (cmp == Py.None || cmp == null) {
                this.sort(bReverse);
            } else {
                this.sort(cmp, bReverse);
            }
        } else {
            this.sort(cmp, key, bReverse);
        }
    }

    public void sort() {
        this.sort(false);
    }

    private synchronized void sort(boolean reverse) {
        this.gListAllocatedStatus = -1;
        if (reverse) {
            Collections.reverse(this.list);
        }
        Collections.sort(this.list, new PyObjectDefaultComparator(this));
        if (reverse) {
            Collections.reverse(this.list);
        }
        this.gListAllocatedStatus = this.__len__();
    }

    public void sort(PyObject compare) {
        this.sort(compare, false);
    }

    private synchronized void sort(PyObject compare, boolean reverse) {
        this.gListAllocatedStatus = -1;
        if (reverse) {
            Collections.reverse(this.list);
        }
        PyObjectComparator c2 = new PyObjectComparator(this, compare);
        Collections.sort(this.list, c2);
        if (reverse) {
            Collections.reverse(this.list);
        }
        this.gListAllocatedStatus = this.__len__();
    }

    private synchronized void sort(PyObject cmp, PyObject key, boolean reverse) {
        this.gListAllocatedStatus = -1;
        int size = this.list.size();
        ArrayList<KV> decorated = new ArrayList<KV>(size);
        for (PyObject value : this.list) {
            decorated.add(new KV(key.__call__(value), value));
        }
        this.list.clear();
        KVComparator c2 = new KVComparator(this, cmp);
        if (reverse) {
            Collections.reverse(decorated);
        }
        Collections.sort(decorated, c2);
        if (reverse) {
            Collections.reverse(decorated);
        }
        if (this.list instanceof ArrayList) {
            ((ArrayList)this.list).ensureCapacity(size);
        }
        for (KV kv : decorated) {
            this.list.add(kv.value);
        }
        this.gListAllocatedStatus = this.__len__();
    }

    @Override
    public int hashCode() {
        return this.list___hash__();
    }

    final synchronized int list___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return new PyTuple(new PyTuple(this.getArray()));
    }

    @Override
    public void add(int index, Object element) {
        this.pyadd(index, Py.java2py(element));
    }

    @Override
    public boolean add(Object o2) {
        this.pyadd(Py.java2py(o2));
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection c2) {
        PyList elements = new PyList(c2);
        return this.list.addAll(index, elements.list);
    }

    @Override
    public boolean addAll(Collection c2) {
        return this.addAll(0, c2);
    }

    @Override
    public synchronized void clear() {
        this.list.clear();
    }

    @Override
    public synchronized boolean contains(Object o2) {
        return this.list.contains(Py.java2py(o2));
    }

    @Override
    public synchronized boolean containsAll(Collection c2) {
        if (c2 instanceof PyList) {
            return this.list.containsAll(((PyList)c2).list);
        }
        if (c2 instanceof PyTuple) {
            return this.list.containsAll(((PyTuple)c2).getList());
        }
        return this.list.containsAll(new PyList(c2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PyObject) {
            PyList pyList = this;
            synchronized (pyList) {
                return this._eq((PyObject)other).__nonzero__();
            }
        }
        if (other instanceof List) {
            PyList pyList = this;
            synchronized (pyList) {
                return ((Object)this.list).equals(other);
            }
        }
        return false;
    }

    @Override
    public synchronized Object get(int index) {
        return this.list.get(index).__tojava__(Object.class);
    }

    @Override
    public synchronized PyObject[] getArray() {
        T[] a2 = null;
        return (PyObject[])this.list.toArray(a2);
    }

    @Override
    public synchronized int indexOf(Object o2) {
        return this.list.indexOf(Py.java2py(o2));
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final Iterator<PyObject> iter;
            {
                this.iter = PyList.this.list.iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            public void remove() {
                this.iter.remove();
            }
        };
    }

    @Override
    public synchronized int lastIndexOf(Object o2) {
        return this.list.lastIndexOf(Py.java2py(o2));
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private final ListIterator<PyObject> iter;
            {
                this.iter = PyList.this.list.listIterator(index);
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            public Object previous() {
                return this.iter.previous().__tojava__(Object.class);
            }

            public int nextIndex() {
                return this.iter.nextIndex();
            }

            public int previousIndex() {
                return this.iter.previousIndex();
            }

            public void remove() {
                this.iter.remove();
            }

            public void set(Object o2) {
                this.iter.set(Py.java2py(o2));
            }

            public void add(Object o2) {
                this.iter.add(Py.java2py(o2));
            }
        };
    }

    @Override
    public synchronized void pyadd(int index, PyObject element) {
        this.list.add(index, element);
    }

    @Override
    public synchronized boolean pyadd(PyObject o2) {
        this.list.add(o2);
        return true;
    }

    @Override
    public synchronized PyObject pyget(int index) {
        return this.list.get(index);
    }

    @Override
    public synchronized void pyset(int index, PyObject element) {
        this.list.set(index, element);
    }

    @Override
    public synchronized Object remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public synchronized void remove(int start, int stop) {
        this.list.subList(start, stop).clear();
    }

    @Override
    public synchronized boolean removeAll(Collection c2) {
        if (c2 instanceof PySequenceList) {
            return this.list.removeAll(c2);
        }
        return this.list.removeAll(new PyList(c2));
    }

    @Override
    public synchronized boolean retainAll(Collection c2) {
        if (c2 instanceof PySequenceList) {
            return this.list.retainAll(c2);
        }
        return this.list.retainAll(new PyList(c2));
    }

    @Override
    public synchronized Object set(int index, Object element) {
        return this.list.set(index, Py.java2py(element)).__tojava__(Object.class);
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    @Override
    public synchronized List subList(int fromIndex, int toIndex) {
        return PyList.fromList(this.list.subList(fromIndex, toIndex));
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] copy = this.list.toArray();
        for (int i2 = 0; i2 < copy.length; ++i2) {
            copy[i2] = ((PyObject)copy[i2]).__tojava__(Object.class);
        }
        return copy;
    }

    @Override
    public synchronized Object[] toArray(Object[] a2) {
        int i2;
        int size = this.size();
        Class<?> type = a2.getClass().getComponentType();
        if (a2.length < size) {
            a2 = (Object[])Array.newInstance(type, size);
        }
        for (i2 = 0; i2 < size; ++i2) {
            a2[i2] = this.list.get(i2).__tojava__(type);
        }
        if (a2.length > size) {
            for (i2 = size; i2 < a2.length; ++i2) {
                a2[i2] = null;
            }
        }
        return a2;
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        ArrayList<PyObject> newList;
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n2 = PyList.sliceLength(start, stop, step);
        if (step == 1) {
            newList = new ArrayList<PyObject>(this.list.subList(start, stop));
        } else {
            newList = new ArrayList(n2);
            int i2 = start;
            for (int j2 = 0; j2 < n2; ++j2) {
                newList.add(this.list.get(i2));
                i2 += step;
            }
        }
        return PyList.fromList(newList);
    }

    @Override
    public synchronized boolean remove(Object o2) {
        return this.list.remove(Py.java2py(o2));
    }

    static {
        PyType.addBuilder(PyList.class, new PyList$PyExposer());
        TYPE = PyType.fromClass(PyList.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KVComparator
    implements Comparator<KV> {
        private final PyList list;
        private final PyObject cmp;

        KVComparator(PyList list, PyObject cmp) {
            this.list = list;
            this.cmp = cmp;
        }

        @Override
        public int compare(KV o1, KV o2) {
            int result = this.cmp != null && this.cmp != Py.None ? this.cmp.__call__(o1.key, o2.key).asInt() : o1.key._cmp(o2.key);
            if (this.list.gListAllocatedStatus >= 0) {
                throw Py.ValueError("list modified during sort");
            }
            return result;
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (o2 instanceof KVComparator) {
                return this.cmp.equals(((KVComparator)o2).cmp);
            }
            return false;
        }
    }

    private static class KV {
        private final PyObject key;
        private final PyObject value;

        KV(PyObject key, PyObject value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PyObjectComparator
    implements Comparator<PyObject> {
        private final PyList list;
        private final PyObject cmp;

        PyObjectComparator(PyList list, PyObject cmp) {
            this.list = list;
            this.cmp = cmp;
        }

        @Override
        public int compare(PyObject o1, PyObject o2) {
            int result = this.cmp.__call__(o1, o2).asInt();
            if (this.list.gListAllocatedStatus >= 0) {
                throw Py.ValueError("list modified during sort");
            }
            return result;
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            if (o2 instanceof PyObjectComparator) {
                return this.cmp.equals(((PyObjectComparator)o2).cmp);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PyObjectDefaultComparator
    implements Comparator<PyObject> {
        private final PyList list;

        PyObjectDefaultComparator(PyList list) {
            this.list = list;
        }

        @Override
        public int compare(PyObject o1, PyObject o2) {
            int result = o1._cmp(o2);
            if (this.list.gListAllocatedStatus >= 0) {
                throw Py.ValueError("list modified during sort");
            }
            return result;
        }

        @Override
        public boolean equals(Object o2) {
            if (o2 == this) {
                return true;
            }
            return o2 instanceof PyObjectDefaultComparator;
        }
    }
}

