/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.StringTokenizer;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.packagecache.PackageManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyJavaPackage
extends PyObject {
    public String __name__;
    public PyStringMap __dict__;
    public PyStringMap clsSet;
    public String __file__;
    public PackageManager __mgr__;

    public PyJavaPackage(String name) {
        this(name, null, null);
    }

    public PyJavaPackage(String name, String jarfile) {
        this(name, null, jarfile);
    }

    public PyJavaPackage(String name, PackageManager mgr) {
        this(name, mgr, null);
    }

    public PyJavaPackage(String name, PackageManager mgr, String jarfile) {
        this.__file__ = jarfile;
        this.__name__ = name;
        this.__mgr__ = mgr == null ? PySystemState.packageManager : mgr;
        this.clsSet = new PyStringMap();
        this.__dict__ = new PyStringMap();
        this.__dict__.__setitem__("__name__", (PyObject)new PyString(this.__name__));
    }

    public PyJavaPackage addPackage(String name) {
        return this.addPackage(name, null);
    }

    public PyJavaPackage addPackage(String name, String jarfile) {
        PyJavaPackage p;
        int dot = name.indexOf(46);
        String firstName = name;
        String lastName = null;
        if (dot != -1) {
            firstName = name.substring(0, dot);
            lastName = name.substring(dot + 1, name.length());
        }
        if ((p = (PyJavaPackage)this.__dict__.__finditem__(firstName = firstName.intern())) == null) {
            String pname = this.__name__.length() == 0 ? firstName : this.__name__ + '.' + firstName;
            p = new PyJavaPackage(pname, this.__mgr__, jarfile);
            this.__dict__.__setitem__(firstName, (PyObject)p);
        } else if (jarfile == null || !jarfile.equals(p.__file__)) {
            p.__file__ = null;
        }
        if (lastName != null) {
            return p.addPackage(lastName, jarfile);
        }
        return p;
    }

    public PyObject addClass(String name, Class<?> c2) {
        PyObject ret = Py.java2py(c2);
        this.__dict__.__setitem__(name.intern(), ret);
        return ret;
    }

    public void addPlaceholders(String classes) {
        StringTokenizer tok = new StringTokenizer(classes, ",@");
        while (tok.hasMoreTokens()) {
            String p = tok.nextToken();
            String name = p.trim().intern();
            if (this.clsSet.__finditem__(name) != null) continue;
            this.clsSet.__setitem__(name, (PyObject)Py.One);
        }
    }

    @Override
    public PyObject __dir__() {
        return this.__mgr__.doDir(this, false, false);
    }

    public PyObject fillDir() {
        return this.__mgr__.doDir(this, true, false);
    }

    @Override
    public PyObject __findattr_ex__(String name) {
        PyObject ret = this.__dict__.__finditem__(name);
        if (ret != null) {
            return ret;
        }
        if (this.__mgr__.packageExists(this.__name__, name)) {
            this.__mgr__.notifyPackageImport(this.__name__, name);
            return this.addPackage(name);
        }
        Class c2 = this.__mgr__.findClass(this.__name__, name);
        if (c2 != null) {
            return this.addClass(name, c2);
        }
        if (name == "__name__") {
            return new PyString(this.__name__);
        }
        if (name == "__dict__") {
            return this.__dict__;
        }
        if (name == "__mgr__") {
            return Py.java2py(this.__mgr__);
        }
        if (name == "__file__") {
            if (this.__file__ != null) {
                return new PyString(this.__file__);
            }
            return Py.None;
        }
        return null;
    }

    @Override
    public void __setattr__(String attr, PyObject value) {
        if (attr == "__mgr__") {
            PackageManager newMgr = Py.tojava(value, PackageManager.class);
            if (newMgr == null) {
                throw Py.TypeError("cannot set java package __mgr__ to None");
            }
            this.__mgr__ = newMgr;
            return;
        }
        if (attr == "__file__") {
            this.__file__ = value.__str__().toString();
            return;
        }
        super.__setattr__(attr, value);
    }

    @Override
    public String toString() {
        return "<java package " + this.__name__ + " " + Py.idstr(this) + ">";
    }
}

