/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyCell;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PythonTraceFunction;
import org.python.core.TraceFunction;

public class PyFrame
extends PyObject {
    public PyFrame f_back;
    public PyBaseCode f_code;
    public PyObject f_locals;
    public PyObject f_globals;
    public int f_lineno;
    public PyObject f_builtins;
    public PyObject[] f_fastlocals;
    public PyCell[] f_env;
    public int f_ncells;
    public int f_nfreevars;
    public int f_lasti;
    public Object[] f_savedlocals;
    private int env_j = 0;
    private Object generatorInput = Py.None;
    public PyObject[] f_exits;
    public TraceFunction tracefunc;
    private static final String NAME_ERROR_MSG = "name '%.200s' is not defined";
    private static final String GLOBAL_NAME_ERROR_MSG = "global name '%.200s' is not defined";
    private static final String UNBOUNDLOCAL_ERROR_MSG = "local variable '%.200s' referenced before assignment";
    private static final String[] __members__ = new String[]{"f_back", "f_code", "f_locals", "f_globals", "f_lineno", "f_builtins", "f_trace"};

    public PyFrame(PyBaseCode code, PyObject locals, PyObject globals, PyObject builtins) {
        this.f_code = code;
        this.f_locals = locals;
        this.f_globals = globals;
        this.f_builtins = builtins;
        if (locals == null && code != null) {
            if (code.co_flags.isFlagSet(CodeFlag.CO_OPTIMIZED) || code.nargs > 0) {
                if (code.co_nlocals > 0) {
                    this.f_fastlocals = new PyObject[code.co_nlocals - code.jy_npurecell];
                }
            } else {
                this.f_locals = new PyStringMap();
            }
        }
        if (code != null) {
            int env_sz = 0;
            if (code.co_freevars != null) {
                this.f_nfreevars = code.co_freevars.length;
                env_sz += this.f_nfreevars;
            }
            if (code.co_cellvars != null) {
                this.f_ncells = code.co_cellvars.length;
                env_sz += this.f_ncells;
            }
            if (env_sz > 0) {
                this.f_env = new PyCell[env_sz];
            }
        }
    }

    public PyFrame(PyBaseCode code, PyObject globals) {
        this(code, null, globals, null);
    }

    void setupEnv(PyTuple freevars) {
        int ntotal = this.f_ncells + this.f_nfreevars;
        while (this.env_j < this.f_ncells) {
            this.f_env[this.env_j] = new PyCell();
            ++this.env_j;
        }
        int i2 = 0;
        while (this.env_j < ntotal) {
            this.f_env[this.env_j] = (PyCell)freevars.pyget(i2);
            ++i2;
            ++this.env_j;
        }
    }

    public PyObject __dir__() {
        PyObject[] members = new PyString[__members__.length];
        for (int i2 = 0; i2 < __members__.length; ++i2) {
            members[i2] = new PyString(__members__[i2]);
        }
        return new PyList(members);
    }

    void setGeneratorInput(Object value) {
        this.generatorInput = value;
    }

    public Object getGeneratorInput() {
        Object input = this.generatorInput;
        this.generatorInput = Py.None;
        return input;
    }

    public Object checkGeneratorInput() {
        return this.generatorInput;
    }

    private void throwReadonly(String name) {
        for (String member : __members__) {
            if (member != name) continue;
            throw Py.TypeError("readonly attribute");
        }
        throw Py.AttributeError(name);
    }

    public void __setattr__(String name, PyObject value) {
        if (name == "f_trace") {
            this.tracefunc = new PythonTraceFunction(value);
        } else {
            this.throwReadonly(name);
        }
    }

    public void __delattr__(String name) {
        if (name == "f_trace") {
            this.tracefunc = null;
        } else {
            this.throwReadonly(name);
        }
    }

    public PyObject __findattr_ex__(String name) {
        if (name == "f_locals") {
            return this.getLocals();
        }
        if (name == "f_trace") {
            if (this.tracefunc instanceof PythonTraceFunction) {
                return ((PythonTraceFunction)this.tracefunc).tracefunc;
            }
            return Py.None;
        }
        return super.__findattr_ex__(name);
    }

    public PyObject getLocals() {
        if (this.f_locals == null) {
            this.f_locals = new PyStringMap();
        }
        if (this.f_code != null && (this.f_code.co_nlocals > 0 || this.f_nfreevars > 0)) {
            PyObject v;
            int i2;
            if (this.f_fastlocals != null) {
                for (i2 = 0; i2 < this.f_fastlocals.length; ++i2) {
                    PyObject o2 = this.f_fastlocals[i2];
                    if (o2 == null) continue;
                    this.f_locals.__setitem__(this.f_code.co_varnames[i2], o2);
                }
                if (!this.f_code.co_flags.isFlagSet(CodeFlag.CO_OPTIMIZED)) {
                    this.f_fastlocals = null;
                }
            }
            int j2 = 0;
            i2 = 0;
            while (i2 < this.f_ncells) {
                v = this.f_env[j2].ob_ref;
                if (v != null) {
                    this.f_locals.__setitem__(this.f_code.co_cellvars[i2], v);
                }
                ++i2;
                ++j2;
            }
            i2 = 0;
            while (i2 < this.f_nfreevars) {
                v = this.f_env[j2].ob_ref;
                if (v != null) {
                    this.f_locals.__setitem__(this.f_code.co_freevars[i2], v);
                }
                ++i2;
                ++j2;
            }
        }
        return this.f_locals;
    }

    public PyObject getf_locals() {
        return this.f_locals;
    }

    public void setline(int line) {
        this.f_lineno = line;
        if (this.tracefunc != null) {
            this.tracefunc = this.tracefunc.traceLine(this, line);
        }
    }

    public int getline() {
        return this.f_code.getline(this);
    }

    public PyObject getlocal(int index) {
        PyObject ret;
        PyObject ret2;
        if (this.f_fastlocals != null && (ret2 = this.f_fastlocals[index]) != null) {
            return ret2;
        }
        String name = this.f_code.co_varnames[index];
        if (this.f_locals != null && (ret = this.f_locals.__finditem__(name)) != null) {
            return ret;
        }
        throw Py.UnboundLocalError(String.format(UNBOUNDLOCAL_ERROR_MSG, name));
    }

    public PyObject getname(String index) {
        PyObject ret;
        if (this.f_locals == null || this.f_locals == this.f_globals) {
            ret = this.doGetglobal(index);
        } else {
            ret = this.f_locals.__finditem__(index);
            if (ret != null) {
                return ret;
            }
            ret = this.doGetglobal(index);
        }
        if (ret != null) {
            return ret;
        }
        throw Py.NameError(String.format(NAME_ERROR_MSG, index));
    }

    public PyObject getglobal(String index) {
        PyObject ret = this.doGetglobal(index);
        if (ret != null) {
            return ret;
        }
        throw Py.NameError(String.format(GLOBAL_NAME_ERROR_MSG, index));
    }

    private PyObject doGetglobal(String index) {
        PyObject ret = this.f_globals.__finditem__(index);
        if (ret != null) {
            return ret;
        }
        if (this.f_builtins == null) {
            this.f_builtins = PySystemState.builtins;
        }
        return this.f_builtins.__finditem__(index);
    }

    public void setlocal(int index, PyObject value) {
        if (this.f_fastlocals != null) {
            this.f_fastlocals[index] = value;
        } else {
            this.setlocal(this.f_code.co_varnames[index], value);
        }
    }

    public void setlocal(String index, PyObject value) {
        if (this.f_locals == null) {
            throw Py.SystemError(String.format("no locals found when storing '%s'", value));
        }
        this.f_locals.__setitem__(index, value);
    }

    public void setglobal(String index, PyObject value) {
        this.f_globals.__setitem__(index, value);
    }

    public void dellocal(int index) {
        if (this.f_fastlocals != null) {
            if (this.f_fastlocals[index] == null) {
                throw Py.UnboundLocalError(String.format(UNBOUNDLOCAL_ERROR_MSG, this.f_code.co_varnames[index]));
            }
            this.f_fastlocals[index] = null;
        } else {
            this.dellocal(this.f_code.co_varnames[index]);
        }
    }

    public void dellocal(String index) {
        if (this.f_locals != null) {
            try {
                this.f_locals.__delitem__(index);
            }
            catch (PyException pye) {
                if (pye.match(Py.KeyError)) {
                    throw Py.NameError(String.format(NAME_ERROR_MSG, index));
                }
                throw pye;
            }
        } else {
            throw Py.SystemError(String.format("no locals when deleting '%s'", index));
        }
    }

    public void delglobal(String index) {
        try {
            this.f_globals.__delitem__(index);
        }
        catch (PyException pye) {
            if (pye.match(Py.KeyError)) {
                throw Py.NameError(String.format(GLOBAL_NAME_ERROR_MSG, index));
            }
            throw pye;
        }
    }

    public PyObject getclosure(int index) {
        return this.f_env[index];
    }

    public PyObject getderef(int index) {
        PyObject obj = this.f_env[index].ob_ref;
        if (obj != null) {
            return obj;
        }
        String name = index >= this.f_ncells ? this.f_code.co_freevars[index - this.f_ncells] : this.f_code.co_cellvars[index];
        throw Py.UnboundLocalError(String.format(UNBOUNDLOCAL_ERROR_MSG, name));
    }

    public void setderef(int index, PyObject value) {
        this.f_env[index].ob_ref = value;
    }

    public void to_cell(int parm_index, int env_index) {
        this.f_env[env_index].ob_ref = this.f_fastlocals[parm_index];
    }
}

