/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import org.python.core.AbstractArray;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyArray$PyExposer;
import org.python.core.PyArrayDerived;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.util.ByteSwapper;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExposedType(name="array.array", base=PyObject.class)
public class PyArray
extends PySequence
implements Cloneable {
    public static final PyType TYPE;
    private Object data;
    private Class<?> type;
    private String typecode;
    private ArrayDelegate delegate;

    public PyArray(PyType type) {
        super(type);
    }

    public PyArray(Class<?> type, Object data) {
        this(TYPE);
        this.setup(type, data);
    }

    public PyArray(Class<?> type, int n2) {
        this(type, Array.newInstance(type, n2));
    }

    public PyArray(PyArray toCopy) {
        this(toCopy.type, toCopy.delegate.copyArray());
        this.typecode = toCopy.typecode;
    }

    private void setup(Class<?> type, Object data) {
        this.type = type;
        this.typecode = PyArray.class2char(type);
        this.data = data == null ? Array.newInstance(type, 0) : data;
        this.delegate = new ArrayDelegate();
    }

    @ExposedNew
    static final PyObject array_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        String type;
        Class<?> typecode;
        if (new_.for_type != subtype && keywords.length > 0) {
            int argc = args.length - keywords.length;
            PyObject[] justArgs = new PyObject[argc];
            System.arraycopy(args, 0, justArgs, 0, argc);
            args = justArgs;
        }
        ArgParser ap = new ArgParser("array", args, Py.NoKeywords, new String[]{"typecode", "initializer"}, 1);
        ap.noKeywords();
        PyObject obj = ap.getPyObject(0);
        PyObject initial = ap.getPyObject(1, null);
        if (obj instanceof PyString && !(obj instanceof PyUnicode)) {
            if (obj.__len__() != 1) {
                throw Py.TypeError("array() argument 1 must be char, not str");
            }
            String string = obj.toString();
            typecode = PyArray.char2class(string.charAt(0));
        } else if (obj instanceof PyJavaType) {
            typecode = ((PyJavaType)obj).getProxyType();
            type = typecode.getName();
        } else {
            throw Py.TypeError("array() argument 1 must be char, not " + obj.getType().fastGetName());
        }
        PyArray self = new_.for_type == subtype ? new PyArray(subtype) : new PyArrayDerived(subtype);
        PyArray.class2char(typecode);
        self.setup(typecode, Array.newInstance(typecode, 0));
        self.typecode = type;
        if (initial == null) {
            return self;
        }
        if (initial instanceof PyList) {
            self.fromlist(initial);
        } else if (initial instanceof PyString && !(initial instanceof PyUnicode)) {
            self.fromstring(initial.toString());
        } else if ("u".equals(type)) {
            if (initial instanceof PyUnicode) {
                self.extendArray(((PyUnicode)initial).toCodePoints());
            } else {
                self.extendUnicodeIter(initial);
            }
        } else {
            self.extendInternal(initial);
        }
        return self;
    }

    public static PyArray zeros(int n2, char typecode) {
        PyArray array = PyArray.zeros(n2, PyArray.char2class(typecode));
        array.typecode = Character.toString(typecode);
        return array;
    }

    public static PyArray zeros(int n2, Class<?> ctype) {
        PyArray array = new PyArray(ctype, n2);
        array.typecode = ctype.getName();
        return array;
    }

    public static PyArray array(PyObject seq, char typecode) {
        PyArray array = PyArray.array(seq, PyArray.char2class(typecode));
        array.typecode = Character.toString(typecode);
        return array;
    }

    public static PyArray array(PyObject init, Class<?> ctype) {
        PyArray array = new PyArray(ctype, 0);
        array.typecode = ctype.getName();
        array.extendInternal(init);
        return array;
    }

    final PyObject array___ne__(PyObject o2) {
        return this.seq___ne__(o2);
    }

    final PyObject array___eq__(PyObject o2) {
        return this.seq___eq__(o2);
    }

    final PyObject array___lt__(PyObject o2) {
        return this.seq___lt__(o2);
    }

    final PyObject array___le__(PyObject o2) {
        return this.seq___le__(o2);
    }

    final PyObject array___gt__(PyObject o2) {
        return this.seq___gt__(o2);
    }

    final PyObject array___ge__(PyObject o2) {
        return this.seq___ge__(o2);
    }

    final boolean array___contains__(PyObject o2) {
        return this.object___contains__(o2);
    }

    final void array___delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final void array___setitem__(PyObject o2, PyObject def) {
        this.seq___setitem__(o2, def);
    }

    final PyObject array___getitem__(PyObject o2) {
        PyObject ret = this.seq___finditem__(o2);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + o2);
        }
        return ret;
    }

    final boolean array___nonzero__() {
        return this.seq___nonzero__();
    }

    public PyObject array___iter__() {
        return this.seq___iter__();
    }

    final PyObject array___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final void array___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final void array___delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    @Override
    public PyObject __imul__(PyObject o2) {
        return this.array___imul__(o2);
    }

    final PyObject array___imul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        if (this.delegate.getSize() > 0) {
            int count = o2.asIndex(Py.OverflowError);
            if (count <= 0) {
                this.delegate.clear();
                return this;
            }
            Object copy = this.delegate.copyArray();
            this.delegate.ensureCapacity(this.delegate.getSize() * count);
            for (int i2 = 1; i2 < count; ++i2) {
                this.delegate.appendArray(copy);
            }
        }
        return this;
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.array___mul__(o2);
    }

    final PyObject array___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.array___rmul__(o2);
    }

    final PyObject array___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iadd__(PyObject other) {
        return this.array___iadd__(other);
    }

    final PyObject array___iadd__(PyObject other) {
        PyArray otherArr = null;
        if (!(other instanceof PyArray)) {
            throw Py.TypeError(String.format("can only append array (not \"%.200s\") to array", other.getType().fastGetName()));
        }
        otherArr = (PyArray)other;
        if (!otherArr.typecode.equals(this.typecode)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        this.delegate.appendArray(otherArr.delegate.copyArray());
        return this;
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.array___add__(other);
    }

    final PyObject array___add__(PyObject other) {
        PyArray otherArr = null;
        if (!(other instanceof PyArray)) {
            throw Py.TypeError("can only append another array to an array");
        }
        otherArr = (PyArray)other;
        if (!otherArr.typecode.equals(this.typecode)) {
            throw Py.TypeError("can only append arrays of the same type, expected '" + this.type + ", found " + otherArr.type);
        }
        PyArray ret = new PyArray(this);
        ret.delegate.appendArray(otherArr.delegate.copyArray());
        return ret;
    }

    @Override
    public int __len__() {
        return this.array___len__();
    }

    final int array___len__() {
        return this.delegate.getSize();
    }

    @Override
    public PyObject __reduce__() {
        return this.array___reduce__();
    }

    final PyObject array___reduce__() {
        PyObject dict = this.__findattr__("__dict__");
        if (dict == null) {
            dict = Py.None;
        }
        if (this.__len__() > 0) {
            return new PyTuple(this.getType(), new PyTuple(Py.newString(this.typecode), Py.newString(this.tostring())), dict);
        }
        return new PyTuple(this.getType(), new PyTuple(Py.newString(this.typecode)), dict);
    }

    @Override
    public String toString() {
        if (this.__len__() == 0) {
            return String.format("array(%s)", this.encodeTypecode(this.typecode));
        }
        String value = "c".equals(this.typecode) ? PyString.encode_UnicodeEscape(this.tostring(), true) : ("u".equals(this.typecode) ? new PyUnicode(this.tounicode()).__repr__().toString() : this.tolist().toString());
        return String.format("array(%s, %s)", this.encodeTypecode(this.typecode), value);
    }

    private String encodeTypecode(String typecode) {
        if (typecode.length() > 1) {
            return typecode;
        }
        return "'" + typecode + "'";
    }

    @Override
    public Object __tojava__(Class<?> c2) {
        if (c2 == Object.class || c2.isArray() && c2.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (c2.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    public final void array_append(PyObject value) {
        this.append(value);
    }

    private static int getCodePoint(PyObject obj) {
        PyUnicode u;
        int[] codepoints;
        if (obj instanceof PyUnicode && (codepoints = (u = (PyUnicode)obj).toCodePoints()).length == 1) {
            return codepoints[0];
        }
        throw Py.TypeError("array item must be unicode character");
    }

    private static int getCodePointOrInt(PyObject obj) {
        if (obj instanceof PyUnicode) {
            PyUnicode u = (PyUnicode)obj;
            return u.toCodePoints()[0];
        }
        if (obj instanceof PyString) {
            PyString s = (PyString)obj;
            return s.toString().charAt(0);
        }
        if (obj.__nonzero__()) {
            return obj.asInt();
        }
        return -1;
    }

    public void append(PyObject value) {
        int afterLast = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePoint(value);
            this.delegate.makeInsertSpace(afterLast);
            Array.setInt(this.data, afterLast, codepoint);
        } else {
            this.delegate.makeInsertSpace(afterLast);
            try {
                this.set(afterLast, value);
            }
            catch (PyException e2) {
                this.delegate.setSize(afterLast);
                throw new PyException(e2.type, e2.value);
            }
        }
    }

    public void array_byteswap() {
        this.byteswap();
    }

    public void byteswap() {
        if (this.getStorageSize() == 0 || "u".equals(this.typecode)) {
            throw Py.RuntimeError("don't know how to byteswap this array type");
        }
        ByteSwapper.swap(this.data);
    }

    public Object clone() {
        return new PyArray(this);
    }

    public static Class<?> char2class(char type) throws PyIgnoreMethodTag {
        switch (type) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'B': {
                return Short.TYPE;
            }
            case 'u': {
                return Integer.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'H': {
                return Integer.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'I': {
                return Long.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'L': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("bad typecode (must be c, b, B, u, h, H, i, I, l, L, f or d)");
    }

    private static String class2char(Class<?> cls) {
        if (cls.equals(Boolean.TYPE)) {
            return "z";
        }
        if (cls.equals(Character.TYPE)) {
            return "c";
        }
        if (cls.equals(Byte.TYPE)) {
            return "b";
        }
        if (cls.equals(Short.TYPE)) {
            return "h";
        }
        if (cls.equals(Integer.TYPE)) {
            return "i";
        }
        if (cls.equals(Long.TYPE)) {
            return "l";
        }
        if (cls.equals(Float.TYPE)) {
            return "f";
        }
        if (cls.equals(Double.TYPE)) {
            return "d";
        }
        return cls.getName();
    }

    public final int array_count(PyObject value) {
        int iCount = 0;
        int len = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePointOrInt(value);
            for (int i2 = 0; i2 < len; ++i2) {
                if (codepoint != Array.getInt(this.data, i2)) continue;
                ++iCount;
            }
        } else {
            for (int i3 = 0; i3 < len; ++i3) {
                if (!value.equals(Py.java2py(Array.get(this.data, i3)))) continue;
                ++iCount;
            }
        }
        return iCount;
    }

    public PyInteger count(PyObject value) {
        return Py.newInteger(this.array_count(value));
    }

    @Override
    protected void del(int i2) {
        this.delegate.remove(i2);
    }

    @Override
    protected void delRange(int start, int stop) {
        this.delegate.remove(start, stop);
    }

    public final void array_extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    public void extend(PyObject iterable) {
        this.extendInternal(iterable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void extendInternal(PyObject iterable) {
        if (iterable instanceof PyUnicode) {
            if ("u".equals(this.typecode)) {
                this.extendUnicodeIter(iterable);
                return;
            }
            if (!"c".equals(this.typecode)) throw Py.TypeError("an integer is required");
            throw Py.TypeError("array item must be char");
        }
        if (iterable instanceof PyString) {
            this.fromstring(((PyString)iterable).toString());
            return;
        }
        if (!(iterable instanceof PyArray)) {
            this.extendInternalIter(iterable);
            return;
        }
        PyArray source = (PyArray)iterable;
        if (!source.typecode.equals(this.typecode)) {
            throw Py.TypeError("can only extend with array of same kind");
        }
        this.delegate.appendArray(source.delegate.copyArray());
    }

    private void extendInternalIter(PyObject iterable) {
        if (iterable.__findattr__("__len__") == null) {
            for (PyObject item : iterable.asIterable()) {
                this.append(item);
            }
        } else {
            int last = this.delegate.getSize();
            this.delegate.ensureCapacity(last + iterable.__len__());
            for (PyObject item : iterable.asIterable()) {
                this.set(last++, item);
                ++this.delegate.size;
            }
        }
    }

    private void extendUnicodeIter(PyObject iterable) {
        for (PyObject item : iterable.asIterable()) {
            PyUnicode uitem;
            try {
                uitem = (PyUnicode)item;
            }
            catch (ClassCastException e2) {
                throw Py.TypeError("Type not compatible with array type");
            }
            for (int codepoint : uitem.toCodePoints()) {
                int afterLast = this.delegate.getSize();
                this.delegate.makeInsertSpace(afterLast);
                Array.setInt(this.data, afterLast, codepoint);
            }
        }
    }

    private void extendArray(int[] items) {
        int last = this.delegate.getSize();
        this.delegate.ensureCapacity(last + items.length);
        for (int item : items) {
            Array.set(this.data, last++, item);
            ++this.delegate.size;
        }
    }

    public final void array_fromfile(PyObject f2, int count) {
        this.fromfile(f2, count);
    }

    public void fromfile(PyObject f2, int count) {
        if (!(f2 instanceof PyFile)) {
            throw Py.TypeError("arg1 must be open file");
        }
        PyFile file = (PyFile)f2;
        int readbytes = count * this.getStorageSize();
        String buffer = file.read(readbytes).toString();
        this.fromstring(buffer);
        if (buffer.length() < readbytes) {
            int readcount = buffer.length() / this.getStorageSize();
            throw Py.EOFError("not enough items in file. " + Integer.toString(count) + " requested, " + Integer.toString(readcount) + " actually read");
        }
    }

    public final void array_fromlist(PyObject obj) {
        this.fromlist(obj);
    }

    public void fromlist(PyObject obj) {
        if (!(obj instanceof PyList)) {
            throw Py.TypeError("arg must be list");
        }
        int size = this.delegate.getSize();
        try {
            this.extendInternalIter(obj);
        }
        catch (PyException e2) {
            this.delegate.setSize(size);
            throw new PyException(e2.type, e2.value);
        }
    }

    private int fromStream(InputStream is) throws IOException, EOFException {
        return this.fromStream(is, is.available() / this.getStorageSize());
    }

    private int fromStream(InputStream is, int count) throws IOException, EOFException {
        int origsize;
        DataInputStream dis = new DataInputStream(is);
        int index = origsize = this.delegate.getSize();
        this.delegate.ensureCapacity(index + count);
        if (this.type.isPrimitive()) {
            switch (this.typecode.charAt(0)) {
                case 'z': {
                    int i2 = 0;
                    while (i2 < count) {
                        Array.setBoolean(this.data, index, dis.readBoolean());
                        ++this.delegate.size;
                        ++i2;
                        ++index;
                    }
                    break;
                }
                case 'b': {
                    int i3 = 0;
                    while (i3 < count) {
                        Array.setByte(this.data, index, dis.readByte());
                        ++this.delegate.size;
                        ++i3;
                        ++index;
                    }
                    break;
                }
                case 'B': {
                    int i4 = 0;
                    while (i4 < count) {
                        Array.setShort(this.data, index, PyArray.unsignedByte(dis.readByte()));
                        ++this.delegate.size;
                        ++i4;
                        ++index;
                    }
                    break;
                }
                case 'u': {
                    int i5 = 0;
                    while (i5 < count) {
                        Array.setInt(this.data, index, dis.readInt());
                        ++this.delegate.size;
                        ++i5;
                        ++index;
                    }
                    break;
                }
                case 'c': {
                    int i6 = 0;
                    while (i6 < count) {
                        Array.setChar(this.data, index, (char)(dis.readByte() & 0xFF));
                        ++this.delegate.size;
                        ++i6;
                        ++index;
                    }
                    break;
                }
                case 'h': {
                    int i7 = 0;
                    while (i7 < count) {
                        Array.setShort(this.data, index, dis.readShort());
                        ++this.delegate.size;
                        ++i7;
                        ++index;
                    }
                    break;
                }
                case 'H': {
                    int i8 = 0;
                    while (i8 < count) {
                        Array.setInt(this.data, index, PyArray.unsignedShort(dis.readShort()));
                        ++this.delegate.size;
                        ++i8;
                        ++index;
                    }
                    break;
                }
                case 'i': {
                    int i9 = 0;
                    while (i9 < count) {
                        Array.setInt(this.data, index, dis.readInt());
                        ++this.delegate.size;
                        ++i9;
                        ++index;
                    }
                    break;
                }
                case 'I': {
                    int i10 = 0;
                    while (i10 < count) {
                        Array.setLong(this.data, index, PyArray.unsignedInt(dis.readInt()));
                        ++this.delegate.size;
                        ++i10;
                        ++index;
                    }
                    break;
                }
                case 'l': {
                    int i11 = 0;
                    while (i11 < count) {
                        Array.setLong(this.data, index, dis.readLong());
                        ++this.delegate.size;
                        ++i11;
                        ++index;
                    }
                    break;
                }
                case 'L': {
                    int i12 = 0;
                    while (i12 < count) {
                        Array.setLong(this.data, index, dis.readLong());
                        ++this.delegate.size;
                        ++i12;
                        ++index;
                    }
                    break;
                }
                case 'f': {
                    int i13 = 0;
                    while (i13 < count) {
                        Array.setFloat(this.data, index, dis.readFloat());
                        ++this.delegate.size;
                        ++i13;
                        ++index;
                    }
                    break;
                }
                case 'd': {
                    int i14 = 0;
                    while (i14 < count) {
                        Array.setDouble(this.data, index, dis.readDouble());
                        ++this.delegate.size;
                        ++i14;
                        ++index;
                    }
                    break;
                }
            }
        }
        dis.close();
        return index - origsize;
    }

    public void fromstring(String input) {
        this.array_fromstring(input);
    }

    final void array_fromstring(String input) {
        int itemsize = this.getStorageSize();
        int strlen = input.length();
        if (strlen % itemsize != 0) {
            throw Py.ValueError("string length not a multiple of item size");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(StringUtil.toBytes(input));
        int origsize = this.delegate.getSize();
        try {
            this.fromStream(bis);
        }
        catch (EOFException e2) {
            throw Py.EOFError("not enough items in string");
        }
        catch (IOException e3) {
            this.delegate.setSize(origsize);
            throw Py.IOError(e3);
        }
    }

    public void fromunicode(PyUnicode input) {
        this.array_fromunicode(input);
    }

    final void array_fromunicode(PyObject input) {
        if (!(input instanceof PyUnicode)) {
            throw Py.ValueError("fromunicode argument must be an unicode object");
        }
        if (!"u".equals(this.typecode)) {
            throw Py.ValueError("fromunicode() may only be called on type 'u' arrays");
        }
        this.extend(input);
    }

    @Override
    protected PyObject pyget(int i2) {
        if ("u".equals(this.typecode)) {
            return new PyUnicode(Array.getInt(this.data, i2));
        }
        return Py.java2py(Array.get(this.data, i2));
    }

    public Object getArray() throws PyIgnoreMethodTag {
        return this.delegate.copyArray();
    }

    public int getItemsize() {
        if (this.type.isPrimitive()) {
            if (this.type == Boolean.TYPE) {
                return 1;
            }
            if (this.type == Byte.TYPE) {
                return 1;
            }
            if (this.type == Character.TYPE) {
                return 1;
            }
            if (this.type == Short.TYPE) {
                return 2;
            }
            if (this.type == Integer.TYPE) {
                return 4;
            }
            if (this.type == Long.TYPE) {
                return 8;
            }
            if (this.type == Float.TYPE) {
                return 4;
            }
            if (this.type == Double.TYPE) {
                return 8;
            }
        }
        return 0;
    }

    public int getStorageSize() {
        if (this.type.isPrimitive()) {
            switch (this.typecode.charAt(0)) {
                case 'z': {
                    return 1;
                }
                case 'b': {
                    return 1;
                }
                case 'B': {
                    return 1;
                }
                case 'u': {
                    return 4;
                }
                case 'c': {
                    return 1;
                }
                case 'h': {
                    return 2;
                }
                case 'H': {
                    return 2;
                }
                case 'i': {
                    return 4;
                }
                case 'I': {
                    return 4;
                }
                case 'l': {
                    return 8;
                }
                case 'L': {
                    return 8;
                }
                case 'f': {
                    return 4;
                }
                case 'd': {
                    return 8;
                }
            }
            throw Py.ValueError("bad typecode (must be c, b, B, u, h, H, i, I, l, L, f or d)");
        }
        return 0;
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n2 = PyArray.sliceLength(start, stop, step);
        PyArray ret = new PyArray(this.type, n2);
        ret.typecode = this.typecode;
        if (step == 1) {
            System.arraycopy(this.data, start, ret.data, 0, n2);
            return ret;
        }
        int i2 = start;
        for (int j2 = 0; j2 < n2; ++j2) {
            Array.set(ret.data, j2, Array.get(this.data, i2));
            i2 += step;
        }
        return ret;
    }

    public String getTypecode() {
        return this.typecode;
    }

    public final int array_index(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            return index;
        }
        throw Py.ValueError("array.index(" + value + "): " + value + " not found in array");
    }

    public PyObject index(PyObject value) {
        return Py.newInteger(this.array_index(value));
    }

    private int indexInternal(PyObject value) {
        int len = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePointOrInt(value);
            for (int i2 = 0; i2 < len; ++i2) {
                if (codepoint != Array.getInt(this.data, i2)) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < len; ++i3) {
                if (!value.equals(Py.java2py(Array.get(this.data, i3)))) continue;
                return i3;
            }
        }
        return -1;
    }

    public final void array_insert(int index, PyObject value) {
        this.insert(index, value);
    }

    public void insert(int index, PyObject value) {
        index = this.boundToSequence(index);
        if ("u".equals(this.typecode)) {
            int codepoint = PyArray.getCodePoint(value);
            this.delegate.makeInsertSpace(index);
            Array.setInt(this.data, index, codepoint);
        } else {
            this.delegate.makeInsertSpace(index);
            Array.set(this.data, index, Py.tojava(value, this.type));
        }
    }

    public final PyObject array_pop(int i2) {
        PyObject val = this.pop(i2);
        if ("u".equals(this.typecode)) {
            return new PyUnicode(val.asInt());
        }
        return val;
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int index) {
        if (this.delegate.getSize() == 0) {
            throw Py.IndexError("pop from empty array");
        }
        if ((index = this.delegator.fixindex(index)) == -1) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject ret = Py.java2py(Array.get(this.data, index));
        this.delegate.remove(index);
        return ret;
    }

    public final void array_remove(PyObject value) {
        this.remove(value);
    }

    public void remove(PyObject value) {
        int index = this.indexInternal(value);
        if (index != -1) {
            this.delegate.remove(index);
            return;
        }
        throw Py.ValueError("array.remove(" + value + "): " + value + " not found in array");
    }

    @Override
    protected PyObject repeat(int count) {
        Object arraycopy = this.delegate.copyArray();
        PyArray ret = new PyArray(this.type, 0);
        ret.typecode = this.typecode;
        for (int i2 = 0; i2 < count; ++i2) {
            ret.delegate.appendArray(arraycopy);
        }
        return ret;
    }

    public final void array_reverse() {
        this.reverse();
    }

    public void reverse() {
        Object array = Array.newInstance(this.type, Array.getLength(this.data));
        int lastIndex = this.delegate.getSize() - 1;
        for (int i2 = 0; i2 <= lastIndex; ++i2) {
            Array.set(array, lastIndex - i2, Array.get(this.data, i2));
        }
        this.data = array;
    }

    public void set(int i2, PyObject value) {
        this.pyset(i2, value);
    }

    @Override
    protected void pyset(int i2, PyObject value) {
        Object object;
        if ("u".equals(this.typecode)) {
            Array.setInt(this.data, i2, PyArray.getCodePoint(value));
            return;
        }
        if (this.type == Byte.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e2) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < (long)(this.isSigned() ? 0 : -128)) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 127L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Short.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e3) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < (long)(this.isSigned() ? 0 : Short.MIN_VALUE)) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > 32767L) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Integer.TYPE) {
            long val;
            try {
                val = (Long)value.__tojava__(Long.TYPE);
            }
            catch (ClassCastException e4) {
                throw Py.TypeError("Type not compatible with array type");
            }
            if (val < (long)(this.isSigned() ? 0 : Integer.MIN_VALUE)) {
                throw Py.OverflowError("value too small for " + this.type.getName());
            }
            if (val > Integer.MAX_VALUE) {
                throw Py.OverflowError("value too large for " + this.type.getName());
            }
        } else if (this.type == Long.TYPE) {
            if (this.isSigned() && value instanceof PyInteger) {
                if (((PyInteger)value).getValue() < 0) {
                    throw Py.OverflowError("value too small for " + this.type.getName());
                }
            } else if (value instanceof PyLong) {
                ((PyLong)value).getLong(this.isSigned() ? 0L : Long.MIN_VALUE, Long.MAX_VALUE);
            } else {
                try {
                    object = value.__tojava__(Long.TYPE);
                }
                catch (ClassCastException classCastException) {
                    throw Py.TypeError("Type not compatible with array type");
                }
                if (object == Py.NoConversion) {
                    throw Py.TypeError("Type not compatible with array type");
                }
            }
        }
        if ((object = Py.tojava(value, this.type)) == Py.NoConversion) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.set(this.data, i2, object);
    }

    public void set(int i2, int value) {
        if (!"u".equals(this.typecode) && this.type != Integer.TYPE && this.type != Long.TYPE) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.setInt(this.data, i2, value);
    }

    public void set(int i2, char value) {
        if (!"c".equals(this.typecode) && this.type != Integer.TYPE && this.type != Long.TYPE) {
            throw Py.TypeError("Type not compatible with array type");
        }
        Array.setChar(this.data, i2, value);
    }

    private boolean isSigned() {
        return this.typecode.length() == 1 && this.typecode.equals(this.typecode.toUpperCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (stop < start) {
            stop = start;
        }
        if (this.type == Character.TYPE && value instanceof PyString) {
            char[] chars = null;
            if (step != 1) {
                throw Py.ValueError("invalid bounds for setting from string");
            }
            chars = value.toString().toCharArray();
            this.delegate.replaceSubArray(start, stop, chars, 0, chars.length);
            return;
        } else if (value instanceof PyString && this.type == Byte.TYPE) {
            byte[] chars = ((PyString)value).toBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        } else {
            if (!(value instanceof PyArray)) throw Py.TypeError(String.format("can only assign array (not \"%.200s\") to array slice", value.getType().fastGetName()));
            PyArray array = (PyArray)value;
            if (!array.typecode.equals(this.typecode)) {
                throw Py.TypeError("bad argument type for built-in operation|" + array.typecode + "|" + this.typecode);
            }
            if (step == 1) {
                Object arrayDelegate = array == this ? array.delegate.copyArray() : array.delegate.getArray();
                try {
                    this.delegate.replaceSubArray(start, stop, arrayDelegate, 0, array.delegate.getSize());
                    return;
                }
                catch (IllegalArgumentException e2) {
                    throw Py.TypeError("Slice typecode '" + array.typecode + "' is not compatible with this array (typecode '" + this.typecode + "')");
                }
            } else if (step > 1) {
                int len = array.__len__();
                int i2 = 0;
                int j2 = 0;
                while (i2 < len) {
                    Array.set(this.data, j2 + start, Array.get(array.data, i2));
                    ++i2;
                    j2 += step;
                }
                return;
            } else {
                if (step >= 0) return;
                if (array == this) {
                    array = (PyArray)array.clone();
                }
                int len = array.__len__();
                int i3 = 0;
                int j3 = this.delegate.getSize() - 1;
                while (i3 < len) {
                    Array.set(this.data, j3, Array.get(array.data, i3));
                    ++i3;
                    j3 += step;
                }
            }
        }
    }

    public final void array_tofile(PyObject f2) {
        this.tofile(f2);
    }

    public void array_write(PyObject f2) {
        this.tofile(f2);
    }

    public void tofile(PyObject f2) {
        if (!(f2 instanceof PyFile)) {
            throw Py.TypeError("arg must be open file");
        }
        PyFile file = (PyFile)f2;
        file.write(this.tostring());
    }

    public final PyObject array_tolist() {
        return this.tolist();
    }

    public PyObject tolist() {
        PyList list = new PyList();
        int len = this.delegate.getSize();
        if ("u".equals(this.typecode)) {
            for (int i2 = 0; i2 < len; ++i2) {
                list.append(new PyUnicode(Array.getInt(this.data, i2)));
            }
        } else {
            for (int i3 = 0; i3 < len; ++i3) {
                list.append(Py.java2py(Array.get(this.data, i3)));
            }
        }
        return list;
    }

    private int toStream(OutputStream os2) throws IOException {
        DataOutputStream dos = new DataOutputStream(os2);
        switch (this.typecode.charAt(0)) {
            case 'z': {
                for (int i2 = 0; i2 < this.delegate.getSize(); ++i2) {
                    dos.writeBoolean(Array.getBoolean(this.data, i2));
                }
                break;
            }
            case 'b': {
                for (int i3 = 0; i3 < this.delegate.getSize(); ++i3) {
                    dos.writeByte(Array.getByte(this.data, i3));
                }
                break;
            }
            case 'B': {
                for (int i4 = 0; i4 < this.delegate.getSize(); ++i4) {
                    dos.writeByte(PyArray.signedByte(Array.getShort(this.data, i4)));
                }
                break;
            }
            case 'u': {
                for (int i5 = 0; i5 < this.delegate.getSize(); ++i5) {
                    dos.writeInt(Array.getInt(this.data, i5));
                }
                break;
            }
            case 'c': {
                for (int i6 = 0; i6 < this.delegate.getSize(); ++i6) {
                    dos.writeByte((byte)Array.getChar(this.data, i6));
                }
                break;
            }
            case 'h': {
                for (int i7 = 0; i7 < this.delegate.getSize(); ++i7) {
                    dos.writeShort(Array.getShort(this.data, i7));
                }
                break;
            }
            case 'H': {
                for (int i8 = 0; i8 < this.delegate.getSize(); ++i8) {
                    dos.writeShort(PyArray.signedShort(Array.getInt(this.data, i8)));
                }
                break;
            }
            case 'i': {
                for (int i9 = 0; i9 < this.delegate.getSize(); ++i9) {
                    dos.writeInt(Array.getInt(this.data, i9));
                }
                break;
            }
            case 'I': {
                for (int i10 = 0; i10 < this.delegate.getSize(); ++i10) {
                    dos.writeInt(PyArray.signedInt(Array.getLong(this.data, i10)));
                }
                break;
            }
            case 'l': {
                for (int i11 = 0; i11 < this.delegate.getSize(); ++i11) {
                    dos.writeLong(Array.getLong(this.data, i11));
                }
                break;
            }
            case 'L': {
                for (int i12 = 0; i12 < this.delegate.getSize(); ++i12) {
                    dos.writeLong(Array.getLong(this.data, i12));
                }
                break;
            }
            case 'f': {
                for (int i13 = 0; i13 < this.delegate.getSize(); ++i13) {
                    dos.writeFloat(Array.getFloat(this.data, i13));
                }
                break;
            }
            case 'd': {
                for (int i14 = 0; i14 < this.delegate.getSize(); ++i14) {
                    dos.writeDouble(Array.getDouble(this.data, i14));
                }
                break;
            }
        }
        return dos.size();
    }

    private static byte signedByte(short x) {
        if (x >= 128 && x < 256) {
            return (byte)(x - 256);
        }
        if (x >= 0) {
            return (byte)x;
        }
        throw Py.ValueError("invalid storage");
    }

    private static short signedShort(int x) {
        if (x >= 32768 && x < 65536) {
            return (short)(x - 65536);
        }
        if (x >= 0) {
            return (short)x;
        }
        throw Py.ValueError("invalid storage");
    }

    private static int signedInt(long x) {
        if (x >= 0x80000000L && x < 0x100000000L) {
            return (int)(x - 0x100000000L);
        }
        if (x >= 0L) {
            return (int)x;
        }
        throw Py.ValueError("invalid storage");
    }

    private static short unsignedByte(byte x) {
        if (x < 0) {
            return (short)(x + 256);
        }
        return x;
    }

    private static int unsignedShort(short x) {
        if (x < 0) {
            return x + 65536;
        }
        return x;
    }

    private static long unsignedInt(int x) {
        if (x < 0) {
            return (long)x + 0x100000000L;
        }
        return x;
    }

    public final PyObject array_tostring() {
        return new PyString(this.tostring());
    }

    public String tostring() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.toStream(bos);
        }
        catch (IOException e2) {
            throw Py.IOError(e2);
        }
        return StringUtil.fromBytes(bos.toByteArray());
    }

    public String tounicode() {
        if (!"u".equals(this.typecode)) {
            throw Py.ValueError("tounicode() may only be called on type 'u' arrays");
        }
        int len = this.delegate.getSize();
        int[] codepoints = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            codepoints[i2] = Array.getInt(this.data, i2);
        }
        return new String(codepoints, 0, codepoints.length);
    }

    public final PyObject array_tounicode() {
        return new PyUnicode(this.tounicode());
    }

    static {
        PyType.addBuilder(PyArray.class, new PyArray$PyExposer());
        TYPE = PyType.fromClass(PyArray.class);
    }

    private class ArrayDelegate
    extends AbstractArray {
        private ArrayDelegate() {
            super(PyArray.this.data == null ? 0 : Array.getLength(PyArray.this.data));
        }

        protected Object getArray() {
            return PyArray.this.data;
        }

        protected void setArray(Object array) {
            PyArray.this.data = array;
        }

        protected Object createArray(int size) {
            Class<?> baseType = PyArray.this.data.getClass().getComponentType();
            return Array.newInstance(baseType, size);
        }
    }
}

