/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import org.python.apache.xerces.impl.io.MalformedByteSequenceException;
import org.python.apache.xerces.impl.msg.XMLMessageFormatter;
import org.python.apache.xerces.util.MessageFormatter;

public class UTF8Reader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final boolean DEBUG_READ = false;
    protected final InputStream fInputStream;
    protected final byte[] fBuffer;
    protected int fOffset;
    private int fSurrogate = -1;
    private final MessageFormatter fFormatter;
    private final Locale fLocale;

    public UTF8Reader(InputStream inputStream) {
        this(inputStream, 2048, (MessageFormatter)new XMLMessageFormatter(), Locale.getDefault());
    }

    public UTF8Reader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    public UTF8Reader(InputStream inputStream, int n2, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, new byte[n2], messageFormatter, locale);
    }

    public UTF8Reader(InputStream inputStream, byte[] byArray, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fBuffer = byArray;
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
    }

    public int read() throws IOException {
        int n2 = this.fSurrogate;
        if (this.fSurrogate == -1) {
            int n3;
            int n4 = 0;
            int n5 = n3 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
            if (n3 == -1) {
                return -1;
            }
            if (n3 < 128) {
                n2 = (char)n3;
            } else if ((n3 & 0xE0) == 192 && (n3 & 0x1E) != 0) {
                int n6;
                int n7 = n6 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n6 == -1) {
                    this.expectedByte(2, 2);
                }
                if ((n6 & 0xC0) != 128) {
                    this.invalidByte(2, 2, n6);
                }
                n2 = n3 << 6 & 0x7C0 | n6 & 0x3F;
            } else if ((n3 & 0xF0) == 224) {
                int n8;
                int n9;
                int n10 = n9 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n9 == -1) {
                    this.expectedByte(2, 3);
                }
                if ((n9 & 0xC0) != 128 || n3 == 237 && n9 >= 160 || (n3 & 0xF) == 0 && (n9 & 0x20) == 0) {
                    this.invalidByte(2, 3, n9);
                }
                int n11 = n8 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n8 == -1) {
                    this.expectedByte(3, 3);
                }
                if ((n8 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n8);
                }
                n2 = n3 << 12 & 0xF000 | n9 << 6 & 0xFC0 | n8 & 0x3F;
            } else if ((n3 & 0xF8) == 240) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = n15 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n15 == -1) {
                    this.expectedByte(2, 4);
                }
                if ((n15 & 0xC0) != 128 || (n15 & 0x30) == 0 && (n3 & 7) == 0) {
                    this.invalidByte(2, 3, n15);
                }
                int n17 = n14 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n14 == -1) {
                    this.expectedByte(3, 4);
                }
                if ((n14 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n14);
                }
                int n18 = n13 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n13 == -1) {
                    this.expectedByte(4, 4);
                }
                if ((n13 & 0xC0) != 128) {
                    this.invalidByte(4, 4, n13);
                }
                if ((n12 = n3 << 2 & 0x1C | n15 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n12);
                }
                int n19 = n12 - 1;
                int n20 = 0xD800 | n19 << 6 & 0x3C0 | n15 << 2 & 0x3C | n14 >> 4 & 3;
                int n21 = 0xDC00 | n14 << 6 & 0x3C0 | n13 & 0x3F;
                n2 = n20;
                this.fSurrogate = n21;
            } else {
                this.invalidByte(1, 1, n3);
            }
        } else {
            this.fSurrogate = -1;
        }
        return n2;
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        byte by;
        int n4 = n2;
        int n5 = 0;
        if (this.fOffset == 0) {
            if (n3 > this.fBuffer.length) {
                n3 = this.fBuffer.length;
            }
            if (this.fSurrogate != -1) {
                cArray[n4++] = (char)this.fSurrogate;
                this.fSurrogate = -1;
                --n3;
            }
            if ((n5 = this.fInputStream.read(this.fBuffer, 0, n3)) == -1) {
                return -1;
            }
            n5 += n4 - n2;
        } else {
            n5 = this.fOffset;
            this.fOffset = 0;
        }
        int n6 = n5;
        int n7 = 0;
        while (n7 < n6) {
            by = this.fBuffer[n7];
            if (by < 0) break;
            cArray[n4++] = (char)by;
            ++n7;
        }
        while (n7 < n6) {
            by = this.fBuffer[n7];
            if (by >= 0) {
                cArray[n4++] = (char)by;
            } else {
                int n8;
                int n9;
                int n10;
                int n11 = by & 0xFF;
                if ((n11 & 0xE0) == 192 && (n11 & 0x1E) != 0) {
                    n10 = -1;
                    if (++n7 < n6) {
                        n10 = this.fBuffer[n7] & 0xFF;
                    } else {
                        n10 = this.fInputStream.read();
                        if (n10 == -1) {
                            if (n4 > n2) {
                                this.fBuffer[0] = (byte)n11;
                                this.fOffset = 1;
                                return n4 - n2;
                            }
                            this.expectedByte(2, 2);
                        }
                        ++n5;
                    }
                    if ((n10 & 0xC0) != 128) {
                        if (n4 > n2) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fOffset = 2;
                            return n4 - n2;
                        }
                        this.invalidByte(2, 2, n10);
                    }
                    n9 = n11 << 6 & 0x7C0 | n10 & 0x3F;
                    cArray[n4++] = (char)n9;
                    --n5;
                } else if ((n11 & 0xF0) == 224) {
                    n10 = -1;
                    if (++n7 < n6) {
                        n10 = this.fBuffer[n7] & 0xFF;
                    } else {
                        n10 = this.fInputStream.read();
                        if (n10 == -1) {
                            if (n4 > n2) {
                                this.fBuffer[0] = (byte)n11;
                                this.fOffset = 1;
                                return n4 - n2;
                            }
                            this.expectedByte(2, 3);
                        }
                        ++n5;
                    }
                    if ((n10 & 0xC0) != 128 || n11 == 237 && n10 >= 160 || (n11 & 0xF) == 0 && (n10 & 0x20) == 0) {
                        if (n4 > n2) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fOffset = 2;
                            return n4 - n2;
                        }
                        this.invalidByte(2, 3, n10);
                    }
                    n9 = -1;
                    if (++n7 < n6) {
                        n9 = this.fBuffer[n7] & 0xFF;
                    } else {
                        n9 = this.fInputStream.read();
                        if (n9 == -1) {
                            if (n4 > n2) {
                                this.fBuffer[0] = (byte)n11;
                                this.fBuffer[1] = (byte)n10;
                                this.fOffset = 2;
                                return n4 - n2;
                            }
                            this.expectedByte(3, 3);
                        }
                        ++n5;
                    }
                    if ((n9 & 0xC0) != 128) {
                        if (n4 > n2) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fBuffer[2] = (byte)n9;
                            this.fOffset = 3;
                            return n4 - n2;
                        }
                        this.invalidByte(3, 3, n9);
                    }
                    n8 = n11 << 12 & 0xF000 | n10 << 6 & 0xFC0 | n9 & 0x3F;
                    cArray[n4++] = (char)n8;
                    n5 -= 2;
                } else if ((n11 & 0xF8) == 240) {
                    int n12;
                    n10 = -1;
                    if (++n7 < n6) {
                        n10 = this.fBuffer[n7] & 0xFF;
                    } else {
                        n10 = this.fInputStream.read();
                        if (n10 == -1) {
                            if (n4 > n2) {
                                this.fBuffer[0] = (byte)n11;
                                this.fOffset = 1;
                                return n4 - n2;
                            }
                            this.expectedByte(2, 4);
                        }
                        ++n5;
                    }
                    if ((n10 & 0xC0) != 128 || (n10 & 0x30) == 0 && (n11 & 7) == 0) {
                        if (n4 > n2) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fOffset = 2;
                            return n4 - n2;
                        }
                        this.invalidByte(2, 4, n10);
                    }
                    n9 = -1;
                    if (++n7 < n6) {
                        n9 = this.fBuffer[n7] & 0xFF;
                    } else {
                        n9 = this.fInputStream.read();
                        if (n9 == -1) {
                            if (n4 > n2) {
                                this.fBuffer[0] = (byte)n11;
                                this.fBuffer[1] = (byte)n10;
                                this.fOffset = 2;
                                return n4 - n2;
                            }
                            this.expectedByte(3, 4);
                        }
                        ++n5;
                    }
                    if ((n9 & 0xC0) != 128) {
                        if (n4 > n2) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fBuffer[2] = (byte)n9;
                            this.fOffset = 3;
                            return n4 - n2;
                        }
                        this.invalidByte(3, 4, n9);
                    }
                    n8 = -1;
                    if (++n7 < n6) {
                        n8 = this.fBuffer[n7] & 0xFF;
                    } else {
                        n8 = this.fInputStream.read();
                        if (n8 == -1) {
                            if (n4 > n2) {
                                this.fBuffer[0] = (byte)n11;
                                this.fBuffer[1] = (byte)n10;
                                this.fBuffer[2] = (byte)n9;
                                this.fOffset = 3;
                                return n4 - n2;
                            }
                            this.expectedByte(4, 4);
                        }
                        ++n5;
                    }
                    if ((n8 & 0xC0) != 128) {
                        if (n4 > n2) {
                            this.fBuffer[0] = (byte)n11;
                            this.fBuffer[1] = (byte)n10;
                            this.fBuffer[2] = (byte)n9;
                            this.fBuffer[3] = (byte)n8;
                            this.fOffset = 4;
                            return n4 - n2;
                        }
                        this.invalidByte(4, 4, n9);
                    }
                    if ((n12 = n11 << 2 & 0x1C | n10 >> 4 & 3) > 16) {
                        this.invalidSurrogate(n12);
                    }
                    int n13 = n12 - 1;
                    int n14 = n10 & 0xF;
                    int n15 = n9 & 0x3F;
                    int n16 = n8 & 0x3F;
                    int n17 = 0xD800 | n13 << 6 & 0x3C0 | n14 << 2 | n15 >> 4;
                    int n18 = 0xDC00 | n15 << 6 & 0x3C0 | n16;
                    cArray[n4++] = (char)n17;
                    if ((n5 -= 2) <= n3) {
                        cArray[n4++] = (char)n18;
                    } else {
                        this.fSurrogate = n18;
                        --n5;
                    }
                } else {
                    if (n4 > n2) {
                        this.fBuffer[0] = (byte)n11;
                        this.fOffset = 1;
                        return n4 - n2;
                    }
                    this.invalidByte(1, 1, n11);
                }
            }
            ++n7;
        }
        return n5;
    }

    public long skip(long l2) throws IOException {
        int n2;
        int n3;
        long l3 = l2;
        char[] cArray = new char[this.fBuffer.length];
        while ((n3 = this.read(cArray, 0, n2 = (long)cArray.length < l3 ? cArray.length : (int)l3)) > 0 && (l3 -= (long)n3) > 0L) {
        }
        long l4 = l2 - l3;
        return l4;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n2) throws IOException {
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "OperationNotSupported", new Object[]{"mark()", "UTF-8"}));
    }

    public void reset() throws IOException {
        this.fOffset = 0;
        this.fSurrogate = -1;
    }

    public void close() throws IOException {
        this.fInputStream.close();
    }

    private void expectedByte(int n2, int n3) throws MalformedByteSequenceException {
        throw new MalformedByteSequenceException(this.fFormatter, this.fLocale, "http://www.w3.org/TR/1998/REC-xml-19980210", "ExpectedByte", new Object[]{Integer.toString(n2), Integer.toString(n3)});
    }

    private void invalidByte(int n2, int n3, int n4) throws MalformedByteSequenceException {
        throw new MalformedByteSequenceException(this.fFormatter, this.fLocale, "http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidByte", new Object[]{Integer.toString(n2), Integer.toString(n3)});
    }

    private void invalidSurrogate(int n2) throws MalformedByteSequenceException {
        throw new MalformedByteSequenceException(this.fFormatter, this.fLocale, "http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidHighSurrogate", new Object[]{Integer.toHexString(n2)});
    }
}

