/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr;

import java.util.ArrayList;
import java.util.List;
import org.python.antlr.AST;
import org.python.antlr.ast.VisitorIF;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.tree.CommonTree;
import org.python.core.PyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonTree
extends AST {
    public boolean from_future_checked = false;
    private int charStartIndex = -1;
    private int charStopIndex = -1;
    private CommonTree node;
    private PythonTree parent;
    protected List<PythonTree> children;

    public PythonTree() {
        this.node = new CommonTree();
    }

    public PythonTree(PyType subType) {
        this.node = new CommonTree();
    }

    public PythonTree(Token t) {
        this.node = new CommonTree(t);
    }

    public PythonTree(int ttype, Token t) {
        CommonToken c2 = new CommonToken(ttype, t.getText());
        c2.setLine(t.getLine());
        c2.setTokenIndex(t.getTokenIndex());
        c2.setCharPositionInLine(t.getCharPositionInLine());
        c2.setChannel(t.getChannel());
        c2.setStartIndex(((CommonToken)t).getStartIndex());
        c2.setStopIndex(((CommonToken)t).getStopIndex());
        this.node = new CommonTree(c2);
    }

    public PythonTree(PythonTree tree) {
        this.node = new CommonTree(tree.getNode());
        this.charStartIndex = tree.getCharStartIndex();
        this.charStopIndex = tree.getCharStopIndex();
    }

    public CommonTree getNode() {
        return this.node;
    }

    public Token getToken() {
        return this.node.getToken();
    }

    public PythonTree dupNode() {
        return new PythonTree(this);
    }

    public boolean isNil() {
        return this.node.isNil();
    }

    public int getAntlrType() {
        return this.node.getType();
    }

    public String getText() {
        return this.node.getText();
    }

    public int getLine() {
        if (this.node.getToken() == null || this.node.getToken().getLine() == 0) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getLine();
            }
            return 1;
        }
        return this.node.getToken().getLine();
    }

    public int getCharPositionInLine() {
        Token token = this.node.getToken();
        if (token == null || token.getCharPositionInLine() == -1) {
            if (this.getChildCount() > 0) {
                return this.getChild(0).getCharPositionInLine();
            }
            return 0;
        }
        if (token != null && token.getCharPositionInLine() == -2) {
            return -1;
        }
        return token.getCharPositionInLine();
    }

    public int getTokenStartIndex() {
        return this.node.getTokenStartIndex();
    }

    public void setTokenStartIndex(int index) {
        this.node.setTokenStartIndex(index);
    }

    public int getTokenStopIndex() {
        return this.node.getTokenStopIndex();
    }

    public void setTokenStopIndex(int index) {
        this.node.setTokenStopIndex(index);
    }

    public int getCharStartIndex() {
        if (this.charStartIndex == -1 && this.node.getToken() != null) {
            return ((CommonToken)this.node.getToken()).getStartIndex();
        }
        return this.charStartIndex;
    }

    public void setCharStartIndex(int index) {
        this.charStartIndex = index;
    }

    public int getCharStopIndex() {
        if (this.charStopIndex == -1 && this.node.getToken() != null) {
            return ((CommonToken)this.node.getToken()).getStopIndex() + 1;
        }
        return this.charStopIndex;
    }

    public void setCharStopIndex(int index) {
        this.charStopIndex = index;
    }

    public int getChildIndex() {
        return this.node.getChildIndex();
    }

    public PythonTree getParent() {
        return this.parent;
    }

    public void setParent(PythonTree t) {
        this.parent = t;
    }

    public void setChildIndex(int index) {
        this.node.setChildIndex(index);
    }

    @Override
    public String toString() {
        if (this.isNil()) {
            return "None";
        }
        if (this.getAntlrType() == 0) {
            return "<errornode>";
        }
        if (this.node.getToken() == null) {
            return null;
        }
        return this.node.getToken().getText() + "(" + this.getLine() + "," + this.getCharPositionInLine() + ")";
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isNil()) {
            buf.append("(");
            buf.append(this.toString());
            buf.append(' ');
        }
        for (int i2 = 0; this.children != null && i2 < this.children.size(); ++i2) {
            PythonTree t = this.children.get(i2);
            if (i2 > 0) {
                buf.append(' ');
            }
            buf.append(t.toStringTree());
        }
        if (!this.isNil()) {
            buf.append(")");
        }
        return buf.toString();
    }

    protected String dumpThis(String s) {
        return s;
    }

    protected String dumpThis(Object o2) {
        if (o2 instanceof PythonTree) {
            return ((PythonTree)o2).toStringTree();
        }
        return String.valueOf(o2);
    }

    protected String dumpThis(Object[] s) {
        StringBuffer sb = new StringBuffer();
        if (s == null) {
            sb.append("null");
        } else {
            sb.append("(");
            for (int i2 = 0; i2 < s.length; ++i2) {
                if (i2 > 0) {
                    sb.append(", ");
                }
                sb.append(this.dumpThis(s[i2]));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public <R> R accept(VisitorIF<R> visitor) throws Exception {
        throw new RuntimeException("Unexpected node: " + this);
    }

    public void traverse(VisitorIF<?> visitor) throws Exception {
        throw new RuntimeException("Cannot traverse node: " + this);
    }

    public PythonTree getChild(int i2) {
        if (this.children == null || i2 >= this.children.size()) {
            return null;
        }
        return this.children.get(i2);
    }

    public List<PythonTree> getChildren() {
        return this.children;
    }

    public PythonTree getFirstChildWithType(int type) {
        for (int i2 = 0; this.children != null && i2 < this.children.size(); ++i2) {
            PythonTree t = this.children.get(i2);
            if (t.getAntlrType() != type) continue;
            return t;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(PythonTree t) {
        if (t == null) {
            return;
        }
        PythonTree childTree = t;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n2 = childTree.children.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        PythonTree c2 = childTree.children.get(i2);
                        this.children.add(c2);
                        c2.setParent(this);
                        c2.setChildIndex(this.children.size() - 1);
                    }
                } else {
                    this.children = childTree.children;
                    this.freshenParentAndChildIndexes();
                }
            }
        } else {
            if (this.children == null) {
                this.children = this.createChildrenList();
            }
            this.children.add(t);
            childTree.setParent(this);
            childTree.setChildIndex(this.children.size() - 1);
        }
    }

    public void addChildren(List<PythonTree> kids) {
        for (int i2 = 0; i2 < kids.size(); ++i2) {
            PythonTree t = kids.get(i2);
            this.addChild(t);
        }
    }

    public void setChild(int i2, PythonTree t) {
        if (t == null) {
            return;
        }
        if (t.isNil()) {
            throw new IllegalArgumentException("Can't set single child to a list");
        }
        if (this.children == null) {
            this.children = this.createChildrenList();
        }
        this.children.set(i2, t);
        t.setParent(this);
        t.setChildIndex(i2);
    }

    public Object deleteChild(int i2) {
        if (this.children == null) {
            return null;
        }
        PythonTree killed = this.children.remove(i2);
        this.freshenParentAndChildIndexes(i2);
        return killed;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        if (this.children == null) {
            throw new IllegalArgumentException("indexes invalid; no children in list");
        }
        int replacingHowMany = stopChildIndex - startChildIndex + 1;
        PythonTree pythonTree = (PythonTree)t;
        List<PythonTree> newTree = null;
        if (pythonTree.isNil()) {
            newTree = pythonTree.children;
        } else {
            newTree = new ArrayList<PythonTree>(1);
            newTree.add(pythonTree);
        }
        int newChildren = newTree.size();
        int numNewChildren = newTree.size();
        int delta = replacingHowMany - newChildren;
        if (delta == 0) {
            int j2 = 0;
            for (int i2 = startChildIndex; i2 <= stopChildIndex; ++i2) {
                PythonTree child = newTree.get(j2);
                this.children.set(i2, child);
                child.setParent(this);
                child.setChildIndex(i2);
                ++j2;
            }
        } else if (delta > 0) {
            int indexToDelete;
            for (int j3 = 0; j3 < numNewChildren; ++j3) {
                this.children.set(startChildIndex + j3, newTree.get(j3));
            }
            for (int c2 = indexToDelete = startChildIndex + numNewChildren; c2 <= stopChildIndex; ++c2) {
                PythonTree killed = this.children.remove(indexToDelete);
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        } else {
            for (int j4 = 0; j4 < replacingHowMany; ++j4) {
                this.children.set(startChildIndex + j4, newTree.get(j4));
            }
            int numToInsert = newChildren - replacingHowMany;
            for (int j5 = replacingHowMany; j5 < newChildren; ++j5) {
                this.children.add(startChildIndex + j5, newTree.get(j5));
            }
            this.freshenParentAndChildIndexes(startChildIndex);
        }
    }

    protected List<PythonTree> createChildrenList() {
        return new ArrayList<PythonTree>();
    }

    public void freshenParentAndChildIndexes() {
        this.freshenParentAndChildIndexes(0);
    }

    public void freshenParentAndChildIndexes(int offset) {
        int n2 = this.getChildCount();
        for (int c2 = offset; c2 < n2; ++c2) {
            PythonTree child = this.getChild(c2);
            child.setChildIndex(c2);
            child.setParent(this);
        }
    }
}

