/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.runners.model.Statement;

public class FailOnTimeout
extends Statement {
    private final Statement fOriginalStatement;
    private final long fTimeout;

    public FailOnTimeout(Statement originalStatement, long timeout) {
        this.fOriginalStatement = originalStatement;
        this.fTimeout = timeout;
    }

    public void evaluate() throws Throwable {
        StatementThread thread2 = this.evaluateStatement();
        if (!thread2.fFinished) {
            this.throwExceptionForUnfinishedThread(thread2);
        }
    }

    private StatementThread evaluateStatement() throws InterruptedException {
        StatementThread thread2 = new StatementThread(this.fOriginalStatement);
        thread2.start();
        thread2.join(this.fTimeout);
        thread2.interrupt();
        return thread2;
    }

    private void throwExceptionForUnfinishedThread(StatementThread thread2) throws Throwable {
        if (thread2.fExceptionThrownByOriginalStatement != null) {
            throw thread2.fExceptionThrownByOriginalStatement;
        }
        this.throwTimeoutException(thread2);
    }

    private void throwTimeoutException(StatementThread thread2) throws Exception {
        Exception exception = new Exception(String.format("test timed out after %d milliseconds", this.fTimeout));
        exception.setStackTrace(thread2.getStackTrace());
        throw exception;
    }

    private static class StatementThread
    extends Thread {
        private final Statement fStatement;
        private boolean fFinished = false;
        private Throwable fExceptionThrownByOriginalStatement = null;

        public StatementThread(Statement statement) {
            this.fStatement = statement;
        }

        public void run() {
            try {
                this.fStatement.evaluate();
                this.fFinished = true;
            }
            catch (InterruptedException e2) {
            }
            catch (Throwable e3) {
                this.fExceptionThrownByOriginalStatement = e3;
            }
        }
    }
}

