/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.vecmath;

import java.io.Serializable;
import org.jogamp.vecmath.GVector;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix3f;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Matrix4f;
import org.jogamp.vecmath.MismatchedSizeException;
import org.jogamp.vecmath.SingularMatrixException;
import org.jogamp.vecmath.VecMathI18N;
import org.jogamp.vecmath.VecMathUtil;

public class GMatrix
implements Serializable,
Cloneable {
    static final long serialVersionUID = 2777097312029690941L;
    private static final boolean debug = false;
    int nRow;
    int nCol;
    double[][] values;
    private static final double EPS = 1.0E-10;

    public GMatrix(int nRow, int nCol) {
        this.values = new double[nRow][nCol];
        this.nRow = nRow;
        this.nCol = nCol;
        int i2 = 0;
        while (i2 < nRow) {
            int j2 = 0;
            while (j2 < nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
        int l2 = nRow < nCol ? nRow : nCol;
        i2 = 0;
        while (i2 < l2) {
            this.values[i2][i2] = 1.0;
            ++i2;
        }
    }

    public GMatrix(int nRow, int nCol, double[] matrix) {
        this.values = new double[nRow][nCol];
        this.nRow = nRow;
        this.nCol = nCol;
        int i2 = 0;
        while (i2 < nRow) {
            int j2 = 0;
            while (j2 < nCol) {
                this.values[i2][j2] = matrix[i2 * nCol + j2];
                ++j2;
            }
            ++i2;
        }
    }

    public GMatrix(GMatrix matrix) {
        this.nRow = matrix.nRow;
        this.nCol = matrix.nCol;
        this.values = new double[this.nRow][this.nCol];
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = matrix.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void mul(GMatrix m1) {
        if (this.nCol != m1.nRow || this.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix0"));
        }
        double[][] tmp = new double[this.nRow][this.nCol];
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                tmp[i2][j2] = 0.0;
                int k2 = 0;
                while (k2 < this.nCol) {
                    double[] dArray = tmp[i2];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + this.values[i2][k2] * m1.values[k2][j2];
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        this.values = tmp;
    }

    public final void mul(GMatrix m1, GMatrix m2) {
        if (m1.nCol != m2.nRow || this.nRow != m1.nRow || this.nCol != m2.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix1"));
        }
        double[][] tmp = new double[this.nRow][this.nCol];
        int i2 = 0;
        while (i2 < m1.nRow) {
            int j2 = 0;
            while (j2 < m2.nCol) {
                tmp[i2][j2] = 0.0;
                int k2 = 0;
                while (k2 < m1.nCol) {
                    double[] dArray = tmp[i2];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + m1.values[i2][k2] * m2.values[k2][j2];
                    ++k2;
                }
                ++j2;
            }
            ++i2;
        }
        this.values = tmp;
    }

    public final void mul(GVector v1, GVector v2) {
        if (this.nRow < v1.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix2"));
        }
        if (this.nCol < v2.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix3"));
        }
        int i2 = 0;
        while (i2 < v1.getSize()) {
            int j2 = 0;
            while (j2 < v2.getSize()) {
                this.values[i2][j2] = v1.values[i2] * v2.values[j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void add(GMatrix m1) {
        if (this.nRow != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix4"));
        }
        if (this.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix5"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = this.values[i2][j2] + m1.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void add(GMatrix m1, GMatrix m2) {
        if (m2.nRow != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix6"));
        }
        if (m2.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix7"));
        }
        if (this.nCol != m1.nCol || this.nRow != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix8"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = m1.values[i2][j2] + m2.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void sub(GMatrix m1) {
        if (this.nRow != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix9"));
        }
        if (this.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix28"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = this.values[i2][j2] - m1.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void sub(GMatrix m1, GMatrix m2) {
        if (m2.nRow != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix10"));
        }
        if (m2.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix11"));
        }
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix12"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = m1.values[i2][j2] - m2.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void negate() {
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = -this.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void negate(GMatrix m1) {
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix13"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = -m1.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void setIdentity() {
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
        int l2 = this.nRow < this.nCol ? this.nRow : this.nCol;
        i2 = 0;
        while (i2 < l2) {
            this.values[i2][i2] = 1.0;
            ++i2;
        }
    }

    public final void setZero() {
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
    }

    public final void identityMinus() {
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = -this.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        int l2 = this.nRow < this.nCol ? this.nRow : this.nCol;
        i2 = 0;
        while (i2 < l2) {
            double[] dArray = this.values[i2];
            int n2 = i2++;
            dArray[n2] = dArray[n2] + 1.0;
        }
    }

    public final void invert() {
        this.invertGeneral(this);
    }

    public final void invert(GMatrix m1) {
        this.invertGeneral(m1);
    }

    public final void copySubMatrix(int rowSource, int colSource, int numRow, int numCol, int rowDest, int colDest, GMatrix target) {
        if (this != target) {
            int i2 = 0;
            while (i2 < numRow) {
                int j2 = 0;
                while (j2 < numCol) {
                    target.values[rowDest + i2][colDest + j2] = this.values[rowSource + i2][colSource + j2];
                    ++j2;
                }
                ++i2;
            }
        } else {
            int j3;
            double[][] tmp = new double[numRow][numCol];
            int i3 = 0;
            while (i3 < numRow) {
                j3 = 0;
                while (j3 < numCol) {
                    tmp[i3][j3] = this.values[rowSource + i3][colSource + j3];
                    ++j3;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < numRow) {
                j3 = 0;
                while (j3 < numCol) {
                    target.values[rowDest + i3][colDest + j3] = tmp[i3][j3];
                    ++j3;
                }
                ++i3;
            }
        }
    }

    public final void setSize(int nRow, int nCol) {
        double[][] tmp = new double[nRow][nCol];
        int maxRow = this.nRow < nRow ? this.nRow : nRow;
        int maxCol = this.nCol < nCol ? this.nCol : nCol;
        int i2 = 0;
        while (i2 < maxRow) {
            int j2 = 0;
            while (j2 < maxCol) {
                tmp[i2][j2] = this.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        this.nRow = nRow;
        this.nCol = nCol;
        this.values = tmp;
    }

    public final void set(double[] matrix) {
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = matrix[this.nCol * i2 + j2];
                ++j2;
            }
            ++i2;
        }
    }

    public final void set(Matrix3f m1) {
        if (this.nCol < 3 || this.nRow < 3) {
            this.nCol = 3;
            this.nRow = 3;
            this.values = new double[this.nRow][this.nCol];
        }
        this.values[0][0] = m1.m00;
        this.values[0][1] = m1.m01;
        this.values[0][2] = m1.m02;
        this.values[1][0] = m1.m10;
        this.values[1][1] = m1.m11;
        this.values[1][2] = m1.m12;
        this.values[2][0] = m1.m20;
        this.values[2][1] = m1.m21;
        this.values[2][2] = m1.m22;
        int i2 = 3;
        while (i2 < this.nRow) {
            int j2 = 3;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
    }

    public final void set(Matrix3d m1) {
        if (this.nRow < 3 || this.nCol < 3) {
            this.values = new double[3][3];
            this.nRow = 3;
            this.nCol = 3;
        }
        this.values[0][0] = m1.m00;
        this.values[0][1] = m1.m01;
        this.values[0][2] = m1.m02;
        this.values[1][0] = m1.m10;
        this.values[1][1] = m1.m11;
        this.values[1][2] = m1.m12;
        this.values[2][0] = m1.m20;
        this.values[2][1] = m1.m21;
        this.values[2][2] = m1.m22;
        int i2 = 3;
        while (i2 < this.nRow) {
            int j2 = 3;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
    }

    public final void set(Matrix4f m1) {
        if (this.nRow < 4 || this.nCol < 4) {
            this.values = new double[4][4];
            this.nRow = 4;
            this.nCol = 4;
        }
        this.values[0][0] = m1.m00;
        this.values[0][1] = m1.m01;
        this.values[0][2] = m1.m02;
        this.values[0][3] = m1.m03;
        this.values[1][0] = m1.m10;
        this.values[1][1] = m1.m11;
        this.values[1][2] = m1.m12;
        this.values[1][3] = m1.m13;
        this.values[2][0] = m1.m20;
        this.values[2][1] = m1.m21;
        this.values[2][2] = m1.m22;
        this.values[2][3] = m1.m23;
        this.values[3][0] = m1.m30;
        this.values[3][1] = m1.m31;
        this.values[3][2] = m1.m32;
        this.values[3][3] = m1.m33;
        int i2 = 4;
        while (i2 < this.nRow) {
            int j2 = 4;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
    }

    public final void set(Matrix4d m1) {
        if (this.nRow < 4 || this.nCol < 4) {
            this.values = new double[4][4];
            this.nRow = 4;
            this.nCol = 4;
        }
        this.values[0][0] = m1.m00;
        this.values[0][1] = m1.m01;
        this.values[0][2] = m1.m02;
        this.values[0][3] = m1.m03;
        this.values[1][0] = m1.m10;
        this.values[1][1] = m1.m11;
        this.values[1][2] = m1.m12;
        this.values[1][3] = m1.m13;
        this.values[2][0] = m1.m20;
        this.values[2][1] = m1.m21;
        this.values[2][2] = m1.m22;
        this.values[2][3] = m1.m23;
        this.values[3][0] = m1.m30;
        this.values[3][1] = m1.m31;
        this.values[3][2] = m1.m32;
        this.values[3][3] = m1.m33;
        int i2 = 4;
        while (i2 < this.nRow) {
            int j2 = 4;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
    }

    public final void set(GMatrix m1) {
        int j2;
        if (this.nRow < m1.nRow || this.nCol < m1.nCol) {
            this.nRow = m1.nRow;
            this.nCol = m1.nCol;
            this.values = new double[this.nRow][this.nCol];
        }
        int i2 = 0;
        while (i2 < Math.min(this.nRow, m1.nRow)) {
            j2 = 0;
            while (j2 < Math.min(this.nCol, m1.nCol)) {
                this.values[i2][j2] = m1.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        i2 = m1.nRow;
        while (i2 < this.nRow) {
            j2 = m1.nCol;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
    }

    public final int getNumRow() {
        return this.nRow;
    }

    public final int getNumCol() {
        return this.nCol;
    }

    public final double getElement(int row, int column) {
        return this.values[row][column];
    }

    public final void setElement(int row, int column, double value) {
        this.values[row][column] = value;
    }

    public final void getRow(int row, double[] array) {
        int i2 = 0;
        while (i2 < this.nCol) {
            array[i2] = this.values[row][i2];
            ++i2;
        }
    }

    public final void getRow(int row, GVector vector) {
        if (vector.getSize() < this.nCol) {
            vector.setSize(this.nCol);
        }
        int i2 = 0;
        while (i2 < this.nCol) {
            vector.values[i2] = this.values[row][i2];
            ++i2;
        }
    }

    public final void getColumn(int col, double[] array) {
        int i2 = 0;
        while (i2 < this.nRow) {
            array[i2] = this.values[i2][col];
            ++i2;
        }
    }

    public final void getColumn(int col, GVector vector) {
        if (vector.getSize() < this.nRow) {
            vector.setSize(this.nRow);
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            vector.values[i2] = this.values[i2][col];
            ++i2;
        }
    }

    public final void get(Matrix3d m1) {
        if (this.nRow < 3 || this.nCol < 3) {
            m1.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    m1.m00 = this.values[0][0];
                    if (this.nRow > 1) {
                        m1.m10 = this.values[1][0];
                        if (this.nRow > 2) {
                            m1.m20 = this.values[2][0];
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        m1.m01 = this.values[0][1];
                        if (this.nRow > 1) {
                            m1.m11 = this.values[1][1];
                            if (this.nRow > 2) {
                                m1.m21 = this.values[2][1];
                            }
                        }
                    }
                    if (this.nCol > 2 && this.nRow > 0) {
                        m1.m02 = this.values[0][2];
                        if (this.nRow > 1) {
                            m1.m12 = this.values[1][2];
                            if (this.nRow > 2) {
                                m1.m22 = this.values[2][2];
                            }
                        }
                    }
                }
            }
        } else {
            m1.m00 = this.values[0][0];
            m1.m01 = this.values[0][1];
            m1.m02 = this.values[0][2];
            m1.m10 = this.values[1][0];
            m1.m11 = this.values[1][1];
            m1.m12 = this.values[1][2];
            m1.m20 = this.values[2][0];
            m1.m21 = this.values[2][1];
            m1.m22 = this.values[2][2];
        }
    }

    public final void get(Matrix3f m1) {
        if (this.nRow < 3 || this.nCol < 3) {
            m1.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    m1.m00 = (float)this.values[0][0];
                    if (this.nRow > 1) {
                        m1.m10 = (float)this.values[1][0];
                        if (this.nRow > 2) {
                            m1.m20 = (float)this.values[2][0];
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        m1.m01 = (float)this.values[0][1];
                        if (this.nRow > 1) {
                            m1.m11 = (float)this.values[1][1];
                            if (this.nRow > 2) {
                                m1.m21 = (float)this.values[2][1];
                            }
                        }
                    }
                    if (this.nCol > 2 && this.nRow > 0) {
                        m1.m02 = (float)this.values[0][2];
                        if (this.nRow > 1) {
                            m1.m12 = (float)this.values[1][2];
                            if (this.nRow > 2) {
                                m1.m22 = (float)this.values[2][2];
                            }
                        }
                    }
                }
            }
        } else {
            m1.m00 = (float)this.values[0][0];
            m1.m01 = (float)this.values[0][1];
            m1.m02 = (float)this.values[0][2];
            m1.m10 = (float)this.values[1][0];
            m1.m11 = (float)this.values[1][1];
            m1.m12 = (float)this.values[1][2];
            m1.m20 = (float)this.values[2][0];
            m1.m21 = (float)this.values[2][1];
            m1.m22 = (float)this.values[2][2];
        }
    }

    public final void get(Matrix4d m1) {
        if (this.nRow < 4 || this.nCol < 4) {
            m1.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    m1.m00 = this.values[0][0];
                    if (this.nRow > 1) {
                        m1.m10 = this.values[1][0];
                        if (this.nRow > 2) {
                            m1.m20 = this.values[2][0];
                            if (this.nRow > 3) {
                                m1.m30 = this.values[3][0];
                            }
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        m1.m01 = this.values[0][1];
                        if (this.nRow > 1) {
                            m1.m11 = this.values[1][1];
                            if (this.nRow > 2) {
                                m1.m21 = this.values[2][1];
                                if (this.nRow > 3) {
                                    m1.m31 = this.values[3][1];
                                }
                            }
                        }
                    }
                    if (this.nCol > 2) {
                        if (this.nRow > 0) {
                            m1.m02 = this.values[0][2];
                            if (this.nRow > 1) {
                                m1.m12 = this.values[1][2];
                                if (this.nRow > 2) {
                                    m1.m22 = this.values[2][2];
                                    if (this.nRow > 3) {
                                        m1.m32 = this.values[3][2];
                                    }
                                }
                            }
                        }
                        if (this.nCol > 3 && this.nRow > 0) {
                            m1.m03 = this.values[0][3];
                            if (this.nRow > 1) {
                                m1.m13 = this.values[1][3];
                                if (this.nRow > 2) {
                                    m1.m23 = this.values[2][3];
                                    if (this.nRow > 3) {
                                        m1.m33 = this.values[3][3];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            m1.m00 = this.values[0][0];
            m1.m01 = this.values[0][1];
            m1.m02 = this.values[0][2];
            m1.m03 = this.values[0][3];
            m1.m10 = this.values[1][0];
            m1.m11 = this.values[1][1];
            m1.m12 = this.values[1][2];
            m1.m13 = this.values[1][3];
            m1.m20 = this.values[2][0];
            m1.m21 = this.values[2][1];
            m1.m22 = this.values[2][2];
            m1.m23 = this.values[2][3];
            m1.m30 = this.values[3][0];
            m1.m31 = this.values[3][1];
            m1.m32 = this.values[3][2];
            m1.m33 = this.values[3][3];
        }
    }

    public final void get(Matrix4f m1) {
        if (this.nRow < 4 || this.nCol < 4) {
            m1.setZero();
            if (this.nCol > 0) {
                if (this.nRow > 0) {
                    m1.m00 = (float)this.values[0][0];
                    if (this.nRow > 1) {
                        m1.m10 = (float)this.values[1][0];
                        if (this.nRow > 2) {
                            m1.m20 = (float)this.values[2][0];
                            if (this.nRow > 3) {
                                m1.m30 = (float)this.values[3][0];
                            }
                        }
                    }
                }
                if (this.nCol > 1) {
                    if (this.nRow > 0) {
                        m1.m01 = (float)this.values[0][1];
                        if (this.nRow > 1) {
                            m1.m11 = (float)this.values[1][1];
                            if (this.nRow > 2) {
                                m1.m21 = (float)this.values[2][1];
                                if (this.nRow > 3) {
                                    m1.m31 = (float)this.values[3][1];
                                }
                            }
                        }
                    }
                    if (this.nCol > 2) {
                        if (this.nRow > 0) {
                            m1.m02 = (float)this.values[0][2];
                            if (this.nRow > 1) {
                                m1.m12 = (float)this.values[1][2];
                                if (this.nRow > 2) {
                                    m1.m22 = (float)this.values[2][2];
                                    if (this.nRow > 3) {
                                        m1.m32 = (float)this.values[3][2];
                                    }
                                }
                            }
                        }
                        if (this.nCol > 3 && this.nRow > 0) {
                            m1.m03 = (float)this.values[0][3];
                            if (this.nRow > 1) {
                                m1.m13 = (float)this.values[1][3];
                                if (this.nRow > 2) {
                                    m1.m23 = (float)this.values[2][3];
                                    if (this.nRow > 3) {
                                        m1.m33 = (float)this.values[3][3];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            m1.m00 = (float)this.values[0][0];
            m1.m01 = (float)this.values[0][1];
            m1.m02 = (float)this.values[0][2];
            m1.m03 = (float)this.values[0][3];
            m1.m10 = (float)this.values[1][0];
            m1.m11 = (float)this.values[1][1];
            m1.m12 = (float)this.values[1][2];
            m1.m13 = (float)this.values[1][3];
            m1.m20 = (float)this.values[2][0];
            m1.m21 = (float)this.values[2][1];
            m1.m22 = (float)this.values[2][2];
            m1.m23 = (float)this.values[2][3];
            m1.m30 = (float)this.values[3][0];
            m1.m31 = (float)this.values[3][1];
            m1.m32 = (float)this.values[3][2];
            m1.m33 = (float)this.values[3][3];
        }
    }

    public final void get(GMatrix m1) {
        int j2;
        int nc = this.nCol < m1.nCol ? this.nCol : m1.nCol;
        int nr = this.nRow < m1.nRow ? this.nRow : m1.nRow;
        int i2 = 0;
        while (i2 < nr) {
            j2 = 0;
            while (j2 < nc) {
                m1.values[i2][j2] = this.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        i2 = nr;
        while (i2 < m1.nRow) {
            j2 = 0;
            while (j2 < m1.nCol) {
                m1.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
        j2 = nc;
        while (j2 < m1.nCol) {
            i2 = 0;
            while (i2 < nr) {
                m1.values[i2][j2] = 0.0;
                ++i2;
            }
            ++j2;
        }
    }

    public final void setRow(int row, double[] array) {
        int i2 = 0;
        while (i2 < this.nCol) {
            this.values[row][i2] = array[i2];
            ++i2;
        }
    }

    public final void setRow(int row, GVector vector) {
        int i2 = 0;
        while (i2 < this.nCol) {
            this.values[row][i2] = vector.values[i2];
            ++i2;
        }
    }

    public final void setColumn(int col, double[] array) {
        int i2 = 0;
        while (i2 < this.nRow) {
            this.values[i2][col] = array[i2];
            ++i2;
        }
    }

    public final void setColumn(int col, GVector vector) {
        int i2 = 0;
        while (i2 < this.nRow) {
            this.values[i2][col] = vector.values[i2];
            ++i2;
        }
    }

    public final void mulTransposeBoth(GMatrix m1, GMatrix m2) {
        if (m1.nRow != m2.nCol || this.nRow != m1.nCol || this.nCol != m2.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix14"));
        }
        if (m1 == this || m2 == this) {
            double[][] tmp = new double[this.nRow][this.nCol];
            int i2 = 0;
            while (i2 < this.nRow) {
                int j2 = 0;
                while (j2 < this.nCol) {
                    tmp[i2][j2] = 0.0;
                    int k2 = 0;
                    while (k2 < m1.nRow) {
                        double[] dArray = tmp[i2];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] + m1.values[k2][i2] * m2.values[j2][k2];
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
            this.values = tmp;
        } else {
            int i3 = 0;
            while (i3 < this.nRow) {
                int j3 = 0;
                while (j3 < this.nCol) {
                    this.values[i3][j3] = 0.0;
                    int k3 = 0;
                    while (k3 < m1.nRow) {
                        double[] dArray = this.values[i3];
                        int n3 = j3;
                        dArray[n3] = dArray[n3] + m1.values[k3][i3] * m2.values[j3][k3];
                        ++k3;
                    }
                    ++j3;
                }
                ++i3;
            }
        }
    }

    public final void mulTransposeRight(GMatrix m1, GMatrix m2) {
        if (m1.nCol != m2.nCol || this.nCol != m2.nRow || this.nRow != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix15"));
        }
        if (m1 == this || m2 == this) {
            double[][] tmp = new double[this.nRow][this.nCol];
            int i2 = 0;
            while (i2 < this.nRow) {
                int j2 = 0;
                while (j2 < this.nCol) {
                    tmp[i2][j2] = 0.0;
                    int k2 = 0;
                    while (k2 < m1.nCol) {
                        double[] dArray = tmp[i2];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] + m1.values[i2][k2] * m2.values[j2][k2];
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
            this.values = tmp;
        } else {
            int i3 = 0;
            while (i3 < this.nRow) {
                int j3 = 0;
                while (j3 < this.nCol) {
                    this.values[i3][j3] = 0.0;
                    int k3 = 0;
                    while (k3 < m1.nCol) {
                        double[] dArray = this.values[i3];
                        int n3 = j3;
                        dArray[n3] = dArray[n3] + m1.values[i3][k3] * m2.values[j3][k3];
                        ++k3;
                    }
                    ++j3;
                }
                ++i3;
            }
        }
    }

    public final void mulTransposeLeft(GMatrix m1, GMatrix m2) {
        if (m1.nRow != m2.nRow || this.nCol != m2.nCol || this.nRow != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix16"));
        }
        if (m1 == this || m2 == this) {
            double[][] tmp = new double[this.nRow][this.nCol];
            int i2 = 0;
            while (i2 < this.nRow) {
                int j2 = 0;
                while (j2 < this.nCol) {
                    tmp[i2][j2] = 0.0;
                    int k2 = 0;
                    while (k2 < m1.nRow) {
                        double[] dArray = tmp[i2];
                        int n2 = j2;
                        dArray[n2] = dArray[n2] + m1.values[k2][i2] * m2.values[k2][j2];
                        ++k2;
                    }
                    ++j2;
                }
                ++i2;
            }
            this.values = tmp;
        } else {
            int i3 = 0;
            while (i3 < this.nRow) {
                int j3 = 0;
                while (j3 < this.nCol) {
                    this.values[i3][j3] = 0.0;
                    int k3 = 0;
                    while (k3 < m1.nRow) {
                        double[] dArray = this.values[i3];
                        int n3 = j3;
                        dArray[n3] = dArray[n3] + m1.values[k3][i3] * m2.values[k3][j3];
                        ++k3;
                    }
                    ++j3;
                }
                ++i3;
            }
        }
    }

    public final void transpose() {
        if (this.nRow != this.nCol) {
            int i2 = this.nRow;
            this.nRow = this.nCol;
            this.nCol = i2;
            double[][] tmp = new double[this.nRow][this.nCol];
            i2 = 0;
            while (i2 < this.nRow) {
                int j2 = 0;
                while (j2 < this.nCol) {
                    tmp[i2][j2] = this.values[j2][i2];
                    ++j2;
                }
                ++i2;
            }
            this.values = tmp;
        } else {
            int i3 = 0;
            while (i3 < this.nRow) {
                int j3 = 0;
                while (j3 < i3) {
                    double swap = this.values[i3][j3];
                    this.values[i3][j3] = this.values[j3][i3];
                    this.values[j3][i3] = swap;
                    ++j3;
                }
                ++i3;
            }
        }
    }

    public final void transpose(GMatrix m1) {
        if (this.nRow != m1.nCol || this.nCol != m1.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix17"));
        }
        if (m1 != this) {
            int i2 = 0;
            while (i2 < this.nRow) {
                int j2 = 0;
                while (j2 < this.nCol) {
                    this.values[i2][j2] = m1.values[j2][i2];
                    ++j2;
                }
                ++i2;
            }
        } else {
            this.transpose();
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.nRow * this.nCol * 8);
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                buffer.append(this.values[i2][j2]).append(" ");
                ++j2;
            }
            buffer.append("\n");
            ++i2;
        }
        return buffer.toString();
    }

    private static void checkMatrix(GMatrix m2) {
        int i2 = 0;
        while (i2 < m2.nRow) {
            int j2 = 0;
            while (j2 < m2.nCol) {
                if (Math.abs(m2.values[i2][j2]) < 1.0E-10) {
                    System.out.print(" 0.0     ");
                } else {
                    System.out.print(" " + m2.values[i2][j2]);
                }
                ++j2;
            }
            System.out.print("\n");
            ++i2;
        }
    }

    public int hashCode() {
        long bits = 1L;
        bits = VecMathUtil.hashLongBits(bits, this.nRow);
        bits = VecMathUtil.hashLongBits(bits, this.nCol);
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                bits = VecMathUtil.hashDoubleBits(bits, this.values[i2][j2]);
                ++j2;
            }
            ++i2;
        }
        return VecMathUtil.hashFinish(bits);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(GMatrix m1) {
        try {
            if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
                return false;
            }
            int i2 = 0;
            block2: while (true) {
                if (i2 >= this.nRow) {
                    return true;
                }
                int j2 = 0;
                while (true) {
                    if (j2 >= this.nCol) {
                        ++i2;
                        continue block2;
                    }
                    if (this.values[i2][j2] != m1.values[i2][j2]) {
                        return false;
                    }
                    ++j2;
                }
                break;
            }
        }
        catch (NullPointerException e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object o1) {
        try {
            GMatrix m2 = (GMatrix)o1;
            if (this.nRow != m2.nRow || this.nCol != m2.nCol) {
                return false;
            }
            int i2 = 0;
            block3: while (true) {
                if (i2 >= this.nRow) {
                    return true;
                }
                int j2 = 0;
                while (true) {
                    if (j2 >= this.nCol) {
                        ++i2;
                        continue block3;
                    }
                    if (this.values[i2][j2] != m2.values[i2][j2]) {
                        return false;
                    }
                    ++j2;
                }
                break;
            }
        }
        catch (ClassCastException e1) {
            return false;
        }
        catch (NullPointerException e2) {
            return false;
        }
    }

    public boolean epsilonEquals(GMatrix m1, float epsilon) {
        return this.epsilonEquals(m1, (double)epsilon);
    }

    public boolean epsilonEquals(GMatrix m1, double epsilon) {
        if (this.nRow != m1.nRow || this.nCol != m1.nCol) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                double diff = this.values[i2][j2] - m1.values[i2][j2];
                double d2 = diff < 0.0 ? -diff : diff;
                if (d2 > epsilon) {
                    return false;
                }
                ++j2;
            }
            ++i2;
        }
        return true;
    }

    public final double trace() {
        int l2 = this.nRow < this.nCol ? this.nRow : this.nCol;
        double t = 0.0;
        int i2 = 0;
        while (i2 < l2) {
            t += this.values[i2][i2];
            ++i2;
        }
        return t;
    }

    public final int SVD(GMatrix U, GMatrix W, GMatrix V) {
        if (this.nCol != V.nCol || this.nCol != V.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix18"));
        }
        if (this.nRow != U.nRow || this.nRow != U.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix25"));
        }
        if (this.nRow != W.nRow || this.nCol != W.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix26"));
        }
        if (this.nRow == 2 && this.nCol == 2 && this.values[1][0] == 0.0) {
            U.setIdentity();
            V.setIdentity();
            if (this.values[0][1] == 0.0) {
                return 2;
            }
            double[] sinl = new double[1];
            double[] sinr = new double[1];
            double[] cosl = new double[1];
            double[] cosr = new double[1];
            double[] single_values = new double[]{this.values[0][0], this.values[1][1]};
            GMatrix.compute_2X2(this.values[0][0], this.values[0][1], this.values[1][1], single_values, sinl, cosl, sinr, cosr, 0);
            GMatrix.update_u(0, U, cosl, sinl);
            GMatrix.update_v(0, V, cosr, sinr);
            return 2;
        }
        return GMatrix.computeSVD(this, U, W, V);
    }

    public final int LUD(GMatrix LU, GVector permutation) {
        int j2;
        int size = LU.nRow * LU.nCol;
        double[] temp = new double[size];
        int[] even_row_exchange = new int[1];
        int[] row_perm = new int[LU.nRow];
        if (this.nRow != this.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix19"));
        }
        if (this.nRow != LU.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix27"));
        }
        if (this.nCol != LU.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix27"));
        }
        if (LU.nRow != permutation.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix20"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            j2 = 0;
            while (j2 < this.nCol) {
                temp[i2 * this.nCol + j2] = this.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        if (!GMatrix.luDecomposition(LU.nRow, temp, row_perm, even_row_exchange)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        i2 = 0;
        while (i2 < this.nRow) {
            j2 = 0;
            while (j2 < this.nCol) {
                LU.values[i2][j2] = temp[i2 * this.nCol + j2];
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < LU.nRow) {
            permutation.values[i2] = row_perm[i2];
            ++i2;
        }
        return even_row_exchange[0];
    }

    public final void setScale(double scale) {
        int l2 = this.nRow < this.nCol ? this.nRow : this.nCol;
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = 0.0;
                ++j2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < l2) {
            this.values[i2][i2] = scale;
            ++i2;
        }
    }

    final void invertGeneral(GMatrix m1) {
        int j2;
        int size = m1.nRow * m1.nCol;
        double[] temp = new double[size];
        double[] result = new double[size];
        int[] row_perm = new int[m1.nRow];
        int[] even_row_exchange = new int[1];
        if (m1.nRow != m1.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GMatrix22"));
        }
        int i2 = 0;
        while (i2 < this.nRow) {
            j2 = 0;
            while (j2 < this.nCol) {
                temp[i2 * this.nCol + j2] = m1.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        if (!GMatrix.luDecomposition(m1.nRow, temp, row_perm, even_row_exchange)) {
            throw new SingularMatrixException(VecMathI18N.getString("GMatrix21"));
        }
        i2 = 0;
        while (i2 < size) {
            result[i2] = 0.0;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.nCol) {
            result[i2 + i2 * this.nCol] = 1.0;
            ++i2;
        }
        GMatrix.luBacksubstitution(m1.nRow, temp, row_perm, result);
        i2 = 0;
        while (i2 < this.nRow) {
            j2 = 0;
            while (j2 < this.nCol) {
                this.values[i2][j2] = result[i2 * this.nCol + j2];
                ++j2;
            }
            ++i2;
        }
    }

    static boolean luDecomposition(int dim, double[] matrix0, int[] row_perm, int[] even_row_xchg) {
        double temp;
        int j2;
        double big;
        double[] row_scale = new double[dim];
        int ptr = 0;
        int rs = 0;
        even_row_xchg[0] = 1;
        int i2 = dim;
        while (i2-- != 0) {
            big = 0.0;
            j2 = dim;
            while (j2-- != 0) {
                temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            row_scale[rs++] = 1.0 / big;
        }
        int mtx = 0;
        j2 = 0;
        while (j2 < dim) {
            int p2;
            int p1;
            int k2;
            double sum;
            int target;
            i2 = 0;
            while (i2 < j2) {
                target = mtx + dim * i2 + j2;
                sum = matrix0[target];
                k2 = i2;
                p1 = mtx + dim * i2;
                p2 = mtx + j2;
                while (k2-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += dim;
                }
                matrix0[target] = sum;
                ++i2;
            }
            big = 0.0;
            int imax = -1;
            i2 = j2;
            while (i2 < dim) {
                double d2;
                target = mtx + dim * i2 + j2;
                sum = matrix0[target];
                k2 = j2;
                p1 = mtx + dim * i2;
                p2 = mtx + j2;
                while (k2-- != 0) {
                    sum -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += dim;
                }
                matrix0[target] = sum;
                temp = row_scale[i2] * Math.abs(sum);
                if (d2 >= big) {
                    big = temp;
                    imax = i2;
                }
                ++i2;
            }
            if (imax < 0) {
                throw new RuntimeException(VecMathI18N.getString("GMatrix24"));
            }
            if (j2 != imax) {
                k2 = dim;
                p1 = mtx + dim * imax;
                p2 = mtx + dim * j2;
                while (k2-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                row_scale[imax] = row_scale[j2];
                even_row_xchg[0] = -even_row_xchg[0];
            }
            row_perm[j2] = imax;
            if (matrix0[mtx + dim * j2 + j2] == 0.0) {
                return false;
            }
            if (j2 != dim - 1) {
                temp = 1.0 / matrix0[mtx + dim * j2 + j2];
                target = mtx + dim * (j2 + 1) + j2;
                i2 = dim - 1 - j2;
                while (i2-- != 0) {
                    int n2 = target;
                    matrix0[n2] = matrix0[n2] * temp;
                    target += dim;
                }
            }
            ++j2;
        }
        return true;
    }

    static void luBacksubstitution(int dim, double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        int k2 = 0;
        while (k2 < dim) {
            int j2;
            int rv;
            int cv = k2;
            int ii = -1;
            int i2 = 0;
            while (i2 < dim) {
                int ip = row_perm[rp + i2];
                double sum = matrix2[cv + dim * ip];
                matrix2[cv + dim * ip] = matrix2[cv + dim * i2];
                if (ii >= 0) {
                    rv = i2 * dim;
                    j2 = ii;
                    while (j2 <= i2 - 1) {
                        sum -= matrix1[rv + j2] * matrix2[cv + dim * j2];
                        ++j2;
                    }
                } else if (sum != 0.0) {
                    ii = i2;
                }
                matrix2[cv + dim * i2] = sum;
                ++i2;
            }
            i2 = 0;
            while (i2 < dim) {
                int ri = dim - 1 - i2;
                rv = dim * ri;
                double tt = 0.0;
                j2 = 1;
                while (j2 <= i2) {
                    tt += matrix1[rv + dim - j2] * matrix2[cv + dim * (dim - j2)];
                    ++j2;
                }
                matrix2[cv + dim * ri] = (matrix2[cv + dim * ri] - tt) / matrix1[rv + ri];
                ++i2;
            }
            ++k2;
        }
    }

    static int computeSVD(GMatrix mat, GMatrix U, GMatrix W, GMatrix V) {
        int i2;
        int eLength;
        int sLength;
        GMatrix tmp = new GMatrix(mat.nRow, mat.nCol);
        GMatrix u = new GMatrix(mat.nRow, mat.nCol);
        GMatrix v = new GMatrix(mat.nRow, mat.nCol);
        GMatrix m2 = new GMatrix(mat);
        if (m2.nRow >= m2.nCol) {
            sLength = m2.nCol;
            eLength = m2.nCol - 1;
        } else {
            sLength = m2.nRow;
            eLength = m2.nRow;
        }
        int vecLength = m2.nRow > m2.nCol ? m2.nRow : m2.nCol;
        double[] vec = new double[vecLength];
        double[] single_values = new double[sLength];
        double[] e2 = new double[eLength];
        int rank = 0;
        U.setIdentity();
        V.setIdentity();
        int nr = m2.nRow;
        int nc = m2.nCol;
        int si = 0;
        while (si < sLength) {
            double t;
            int k2;
            int j2;
            double scale;
            double mag;
            if (nr > 1) {
                mag = 0.0;
                i2 = 0;
                while (i2 < nr) {
                    mag += m2.values[i2 + si][si] * m2.values[i2 + si][si];
                    ++i2;
                }
                mag = Math.sqrt(mag);
                vec[0] = m2.values[si][si] == 0.0 ? mag : m2.values[si][si] + GMatrix.d_sign(mag, m2.values[si][si]);
                i2 = 1;
                while (i2 < nr) {
                    vec[i2] = m2.values[si + i2][si];
                    ++i2;
                }
                scale = 0.0;
                i2 = 0;
                while (i2 < nr) {
                    scale += vec[i2] * vec[i2];
                    ++i2;
                }
                scale = 2.0 / scale;
                j2 = si;
                while (j2 < m2.nRow) {
                    k2 = si;
                    while (k2 < m2.nRow) {
                        u.values[j2][k2] = -scale * vec[j2 - si] * vec[k2 - si];
                        ++k2;
                    }
                    ++j2;
                }
                i2 = si;
                while (i2 < m2.nRow) {
                    double[] dArray = u.values[i2];
                    int n2 = i2++;
                    dArray[n2] = dArray[n2] + 1.0;
                }
                t = 0.0;
                i2 = si;
                while (i2 < m2.nRow) {
                    t += u.values[si][i2] * m2.values[i2][si];
                    ++i2;
                }
                m2.values[si][si] = t;
                j2 = si;
                while (j2 < m2.nRow) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        tmp.values[j2][k2] = 0.0;
                        i2 = si;
                        while (i2 < m2.nCol) {
                            double[] dArray = tmp.values[j2];
                            int n3 = k2;
                            dArray[n3] = dArray[n3] + u.values[j2][i2] * m2.values[i2][k2];
                            ++i2;
                        }
                        ++k2;
                    }
                    ++j2;
                }
                j2 = si;
                while (j2 < m2.nRow) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        m2.values[j2][k2] = tmp.values[j2][k2];
                        ++k2;
                    }
                    ++j2;
                }
                j2 = si;
                while (j2 < m2.nRow) {
                    k2 = 0;
                    while (k2 < m2.nCol) {
                        tmp.values[j2][k2] = 0.0;
                        i2 = si;
                        while (i2 < m2.nCol) {
                            double[] dArray = tmp.values[j2];
                            int n4 = k2;
                            dArray[n4] = dArray[n4] + u.values[j2][i2] * U.values[i2][k2];
                            ++i2;
                        }
                        ++k2;
                    }
                    ++j2;
                }
                j2 = si;
                while (j2 < m2.nRow) {
                    k2 = 0;
                    while (k2 < m2.nCol) {
                        U.values[j2][k2] = tmp.values[j2][k2];
                        ++k2;
                    }
                    ++j2;
                }
                --nr;
            }
            if (nc > 2) {
                mag = 0.0;
                i2 = 1;
                while (i2 < nc) {
                    mag += m2.values[si][si + i2] * m2.values[si][si + i2];
                    ++i2;
                }
                mag = Math.sqrt(mag);
                vec[0] = m2.values[si][si + 1] == 0.0 ? mag : m2.values[si][si + 1] + GMatrix.d_sign(mag, m2.values[si][si + 1]);
                i2 = 1;
                while (i2 < nc - 1) {
                    vec[i2] = m2.values[si][si + i2 + 1];
                    ++i2;
                }
                scale = 0.0;
                i2 = 0;
                while (i2 < nc - 1) {
                    scale += vec[i2] * vec[i2];
                    ++i2;
                }
                scale = 2.0 / scale;
                j2 = si + 1;
                while (j2 < nc) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        v.values[j2][k2] = -scale * vec[j2 - si - 1] * vec[k2 - si - 1];
                        ++k2;
                    }
                    ++j2;
                }
                i2 = si + 1;
                while (i2 < m2.nCol) {
                    double[] dArray = v.values[i2];
                    int n5 = i2++;
                    dArray[n5] = dArray[n5] + 1.0;
                }
                t = 0.0;
                i2 = si;
                while (i2 < m2.nCol) {
                    t += v.values[i2][si + 1] * m2.values[si][i2];
                    ++i2;
                }
                m2.values[si][si + 1] = t;
                j2 = si + 1;
                while (j2 < m2.nRow) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        tmp.values[j2][k2] = 0.0;
                        i2 = si + 1;
                        while (i2 < m2.nCol) {
                            double[] dArray = tmp.values[j2];
                            int n6 = k2;
                            dArray[n6] = dArray[n6] + v.values[i2][k2] * m2.values[j2][i2];
                            ++i2;
                        }
                        ++k2;
                    }
                    ++j2;
                }
                j2 = si + 1;
                while (j2 < m2.nRow) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        m2.values[j2][k2] = tmp.values[j2][k2];
                        ++k2;
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < m2.nRow) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        tmp.values[j2][k2] = 0.0;
                        i2 = si + 1;
                        while (i2 < m2.nCol) {
                            double[] dArray = tmp.values[j2];
                            int n7 = k2;
                            dArray[n7] = dArray[n7] + v.values[i2][k2] * V.values[j2][i2];
                            ++i2;
                        }
                        ++k2;
                    }
                    ++j2;
                }
                j2 = 0;
                while (j2 < m2.nRow) {
                    k2 = si + 1;
                    while (k2 < m2.nCol) {
                        V.values[j2][k2] = tmp.values[j2][k2];
                        ++k2;
                    }
                    ++j2;
                }
                --nc;
            }
            ++si;
        }
        i2 = 0;
        while (i2 < sLength) {
            single_values[i2] = m2.values[i2][i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < eLength) {
            e2[i2] = m2.values[i2][i2 + 1];
            ++i2;
        }
        if (m2.nRow == 2 && m2.nCol == 2) {
            double[] cosl = new double[1];
            double[] cosr = new double[1];
            double[] sinl = new double[1];
            double[] sinr = new double[1];
            GMatrix.compute_2X2(single_values[0], e2[0], single_values[1], single_values, sinl, cosl, sinr, cosr, 0);
            GMatrix.update_u(0, U, cosl, sinl);
            GMatrix.update_v(0, V, cosr, sinr);
            return 2;
        }
        GMatrix.compute_qr(0, e2.length - 1, single_values, e2, U, V);
        rank = single_values.length;
        return rank;
    }

    static void compute_qr(int start, int end, double[] s, double[] e2, GMatrix u, GMatrix v) {
        int i2;
        double[] cosl = new double[1];
        double[] cosr = new double[1];
        double[] sinl = new double[1];
        double[] sinr = new double[1];
        GMatrix m2 = new GMatrix(u.nCol, v.nRow);
        int MAX_INTERATIONS = 2;
        double CONVERGE_TOL = 4.89E-15;
        double c_b48 = 1.0;
        double c_b71 = -1.0;
        boolean converged = false;
        double f2 = 0.0;
        double g2 = 0.0;
        int k2 = 0;
        while (k2 < 2 && !converged) {
            double r;
            i2 = start;
            while (i2 <= end) {
                if (i2 == start) {
                    int sl = e2.length == s.length ? end : end + 1;
                    double shift = GMatrix.compute_shift(s[sl - 1], e2[end], s[sl]);
                    f2 = (Math.abs(s[i2]) - shift) * (GMatrix.d_sign(c_b48, s[i2]) + shift / s[i2]);
                    g2 = e2[i2];
                }
                r = GMatrix.compute_rot(f2, g2, sinr, cosr);
                if (i2 != start) {
                    e2[i2 - 1] = r;
                }
                f2 = cosr[0] * s[i2] + sinr[0] * e2[i2];
                e2[i2] = cosr[0] * e2[i2] - sinr[0] * s[i2];
                g2 = sinr[0] * s[i2 + 1];
                s[i2 + 1] = cosr[0] * s[i2 + 1];
                GMatrix.update_v(i2, v, cosr, sinr);
                s[i2] = r = GMatrix.compute_rot(f2, g2, sinl, cosl);
                f2 = cosl[0] * e2[i2] + sinl[0] * s[i2 + 1];
                s[i2 + 1] = cosl[0] * s[i2 + 1] - sinl[0] * e2[i2];
                if (i2 < end) {
                    g2 = sinl[0] * e2[i2 + 1];
                    e2[i2 + 1] = cosl[0] * e2[i2 + 1];
                }
                GMatrix.update_u(i2, u, cosl, sinl);
                ++i2;
            }
            if (s.length == e2.length) {
                r = GMatrix.compute_rot(f2, g2, sinr, cosr);
                f2 = cosr[0] * s[i2] + sinr[0] * e2[i2];
                e2[i2] = cosr[0] * e2[i2] - sinr[0] * s[i2];
                s[i2 + 1] = cosr[0] * s[i2 + 1];
                GMatrix.update_v(i2, v, cosr, sinr);
            }
            while (end - start > 1 && Math.abs(e2[end]) < 4.89E-15) {
                --end;
            }
            int n2 = end - 2;
            while (n2 > start) {
                if (Math.abs(e2[n2]) < 4.89E-15) {
                    GMatrix.compute_qr(n2 + 1, end, s, e2, u, v);
                    end = n2 - 1;
                    while (end - start > 1 && Math.abs(e2[end]) < 4.89E-15) {
                        --end;
                    }
                }
                --n2;
            }
            if (end - start <= 1 && Math.abs(e2[start + 1]) < 4.89E-15) {
                converged = true;
            }
            ++k2;
        }
        if (Math.abs(e2[1]) < 4.89E-15) {
            GMatrix.compute_2X2(s[start], e2[start], s[start + 1], s, sinl, cosl, sinr, cosr, 0);
            e2[start] = 0.0;
            e2[start + 1] = 0.0;
        }
        i2 = start;
        GMatrix.update_u(i2, u, cosl, sinl);
        GMatrix.update_v(i2, v, cosr, sinr);
    }

    private static void print_se(double[] s, double[] e2) {
        System.out.println("\ns =" + s[0] + " " + s[1] + " " + s[2]);
        System.out.println("e =" + e2[0] + " " + e2[1]);
    }

    private static void update_v(int index, GMatrix v, double[] cosr, double[] sinr) {
        int j2 = 0;
        while (j2 < v.nRow) {
            double vtemp = v.values[j2][index];
            v.values[j2][index] = cosr[0] * vtemp + sinr[0] * v.values[j2][index + 1];
            v.values[j2][index + 1] = -sinr[0] * vtemp + cosr[0] * v.values[j2][index + 1];
            ++j2;
        }
    }

    private static void chase_up(double[] s, double[] e2, int k2, GMatrix v) {
        double[] cosr = new double[1];
        double[] sinr = new double[1];
        GMatrix t = new GMatrix(v.nRow, v.nCol);
        GMatrix m2 = new GMatrix(v.nRow, v.nCol);
        double f2 = e2[k2];
        double g2 = s[k2];
        int i2 = k2;
        while (i2 > 0) {
            double r = GMatrix.compute_rot(f2, g2, sinr, cosr);
            f2 = -e2[i2 - 1] * sinr[0];
            g2 = s[i2 - 1];
            s[i2] = r;
            e2[i2 - 1] = e2[i2 - 1] * cosr[0];
            GMatrix.update_v_split(i2, k2 + 1, v, cosr, sinr, t, m2);
            --i2;
        }
        s[i2 + 1] = GMatrix.compute_rot(f2, g2, sinr, cosr);
        GMatrix.update_v_split(i2, k2 + 1, v, cosr, sinr, t, m2);
    }

    private static void chase_across(double[] s, double[] e2, int k2, GMatrix u) {
        double[] cosl = new double[1];
        double[] sinl = new double[1];
        GMatrix t = new GMatrix(u.nRow, u.nCol);
        GMatrix m2 = new GMatrix(u.nRow, u.nCol);
        double g2 = e2[k2];
        double f2 = s[k2 + 1];
        int i2 = k2;
        while (i2 < u.nCol - 2) {
            double r = GMatrix.compute_rot(f2, g2, sinl, cosl);
            g2 = -e2[i2 + 1] * sinl[0];
            f2 = s[i2 + 2];
            s[i2 + 1] = r;
            e2[i2 + 1] = e2[i2 + 1] * cosl[0];
            GMatrix.update_u_split(k2, i2 + 1, u, cosl, sinl, t, m2);
            ++i2;
        }
        s[i2 + 1] = GMatrix.compute_rot(f2, g2, sinl, cosl);
        GMatrix.update_u_split(k2, i2 + 1, u, cosl, sinl, t, m2);
    }

    private static void update_v_split(int topr, int bottomr, GMatrix v, double[] cosr, double[] sinr, GMatrix t, GMatrix m2) {
        int j2 = 0;
        while (j2 < v.nRow) {
            double vtemp = v.values[j2][topr];
            v.values[j2][topr] = cosr[0] * vtemp - sinr[0] * v.values[j2][bottomr];
            v.values[j2][bottomr] = sinr[0] * vtemp + cosr[0] * v.values[j2][bottomr];
            ++j2;
        }
        System.out.println("topr    =" + topr);
        System.out.println("bottomr =" + bottomr);
        System.out.println("cosr =" + cosr[0]);
        System.out.println("sinr =" + sinr[0]);
        System.out.println("\nm =");
        GMatrix.checkMatrix(m2);
        System.out.println("\nv =");
        GMatrix.checkMatrix(t);
        m2.mul(m2, t);
        System.out.println("\nt*m =");
        GMatrix.checkMatrix(m2);
    }

    private static void update_u_split(int topr, int bottomr, GMatrix u, double[] cosl, double[] sinl, GMatrix t, GMatrix m2) {
        int j2 = 0;
        while (j2 < u.nCol) {
            double utemp = u.values[topr][j2];
            u.values[topr][j2] = cosl[0] * utemp - sinl[0] * u.values[bottomr][j2];
            u.values[bottomr][j2] = sinl[0] * utemp + cosl[0] * u.values[bottomr][j2];
            ++j2;
        }
        System.out.println("\nm=");
        GMatrix.checkMatrix(m2);
        System.out.println("\nu=");
        GMatrix.checkMatrix(t);
        m2.mul(t, m2);
        System.out.println("\nt*m=");
        GMatrix.checkMatrix(m2);
    }

    private static void update_u(int index, GMatrix u, double[] cosl, double[] sinl) {
        int j2 = 0;
        while (j2 < u.nCol) {
            double utemp = u.values[index][j2];
            u.values[index][j2] = cosl[0] * utemp + sinl[0] * u.values[index + 1][j2];
            u.values[index + 1][j2] = -sinl[0] * utemp + cosl[0] * u.values[index + 1][j2];
            ++j2;
        }
    }

    private static void print_m(GMatrix m2, GMatrix u, GMatrix v) {
        GMatrix mtmp = new GMatrix(m2.nCol, m2.nRow);
        mtmp.mul(u, mtmp);
        mtmp.mul(mtmp, v);
        System.out.println("\n m = \n" + GMatrix.toString(mtmp));
    }

    private static String toString(GMatrix m2) {
        StringBuffer buffer = new StringBuffer(m2.nRow * m2.nCol * 8);
        int i2 = 0;
        while (i2 < m2.nRow) {
            int j2 = 0;
            while (j2 < m2.nCol) {
                if (Math.abs(m2.values[i2][j2]) < 1.0E-9) {
                    buffer.append("0.0000 ");
                } else {
                    buffer.append(m2.values[i2][j2]).append(" ");
                }
                ++j2;
            }
            buffer.append("\n");
            ++i2;
        }
        return buffer.toString();
    }

    private static void print_svd(double[] s, double[] e2, GMatrix u, GMatrix v) {
        GMatrix mtmp = new GMatrix(u.nCol, v.nRow);
        System.out.println(" \ns = ");
        int i2 = 0;
        while (i2 < s.length) {
            System.out.println(" " + s[i2]);
            ++i2;
        }
        System.out.println(" \ne = ");
        i2 = 0;
        while (i2 < e2.length) {
            System.out.println(" " + e2[i2]);
            ++i2;
        }
        System.out.println(" \nu  = \n" + u.toString());
        System.out.println(" \nv  = \n" + v.toString());
        mtmp.setIdentity();
        i2 = 0;
        while (i2 < s.length) {
            mtmp.values[i2][i2] = s[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < e2.length) {
            mtmp.values[i2][i2 + 1] = e2[i2];
            ++i2;
        }
        System.out.println(" \nm  = \n" + mtmp.toString());
        mtmp.mulTransposeLeft(u, mtmp);
        mtmp.mulTransposeRight(mtmp, v);
        System.out.println(" \n u.transpose*m*v.transpose  = \n" + mtmp.toString());
    }

    static double max(double a2, double b2) {
        if (a2 > b2) {
            return a2;
        }
        return b2;
    }

    static double min(double a2, double b2) {
        if (a2 < b2) {
            return a2;
        }
        return b2;
    }

    static double compute_shift(double f2, double g2, double h2) {
        double ssmin;
        double fa = Math.abs(f2);
        double ga = Math.abs(g2);
        double ha = Math.abs(h2);
        double fhmn = GMatrix.min(fa, ha);
        double fhmx = GMatrix.max(fa, ha);
        if (fhmn == 0.0) {
            ssmin = 0.0;
            if (fhmx != 0.0) {
                double d2 = GMatrix.min(fhmx, ga) / GMatrix.max(fhmx, ga);
            }
        } else if (ga < fhmx) {
            double as = fhmn / fhmx + 1.0;
            double at = (fhmx - fhmn) / fhmx;
            double d__1 = ga / fhmx;
            double au = d__1 * d__1;
            double c2 = 2.0 / (Math.sqrt(as * as + au) + Math.sqrt(at * at + au));
            ssmin = fhmn * c2;
        } else {
            double au = fhmx / ga;
            if (au == 0.0) {
                ssmin = fhmn * fhmx / ga;
            } else {
                double as = fhmn / fhmx + 1.0;
                double at = (fhmx - fhmn) / fhmx;
                double d__1 = as * au;
                double d__2 = at * au;
                double c3 = 1.0 / (Math.sqrt(d__1 * d__1 + 1.0) + Math.sqrt(d__2 * d__2 + 1.0));
                ssmin = fhmn * c3 * au;
                ssmin += ssmin;
            }
        }
        return ssmin;
    }

    static int compute_2X2(double f2, double g2, double h2, double[] single_values, double[] snl, double[] csl, double[] snr, double[] csr, int index) {
        double gt;
        double ga;
        double c_b3 = 2.0;
        double c_b4 = 1.0;
        double ssmax = single_values[0];
        double ssmin = single_values[1];
        double clt = 0.0;
        double crt = 0.0;
        double slt = 0.0;
        double srt = 0.0;
        double tsign = 0.0;
        double ft = f2;
        double fa = Math.abs(ft);
        double ht = h2;
        double ha = Math.abs(h2);
        int pmax = 1;
        boolean swap = ha > fa;
        if (swap) {
            pmax = 3;
            double temp = ft;
            ft = ht;
            ht = temp;
            temp = fa;
            fa = ha;
            ha = temp;
        }
        if ((ga = Math.abs(gt = g2)) == 0.0) {
            single_values[1] = ha;
            single_values[0] = fa;
            clt = 1.0;
            crt = 1.0;
            slt = 0.0;
            srt = 0.0;
        } else {
            boolean gasmal = true;
            if (ga > fa) {
                pmax = 2;
                if (fa / ga < 1.0E-10) {
                    gasmal = false;
                    ssmax = ga;
                    ssmin = ha > 1.0 ? fa / (ga / ha) : fa / ga * ha;
                    clt = 1.0;
                    slt = ht / gt;
                    srt = 1.0;
                    crt = ft / gt;
                }
            }
            if (gasmal) {
                double d2 = fa - ha;
                double l2 = d2 == fa ? 1.0 : d2 / fa;
                double m2 = gt / ft;
                double t = 2.0 - l2;
                double mm = m2 * m2;
                double tt = t * t;
                double s = Math.sqrt(tt + mm);
                double r = l2 == 0.0 ? Math.abs(m2) : Math.sqrt(l2 * l2 + mm);
                double a2 = (s + r) * 0.5;
                if (ga > fa) {
                    pmax = 2;
                    if (fa / ga < 1.0E-10) {
                        gasmal = false;
                        ssmax = ga;
                        ssmin = ha > 1.0 ? fa / (ga / ha) : fa / ga * ha;
                        clt = 1.0;
                        slt = ht / gt;
                        srt = 1.0;
                        crt = ft / gt;
                    }
                }
                if (gasmal) {
                    d2 = fa - ha;
                    l2 = d2 == fa ? 1.0 : d2 / fa;
                    m2 = gt / ft;
                    t = 2.0 - l2;
                    mm = m2 * m2;
                    tt = t * t;
                    s = Math.sqrt(tt + mm);
                    r = l2 == 0.0 ? Math.abs(m2) : Math.sqrt(l2 * l2 + mm);
                    a2 = (s + r) * 0.5;
                    ssmin = ha / a2;
                    ssmax = fa * a2;
                    t = mm == 0.0 ? (l2 == 0.0 ? GMatrix.d_sign(c_b3, ft) * GMatrix.d_sign(c_b4, gt) : gt / GMatrix.d_sign(d2, ft) + m2 / t) : (m2 / (s + t) + m2 / (r + l2)) * (a2 + 1.0);
                    l2 = Math.sqrt(t * t + 4.0);
                    crt = 2.0 / l2;
                    srt = t / l2;
                    clt = (crt + srt * m2) / a2;
                    slt = ht / ft * srt / a2;
                }
            }
            if (swap) {
                csl[0] = srt;
                snl[0] = crt;
                csr[0] = slt;
                snr[0] = clt;
            } else {
                csl[0] = clt;
                snl[0] = slt;
                csr[0] = crt;
                snr[0] = srt;
            }
            if (pmax == 1) {
                tsign = GMatrix.d_sign(c_b4, csr[0]) * GMatrix.d_sign(c_b4, csl[0]) * GMatrix.d_sign(c_b4, f2);
            }
            if (pmax == 2) {
                tsign = GMatrix.d_sign(c_b4, snr[0]) * GMatrix.d_sign(c_b4, csl[0]) * GMatrix.d_sign(c_b4, g2);
            }
            if (pmax == 3) {
                tsign = GMatrix.d_sign(c_b4, snr[0]) * GMatrix.d_sign(c_b4, snl[0]) * GMatrix.d_sign(c_b4, h2);
            }
            single_values[index] = GMatrix.d_sign(ssmax, tsign);
            double d__1 = tsign * GMatrix.d_sign(c_b4, f2) * GMatrix.d_sign(c_b4, h2);
            single_values[index + 1] = GMatrix.d_sign(ssmin, d__1);
        }
        return 0;
    }

    static double compute_rot(double f2, double g2, double[] sin, double[] cos) {
        double r;
        double sn;
        double cs;
        double safmn2 = 2.002083095183101E-146;
        double safmx2 = 4.994797680505588E145;
        if (g2 == 0.0) {
            cs = 1.0;
            sn = 0.0;
            r = f2;
        } else if (f2 == 0.0) {
            cs = 0.0;
            sn = 1.0;
            r = g2;
        } else {
            double f1 = f2;
            double g1 = g2;
            double scale = GMatrix.max(Math.abs(f1), Math.abs(g1));
            if (scale >= 4.994797680505588E145) {
                int count = 0;
                while (scale >= 4.994797680505588E145) {
                    ++count;
                    scale = GMatrix.max(Math.abs(f1 *= 2.002083095183101E-146), Math.abs(g1 *= 2.002083095183101E-146));
                }
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
                int i__1 = count;
                int i2 = 1;
                while (i2 <= count) {
                    r *= 4.994797680505588E145;
                    ++i2;
                }
            } else if (scale <= 2.002083095183101E-146) {
                int count = 0;
                while (scale <= 2.002083095183101E-146) {
                    ++count;
                    scale = GMatrix.max(Math.abs(f1 *= 4.994797680505588E145), Math.abs(g1 *= 4.994797680505588E145));
                }
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
                int i__1 = count;
                int i3 = 1;
                while (i3 <= count) {
                    r *= 2.002083095183101E-146;
                    ++i3;
                }
            } else {
                r = Math.sqrt(f1 * f1 + g1 * g1);
                cs = f1 / r;
                sn = g1 / r;
            }
            if (Math.abs(f2) > Math.abs(g2) && cs < 0.0) {
                cs = -cs;
                sn = -sn;
                r = -r;
            }
        }
        sin[0] = sn;
        cos[0] = cs;
        return r;
    }

    static double d_sign(double a2, double b2) {
        double x = a2 >= 0.0 ? a2 : -a2;
        return b2 >= 0.0 ? x : -x;
    }

    public Object clone() {
        GMatrix m1 = null;
        try {
            m1 = (GMatrix)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
        m1.values = new double[this.nRow][this.nCol];
        int i2 = 0;
        while (i2 < this.nRow) {
            int j2 = 0;
            while (j2 < this.nCol) {
                m1.values[i2][j2] = this.values[i2][j2];
                ++j2;
            }
            ++i2;
        }
        return m1;
    }
}

