/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigContainer;

class ConfigObject {
    String baseName = null;
    String instanceName = null;
    Object targetObject = null;
    String targetClassName = null;
    Class targetClass = null;
    List properties = new ArrayList();
    ConfigContainer configContainer = null;
    ConfigCommand creatingCommand = null;
    boolean isAlias = false;
    ConfigObject original = null;
    List aliases = new ArrayList();
    protected ClassLoader classLoader;

    ConfigObject() {
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected void initialize(ConfigCommand c2) {
        if (c2.argc != 3) {
            this.syntaxError("Wrong number of arguments to " + c2.commandName);
        }
        if (!this.isName(c2.argv[1])) {
            this.syntaxError("The first argument to " + c2.commandName + " must be the instance name");
        }
        if (!this.isName(c2.argv[2])) {
            this.syntaxError("The second argument to " + c2.commandName + " must be the class name");
        }
        this.targetClassName = (String)c2.argv[2];
    }

    protected void setProperty(ConfigCommand c2) {
        if (c2.argc < 4) {
            this.syntaxError("Wrong number of arguments to " + c2.commandName);
        }
        if (!this.isName(c2.argv[1])) {
            this.syntaxError("The first argument to " + c2.commandName + " must be the instance name");
        }
        if (!this.isName(c2.argv[2])) {
            this.syntaxError("The second argument to " + c2.commandName + " must be the property name");
        }
        this.properties.add(c2);
    }

    protected Object createTargetObject() {
        if (this.targetClassName == null) {
            return null;
        }
        this.targetClass = this.getClassForName(this.creatingCommand, this.targetClassName);
        this.targetObject = this.getNewInstance(this.creatingCommand, this.targetClass);
        return this.targetObject;
    }

    protected Class getClassForName(ConfigCommand cmd, String className) {
        try {
            return Class.forName(className, true, this.classLoader);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Class \"" + className + "\" not found"));
        }
    }

    protected Object getNewInstance(ConfigCommand cmd, Class objectClass) {
        try {
            return objectClass.newInstance();
        }
        catch (IllegalAccessException e2) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Illegal access to object class"));
        }
        catch (InstantiationException e3) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Instantiation error for object class"));
        }
    }

    protected void processProperties() {
        this.evaluateProperties(this.targetClass, this.targetObject, this.properties);
        this.properties.clear();
    }

    protected void evaluateProperties(Class objectClass, Object objectInstance, List properties) {
        Object[] parameters = new Object[1];
        Class[] parameterTypes = new Class[]{parameters.getClass()};
        int i2 = 0;
        while (i2 < properties.size()) {
            ConfigCommand cmd = (ConfigCommand)properties.get(i2);
            String methodName = (String)cmd.argv[2];
            Object[] argv = new Object[cmd.argc - 3];
            int a2 = 0;
            while (a2 < argv.length) {
                argv[a2] = cmd.argv[a2 + 3];
                if (argv[a2] instanceof ConfigCommand) {
                    ConfigCommand bcmd = (ConfigCommand)argv[a2];
                    argv[a2] = this.configContainer.evaluateBuiltIn(bcmd);
                }
                ++a2;
            }
            parameters[0] = argv;
            try {
                Method objectMethod = objectClass.getMethod(methodName, parameterTypes);
                objectMethod.invoke(objectInstance, parameters);
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Unknown property \"" + methodName + "\""));
            }
            catch (IllegalAccessException e3) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Illegal access to \"" + methodName + "\""));
            }
            catch (InvocationTargetException e4) {
                throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, e4.getTargetException().getMessage()));
            }
            ++i2;
        }
    }

    protected void syntaxError(String s) {
        throw new IllegalArgumentException(s);
    }

    static String errorMessage(ConfigCommand cmd, String s) {
        return String.valueOf(s) + "\nat line " + cmd.lineNumber + " in " + cmd.fileName + "\n" + cmd;
    }

    protected boolean isName(Object o2) {
        return o2 instanceof String;
    }
}

