/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.Collection;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Matrix4d;

class ConfigCommand {
    static final int CREATE = 0;
    static final int ATTRIBUTE = 1;
    static final int PROPERTY = 2;
    static final int ALIAS = 3;
    static final int BUILTIN = 4;
    static final int INCLUDE = 5;
    static final int IGNORE = 6;
    int type = -1;
    int argc = 0;
    Object[] argv = null;
    String commandName = null;
    String baseName = null;
    String instanceName = null;
    String fileName = null;
    int lineNumber = 0;

    ConfigCommand(Collection elements, String fileName, int lineNumber) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.argc = elements.size();
        this.argv = elements.toArray(new Object[0]);
        if (this.argc <= 0 || !(this.argv[0] instanceof String)) {
            throw new IllegalArgumentException("malformed command");
        }
        this.commandName = (String)this.argv[0];
        if (this.commandName.startsWith("New")) {
            this.type = 0;
            this.baseName = this.commandName.substring(3);
            this.instanceName = this.checkName(this.argv[1]);
        } else if (this.commandName.endsWith("Property")) {
            this.baseName = this.commandName.substring(0, this.commandName.length() - 8);
            if (this.baseName.equals("Java")) {
                this.type = 6;
                ConfigCommand.processJavaProperty(this.argc, this.argv);
            } else {
                this.type = 2;
                this.instanceName = this.checkName(this.argv[1]);
            }
        } else if (this.commandName.endsWith("Attribute")) {
            this.type = 2;
            this.baseName = this.commandName.substring(0, this.commandName.length() - 9);
            this.instanceName = this.checkName(this.argv[1]);
        } else if (this.commandName.endsWith("Alias")) {
            this.type = 3;
            this.baseName = this.commandName.substring(0, this.commandName.length() - 5);
            this.instanceName = this.checkName(this.argv[1]);
        } else {
            this.type = this.commandName.equals("Include") ? 5 : 4;
        }
        if (this.baseName != null && this.baseName.equals("Window")) {
            this.baseName = "Screen";
        }
    }

    private static void processJavaProperty(int argc, Object[] argv) {
        int i2 = 1;
        while (i2 < argc) {
            if (argv[i2] instanceof Boolean) {
                argv[i2] = ((Boolean)argv[i2]).toString();
            } else if (!(argv[i2] instanceof String)) {
                throw new IllegalArgumentException("JavaProperty arguments must be Strings or Booleans");
            }
            ++i2;
        }
        if (argc == 3) {
            ConfigCommand.setJavaProperty((String)argv[1], (String)argv[2]);
        } else {
            if (argc != 4) {
                throw new IllegalArgumentException("JavaProperty must have either 2 or 3 arguments");
            }
            if (!((String)argv[2]).equals("Default")) {
                throw new IllegalArgumentException("JavaProperty 2nd argument must be \"Default\"");
            }
            if (ConfigCommand.evaluateJavaProperty((String)argv[1]) == null) {
                ConfigCommand.setJavaProperty((String)argv[1], (String)argv[3]);
            }
        }
    }

    static String setJavaProperty(final String key, final String value) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.setProperty(key, value);
            }
        });
    }

    static String evaluateJavaProperty(final String key) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(key);
            }
        });
    }

    private final String checkName(Object o2) {
        if (!(o2 instanceof String)) {
            throw new IllegalArgumentException("second argument to \"" + this.commandName + "\" must be a name");
        }
        return (String)o2;
    }

    static String[] formatMatrixRows(Matrix3d m3) {
        double[] m2 = new double[]{m3.m00, m3.m01, m3.m02, m3.m10, m3.m11, m3.m12, m3.m20, m3.m21, m3.m22};
        return ConfigCommand.formatMatrixRows(3, 3, m2);
    }

    static String[] formatMatrixRows(Matrix4d m4) {
        double[] m2 = new double[]{m4.m00, m4.m01, m4.m02, m4.m03, m4.m10, m4.m11, m4.m12, m4.m13, m4.m20, m4.m21, m4.m22, m4.m23, m4.m30, m4.m31, m4.m32, m4.m33};
        return ConfigCommand.formatMatrixRows(4, 4, m2);
    }

    static String[] formatMatrixRows(int rowCount, int colCount, double[] m2) {
        DecimalFormat df = new DecimalFormat("0.000000");
        FieldPosition fp = new FieldPosition(0);
        StringBuffer sb0 = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        String[] rows = new String[rowCount];
        int i2 = 0;
        while (i2 < rowCount) {
            sb0.setLength(0);
            int j2 = 0;
            while (j2 < colCount) {
                sb1.setLength(0);
                df.format(m2[i2 * colCount + j2], sb1, fp);
                int pad = 8 - fp.getEndIndex();
                int k2 = 0;
                while (k2 < pad) {
                    sb1.insert(0, " ");
                    ++k2;
                }
                sb0.append(sb1);
                ++j2;
            }
            rows[i2] = sb0.toString();
            ++i2;
        }
        return rows;
    }

    public String toString() {
        String[] lines = null;
        StringBuffer sb = new StringBuffer("(");
        int i2 = 0;
        while (i2 < this.argc) {
            if (this.argv[i2] instanceof Matrix3d) {
                lines = ConfigCommand.formatMatrixRows((Matrix3d)this.argv[i2]);
                sb.append("\n ((" + lines[0] + ")\n");
                sb.append("  (" + lines[1] + ")\n");
                sb.append("  (" + lines[2] + "))");
                if (i2 != this.argc - 1) {
                    sb.append("\n");
                }
            } else if (this.argv[i2] instanceof Matrix4d) {
                lines = ConfigCommand.formatMatrixRows((Matrix4d)this.argv[i2]);
                sb.append("\n ((" + lines[0] + ")\n");
                sb.append("  (" + lines[1] + ")\n");
                sb.append("  (" + lines[2] + ")\n");
                sb.append("  (" + lines[3] + "))");
                if (i2 != this.argc - 1) {
                    sb.append("\n");
                }
            } else {
                if (i2 > 0) {
                    sb.append(" ");
                }
                sb.append(this.argv[i2].toString());
            }
            ++i2;
        }
        sb.append(")");
        return sb.toString();
    }
}

