/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.shader;

import java.util.HashMap;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.GLSLShaderProgram;
import org.jogamp.java3d.LineAttributes;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.PointAttributes;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.Shader;
import org.jogamp.java3d.ShaderAppearance;
import org.jogamp.java3d.ShaderAttributeSet;
import org.jogamp.java3d.ShaderAttributeValue;
import org.jogamp.java3d.SourceCodeShader;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureUnitState;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector4f;

public class SimpleShaderAppearance
extends ShaderAppearance {
    private static String versionString = "#version 100\n";
    private static String outString = "varying";
    private static String inString = "varying";
    private static String fragColorDec = "";
    private static String fragColorVar = "gl_FragColor";
    private static String vertexAttributeInString = "attribute";
    private static String texture2D = "texture2D";
    private static String constMaxLights = "\tconst int maxLights = (gl_MaxVaryingVectors - 6) / 3;\n";
    public static String alphaTestUniforms = "uniform int alphaTestEnabled;\nuniform int alphaTestFunction;\nuniform float alphaTestValue;\n";
    public static String alphaTestMethod = "if(alphaTestEnabled != 0)\n{\t\n \tif(alphaTestFunction==516)//>\n\t\tif(baseMap.a<=alphaTestValue)discard;\n\telse if(alphaTestFunction==518)//>=\n\t\tif(baseMap.a<alphaTestValue)discard;\n\telse if(alphaTestFunction==514)//==\n\t\tif(baseMap.a!=alphaTestValue)discard;\n\telse if(alphaTestFunction==517)//!=\n\t\tif(baseMap.a==alphaTestValue)discard;\n\telse if(alphaTestFunction==513)//<\n\t\tif(baseMap.a>=alphaTestValue)discard;\n\telse if(alphaTestFunction==515)//<=\n\t\tif(baseMap.a>alphaTestValue)discard;\n\telse if(alphaTestFunction==512)//never\t\n\t\tdiscard;\t\n}\n";
    public static String glFrontMaterial = "struct material\n\t{\n\t\tint lightEnabled;\n\t\tvec4 ambient;\n\t\tvec4 diffuse;\n\t\tvec4 emission; \n\t\tvec3 specular;\n\t\tfloat shininess;\n\t};\nuniform material glFrontMaterial;\n";
    public static String glLightSource = "struct lightSource\n\t{\n\t\tvec4 position;\n\t\tvec4 diffuse;\n\t\tvec4 specular;\n\t\tfloat constantAttenuation, linearAttenuation, quadraticAttenuation;\n\t\tfloat spotCutoff, spotExponent;\n\t\tvec3 spotDirection;\n\t};\n\n\tuniform int numberOfLights;\n" + constMaxLights + "\tuniform lightSource glLightSource[maxLights];\n";
    private static HashMap<Integer, GLSLShaderProgram> shaderPrograms = new HashMap();
    private static GLSLShaderProgram flatShaderProgram;
    private static GLSLShaderProgram colorLineShaderProgram;
    private static HashMap<GLSLShaderProgram, String> vertexShaderSources;
    private static HashMap<GLSLShaderProgram, String> fragmentShaderSources;
    private static ShaderAttributeSet baseMapShaderAttributeSet;
    private static HashMap<String, ShaderAttributeSet> shaderAttributeSetCache;
    private boolean buildBasedOnAttributes = false;
    private TexCoordGeneration texCoordGeneration = null;
    private String vertexShaderSource = null;
    private String fragmentShaderSource = null;

    static {
        vertexShaderSources = new HashMap();
        fragmentShaderSources = new HashMap();
        baseMapShaderAttributeSet = null;
        shaderAttributeSetCache = new HashMap();
    }

    public static void setVersionES100() {
        versionString = "#version 100\n";
        outString = "varying";
        inString = "varying";
        fragColorDec = "";
        fragColorVar = "gl_FragColor";
        vertexAttributeInString = "attribute";
        texture2D = "texture2D";
        constMaxLights = "\tconst int maxLights = (gl_MaxVaryingVectors - 6) / 3;\n";
    }

    public static void setVersionES300() {
        versionString = "#version 300 es\n";
        outString = "out";
        inString = "in";
        fragColorDec = "out vec4 glFragColor;\n";
        fragColorVar = "glFragColor";
        vertexAttributeInString = "in";
        texture2D = "texture";
        constMaxLights = "\tconst int maxLights = (gl_MaxVaryingVectors - 6) / 3;\n";
    }

    public static void setVersion120() {
        versionString = "#version 120\n";
        outString = "varying";
        inString = "varying";
        fragColorDec = "";
        fragColorVar = "gl_FragColor";
        vertexAttributeInString = "attribute";
        texture2D = "texture2D";
        constMaxLights = "\tconst int maxLights = 3;\n";
    }

    public SimpleShaderAppearance() {
        this.buildBasedOnAttributes = true;
        this.rebuildShaders();
    }

    public SimpleShaderAppearance(Color3f color) {
        this(color, false, false);
    }

    public SimpleShaderAppearance(boolean lit, boolean hasTexture) {
        this(null, lit, hasTexture);
    }

    private SimpleShaderAppearance(Color3f color, boolean lit, boolean hasTexture) {
        if (lit || hasTexture) {
            boolean hasTextureCoordGen = false;
            boolean texCoordGenModeObjLinear = false;
            boolean hasTextureAttributeTransform = false;
            this.build(hasTexture, lit, hasTextureCoordGen, texCoordGenModeObjLinear, hasTextureAttributeTransform);
        } else if (color != null) {
            PolygonAttributes polyAtt = new PolygonAttributes(1, 0, 0.0f);
            polyAtt.setPolygonOffset(0.1f);
            this.setPolygonAttributes(polyAtt);
            LineAttributes lineAtt = new LineAttributes(1.0f, 0, false);
            this.setLineAttributes(lineAtt);
            ColoringAttributes colorAtt = new ColoringAttributes(color, 0);
            this.setColoringAttributes(colorAtt);
            RenderingAttributes ra = new RenderingAttributes();
            ra.setIgnoreVertexColors(true);
            this.setRenderingAttributes(ra);
            Material mat = new Material();
            this.setMaterial(mat);
            if (colorLineShaderProgram == null) {
                colorLineShaderProgram = new GLSLShaderProgram(){

                    @Override
                    public String toString() {
                        return "SimpleShaderAppearance colorLineShaderProgram";
                    }
                };
                String vertexProgram = versionString;
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform int ignoreVertexColors;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform vec4 objectColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + " vec4 glFrontColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "void main( void ){\n";
                vertexProgram = String.valueOf(vertexProgram) + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + "if( ignoreVertexColors != 0 )\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tglFrontColor = objectColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "else\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tglFrontColor = glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "}";
                String fragmentProgram = versionString;
                fragmentProgram = String.valueOf(fragmentProgram) + "precision mediump float;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec4 glFrontColor;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorDec;
                fragmentProgram = String.valueOf(fragmentProgram) + "void main( void ){\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + " = glFrontColor;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "}";
                colorLineShaderProgram.setShaders(SimpleShaderAppearance.makeShaders(vertexProgram, fragmentProgram));
                vertexShaderSources.put(colorLineShaderProgram, vertexProgram);
                fragmentShaderSources.put(colorLineShaderProgram, fragmentProgram);
            }
            this.setShaderProgram(colorLineShaderProgram);
            this.vertexShaderSource = vertexShaderSources.get(colorLineShaderProgram);
            this.fragmentShaderSource = fragmentShaderSources.get(colorLineShaderProgram);
        } else {
            if (flatShaderProgram == null) {
                flatShaderProgram = new GLSLShaderProgram(){

                    @Override
                    public String toString() {
                        return "SimpleShaderAppearance flatShaderProgram";
                    }
                };
                String vertexProgram = versionString;
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform int ignoreVertexColors;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform vec4 objectColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + " vec4 glFrontColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "void main( void ){\n";
                vertexProgram = String.valueOf(vertexProgram) + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + "if( ignoreVertexColors != 0 )\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tglFrontColor = objectColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "else\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tglFrontColor = glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "}";
                String fragmentProgram = versionString;
                fragmentProgram = String.valueOf(fragmentProgram) + "precision mediump float;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "uniform float transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec4 glFrontColor;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorDec;
                fragmentProgram = String.valueOf(fragmentProgram) + "void main( void ){\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + " = glFrontColor;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + ".a *= transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "}";
                flatShaderProgram.setShaders(SimpleShaderAppearance.makeShaders(vertexProgram, fragmentProgram));
                vertexShaderSources.put(flatShaderProgram, vertexProgram);
                fragmentShaderSources.put(flatShaderProgram, fragmentProgram);
            }
            this.setShaderProgram(flatShaderProgram);
            this.vertexShaderSource = vertexShaderSources.get(flatShaderProgram);
            this.fragmentShaderSource = fragmentShaderSources.get(flatShaderProgram);
        }
    }

    public String getVertexShaderSource() {
        return this.vertexShaderSource;
    }

    public String getFragmentShaderSource() {
        return this.fragmentShaderSource;
    }

    private static Shader[] makeShaders(String vertexProgram, String fragmentProgram) {
        Shader[] shaders = new Shader[]{new SourceCodeShader(1, 1, vertexProgram){

            @Override
            public String toString() {
                return "vertexProgram";
            }
        }, new SourceCodeShader(1, 2, fragmentProgram){

            @Override
            public String toString() {
                return "fragmentProgram";
            }
        }};
        return shaders;
    }

    public void rebuildShaders() {
        if (this.buildBasedOnAttributes && (!this.isLive() && !this.isCompiled() || this.getCapability(0) && this.getCapability(20) && this.getCapability(2) && this.getCapability(14)) && (this.getPolygonAttributes() == null || !this.getPolygonAttributes().isLive() && !this.getPolygonAttributes().isCompiled() || this.getPolygonAttributes().getCapability(2)) && (!this.isLive() && !this.isCompiled() || this.getCapability(23))) {
            boolean hasTexture;
            boolean bl = hasTexture = this.getTexture() != null || this.getTextureUnitCount() > 0;
            if (this.getTextureUnitCount() > 0) {
                System.out.println("this.getTextureUnitCount() " + this.getTextureUnitCount());
            }
            boolean lit = this.getMaterial() != null;
            lit = lit && (this.getPolygonAttributes() == null || this.getPolygonAttributes().getPolygonMode() == 2);
            boolean hasTextureCoordGen = hasTexture && this.texCoordGeneration != null;
            boolean texCoordGenModeObjLinear = hasTextureCoordGen && this.texCoordGeneration.getGenMode() == 0;
            boolean hasTextureAttributeTransform = false;
            if (this.getTexture() != null && this.getTextureAttributes() != null) {
                Transform3D t = new Transform3D();
                this.getTextureAttributes().getTextureTransform(t);
                hasTextureAttributeTransform = t.getBestType() != 2;
            } else if (this.getTextureUnitCount() > 0) {
                Transform3D t = new Transform3D();
                this.getTextureUnitState(0).getTextureAttributes().getTextureTransform(t);
                hasTextureAttributeTransform = t.getBestType() != 2;
            }
            this.build(hasTexture, lit, hasTextureCoordGen, texCoordGenModeObjLinear, hasTextureAttributeTransform);
        }
    }

    private void build(boolean hasTexture, boolean lit, boolean hasTextureCoordGen, boolean texCoordGenModeObjLinear, boolean hasTextureAttributeTransform) {
        int shaderKey = (hasTexture ? 1 : 0) + (lit ? 2 : 0) + (hasTextureCoordGen ? 4 : 0) + (texCoordGenModeObjLinear ? 8 : 0) + (hasTextureAttributeTransform ? 16 : 0);
        GLSLShaderProgram shaderProgram = shaderPrograms.get(new Integer(shaderKey));
        if (shaderProgram == null) {
            String vertexProgram = versionString;
            String fragmentProgram = versionString;
            if (hasTextureCoordGen && this.texCoordGeneration.getFormat() != 0) {
                System.out.println("texCoordGeneration.getFormat() must be 0");
            }
            if (lit) {
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec3 glNormal; \n";
                if (hasTexture && !hasTextureCoordGen) {
                    vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec2 glMultiTexCoord0;\n";
                }
                if (hasTextureAttributeTransform) {
                    vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 textureTransform;\n";
                }
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 glModelViewMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat3 glNormalMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform int ignoreVertexColors;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform vec4 glLightModelambient;\n";
                vertexProgram = String.valueOf(vertexProgram) + glFrontMaterial;
                vertexProgram = String.valueOf(vertexProgram) + glLightSource;
                if (hasTextureCoordGen && texCoordGenModeObjLinear) {
                    vertexProgram = String.valueOf(vertexProgram) + "uniform vec4 texCoordGenPlaneS;\n";
                    vertexProgram = String.valueOf(vertexProgram) + "uniform vec4 texCoordGenPlaneT;\n";
                }
                if (hasTexture) {
                    vertexProgram = String.valueOf(vertexProgram) + outString + " vec2 glTexCoord0;\n";
                }
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec3 ViewVec;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec3 N;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec4 A;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec4 C;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec3 emissive;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec4 lightsD[maxLights];\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec3 lightsS[maxLights];\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  vec3 lightsLightDir[maxLights];\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + "  float shininess;\n";
                if (hasTextureCoordGen) {
                    vertexProgram = String.valueOf(vertexProgram) + "vec2 object_linear(vec4 pos, vec4 planeOS, vec4 planeOT)\n";
                    vertexProgram = String.valueOf(vertexProgram) + "{\n";
                    vertexProgram = String.valueOf(vertexProgram) + "\treturn vec2(pos.x*planeOS.x+pos.y*planeOS.y+pos.z*planeOS.z+pos.w*planeOS.w,pos.x*planeOT.x+pos.y*planeOT.y+pos.z*planeOT.z+pos.w*planeOT.w);\n";
                    vertexProgram = String.valueOf(vertexProgram) + "}\n";
                }
                vertexProgram = String.valueOf(vertexProgram) + "void main( void ){\n";
                vertexProgram = String.valueOf(vertexProgram) + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + "N = normalize(glNormalMatrix * glNormal);\n";
                if (hasTexture) {
                    if (!hasTextureCoordGen) {
                        vertexProgram = hasTextureAttributeTransform ? String.valueOf(vertexProgram) + "glTexCoord0 = (textureTransform * vec4(glMultiTexCoord0,0,1)).st;\n" : String.valueOf(vertexProgram) + "glTexCoord0 = glMultiTexCoord0.st;\n";
                    } else if (texCoordGenModeObjLinear) {
                        vertexProgram = String.valueOf(vertexProgram) + "glTexCoord0 = object_linear(glVertex, texCoordGenPlaneS, texCoordGenPlaneT);\n";
                    } else {
                        System.err.println("texCoordGeneration.getGenMode() not supported " + this.texCoordGeneration.getGenMode());
                    }
                }
                vertexProgram = String.valueOf(vertexProgram) + "vec3 v = vec3(glModelViewMatrix * glVertex);\n";
                vertexProgram = String.valueOf(vertexProgram) + "ViewVec = -v.xyz;\n";
                vertexProgram = String.valueOf(vertexProgram) + "A = glLightModelambient * glFrontMaterial.ambient;\n";
                vertexProgram = String.valueOf(vertexProgram) + "if( ignoreVertexColors != 0) \n";
                vertexProgram = String.valueOf(vertexProgram) + "\tC = vec4(1,1,1,1);//glFrontMaterial.diffuse; \n";
                vertexProgram = String.valueOf(vertexProgram) + "else \n";
                vertexProgram = String.valueOf(vertexProgram) + "\tC = glColor; \n";
                vertexProgram = String.valueOf(vertexProgram) + "emissive = glFrontMaterial.emission.rgb;\n";
                vertexProgram = String.valueOf(vertexProgram) + "shininess = glFrontMaterial.shininess;\n";
                vertexProgram = String.valueOf(vertexProgram) + "for (int index = 0; index < numberOfLights && index < maxLights; index++) // for all light sources\n";
                vertexProgram = String.valueOf(vertexProgram) + "{\t\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tlightsD[index] = glLightSource[index].diffuse * glFrontMaterial.diffuse;\t\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tlightsS[index] = glLightSource[index].specular.rgb * glFrontMaterial.specular;\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tlightsLightDir[index] = glLightSource[index].position.xyz;\t\n";
                vertexProgram = String.valueOf(vertexProgram) + "}\n";
                vertexProgram = String.valueOf(vertexProgram) + "}";
                fragmentProgram = String.valueOf(fragmentProgram) + "precision mediump float;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "precision highp int;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "uniform float transparencyAlpha;\n";
                if (hasTexture) {
                    fragmentProgram = String.valueOf(fragmentProgram) + alphaTestUniforms;
                    fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec2 glTexCoord0;\n";
                    fragmentProgram = String.valueOf(fragmentProgram) + "uniform sampler2D BaseMap;\n";
                }
                fragmentProgram = String.valueOf(fragmentProgram) + "uniform int numberOfLights;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec3 ViewVec;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec3 N;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec4 A;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec4 C;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec3 emissive;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " float shininess;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + constMaxLights;
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec4 lightsD[maxLights]; \n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec3 lightsS[maxLights]; \n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec3 lightsLightDir[maxLights]; \n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorDec;
                fragmentProgram = String.valueOf(fragmentProgram) + "void main( void ){\n ";
                if (hasTexture) {
                    fragmentProgram = String.valueOf(fragmentProgram) + "vec4 baseMap = " + texture2D + "( BaseMap, glTexCoord0.st );\n";
                }
                if (hasTexture) {
                    fragmentProgram = String.valueOf(fragmentProgram) + alphaTestMethod;
                }
                fragmentProgram = String.valueOf(fragmentProgram) + "vec4 color;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "vec3 albedo = " + (hasTexture ? "baseMap.rgb *" : "") + " C.rgb;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "vec3 diffuse = A.rgb;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "vec3 spec;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "vec3 normal = N;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "vec3 E = normalize(ViewVec);\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "float EdotN = max( dot(normal, E), 0.0 );\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "for (int index = 0; index < numberOfLights && index < maxLights; index++) // for all light sources\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "{ \t\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tvec3 L = normalize( lightsLightDir[index] );\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\t//vec3 R = reflect(-L, normal);\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tvec3 H = normalize( L + E );\t\t\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tfloat NdotL = max( dot(normal, L), 0.0 );\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tfloat NdotH = max( dot(normal, H), 0.0 );\t\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tfloat NdotNegL = max( dot(normal, -L), 0.0 );\t\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tdiffuse = diffuse + (lightsD[index].rgb * NdotL);\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "\tspec = spec + (lightsS[index] * pow(NdotH, 0.3*shininess));\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "}\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "color.rgb = albedo * (diffuse + emissive) + spec;\n";
                fragmentProgram = hasTexture ? String.valueOf(fragmentProgram) + "color.a = C.a * baseMap.a;\n" : String.valueOf(fragmentProgram) + "color.a = C.a;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "color.a *= transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + " = color;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "}";
            } else if (hasTexture) {
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glVertex;\n";
                if (hasTexture && !hasTextureCoordGen) {
                    vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec2 glMultiTexCoord0;\n";
                }
                if (hasTextureAttributeTransform) {
                    vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 textureTransform;\n";
                }
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + " vec2 glTexCoord0;\n";
                vertexProgram = String.valueOf(vertexProgram) + "void main( void ){\n";
                vertexProgram = String.valueOf(vertexProgram) + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                if (!hasTextureCoordGen) {
                    vertexProgram = hasTextureAttributeTransform ? String.valueOf(vertexProgram) + "glTexCoord0 = (textureTransform * vec4(glMultiTexCoord0,0,1)).st;\n" : String.valueOf(vertexProgram) + "glTexCoord0 = glMultiTexCoord0.st;\n";
                } else if (texCoordGenModeObjLinear) {
                    vertexProgram = String.valueOf(vertexProgram) + "glTexCoord0 = object_linear(glVertex, texCoordGenPlaneS, texCoordGenPlaneT);\n";
                } else {
                    System.err.println("texCoordGeneration.getGenMode() not supported " + this.texCoordGeneration.getGenMode());
                }
                vertexProgram = String.valueOf(vertexProgram) + "}";
                fragmentProgram = String.valueOf(fragmentProgram) + "precision mediump float;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "uniform float transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + alphaTestUniforms;
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec2 glTexCoord0;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "uniform sampler2D BaseMap;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorDec;
                fragmentProgram = String.valueOf(fragmentProgram) + "void main( void ){\n ";
                fragmentProgram = String.valueOf(fragmentProgram) + "vec4 baseMap = " + texture2D + "( BaseMap, glTexCoord0.st );\n";
                fragmentProgram = String.valueOf(fragmentProgram) + alphaTestMethod;
                fragmentProgram = String.valueOf(fragmentProgram) + "baseMap.a *= transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + " = baseMap;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "}";
            } else {
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + vertexAttributeInString + " vec4 glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform int ignoreVertexColors;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform vec4 objectColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "uniform mat4 glModelViewProjectionMatrix;\n";
                vertexProgram = String.valueOf(vertexProgram) + outString + " vec4 glFrontColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "void main( void ){\n";
                vertexProgram = String.valueOf(vertexProgram) + "gl_Position = glModelViewProjectionMatrix * glVertex;\n";
                vertexProgram = String.valueOf(vertexProgram) + "if( ignoreVertexColors != 0 )\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tglFrontColor = objectColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "else\n";
                vertexProgram = String.valueOf(vertexProgram) + "\tglFrontColor = glColor;\n";
                vertexProgram = String.valueOf(vertexProgram) + "}";
                fragmentProgram = String.valueOf(fragmentProgram) + "precision mediump float;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "uniform float transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + inString + " vec4 glFrontColor;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorDec;
                fragmentProgram = String.valueOf(fragmentProgram) + "void main( void ){\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + " = glFrontColor;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + fragColorVar + ".a *= transparencyAlpha;\n";
                fragmentProgram = String.valueOf(fragmentProgram) + "}";
            }
            shaderProgram = new GLSLShaderProgram(){

                @Override
                public String toString() {
                    return "SimpleShaderAppearance " + this.getName();
                }
            };
            shaderProgram.setName("shaderkey = " + shaderKey);
            shaderProgram.setShaders(SimpleShaderAppearance.makeShaders(vertexProgram, fragmentProgram));
            vertexShaderSources.put(shaderProgram, vertexProgram);
            fragmentShaderSources.put(shaderProgram, fragmentProgram);
            if (hasTexture) {
                if (texCoordGenModeObjLinear) {
                    shaderProgram.setShaderAttrNames(new String[]{"BaseMap", "texCoordGenPlaneS", "texCoordGenPlaneT"});
                } else {
                    shaderProgram.setShaderAttrNames(new String[]{"BaseMap"});
                }
            }
            shaderPrograms.put(new Integer(shaderKey), shaderProgram);
        }
        this.setShaderProgram(shaderProgram);
        this.vertexShaderSource = vertexShaderSources.get(shaderProgram);
        this.fragmentShaderSource = fragmentShaderSources.get(shaderProgram);
        if (hasTexture) {
            if (texCoordGenModeObjLinear) {
                Vector4f planeS = new Vector4f();
                this.texCoordGeneration.getPlaneS(planeS);
                Vector4f planeT = new Vector4f();
                this.texCoordGeneration.getPlaneT(planeT);
                String key = "planeS " + planeS + " planeT " + planeT;
                ShaderAttributeSet shaderAttributeSet = shaderAttributeSetCache.get(key);
                if (shaderAttributeSet == null) {
                    shaderAttributeSet = new ShaderAttributeSet();
                    shaderAttributeSet.put(new ShaderAttributeValue("BaseMap", new Integer(0)));
                    shaderAttributeSet.put(new ShaderAttributeValue("texCoordGenPlaneS", planeS));
                    shaderAttributeSet.put(new ShaderAttributeValue("texCoordGenPlaneT", planeT));
                    shaderAttributeSetCache.put(key, shaderAttributeSet);
                }
                this.setShaderAttributeSet(shaderAttributeSet);
            } else {
                if (baseMapShaderAttributeSet == null) {
                    baseMapShaderAttributeSet = new ShaderAttributeSet();
                    baseMapShaderAttributeSet.put(new ShaderAttributeValue("BaseMap", new Integer(0)));
                }
                this.setShaderAttributeSet(baseMapShaderAttributeSet);
            }
        }
    }

    @Override
    public void setMaterial(Material material) {
        super.setMaterial(material);
        this.rebuildShaders();
    }

    @Override
    public void setColoringAttributes(ColoringAttributes coloringAttributes) {
        super.setColoringAttributes(coloringAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setTransparencyAttributes(TransparencyAttributes transparencyAttributes) {
        super.setTransparencyAttributes(transparencyAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setRenderingAttributes(RenderingAttributes renderingAttributes) {
        super.setRenderingAttributes(renderingAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setPolygonAttributes(PolygonAttributes polygonAttributes) {
        super.setPolygonAttributes(polygonAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setLineAttributes(LineAttributes lineAttributes) {
        super.setLineAttributes(lineAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setPointAttributes(PointAttributes pointAttributes) {
        super.setPointAttributes(pointAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setTexture(Texture texture) {
        super.setTexture(texture);
        this.rebuildShaders();
    }

    @Override
    public void setTextureAttributes(TextureAttributes textureAttributes) {
        super.setTextureAttributes(textureAttributes);
        this.rebuildShaders();
    }

    @Override
    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        this.texCoordGeneration = texCoordGeneration;
        this.rebuildShaders();
    }

    @Override
    public void setTextureUnitState(TextureUnitState[] stateArray) {
        System.out.println("SimpleShaderAppearance with textureunitstates in use");
        super.setTextureUnitState(stateArray);
        this.rebuildShaders();
    }

    @Override
    public void setTextureUnitState(int index, TextureUnitState state) {
        System.out.println("SimpleShaderAppearance with textureunitstates in use");
        super.setTextureUnitState(index, state);
        this.rebuildShaders();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        SimpleShaderAppearance a2 = new SimpleShaderAppearance();
        a2.duplicateNodeComponent(this);
        return a2;
    }
}

