/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.shader;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.utils.shader.SimpleShaderAppearance;

public class Cube
extends Shape3D {
    private static final float[] verts = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f};
    private static final float[] colors = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    public Cube() {
        TriangleArray cube = new TriangleArray(36, 2181);
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(verts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double scale) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        int i2 = 0;
        while (i2 < verts.length) {
            scaledVerts[i2] = verts[i2] * (float)scale;
            ++i2;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double scale, float r, float g2, float b2) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        int i2 = 0;
        while (i2 < verts.length) {
            scaledVerts[i2] = verts[i2] * (float)scale;
            ++i2;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        float[] colorsSet = new float[108];
        int i3 = 0;
        while (i3 < 36) {
            colorsSet[i3 * 3 + 0] = r;
            colorsSet[i3 * 3 + 1] = g2;
            colorsSet[i3 * 3 + 2] = b2;
            ++i3;
        }
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colorsSet)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double xScale, double yScale, double zScale) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        int i2 = 0;
        while (i2 < verts.length) {
            scaledVerts[i2 + 0] = verts[i2 + 0] * (float)xScale;
            scaledVerts[i2 + 1] = verts[i2 + 1] * (float)yScale;
            scaledVerts[i2 + 2] = verts[i2 + 2] * (float)zScale;
            i2 += 3;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(double xScale, double yScale, double zScale, float r, float g2, float b2) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[verts.length];
        int i2 = 0;
        while (i2 < verts.length) {
            scaledVerts[i2 + 0] = verts[i2 + 0] * (float)xScale;
            scaledVerts[i2 + 1] = verts[i2 + 1] * (float)yScale;
            scaledVerts[i2 + 2] = verts[i2 + 2] * (float)zScale;
            i2 += 3;
        }
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        float[] colorsSet = new float[108];
        int i3 = 0;
        while (i3 < 36) {
            colorsSet[i3 * 3 + 0] = r;
            colorsSet[i3 * 3 + 1] = g2;
            colorsSet[i3 * 3 + 2] = b2;
            ++i3;
        }
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colorsSet)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public Cube(float xMin, float yMin, float zMin, float xMax, float yMax, float zMax) {
        TriangleArray cube = new TriangleArray(36, 2181);
        float[] scaledVerts = new float[]{xMax, yMin, zMax, xMax, yMax, zMax, xMin, yMax, zMax, xMax, yMin, zMax, xMin, yMax, zMax, xMin, yMin, zMax, xMin, yMin, zMin, xMin, yMax, zMin, xMax, yMax, zMin, xMin, yMin, zMin, xMax, yMax, zMin, xMax, yMin, zMin, xMax, yMin, zMin, xMax, yMax, zMin, xMax, yMax, zMax, xMax, yMin, zMin, xMax, yMax, zMax, xMax, yMin, zMax, xMin, yMin, zMax, xMin, yMax, zMax, xMin, yMax, zMin, xMin, yMin, zMax, xMin, yMax, zMin, xMin, yMin, zMin, xMax, yMax, zMax, xMax, yMax, zMin, xMin, yMax, zMin, xMax, yMax, zMax, xMin, yMax, zMin, xMin, yMax, zMax, xMin, yMin, zMax, xMin, yMin, zMin, xMax, yMin, zMin, xMin, yMin, zMax, xMax, yMin, zMin, xMax, yMin, zMax};
        cube.setCoordRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(scaledVerts)));
        cube.setColorRefBuffer(new J3DBuffer(Cube.makeFloatBuffer(colors)));
        this.setGeometry(cube);
        this.setAppearance(new SimpleShaderAppearance());
    }

    public static FloatBuffer makeFloatBuffer(float[] arr) {
        ByteBuffer bb = ByteBuffer.allocateDirect(arr.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(arr);
        fb.position(0);
        return fb;
    }
}

