/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.universe;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.HiResCoord;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SceneGraphObjectState;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.universe.PlatformGeometryState;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.universe.ViewerAvatarState;
import org.jogamp.java3d.utils.universe.ConfiguredUniverse;
import org.jogamp.java3d.utils.universe.MultiTransformGroup;
import org.jogamp.java3d.utils.universe.PlatformGeometry;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.java3d.utils.universe.ViewerAvatar;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.Matrix4d;

public class SimpleUniverseState {
    private SimpleUniverse universe = null;
    private Controller control;
    private ArrayList localeBGs;
    private int totalBGs = 0;
    private PlatformGeometryState platformGeom;
    private ViewerAvatarState viewerAvatar;

    public SimpleUniverseState(ConfiguredUniverse universe, Controller control) {
        this.universe = universe;
        this.control = control;
    }

    public SimpleUniverseState(SimpleUniverse universe, Controller control) {
        this.universe = universe;
        this.control = control;
    }

    public SimpleUniverseState(Controller control) {
        this.control = control;
    }

    public void writeObject(DataOutput out) throws IOException {
        MultiTransformGroup mtg = this.universe.getViewingPlatform().getMultiTransformGroup();
        int mtgSize = mtg.getNumTransforms();
        out.writeInt(mtgSize);
        Transform3D trans = new Transform3D();
        Matrix4d matrix = new Matrix4d();
        int i2 = 0;
        while (i2 < mtgSize) {
            TransformGroup tg = mtg.getTransformGroup(i2);
            tg.getTransform(trans);
            trans.get(matrix);
            this.control.writeMatrix4d(out, matrix);
            ++i2;
        }
        this.control.writeObject(out, this.control.createState(this.universe.getViewingPlatform().getPlatformGeometry()));
        this.control.writeObject(out, this.control.createState(this.universe.getViewer().getAvatar()));
        this.writeLocales(out);
    }

    public void readObject(DataInput in, Canvas3D canvas) throws IOException {
        int mtgSize = in.readInt();
        this.universe = canvas != null ? new ConfiguredUniverse(canvas, mtgSize) : new ConfiguredUniverse(ConfiguredUniverse.getConfigURL(), mtgSize);
        MultiTransformGroup mtg = this.universe.getViewingPlatform().getMultiTransformGroup();
        Matrix4d matrix = new Matrix4d();
        int i2 = 0;
        while (i2 < mtgSize) {
            TransformGroup tg = mtg.getTransformGroup(i2);
            matrix = this.control.readMatrix4d(in);
            Transform3D trans = new Transform3D(matrix);
            tg.setTransform(trans);
            ++i2;
        }
        SceneGraphObjectState tmp = this.control.readObject(in);
        this.platformGeom = tmp instanceof PlatformGeometryState ? (PlatformGeometryState)tmp : null;
        tmp = this.control.readObject(in);
        this.viewerAvatar = tmp instanceof ViewerAvatarState ? (ViewerAvatarState)tmp : null;
        this.readLocales(in);
    }

    private void writeLocales(DataOutput out) throws IOException {
        Iterator<Locale> allLocales = this.universe.getAllLocales();
        out.writeInt(this.universe.numLocales());
        this.localeBGs = new ArrayList(this.universe.numLocales());
        boolean currentLocale = false;
        int graphID = 0;
        while (allLocales.hasNext()) {
            Locale locale = allLocales.next();
            HiResCoord hiRes = new HiResCoord();
            this.writeHiResCoord(out, hiRes);
            int[] bgs = !currentLocale ? new int[locale.numBranchGraphs() - 1] : new int[locale.numBranchGraphs()];
            out.writeInt(bgs.length);
            int count = 0;
            Iterator<BranchGroup> e2 = locale.getAllBranchGraphs();
            while (e2.hasNext()) {
                BranchGroup bg = e2.next();
                if (bg instanceof ViewingPlatform) continue;
                this.control.getSymbolTable().addBranchGraphReference(bg, graphID);
                bgs[count] = graphID++;
                out.writeInt(bgs[count]);
                ++count;
                ++this.totalBGs;
            }
            this.localeBGs.add(bgs);
        }
    }

    private void readLocales(DataInput in) throws IOException {
        int numLocales = in.readInt();
        this.localeBGs = new ArrayList(numLocales);
        int i2 = 0;
        while (i2 < numLocales) {
            Locale locale;
            HiResCoord hiRes = this.readHiResCoord(in);
            if (i2 == 0) {
                locale = this.universe.getLocale();
                locale.setHiRes(hiRes);
            } else {
                locale = new Locale(this.universe, hiRes);
            }
            int numBG = in.readInt();
            int[] bgs = new int[numBG];
            int n2 = 0;
            while (n2 < numBG) {
                bgs[i2] = in.readInt();
                ++this.totalBGs;
                ++n2;
            }
            this.localeBGs.add(bgs);
            ++i2;
        }
    }

    public void buildGraph() {
        Iterator<Locale> e2 = this.universe.getAllLocales();
        int i2 = 0;
        while (i2 < this.localeBGs.size()) {
            Locale locale = e2.next();
            int[] bgs = (int[])this.localeBGs.get(i2);
            int j2 = 0;
            while (j2 < bgs.length) {
                SymbolTableData symbol = this.control.getSymbolTable().getBranchGraphRoot(bgs[j2]);
                locale.addBranchGraph((BranchGroup)symbol.j3dNode);
                ++j2;
            }
            ++i2;
        }
        if (this.viewerAvatar != null) {
            this.viewerAvatar.buildGraph();
            this.universe.getViewer().setAvatar((ViewerAvatar)this.viewerAvatar.getNode());
        }
        if (this.platformGeom != null) {
            this.universe.getViewingPlatform().setPlatformGeometry((PlatformGeometry)this.platformGeom.getNode());
            this.platformGeom.buildGraph();
        }
    }

    public int[] getAllGraphIDs() {
        int[] ret = new int[this.totalBGs];
        int c2 = 0;
        int i2 = 0;
        while (i2 < this.localeBGs.size()) {
            int[] bgs = (int[])this.localeBGs.get(i2);
            int j2 = 0;
            while (j2 < bgs.length) {
                ret[c2++] = bgs[j2];
                ++j2;
            }
            ++i2;
        }
        return ret;
    }

    public void detachAllGraphs() {
        boolean c2 = false;
        try {
            int i2 = 0;
            while (i2 < this.localeBGs.size()) {
                int[] bgs = (int[])this.localeBGs.get(i2);
                int j2 = 0;
                while (j2 < bgs.length) {
                    SymbolTableData symbol = this.control.getSymbolTable().getBranchGraphRoot(bgs[j2]);
                    ((BranchGroup)symbol.j3dNode).detach();
                    ++j2;
                }
                ++i2;
            }
        }
        catch (CapabilityNotSetException e2) {
            throw new CapabilityNotSetException("Locale BranchGraphs MUST have ALLOW_DETACH capability set");
        }
    }

    public void attachAllGraphs() {
        Iterator<Locale> e2 = this.universe.getAllLocales();
        int i2 = 0;
        while (i2 < this.localeBGs.size()) {
            Locale locale = e2.next();
            int[] bgs = (int[])this.localeBGs.get(i2);
            int j2 = 0;
            while (j2 < bgs.length) {
                SymbolTableData symbol = this.control.getSymbolTable().getBranchGraphRoot(bgs[j2]);
                locale.addBranchGraph((BranchGroup)symbol.j3dNode);
                ++j2;
            }
            ++i2;
        }
    }

    public ConfiguredUniverse getNode() {
        if (this.universe instanceof ConfiguredUniverse) {
            return (ConfiguredUniverse)this.universe;
        }
        return null;
    }

    private void writeHiResCoord(DataOutput out, HiResCoord hiRes) throws IOException {
        int[] x = new int[8];
        int[] y = new int[8];
        int[] z = new int[8];
        hiRes.getHiResCoord(x, y, z);
        int i2 = 0;
        while (i2 < 8) {
            out.writeInt(x[i2]);
            out.writeInt(y[i2]);
            out.writeInt(z[i2]);
            ++i2;
        }
    }

    private HiResCoord readHiResCoord(DataInput in) throws IOException {
        int[] x = new int[8];
        int[] y = new int[8];
        int[] z = new int[8];
        int i2 = 0;
        while (i2 < 8) {
            x[i2] = in.readInt();
            y[i2] = in.readInt();
            z[i2] = in.readInt();
            ++i2;
        }
        return new HiResCoord(x, y, z);
    }
}

