/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;

public class MorphState
extends LeafState {
    private int[] geometry;
    private double[] weights;
    private int appearance;

    public MorphState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.appearance = control.getSymbolTable().addReference(((Morph)this.node).getAppearance());
            this.weights = ((Morph)this.node).getWeights();
            this.geometry = new int[this.weights.length];
            int i2 = 0;
            while (i2 < this.weights.length) {
                this.geometry[i2] = control.getSymbolTable().addReference(((Morph)this.node).getGeometryArray(i2));
                ++i2;
            }
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Morph)this.node).getCollisionBounds());
        out.writeInt(this.appearance);
        out.writeBoolean(((Morph)this.node).getAppearanceOverrideEnable());
        out.writeInt(this.geometry.length);
        int i2 = 0;
        while (i2 < this.geometry.length) {
            out.writeInt(this.geometry[i2]);
            out.writeDouble(this.weights[i2]);
            ++i2;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Morph)this.node).setCollisionBounds(this.control.readBounds(in));
        this.appearance = in.readInt();
        ((Morph)this.node).setAppearanceOverrideEnable(in.readBoolean());
        int len = in.readInt();
        this.geometry = new int[len];
        this.weights = new double[len];
        int i2 = 0;
        while (i2 < this.geometry.length) {
            this.geometry[i2] = in.readInt();
            this.weights[i2] = in.readDouble();
            ++i2;
        }
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
        int i2 = 0;
        while (i2 < this.geometry.length) {
            this.control.getSymbolTable().incNodeComponentRefCount(this.geometry[i2]);
            ++i2;
        }
    }

    @Override
    public void buildGraph() {
        ((Morph)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        GeometryArray[] geom = new GeometryArray[this.geometry.length];
        int i2 = 0;
        while (i2 < this.geometry.length) {
            geom[i2] = (GeometryArray)this.control.getSymbolTable().getJ3dNode(this.geometry[i2]);
            ++i2;
        }
        ((Morph)this.node).setGeometryArrays(geom);
        ((Morph)this.node).setWeights(this.weights);
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Morph(null);
    }
}

