/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Light;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;
import org.jogamp.vecmath.Color3f;

public abstract class LightState
extends LeafState {
    private int boundingLeaf = 0;
    private int[] scope;

    public LightState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.scope = new int[((Light)this.node).numScopes()];
        int i2 = 0;
        while (i2 < ((Light)this.node).numScopes()) {
            this.scope[i2] = this.control.getSymbolTable().addReference(((Light)this.node).getScope(i2));
            ++i2;
        }
        this.boundingLeaf = this.control.getSymbolTable().addReference(((Light)this.node).getInfluencingBoundingLeaf());
        Color3f color = new Color3f();
        ((Light)this.node).getColor(color);
        this.control.writeColor3f(out, color);
        out.writeBoolean(((Light)this.node).getEnable());
        out.writeInt(this.boundingLeaf);
        this.control.writeBounds(out, ((Light)this.node).getInfluencingBounds());
        out.writeInt(this.scope.length);
        int i3 = 0;
        while (i3 < this.scope.length) {
            out.writeInt(this.scope[i3]);
            ++i3;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Light)this.node).setColor(this.control.readColor3f(in));
        ((Light)this.node).setEnable(in.readBoolean());
        this.boundingLeaf = in.readInt();
        ((Light)this.node).setInfluencingBounds(this.control.readBounds(in));
        this.scope = new int[in.readInt()];
        int i2 = 0;
        while (i2 < this.scope.length) {
            this.scope[i2] = in.readInt();
            ++i2;
        }
    }

    @Override
    public void buildGraph() {
        ((Light)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        int i2 = 0;
        while (i2 < this.scope.length) {
            ((Light)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scope[i2]));
            ++i2;
        }
        super.buildGraph();
    }
}

