/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.internal.BufferWrapper;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.GeometryState;
import org.jogamp.vecmath.Color3b;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4b;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.Vector3f;

public abstract class GeometryArrayState
extends GeometryState {
    protected int vertexFormat;
    protected int vertexCount;
    protected int texCoordSetCount;
    protected int[] texCoordSetMap;
    private static final int FORMAT_NULL = 0;
    private static final int FORMAT_BYTE = 1;
    private static final int FORMAT_FLOAT = 2;
    private static final int FORMAT_DOUBLE = 3;
    private static final int FORMAT_3B = 4;
    private static final int FORMAT_4B = 5;
    private static final int FORMAT_2F = 6;
    private static final int FORMAT_3F = 7;
    private static final int FORMAT_4F = 8;
    private static final int FORMAT_2D = 9;
    private static final int FORMAT_3D = 10;

    public GeometryArrayState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        block121: {
            float[] textureCoords;
            J3DBuffer buf;
            boolean byRef;
            boolean nio;
            block123: {
                Cloneable[] tcoords;
                block122: {
                    Object[] data;
                    Object[] colors;
                    Buffer bb;
                    J3DBuffer buf2;
                    block120: {
                        super.writeObject(out);
                        boolean bl = nio = (this.vertexFormat & 0x800) != 0;
                        if ((this.vertexFormat & 0x100) == 0) break block120;
                        if (!(this.node instanceof IndexedGeometryArray)) {
                            out.writeInt(((GeometryArray)this.node).getInitialVertexIndex());
                            if (!(this.node instanceof GeometryStripArray)) {
                                out.writeInt(((GeometryArray)this.node).getValidVertexCount());
                            }
                        }
                        if (nio) {
                            FloatBuffer x = (FloatBuffer)((GeometryArray)this.node).getInterleavedVertexBuffer().getBuffer();
                            float[] f2 = new float[x.limit()];
                            x.position(0);
                            x.get(f2);
                            this.writeFloatArray(out, f2);
                        } else {
                            this.writeFloatArray(out, ((GeometryArray)this.node).getInterleavedVertices());
                        }
                        break block121;
                    }
                    boolean bl = byRef = (this.vertexFormat & 0x80) != 0;
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        if (!byRef) {
                            out.writeInt(((GeometryArray)this.node).getInitialVertexIndex());
                        }
                        if (!(this.node instanceof GeometryStripArray)) {
                            out.writeInt(((GeometryArray)this.node).getValidVertexCount());
                        }
                    }
                    if ((this.vertexFormat & 0xC) == 12) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialColorIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getColorRefBuffer();
                                switch (BufferWrapper.getBufferType(buf2)) {
                                    case 2: {
                                        out.writeInt(1);
                                        bb = (ByteBuffer)buf2.getBuffer();
                                        byte[] bytes = new byte[bb.limit()];
                                        ((ByteBuffer)bb).position(0);
                                        ((ByteBuffer)bb).get(bytes);
                                        out.writeInt(bytes.length);
                                        out.write(bytes);
                                        break;
                                    }
                                    case 3: {
                                        out.writeInt(2);
                                        bb = (FloatBuffer)buf2.getBuffer();
                                        float[] floats = new float[bb.limit()];
                                        ((FloatBuffer)bb).position(0);
                                        ((FloatBuffer)bb).get(floats);
                                        this.writeFloatArray(out, floats);
                                        break;
                                    }
                                    case 0: {
                                        out.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getColorRef4f() != null) {
                                out.writeInt(8);
                                colors = ((GeometryArray)this.node).getColorRef4f();
                                data = new float[colors.length * 4];
                                int i2 = 0;
                                while (i2 < colors.length) {
                                    data[i2 * 4 + 0] = colors[i2].x;
                                    data[i2 * 4 + 1] = colors[i2].y;
                                    data[i2 * 4 + 2] = colors[i2].z;
                                    data[i2 * 4 + 3] = colors[i2].w;
                                    ++i2;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getColorRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getColorRefFloat());
                            } else if (((GeometryArray)this.node).getColorRefByte() != null) {
                                out.writeInt(1);
                                colors = ((GeometryArray)this.node).getColorRefByte();
                                out.writeInt(colors.length);
                                out.write((byte[])colors);
                            } else if (((GeometryArray)this.node).getColorRef4b() != null) {
                                out.writeInt(5);
                                colors = ((GeometryArray)this.node).getColorRef4b();
                                out.writeInt(colors.length);
                                data = new byte[colors.length * 4];
                                int i3 = 0;
                                while (i3 < colors.length) {
                                    data[i3 * 4 + 0] = colors[i3].x;
                                    data[i3 * 4 + 1] = colors[i3].y;
                                    data[i3 * 4 + 2] = colors[i3].z;
                                    data[i3 * 4 + 3] = colors[i3].w;
                                    ++i3;
                                }
                                out.write((byte[])data);
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            colors = new byte[this.vertexCount * 4];
                            ((GeometryArray)this.node).getColors(0, (byte[])colors);
                            out.write((byte[])colors);
                        }
                    } else if ((this.vertexFormat & 4) == 4) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialColorIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getColorRefBuffer();
                                switch (BufferWrapper.getBufferType(buf2)) {
                                    case 2: {
                                        out.writeInt(1);
                                        bb = (ByteBuffer)buf2.getBuffer();
                                        byte[] bytes = new byte[bb.limit()];
                                        ((ByteBuffer)bb).position(0);
                                        ((ByteBuffer)bb).get(bytes);
                                        out.writeInt(bytes.length);
                                        out.write(bytes);
                                        break;
                                    }
                                    case 3: {
                                        out.writeInt(2);
                                        bb = (FloatBuffer)buf2.getBuffer();
                                        float[] floats = new float[bb.limit()];
                                        ((FloatBuffer)bb).position(0);
                                        ((FloatBuffer)bb).get(floats);
                                        this.writeFloatArray(out, floats);
                                        break;
                                    }
                                    case 0: {
                                        out.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getColorRef3f() != null) {
                                out.writeInt(7);
                                colors = ((GeometryArray)this.node).getColorRef3f();
                                data = new float[colors.length * 3];
                                int i4 = 0;
                                while (i4 < colors.length) {
                                    data[i4 * 3 + 0] = colors[i4].x;
                                    data[i4 * 3 + 1] = colors[i4].y;
                                    data[i4 * 3 + 2] = colors[i4].z;
                                    ++i4;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getColorRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getColorRefFloat());
                            } else if (((GeometryArray)this.node).getColorRefByte() != null) {
                                out.writeInt(1);
                                colors = ((GeometryArray)this.node).getColorRefByte();
                                out.writeInt(colors.length);
                                out.write((byte[])colors);
                            } else if (((GeometryArray)this.node).getColorRef3b() != null) {
                                out.writeInt(4);
                                colors = ((GeometryArray)this.node).getColorRef3b();
                                out.writeInt(colors.length);
                                data = new byte[colors.length * 3];
                                int i5 = 0;
                                while (i5 < colors.length) {
                                    data[i5 * 3 + 0] = colors[i5].x;
                                    data[i5 * 3 + 1] = colors[i5].y;
                                    data[i5 * 3 + 2] = colors[i5].z;
                                    ++i5;
                                }
                                out.write((byte[])data);
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            byte[] colors3 = new byte[this.vertexCount * 3];
                            ((GeometryArray)this.node).getColors(0, colors3);
                            out.write(colors3);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        if (byRef) {
                            Cloneable[] coords;
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialCoordIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getCoordRefBuffer();
                                switch (BufferWrapper.getBufferType(buf2)) {
                                    case 3: {
                                        out.writeInt(2);
                                        bb = (FloatBuffer)buf2.getBuffer();
                                        float[] floats = new float[bb.limit()];
                                        ((FloatBuffer)bb).position(0);
                                        ((FloatBuffer)bb).get(floats);
                                        this.writeFloatArray(out, floats);
                                        break;
                                    }
                                    case 4: {
                                        out.writeInt(3);
                                        bb = (DoubleBuffer)buf2.getBuffer();
                                        double[] doubles = new double[bb.limit()];
                                        ((DoubleBuffer)bb).position(0);
                                        ((DoubleBuffer)bb).get(doubles);
                                        this.writeDoubleArray(out, doubles);
                                        break;
                                    }
                                    case 0: {
                                        out.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getCoordRef3f() != null) {
                                out.writeInt(7);
                                coords = ((GeometryArray)this.node).getCoordRef3f();
                                data = new float[coords.length * 3];
                                int i6 = 0;
                                while (i6 < coords.length) {
                                    data[i6 * 3 + 0] = ((Point3f)coords[i6]).x;
                                    data[i6 * 3 + 1] = ((Point3f)coords[i6]).y;
                                    data[i6 * 3 + 2] = ((Point3f)coords[i6]).z;
                                    ++i6;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getCoordRef3d() != null) {
                                out.writeInt(10);
                                coords = ((GeometryArray)this.node).getCoordRef3d();
                                data = new double[coords.length * 3];
                                int i7 = 0;
                                while (i7 < coords.length) {
                                    data[i7 * 3 + 0] = (float)((Point3d)coords[i7]).x;
                                    data[i7 * 3 + 1] = (float)((Point3d)coords[i7]).y;
                                    data[i7 * 3 + 2] = (float)((Point3d)coords[i7]).z;
                                    ++i7;
                                }
                                this.writeDoubleArray(out, (double[])data);
                            } else if (((GeometryArray)this.node).getCoordRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getCoordRefFloat());
                            } else if (((GeometryArray)this.node).getCoordRefDouble() != null) {
                                out.writeInt(3);
                                this.writeDoubleArray(out, ((GeometryArray)this.node).getCoordRefDouble());
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            float[] points = new float[this.vertexCount * 3];
                            ((GeometryArray)this.node).getCoordinates(0, points);
                            this.writeFloatArray(out, points);
                        }
                    }
                    if ((this.vertexFormat & 2) != 0) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialNormalIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getNormalRefBuffer();
                                if (BufferWrapper.getBufferType(buf2) == 0) {
                                    out.writeInt(0);
                                } else {
                                    out.writeInt(2);
                                    bb = (FloatBuffer)buf2.getBuffer();
                                    float[] floats = new float[bb.limit()];
                                    ((FloatBuffer)bb).position(0);
                                    ((FloatBuffer)bb).get(floats);
                                    this.writeFloatArray(out, floats);
                                }
                            } else if (((GeometryArray)this.node).getNormalRef3f() != null) {
                                out.writeInt(7);
                                Vector3f[] norms = ((GeometryArray)this.node).getNormalRef3f();
                                data = new float[norms.length * 3];
                                int i8 = 0;
                                while (i8 < norms.length) {
                                    data[i8 * 3 + 0] = norms[i8].x;
                                    data[i8 * 3 + 1] = norms[i8].y;
                                    data[i8 * 3 + 2] = norms[i8].z;
                                    ++i8;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getNormalRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getNormalRefFloat());
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            float[] normals = new float[this.vertexCount * 3];
                            ((GeometryArray)this.node).getNormals(0, normals);
                            this.writeFloatArray(out, normals);
                        }
                    }
                    if ((this.vertexFormat & 0x20) == 0) break block122;
                    int set = 0;
                    while (set < this.texCoordSetCount) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(set));
                            }
                            if (nio) {
                                buf = ((GeometryArray)this.node).getTexCoordRefBuffer(set);
                                if (BufferWrapper.getBufferType(buf) == 0) {
                                    out.writeInt(0);
                                } else {
                                    out.writeInt(2);
                                    FloatBuffer bb2 = (FloatBuffer)buf.getBuffer();
                                    float[] floats = new float[bb2.limit()];
                                    bb2.position(0);
                                    bb2.get(floats);
                                    this.writeFloatArray(out, floats);
                                }
                            } else if (((GeometryArray)this.node).getTexCoordRef2f(set) != null) {
                                out.writeInt(6);
                                tcoords = ((GeometryArray)this.node).getTexCoordRef2f(set);
                                float[] data2 = new float[tcoords.length * 2];
                                int i9 = 0;
                                while (i9 < tcoords.length) {
                                    data2[i9 * 2 + 0] = ((TexCoord2f)tcoords[i9]).x;
                                    data2[i9 * 2 + 1] = ((TexCoord2f)tcoords[i9]).y;
                                    ++i9;
                                }
                                this.writeFloatArray(out, data2);
                            } else if (((GeometryArray)this.node).getTexCoordRefFloat(set) != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getTexCoordRefFloat(set));
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            textureCoords = new float[this.vertexCount * 2];
                            ((GeometryArray)this.node).getTextureCoordinates(set, 0, textureCoords);
                            this.writeFloatArray(out, textureCoords);
                        }
                        ++set;
                    }
                    break block121;
                }
                if ((this.vertexFormat & 0x40) == 0) break block123;
                int set = 0;
                while (set < this.texCoordSetCount) {
                    if (byRef) {
                        if (!(this.node instanceof IndexedGeometryArray)) {
                            out.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(set));
                        }
                        if (nio) {
                            buf = ((GeometryArray)this.node).getTexCoordRefBuffer(set);
                            if (BufferWrapper.getBufferType(buf) == 0) {
                                out.writeInt(0);
                            } else {
                                out.writeInt(2);
                                FloatBuffer bb = (FloatBuffer)buf.getBuffer();
                                float[] floats = new float[bb.limit()];
                                bb.position(0);
                                bb.get(floats);
                                this.writeFloatArray(out, floats);
                            }
                        } else if (((GeometryArray)this.node).getTexCoordRef3f(set) != null) {
                            out.writeInt(7);
                            tcoords = ((GeometryArray)this.node).getTexCoordRef3f(set);
                            float[] data = new float[tcoords.length * 3];
                            int i10 = 0;
                            while (i10 < tcoords.length) {
                                data[i10 * 3 + 0] = ((TexCoord3f)tcoords[i10]).x;
                                data[i10 * 3 + 1] = ((TexCoord3f)tcoords[i10]).y;
                                data[i10 * 3 + 2] = ((TexCoord3f)tcoords[i10]).z;
                                ++i10;
                            }
                            this.writeFloatArray(out, data);
                        } else if (((GeometryArray)this.node).getTexCoordRefFloat(set) != null) {
                            out.writeInt(2);
                            this.writeFloatArray(out, ((GeometryArray)this.node).getTexCoordRefFloat(set));
                        } else {
                            out.writeInt(0);
                        }
                    } else {
                        textureCoords = new float[this.vertexCount * 3];
                        ((GeometryArray)this.node).getTextureCoordinates(set, 0, textureCoords);
                        this.writeFloatArray(out, textureCoords);
                    }
                    ++set;
                }
                break block121;
            }
            if ((this.vertexFormat & 0x400) == 0) break block121;
            int set = 0;
            while (set < this.texCoordSetCount) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        out.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(set));
                    }
                    if (nio) {
                        buf = ((GeometryArray)this.node).getTexCoordRefBuffer(set);
                        if (BufferWrapper.getBufferType(buf) == 0) {
                            out.writeInt(0);
                        } else {
                            out.writeInt(2);
                            FloatBuffer bb = (FloatBuffer)buf.getBuffer();
                            float[] floats = new float[bb.limit()];
                            bb.position(0);
                            bb.get(floats);
                            this.writeFloatArray(out, floats);
                        }
                    } else if (((GeometryArray)this.node).getTexCoordRefFloat(set) != null) {
                        out.writeInt(2);
                        this.writeFloatArray(out, ((GeometryArray)this.node).getTexCoordRefFloat(set));
                    } else {
                        out.writeInt(0);
                    }
                } else {
                    textureCoords = new float[this.vertexCount * 4];
                    ((GeometryArray)this.node).getTextureCoordinates(set, 0, textureCoords);
                    this.writeFloatArray(out, textureCoords);
                }
                ++set;
            }
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        block90: {
            Object[] data;
            Object[] colors;
            Cloneable[] colors2;
            Object[] data2;
            float[] floats;
            ByteBuffer b2;
            byte[] bytes;
            boolean byRef;
            boolean nio;
            block89: {
                super.readObject(in);
                boolean bl = nio = (this.vertexFormat & 0x800) != 0;
                if ((this.vertexFormat & 0x100) == 0) break block89;
                if (!(this.node instanceof IndexedGeometryArray)) {
                    ((GeometryArray)this.node).setInitialVertexIndex(in.readInt());
                    if (!(this.node instanceof GeometryStripArray)) {
                        ((GeometryArray)this.node).setValidVertexCount(in.readInt());
                    }
                }
                if (nio) {
                    float[] floats2 = this.readFloatArray(in);
                    ByteBuffer b3 = ByteBuffer.allocateDirect(floats2.length * 4);
                    FloatBuffer f2 = b3.order(ByteOrder.nativeOrder()).asFloatBuffer();
                    f2.put(floats2);
                    ((GeometryArray)this.node).setInterleavedVertexBuffer(new J3DBuffer(f2));
                } else {
                    ((GeometryArray)this.node).setInterleavedVertices(this.readFloatArray(in));
                }
                break block90;
            }
            boolean bl = byRef = (this.vertexFormat & 0x80) != 0;
            if (!(this.node instanceof IndexedGeometryArray)) {
                if (!byRef) {
                    ((GeometryArray)this.node).setInitialVertexIndex(in.readInt());
                }
                if (!(this.node instanceof GeometryStripArray)) {
                    ((GeometryArray)this.node).setValidVertexCount(in.readInt());
                }
            }
            if ((this.vertexFormat & 0xC) == 12) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialColorIndex(in.readInt());
                    }
                    if (nio) {
                        switch (in.readInt()) {
                            case 1: {
                                bytes = new byte[in.readInt()];
                                in.readFully(bytes);
                                b2 = ByteBuffer.allocateDirect(bytes.length);
                                b2.put(bytes);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(b2));
                                break;
                            }
                            case 2: {
                                floats = this.readFloatArray(in);
                                b2 = ByteBuffer.allocateDirect(floats.length * 4);
                                FloatBuffer f3 = b2.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                f3.put(floats);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(f3));
                            }
                        }
                    } else {
                        switch (in.readInt()) {
                            case 8: {
                                data2 = this.readFloatArray(in);
                                colors2 = new Color4f[data2.length / 4];
                                int i2 = 0;
                                while (i2 < colors2.length) {
                                    ((Color4f)colors2[i2]).x = data2[i2 * 4 + 0];
                                    ((Color4f)colors2[i2]).y = data2[i2 * 4 + 1];
                                    ((Color4f)colors2[i2]).z = data2[i2 * 4 + 2];
                                    ((Color4f)colors2[i2]).w = data2[i2 * 4 + 3];
                                    ++i2;
                                }
                                ((GeometryArray)this.node).setColorRef4f((Color4f[])colors2);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setColorRefFloat(this.readFloatArray(in));
                                break;
                            }
                            case 1: {
                                data2 = new byte[in.readInt()];
                                in.readFully((byte[])data2);
                                ((GeometryArray)this.node).setColorRefByte((byte[])data2);
                                break;
                            }
                            case 5: {
                                colors = new Color4b[in.readInt()];
                                data = new byte[colors.length * 4];
                                in.readFully((byte[])data);
                                int i3 = 0;
                                while (i3 < colors.length) {
                                    colors[i3].x = data[i3 * 4 + 0];
                                    colors[i3].y = data[i3 * 4 + 1];
                                    colors[i3].z = data[i3 * 4 + 2];
                                    colors[i3].w = data[i3 * 4 + 3];
                                    ++i3;
                                }
                                ((GeometryArray)this.node).setColorRef4b((Color4b[])colors);
                            }
                        }
                    }
                } else {
                    colors = new byte[this.vertexCount * 4];
                    in.readFully((byte[])colors);
                    ((GeometryArray)this.node).setColors(0, (byte[])colors);
                }
            } else if ((this.vertexFormat & 4) == 4) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialColorIndex(in.readInt());
                    }
                    if (nio) {
                        switch (in.readInt()) {
                            case 1: {
                                bytes = new byte[in.readInt()];
                                in.readFully(bytes);
                                b2 = ByteBuffer.allocateDirect(bytes.length);
                                b2.put(bytes);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(b2));
                                break;
                            }
                            case 2: {
                                floats = this.readFloatArray(in);
                                b2 = ByteBuffer.allocateDirect(floats.length * 4);
                                FloatBuffer f4 = b2.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                f4.put(floats);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(f4));
                            }
                        }
                    } else {
                        switch (in.readInt()) {
                            case 7: {
                                data2 = this.readFloatArray(in);
                                colors2 = new Color3f[data2.length / 3];
                                int i4 = 0;
                                while (i4 < colors2.length) {
                                    ((Color3f)colors2[i4]).x = data2[i4 * 3 + 0];
                                    ((Color3f)colors2[i4]).y = data2[i4 * 3 + 1];
                                    ((Color3f)colors2[i4]).z = data2[i4 * 3 + 2];
                                    ++i4;
                                }
                                ((GeometryArray)this.node).setColorRef3f((Color3f[])colors2);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setColorRefFloat(this.readFloatArray(in));
                                break;
                            }
                            case 1: {
                                data2 = new byte[in.readInt()];
                                in.readFully((byte[])data2);
                                ((GeometryArray)this.node).setColorRefByte((byte[])data2);
                                break;
                            }
                            case 4: {
                                colors = new Color3b[in.readInt()];
                                data = new byte[colors.length * 3];
                                in.readFully((byte[])data);
                                int i5 = 0;
                                while (i5 < colors.length) {
                                    colors[i5].x = data[i5 * 3 + 0];
                                    colors[i5].y = data[i5 * 3 + 1];
                                    colors[i5].z = data[i5 * 3 + 2];
                                    ++i5;
                                }
                                ((GeometryArray)this.node).setColorRef3b((Color3b[])colors);
                            }
                        }
                    }
                } else {
                    colors = new byte[this.vertexCount * 3];
                    in.readFully((byte[])colors);
                    ((GeometryArray)this.node).setColors(0, (byte[])colors);
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialCoordIndex(in.readInt());
                    }
                    if (nio) {
                        switch (in.readInt()) {
                            case 2: {
                                floats = this.readFloatArray(in);
                                b2 = ByteBuffer.allocateDirect(floats.length * 4);
                                FloatBuffer f5 = b2.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                f5.put(floats);
                                ((GeometryArray)this.node).setCoordRefBuffer(new J3DBuffer(f5));
                                break;
                            }
                            case 3: {
                                double[] doubles = this.readDoubleArray(in);
                                b2 = ByteBuffer.allocateDirect(doubles.length * 8);
                                DoubleBuffer f6 = b2.order(ByteOrder.nativeOrder()).asDoubleBuffer();
                                f6.put(doubles);
                                ((GeometryArray)this.node).setCoordRefBuffer(new J3DBuffer(f6));
                            }
                        }
                    } else {
                        switch (in.readInt()) {
                            case 7: {
                                data2 = this.readFloatArray(in);
                                Cloneable[] coords = new Point3f[data2.length / 3];
                                int i6 = 0;
                                while (i6 < coords.length) {
                                    ((Point3f)coords[i6]).x = data2[i6 * 3 + 0];
                                    ((Point3f)coords[i6]).y = data2[i6 * 3 + 1];
                                    ((Point3f)coords[i6]).z = data2[i6 * 3 + 2];
                                    ++i6;
                                }
                                ((GeometryArray)this.node).setCoordRef3f((Point3f[])coords);
                                break;
                            }
                            case 10: {
                                data2 = this.readDoubleArray(in);
                                Cloneable[] coords = new Point3d[data2.length / 3];
                                int i7 = 0;
                                while (i7 < coords.length) {
                                    ((Point3d)coords[i7]).x = data2[i7 * 3 + 0];
                                    ((Point3d)coords[i7]).y = data2[i7 * 3 + 1];
                                    ((Point3d)coords[i7]).z = data2[i7 * 3 + 2];
                                    ++i7;
                                }
                                ((GeometryArray)this.node).setCoordRef3d((Point3d[])coords);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setCoordRefFloat(this.readFloatArray(in));
                                break;
                            }
                            case 3: {
                                ((GeometryArray)this.node).setCoordRefDouble(this.readDoubleArray(in));
                            }
                        }
                    }
                } else {
                    float[] points = this.readFloatArray(in);
                    ((GeometryArray)this.node).setCoordinates(0, points);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialNormalIndex(in.readInt());
                    }
                    if (nio) {
                        if (in.readInt() == 2) {
                            floats = this.readFloatArray(in);
                            b2 = ByteBuffer.allocateDirect(floats.length * 4);
                            FloatBuffer f7 = b2.order(ByteOrder.nativeOrder()).asFloatBuffer();
                            f7.put(floats);
                            ((GeometryArray)this.node).setNormalRefBuffer(new J3DBuffer(f7));
                        }
                    } else {
                        switch (in.readInt()) {
                            case 7: {
                                data2 = this.readFloatArray(in);
                                Vector3f[] norms = new Vector3f[data2.length / 3];
                                int i8 = 0;
                                while (i8 < norms.length) {
                                    norms[i8].x = data2[i8 * 3 + 0];
                                    norms[i8].y = data2[i8 * 3 + 1];
                                    norms[i8].z = data2[i8 * 3 + 2];
                                    ++i8;
                                }
                                ((GeometryArray)this.node).setNormalRef3f(norms);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setNormalRefFloat(this.readFloatArray(in));
                            }
                        }
                    }
                } else {
                    float[] normals = this.readFloatArray(in);
                    ((GeometryArray)this.node).setNormals(0, normals);
                }
            }
            if ((this.vertexFormat & 0x20) == 0 && (this.vertexFormat & 0x40) == 0 && (this.vertexFormat & 0x400) == 0) break block90;
            if (byRef) {
                int set = 0;
                while (set < this.texCoordSetCount) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialTexCoordIndex(set, in.readInt());
                    }
                    if (nio) {
                        if (in.readInt() == 2) {
                            float[] floats3 = this.readFloatArray(in);
                            ByteBuffer b4 = ByteBuffer.allocateDirect(floats3.length * 4);
                            FloatBuffer f8 = b4.order(ByteOrder.nativeOrder()).asFloatBuffer();
                            f8.put(floats3);
                            ((GeometryArray)this.node).setTexCoordRefBuffer(set, new J3DBuffer(f8));
                        }
                    } else {
                        switch (in.readInt()) {
                            case 6: {
                                data = this.readFloatArray(in);
                                TexCoord2f[] tcoords = new TexCoord2f[data.length / 2];
                                int i9 = 0;
                                while (i9 < tcoords.length) {
                                    tcoords[i9].x = data[i9 * 2 + 0];
                                    tcoords[i9].y = data[i9 * 2 + 1];
                                    ++i9;
                                }
                                ((GeometryArray)this.node).setTexCoordRef2f(set, tcoords);
                                break;
                            }
                            case 7: {
                                data = this.readFloatArray(in);
                                TexCoord3f[] tcoords = new TexCoord3f[data.length / 3];
                                int i10 = 0;
                                while (i10 < tcoords.length) {
                                    tcoords[i10].x = data[i10 * 3 + 0];
                                    tcoords[i10].y = data[i10 * 3 + 1];
                                    tcoords[i10].z = data[i10 * 3 + 2];
                                    ++i10;
                                }
                                ((GeometryArray)this.node).setTexCoordRef3f(set, tcoords);
                                break;
                            }
                            case 2: {
                                float[] tcoords = this.readFloatArray(in);
                                ((GeometryArray)this.node).setTexCoordRefFloat(set, tcoords);
                            }
                        }
                    }
                    ++set;
                }
            } else {
                int set = 0;
                while (set < this.texCoordSetCount) {
                    float[] textureCoords = this.readFloatArray(in);
                    ((GeometryArray)this.node).setTextureCoordinates(set, 0, textureCoords);
                    ++set;
                }
            }
        }
    }

    @Override
    protected void writeConstructorParams(DataOutput out) throws IOException {
        this.vertexCount = ((GeometryArray)this.node).getVertexCount();
        this.vertexFormat = ((GeometryArray)this.node).getVertexFormat();
        this.texCoordSetCount = ((GeometryArray)this.node).getTexCoordSetCount();
        this.texCoordSetMap = new int[((GeometryArray)this.node).getTexCoordSetMapLength()];
        ((GeometryArray)this.node).getTexCoordSetMap(this.texCoordSetMap);
        out.writeInt(this.vertexCount);
        out.writeInt(this.vertexFormat);
        out.writeInt(this.texCoordSetCount);
        out.writeInt(this.texCoordSetMap.length);
        int i2 = 0;
        while (i2 < this.texCoordSetMap.length) {
            out.writeInt(this.texCoordSetMap[i2]);
            ++i2;
        }
        super.writeConstructorParams(out);
    }

    @Override
    protected void readConstructorParams(DataInput in) throws IOException {
        this.vertexCount = in.readInt();
        this.vertexFormat = in.readInt();
        this.texCoordSetCount = in.readInt();
        this.texCoordSetMap = new int[in.readInt()];
        int i2 = 0;
        while (i2 < this.texCoordSetMap.length) {
            this.texCoordSetMap[i2] = in.readInt();
            ++i2;
        }
        super.readConstructorParams(in);
    }

    protected void writeDoubleArray(DataOutput out, double[] array) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteStream);
        dataOut.writeInt(array.length);
        int i2 = 0;
        while (i2 < array.length) {
            dataOut.writeDouble(array[i2]);
            ++i2;
        }
        dataOut.close();
        out.writeInt(byteStream.size());
        out.write(byteStream.toByteArray());
    }

    protected double[] readDoubleArray(DataInput in) throws IOException {
        byte[] buffer = new byte[in.readInt()];
        in.readFully(buffer);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(buffer);
        DataInputStream dataIn = new DataInputStream(byteStream);
        double[] array = new double[dataIn.readInt()];
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = dataIn.readDouble();
            ++i2;
        }
        dataIn.close();
        return array;
    }

    protected void writeFloatArray(DataOutput out, float[] array) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteStream);
        dataOut.writeInt(array.length);
        int i2 = 0;
        while (i2 < array.length) {
            dataOut.writeFloat(array[i2]);
            ++i2;
        }
        dataOut.close();
        out.writeInt(byteStream.size());
        out.write(byteStream.toByteArray());
    }

    protected float[] readFloatArray(DataInput in) throws IOException {
        byte[] buffer = new byte[in.readInt()];
        in.readFully(buffer);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(buffer);
        DataInputStream dataIn = new DataInputStream(byteStream);
        float[] array = new float[dataIn.readInt()];
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = dataIn.readFloat();
            ++i2;
        }
        dataIn.close();
        return array;
    }
}

