/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.DistanceLOD;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LODState;
import org.jogamp.vecmath.Point3f;

public class DistanceLODState
extends LODState {
    private int numDistances;

    public DistanceLODState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        int i2 = 0;
        while (i2 < this.numDistances) {
            out.writeDouble(((DistanceLOD)this.node).getDistance(i2));
            ++i2;
        }
        Point3f pos = new Point3f();
        ((DistanceLOD)this.node).getPosition(pos);
        this.control.writePoint3f(out, pos);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        int i2 = 0;
        while (i2 < this.numDistances) {
            ((DistanceLOD)this.node).setDistance(i2, in.readDouble());
            ++i2;
        }
        ((DistanceLOD)this.node).setPosition(this.control.readPoint3f(in));
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        this.numDistances = ((DistanceLOD)this.node).numDistances();
        out.writeInt(this.numDistances);
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.numDistances = in.readInt();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        float[] distances = new float[this.numDistances];
        return this.createNode(j3dClass, new Class[]{distances.getClass()}, new Object[]{distances});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new DistanceLOD(new float[this.numDistances]);
    }
}

