/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.DepthComponentFloat;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;

public class DepthComponentFloatState
extends NodeComponentState {
    private int height;
    private int width;

    public DepthComponentFloatState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        float[] buf = new float[this.width * this.height];
        ((DepthComponentFloat)this.node).getDepthData(buf);
        int i2 = 0;
        while (i2 < buf.length) {
            out.writeFloat(buf[i2]);
            ++i2;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        float[] buf = new float[this.width * this.height];
        int i2 = 0;
        while (i2 < buf.length) {
            buf[i2] = in.readFloat();
            ++i2;
        }
        ((DepthComponentFloat)this.node).setDepthData(buf);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeInt(this.width);
        out.writeInt(this.height);
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.width = in.readInt();
        this.height = in.readInt();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.width), new Integer(this.height)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new DepthComponentFloat(this.width, this.height);
    }
}

