/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.ConeSound;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.PointSoundState;
import org.jogamp.vecmath.Vector3f;

public class ConeSoundState
extends PointSoundState {
    public ConeSoundState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        float[] distanceAtten = new float[((ConeSound)this.node).getAngularAttenuationLength()];
        float[] gainAtten = new float[distanceAtten.length];
        float[] filterAtten = new float[distanceAtten.length];
        float[] backDistance = new float[distanceAtten.length];
        float[] backGain = new float[distanceAtten.length];
        float[] frontDistance = new float[distanceAtten.length];
        float[] frontGain = new float[distanceAtten.length];
        ((ConeSound)this.node).getDistanceGain(frontDistance, frontGain, backDistance, backGain);
        ((ConeSound)this.node).getAngularAttenuation(distanceAtten, gainAtten, filterAtten);
        out.writeInt(distanceAtten.length);
        int i2 = 0;
        while (i2 < distanceAtten.length) {
            out.writeFloat(distanceAtten[i2]);
            out.writeFloat(gainAtten[i2]);
            out.writeFloat(filterAtten[i2]);
            out.writeFloat(backDistance[i2]);
            out.writeFloat(backGain[i2]);
            ++i2;
        }
        Vector3f direction = new Vector3f();
        ((ConeSound)this.node).getDirection(direction);
        this.control.writeVector3f(out, direction);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        float[] distanceAtten = new float[in.readInt()];
        float[] gainAtten = new float[distanceAtten.length];
        float[] filterAtten = new float[distanceAtten.length];
        float[] backDistance = new float[distanceAtten.length];
        float[] backGain = new float[distanceAtten.length];
        int i2 = 0;
        while (i2 < distanceAtten.length) {
            distanceAtten[i2] = in.readFloat();
            gainAtten[i2] = in.readFloat();
            filterAtten[i2] = in.readFloat();
            backDistance[i2] = in.readFloat();
            backGain[i2] = in.readFloat();
            ++i2;
        }
        ((ConeSound)this.node).setBackDistanceGain(backDistance, backGain);
        ((ConeSound)this.node).setAngularAttenuation(distanceAtten, gainAtten, filterAtten);
        ((ConeSound)this.node).setDirection(this.control.readVector3f(in));
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ConeSound();
    }
}

