/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.pickfast;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Link;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickConeRay;
import org.jogamp.java3d.PickConeSegment;
import org.jogamp.java3d.PickCylinderRay;
import org.jogamp.java3d.PickCylinderSegment;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class PickTool {
    public static final int TYPE_SHAPE3D = 1;
    public static final int TYPE_MORPH = 2;
    public static final int TYPE_PRIMITIVE = 4;
    public static final int TYPE_LINK = 8;
    public static final int TYPE_GROUP = 16;
    public static final int TYPE_TRANSFORM_GROUP = 32;
    public static final int TYPE_BRANCH_GROUP = 64;
    public static final int TYPE_SWITCH = 128;
    private static final int ALL_FLAGS = 127;
    private final boolean debug = false;
    protected boolean userDefineShape = false;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 1;
    int flags = 2;

    public PickTool(BranchGroup b2) {
        this.pickRootBG = b2;
    }

    public PickTool(Locale l2) {
        this.pickRootL = l2;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public Locale getLocale() {
        return this.pickRootL;
    }

    public void setShape(PickShape ps, Point3d startPt) {
        this.pickShape = ps;
        this.start = startPt;
        this.userDefineShape = ps != null;
    }

    public void setShapeBounds(Bounds bounds, Point3d startPt) {
        this.pickShape = new PickBounds(bounds);
        this.start = startPt;
        this.userDefineShape = true;
    }

    public void setMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setFlags(int flags) {
        if ((flags & 0xFFFFFF80) != 0) {
            throw new IllegalArgumentException();
        }
        this.flags = flags;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setShapeRay(Point3d start, Vector3d dir2) {
        this.pickShape = new PickRay(start, dir2);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeSegment(Point3d start, Point3d end) {
        this.pickShape = new PickSegment(start, end);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeCylinderSegment(Point3d start, Point3d end, double radius) {
        this.pickShape = new PickCylinderSegment(start, end, radius);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeCylinderRay(Point3d start, Vector3d dir2, double radius) {
        this.pickShape = new PickCylinderRay(start, dir2, radius);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeConeSegment(Point3d start, Point3d end, double angle) {
        this.pickShape = new PickConeSegment(start, end, angle);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeConeRay(Point3d start, Vector3d dir2, double angle) {
        this.pickShape = new PickConeRay(start, dir2, angle);
        this.start = start;
        this.userDefineShape = true;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickInfo[] pickAll() {
        PickInfo[] pickInfos = null;
        if (this.pickRootBG != null) {
            pickInfos = this.pickRootBG.pickAll(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfos = this.pickRootL.pickAll(this.mode, this.flags, this.pickShape);
        }
        return pickInfos;
    }

    public PickInfo pickAny() {
        PickInfo pickInfo = null;
        if (this.pickRootBG != null) {
            pickInfo = this.pickRootBG.pickAny(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfo = this.pickRootL.pickAny(this.mode, this.flags, this.pickShape);
        }
        return pickInfo;
    }

    public PickInfo[] pickAllSorted() {
        PickInfo[] pickInfos = null;
        if (this.pickRootBG != null) {
            pickInfos = this.pickRootBG.pickAllSorted(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfos = this.pickRootL.pickAllSorted(this.mode, this.flags, this.pickShape);
        }
        return pickInfos;
    }

    public PickInfo pickClosest() {
        PickInfo pickInfo = null;
        if (this.pickRootBG != null) {
            pickInfo = this.pickRootBG.pickClosest(this.mode, this.flags, this.pickShape);
        } else if (this.pickRootL != null) {
            pickInfo = this.pickRootL.pickClosest(this.mode, this.flags, this.pickShape);
        }
        return pickInfo;
    }

    public Node getNode(PickInfo pickInfo, int type) {
        if (pickInfo == null) {
            return null;
        }
        SceneGraphPath sgp = pickInfo.getSceneGraphPath();
        Node pickedNode = pickInfo.getNode();
        if (pickedNode instanceof Shape3D && (type & 1) != 0) {
            return pickedNode;
        }
        if (pickedNode instanceof Morph && (type & 2) != 0) {
            return pickedNode;
        }
        int j2 = sgp.nodeCount() - 1;
        while (j2 >= 0) {
            Node pNode = sgp.getNode(j2);
            if (pNode instanceof Primitive && (type & 4) != 0) {
                return pNode;
            }
            if (pNode instanceof Link && (type & 8) != 0) {
                return pNode;
            }
            if (pNode instanceof Switch && (type & 0x80) != 0) {
                return pNode;
            }
            if (pNode instanceof TransformGroup && (type & 0x20) != 0) {
                return pNode;
            }
            if (pNode instanceof BranchGroup && (type & 0x40) != 0) {
                return pNode;
            }
            if (pNode instanceof Group && (type & 0x10) != 0) {
                return pNode;
            }
            --j2;
        }
        return null;
    }
}

