/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.pickfast;

import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class PickIntersection {
    private double[] interpWeights;
    private static final boolean debug = false;
    private static final int X_AXIS = 1;
    private static final int Y_AXIS = 2;
    private static final int Z_AXIS = 3;
    static final double TOL = 1.0E-5;
    private PickInfo.IntersectionInfo iInfo = null;
    private Transform3D l2vw = null;
    private Geometry geometry = null;
    private boolean geometryIsIndexed = false;
    private double distance;
    private boolean hasColors;
    private boolean hasNormals;
    private boolean hasTexCoords;
    private int[] primitiveCoordinateIndices;
    private int[] primitiveNormalIndices;
    private int[] primitiveColorIndices;
    private int[] primitiveTexCoordIndices;
    private int[] primitiveVertexIndices = null;
    private Point3d[] primitiveCoordinates = null;
    private Point3d[] primitiveCoordinatesVW = null;
    private Vector3f[] primitiveNormals = null;
    private Color4f[] primitiveColors = null;
    private TexCoord3f[] primitiveTexCoords = null;
    private Point3d pointCoordinatesVW = null;
    private Point3d pointCoordinates = null;
    private Vector3f pointNormal = null;
    private Color4f pointColor = null;
    private TexCoord3f pointTexCoord = null;
    private int closestVertexIndex = -1;
    private Point3d closestVertexCoordinates = null;
    private Point3d closestVertexCoordinatesVW = null;

    public PickIntersection(Transform3D localToVWorld, PickInfo.IntersectionInfo intersectionInfo) {
        this.l2vw = localToVWorld;
        this.iInfo = intersectionInfo;
        this.geometry = this.iInfo.getGeometry();
        this.pointCoordinates = this.iInfo.getIntersectionPoint();
        this.distance = this.iInfo.getDistance();
        this.primitiveVertexIndices = this.iInfo.getVertexIndices();
        if (this.geometry instanceof GeometryArray) {
            int vertexFormat = ((GeometryArray)this.geometry).getVertexFormat();
            this.hasColors = (vertexFormat & 0xC) != 0;
            this.hasNormals = (vertexFormat & 2) != 0;
            boolean bl = this.hasTexCoords = (vertexFormat & 0x60) != 0;
            if (this.geometry instanceof IndexedGeometryArray) {
                this.geometryIsIndexed = true;
            }
        }
    }

    public boolean geometryIsIndexed() {
        return this.geometryIsIndexed;
    }

    public Point3d getClosestVertexCoordinates() {
        GeometryArray geom = (GeometryArray)this.geometry;
        if (this.closestVertexCoordinates == null) {
            int vertexIndex = this.getClosestVertexIndex();
            int vformat = geom.getVertexFormat();
            int[] indices = this.getPrimitiveCoordinateIndices();
            if ((vformat & 0x80) == 0) {
                this.closestVertexCoordinates = new Point3d();
                geom.getCoordinate(indices[vertexIndex], this.closestVertexCoordinates);
            } else if ((vformat & 0x100) == 0) {
                double[] doubleData = geom.getCoordRefDouble();
                if (doubleData == null) {
                    float[] floatData = geom.getCoordRefFloat();
                    if (floatData == null) {
                        throw new UnsupportedOperationException("Deprecated : BY_REF - p3f and p3d");
                    }
                    int val = indices[vertexIndex] * 3;
                    this.closestVertexCoordinates = new Point3d(floatData[val], floatData[val + 1], floatData[val + 2]);
                } else {
                    int val = indices[vertexIndex] * 3;
                    this.closestVertexCoordinates = new Point3d(doubleData[val], doubleData[val + 1], doubleData[val + 2]);
                }
            } else {
                float[] floatData = geom.getInterleavedVertices();
                int offset = this.getInterleavedVertexOffset(geom);
                int stride = offset + 3;
                int val = stride * indices[vertexIndex] + offset;
                this.closestVertexCoordinates = new Point3d(floatData[val], floatData[val + 1], floatData[val + 2]);
            }
        }
        return this.closestVertexCoordinates;
    }

    public Point3d getClosestVertexCoordinatesVW() {
        if (this.closestVertexCoordinatesVW == null) {
            int vertexIndex = this.getClosestVertexIndex();
            Point3d[] coordinatesVW = this.getPrimitiveCoordinatesVW();
            this.closestVertexCoordinatesVW = coordinatesVW[vertexIndex];
        }
        return this.closestVertexCoordinatesVW;
    }

    public int getClosestVertexIndex() {
        if (this.closestVertexIndex == -1) {
            double maxDist = Double.MAX_VALUE;
            double curDist = Double.MAX_VALUE;
            int closestIndex = -1;
            this.primitiveCoordinates = this.getPrimitiveCoordinates();
            assert (this.primitiveCoordinates != null);
            int i2 = 0;
            while (i2 < this.primitiveCoordinates.length) {
                curDist = this.pointCoordinates.distance(this.primitiveCoordinates[i2]);
                if (curDist < maxDist) {
                    closestIndex = i2;
                    maxDist = curDist;
                }
                ++i2;
            }
            this.closestVertexIndex = closestIndex;
        }
        return this.closestVertexIndex;
    }

    public double getDistance() {
        return this.distance;
    }

    public Color4f getPointColor() {
        if (this.hasColors && this.pointColor == null) {
            double[] weights = this.getInterpWeights();
            Color4f[] colors = this.getPrimitiveColors();
            this.pointColor = new Color4f();
            int i2 = 0;
            while (i2 < weights.length) {
                this.pointColor.x += (float)weights[i2] * colors[i2].x;
                this.pointColor.y += (float)weights[i2] * colors[i2].y;
                this.pointColor.z += (float)weights[i2] * colors[i2].z;
                this.pointColor.w += (float)weights[i2] * colors[i2].w;
                ++i2;
            }
        }
        return this.pointColor;
    }

    public Point3d getPointCoordinates() {
        return this.pointCoordinates;
    }

    public Point3d getPointCoordinatesVW() {
        if (this.pointCoordinatesVW != null) {
            return this.pointCoordinatesVW;
        }
        this.pointCoordinatesVW = new Point3d();
        this.pointCoordinatesVW.x = this.pointCoordinates.x;
        this.pointCoordinatesVW.y = this.pointCoordinates.y;
        this.pointCoordinatesVW.z = this.pointCoordinates.z;
        this.l2vw.transform(this.pointCoordinatesVW);
        return this.pointCoordinatesVW;
    }

    public Vector3f getPointNormal() {
        if (this.hasNormals && this.pointNormal == null) {
            double[] weights = this.getInterpWeights();
            Vector3f[] normals = this.getPrimitiveNormals();
            this.pointNormal = new Vector3f();
            int i2 = 0;
            while (i2 < weights.length) {
                this.pointNormal.x += (float)weights[i2] * normals[i2].x;
                this.pointNormal.y += (float)weights[i2] * normals[i2].y;
                this.pointNormal.z += (float)weights[i2] * normals[i2].z;
                ++i2;
            }
        }
        return this.pointNormal;
    }

    public TexCoord3f getPointTextureCoordinate(int index) {
        if (this.hasTexCoords && this.pointTexCoord == null) {
            double[] weights = this.getInterpWeights();
            TexCoord3f[] texCoords = this.getPrimitiveTexCoords(index);
            this.pointTexCoord = new TexCoord3f();
            int i2 = 0;
            while (i2 < weights.length) {
                this.pointTexCoord.x += (float)weights[i2] * texCoords[i2].x;
                this.pointTexCoord.y += (float)weights[i2] * texCoords[i2].y;
                this.pointTexCoord.z += (float)weights[i2] * texCoords[i2].z;
                ++i2;
            }
        }
        return this.pointTexCoord;
    }

    public int[] getPrimitiveColorIndices() {
        if (this.hasColors && this.primitiveColorIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveColorIndices = new int[this.primitiveVertexIndices.length];
                int i2 = 0;
                while (i2 < this.primitiveVertexIndices.length) {
                    this.primitiveColorIndices[i2] = ((IndexedGeometryArray)this.geometry).getColorIndex(this.primitiveVertexIndices[i2]);
                    ++i2;
                }
            } else {
                this.primitiveColorIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveColorIndices;
    }

    public Color4f[] getPrimitiveColors() {
        block20: {
            GeometryArray geom = (GeometryArray)this.geometry;
            if (!this.hasColors || this.primitiveColors != null) break block20;
            this.primitiveColors = new Color4f[this.primitiveVertexIndices.length];
            int[] indices = this.getPrimitiveColorIndices();
            int vformat = geom.getVertexFormat();
            if ((vformat & 0x80) == 0) {
                if ((vformat & 0xC) == 12) {
                    int i2 = 0;
                    while (i2 < indices.length) {
                        this.primitiveColors[i2] = new Color4f();
                        geom.getColor(indices[i2], this.primitiveColors[i2]);
                        ++i2;
                    }
                } else {
                    Color3f color = new Color3f();
                    int i3 = 0;
                    while (i3 < indices.length) {
                        this.primitiveColors[i3] = new Color4f();
                        geom.getColor(indices[i3], color);
                        this.primitiveColors[i3].x = color.x;
                        this.primitiveColors[i3].y = color.y;
                        this.primitiveColors[i3].z = color.z;
                        this.primitiveColors[i3].w = 1.0f;
                        ++i3;
                    }
                }
            } else if ((vformat & 0x100) == 0) {
                float[] floatData = geom.getColorRefFloat();
                if (floatData == null) {
                    byte[] byteData = geom.getColorRefByte();
                    if (byteData == null) {
                        throw new UnsupportedOperationException("Deprecated : BY_REF - c3b and c3f");
                    }
                    if ((vformat & 0xC) == 12) {
                        int i4 = 0;
                        while (i4 < indices.length) {
                            int val = indices[i4] << 2;
                            this.primitiveColors[i4] = new Color4f(byteData[val], byteData[val + 1], byteData[val + 2], byteData[val + 3]);
                            ++i4;
                        }
                    } else {
                        int i5 = 0;
                        while (i5 < indices.length) {
                            int val = indices[i5] * 3;
                            this.primitiveColors[i5] = new Color4f(byteData[val], byteData[val + 1], byteData[val + 2], 1.0f);
                            ++i5;
                        }
                    }
                } else if ((vformat & 0xC) == 12) {
                    int i6 = 0;
                    while (i6 < indices.length) {
                        int val = indices[i6] << 2;
                        this.primitiveColors[i6] = new Color4f(floatData[val], floatData[val + 1], floatData[val + 2], floatData[val + 3]);
                        ++i6;
                    }
                } else {
                    int i7 = 0;
                    while (i7 < indices.length) {
                        int val = indices[i7] * 3;
                        this.primitiveColors[i7] = new Color4f(floatData[val], floatData[val + 1], floatData[val + 2], 1.0f);
                        ++i7;
                    }
                }
            } else {
                float[] floatData = geom.getInterleavedVertices();
                int offset = this.getInterleavedColorOffset(geom);
                int stride = this.getInterleavedStride(geom);
                int i8 = 0;
                while (i8 < indices.length) {
                    int val = stride * indices[i8] + offset;
                    this.primitiveColors[i8] = (vformat & 0xC) == 12 ? new Color4f(floatData[val], floatData[val + 1], floatData[val + 2], floatData[val + 3]) : new Color4f(floatData[val], floatData[val + 1], floatData[val + 2], 1.0f);
                    ++i8;
                }
            }
        }
        return this.primitiveColors;
    }

    public int[] getPrimitiveCoordinateIndices() {
        if (this.primitiveCoordinateIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveCoordinateIndices = new int[this.primitiveVertexIndices.length];
                int i2 = 0;
                while (i2 < this.primitiveVertexIndices.length) {
                    this.primitiveCoordinateIndices[i2] = ((IndexedGeometryArray)this.geometry).getCoordinateIndex(this.primitiveVertexIndices[i2]);
                    ++i2;
                }
            } else {
                this.primitiveCoordinateIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveCoordinateIndices;
    }

    public Point3d[] getPrimitiveCoordinates() {
        block11: {
            GeometryArray geom = (GeometryArray)this.geometry;
            if (this.primitiveCoordinates != null) break block11;
            this.primitiveCoordinates = new Point3d[this.primitiveVertexIndices.length];
            int[] indices = this.getPrimitiveCoordinateIndices();
            int vformat = geom.getVertexFormat();
            if ((vformat & 0x80) == 0) {
                int i2 = 0;
                while (i2 < indices.length) {
                    this.primitiveCoordinates[i2] = new Point3d();
                    geom.getCoordinate(indices[i2], this.primitiveCoordinates[i2]);
                    ++i2;
                }
            } else if ((vformat & 0x100) == 0) {
                double[] doubleData = geom.getCoordRefDouble();
                if (doubleData == null) {
                    float[] floatData = geom.getCoordRefFloat();
                    if (floatData == null) {
                        throw new UnsupportedOperationException("Deprecated : BY_REF - c3f and c3d");
                    }
                    int i3 = 0;
                    while (i3 < indices.length) {
                        int val = indices[i3] * 3;
                        this.primitiveCoordinates[i3] = new Point3d(floatData[val], floatData[val + 1], floatData[val + 2]);
                        ++i3;
                    }
                } else {
                    int i4 = 0;
                    while (i4 < indices.length) {
                        int val = indices[i4] * 3;
                        this.primitiveCoordinates[i4] = new Point3d(doubleData[val], doubleData[val + 1], doubleData[val + 2]);
                        ++i4;
                    }
                }
            } else {
                float[] floatData = geom.getInterleavedVertices();
                int offset = this.getInterleavedVertexOffset(geom);
                int stride = offset + 3;
                int i5 = 0;
                while (i5 < indices.length) {
                    int val = stride * indices[i5] + offset;
                    this.primitiveCoordinates[i5] = new Point3d(floatData[val], floatData[val + 1], floatData[val + 2]);
                    ++i5;
                }
            }
        }
        return this.primitiveCoordinates;
    }

    public Point3d[] getPrimitiveCoordinatesVW() {
        if (this.primitiveCoordinatesVW == null) {
            Point3d[] coords = this.getPrimitiveCoordinates();
            this.primitiveCoordinatesVW = new Point3d[coords.length];
            int i2 = 0;
            while (i2 < coords.length) {
                this.primitiveCoordinatesVW[i2] = new Point3d();
                this.primitiveCoordinatesVW[i2].x = coords[i2].x;
                this.primitiveCoordinatesVW[i2].y = coords[i2].y;
                this.primitiveCoordinatesVW[i2].z = coords[i2].z;
                this.l2vw.transform(this.primitiveCoordinatesVW[i2]);
                ++i2;
            }
        }
        return this.primitiveCoordinatesVW;
    }

    public int[] getPrimitiveNormalIndices() {
        if (this.hasNormals && this.primitiveNormalIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveNormalIndices = new int[this.primitiveVertexIndices.length];
                int i2 = 0;
                while (i2 < this.primitiveVertexIndices.length) {
                    this.primitiveNormalIndices[i2] = ((IndexedGeometryArray)this.geometry).getNormalIndex(this.primitiveVertexIndices[i2]);
                    ++i2;
                }
            } else {
                this.primitiveNormalIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveNormalIndices;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector3f[] getPrimitiveNormals() {
        GeometryArray geom = (GeometryArray)this.geometry;
        if (!this.hasNormals || this.primitiveNormals != null) return this.primitiveNormals;
        this.primitiveNormals = new Vector3f[this.primitiveVertexIndices.length];
        int[] indices = this.getPrimitiveNormalIndices();
        int vformat = geom.getVertexFormat();
        if ((vformat & 0x80) == 0) {
            int i2 = 0;
            while (i2 < indices.length) {
                this.primitiveNormals[i2] = new Vector3f();
                geom.getNormal(indices[i2], this.primitiveNormals[i2]);
                ++i2;
            }
            return this.primitiveNormals;
        } else if ((vformat & 0x100) == 0) {
            float[] floatNormals = geom.getNormalRefFloat();
            if (floatNormals == null) throw new UnsupportedOperationException("Deprecated : BY_REF - n3f");
            int i3 = 0;
            while (i3 < indices.length) {
                int val = indices[i3] * 3;
                this.primitiveNormals[i3] = new Vector3f(floatNormals[val], floatNormals[val + 1], floatNormals[val + 2]);
                ++i3;
            }
            return this.primitiveNormals;
        } else {
            float[] floatData = geom.getInterleavedVertices();
            int offset = this.getInterleavedColorOffset(geom);
            int stride = this.getInterleavedStride(geom);
            int i4 = 0;
            while (i4 < indices.length) {
                int val = stride * indices[i4] + offset;
                this.primitiveNormals[i4] = new Vector3f(floatData[val], floatData[val + 1], floatData[val + 2]);
                ++i4;
            }
        }
        return this.primitiveNormals;
    }

    public int[] getPrimitiveTexCoordIndices(int index) {
        if (this.hasTexCoords && this.primitiveTexCoordIndices == null) {
            if (this.geometryIsIndexed()) {
                this.primitiveTexCoordIndices = new int[this.primitiveVertexIndices.length];
                int i2 = 0;
                while (i2 < this.primitiveVertexIndices.length) {
                    this.primitiveTexCoordIndices[i2] = ((IndexedGeometryArray)this.geometry).getTextureCoordinateIndex(index, this.primitiveVertexIndices[i2]);
                    ++i2;
                }
            } else {
                this.primitiveTexCoordIndices = this.primitiveVertexIndices;
            }
        }
        return this.primitiveTexCoordIndices;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TexCoord3f[] getPrimitiveTexCoords(int index) {
        GeometryArray geom = (GeometryArray)this.geometry;
        if (this.primitiveTexCoords != null) return this.primitiveTexCoords;
        this.primitiveTexCoords = new TexCoord3f[this.primitiveVertexIndices.length];
        int[] indices = this.getPrimitiveTexCoordIndices(index);
        int vformat = geom.getVertexFormat();
        if ((vformat & 0x80) == 0) {
            int i2 = 0;
            while (i2 < indices.length) {
                this.primitiveTexCoords[i2] = new TexCoord3f();
                geom.getTextureCoordinate(index, indices[i2], this.primitiveTexCoords[i2]);
                ++i2;
            }
            return this.primitiveTexCoords;
        } else if ((vformat & 0x100) == 0) {
            float[] floatTexCoords = geom.getTexCoordRefFloat(index);
            if (floatTexCoords == null) throw new UnsupportedOperationException("Deprecated : BY_REF - t2f and t3f");
            if ((vformat & 0x20) == 32) {
                int i3 = 0;
                while (i3 < indices.length) {
                    int val = indices[i3] << 1;
                    this.primitiveTexCoords[i3] = new TexCoord3f(floatTexCoords[val], floatTexCoords[val + 1], 0.0f);
                    ++i3;
                }
                return this.primitiveTexCoords;
            } else {
                int i4 = 0;
                while (i4 < indices.length) {
                    int val = indices[i4] * 3;
                    this.primitiveTexCoords[i4] = new TexCoord3f(floatTexCoords[val], floatTexCoords[val + 1], floatTexCoords[val + 2]);
                    ++i4;
                }
            }
            return this.primitiveTexCoords;
        } else {
            float[] floatData = geom.getInterleavedVertices();
            int stride = this.getInterleavedStride(geom);
            int offset = (vformat & 0x20) == 32 ? index << 1 : index * 3;
            int i5 = 0;
            while (i5 < indices.length) {
                int val = stride * indices[i5];
                this.primitiveTexCoords[i5] = (vformat & 0x20) == 32 ? new TexCoord3f(floatData[val + offset], floatData[val + 1 + offset], 0.0f) : new TexCoord3f(floatData[val + offset], floatData[val + 1 + offset], floatData[val + 2 + offset]);
                ++i5;
            }
        }
        return this.primitiveTexCoords;
    }

    public int[] getPrimitiveVertexIndices() {
        return this.primitiveVertexIndices;
    }

    public PickInfo.IntersectionInfo getIntersectionInfo() {
        return this.iInfo;
    }

    public String toString() {
        int i2;
        String rt = new String("PickIntersection: ");
        rt = String.valueOf(rt) + " IntersectionInfo = " + this.iInfo + "\n";
        rt = String.valueOf(rt) + " geometry = " + this.geometry + "\n";
        if (this.distance != -1.0) {
            rt = String.valueOf(rt) + " dist:" + this.distance + "\n";
        }
        if (this.pointCoordinates != null) {
            rt = String.valueOf(rt) + " pt:" + this.pointCoordinates + "\n";
        }
        if (this.pointCoordinatesVW != null) {
            rt = String.valueOf(rt) + " ptVW:" + this.pointCoordinatesVW + "\n";
        }
        if (this.primitiveCoordinateIndices != null) {
            rt = String.valueOf(rt) + " prim coordinate ind:\n";
            i2 = 0;
            while (i2 < this.primitiveCoordinateIndices.length) {
                rt = String.valueOf(rt) + " " + this.primitiveCoordinateIndices[i2] + "\n";
                ++i2;
            }
        }
        if (this.primitiveColorIndices != null) {
            rt = String.valueOf(rt) + " prim color ind:\n";
            i2 = 0;
            while (i2 < this.primitiveColorIndices.length) {
                rt = String.valueOf(rt) + " " + this.primitiveColorIndices[i2] + "\n";
                ++i2;
            }
        }
        if (this.primitiveNormalIndices != null) {
            rt = String.valueOf(rt) + " prim normal ind:\n";
            i2 = 0;
            while (i2 < this.primitiveNormalIndices.length) {
                rt = String.valueOf(rt) + " " + this.primitiveNormalIndices[i2] + "\n";
                ++i2;
            }
        }
        if (this.primitiveTexCoordIndices != null) {
            rt = String.valueOf(rt) + " prim texture ind:\n";
            i2 = 0;
            while (i2 < this.primitiveTexCoordIndices.length) {
                rt = String.valueOf(rt) + " " + this.primitiveTexCoordIndices[i2] + "\n";
                ++i2;
            }
        }
        if (this.closestVertexCoordinates != null) {
            rt = String.valueOf(rt) + " clos. vert:" + this.closestVertexCoordinates + "\n";
        }
        if (this.closestVertexCoordinatesVW != null) {
            rt = String.valueOf(rt) + " clos. vert:" + this.closestVertexCoordinatesVW + "\n";
        }
        if (this.closestVertexIndex != -1) {
            rt = String.valueOf(rt) + " clos. vert. ind.:" + this.closestVertexIndex + "\n";
        }
        return rt;
    }

    int getInterleavedVertexOffset(GeometryArray geo) {
        int offset = 0;
        int vformat = geo.getVertexFormat();
        if ((vformat & 4) == 4) {
            offset += 3;
        } else if ((vformat & 0xC) == 12) {
            offset += 4;
        }
        if ((vformat & 2) != 0) {
            offset += 3;
        }
        if ((vformat & 0x20) == 32) {
            offset += 2 * geo.getTexCoordSetCount();
        } else if ((vformat & 0x40) == 64) {
            offset += 3 * geo.getTexCoordSetCount();
        }
        return offset;
    }

    int getInterleavedStride(GeometryArray geo) {
        int offset = 3;
        int vformat = geo.getVertexFormat();
        if ((vformat & 4) == 4) {
            offset += 3;
        } else if ((vformat & 0xC) == 12) {
            offset += 4;
        }
        if ((vformat & 2) != 0) {
            offset += 3;
        }
        if ((vformat & 0x20) == 32) {
            offset += 2 * geo.getTexCoordSetCount();
        } else if ((vformat & 0x40) == 64) {
            offset += 3 * geo.getTexCoordSetCount();
        }
        return offset;
    }

    int getInterleavedColorOffset(GeometryArray geo) {
        int offset = 0;
        int vformat = geo.getVertexFormat();
        if ((vformat & 0x20) == 32) {
            offset += 2 * geo.getTexCoordSetCount();
        } else if ((vformat & 0x40) == 64) {
            offset += 3 * geo.getTexCoordSetCount();
        }
        return offset;
    }

    double abs(double value) {
        if (value < 0.0) {
            return -value;
        }
        return value;
    }

    int maxAxis(Vector3d delta) {
        int axis = 1;
        double max = this.abs(delta.x);
        if (this.abs(delta.y) > max) {
            axis = 2;
            max = this.abs(delta.y);
        }
        if (this.abs(delta.z) > max) {
            axis = 3;
        }
        return axis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean interpTriangle(int index0, int index1, int index2, Point3d[] coords, Point3d intPt) {
        double leftFactor;
        double rightFactor;
        int left;
        int right;
        int base;
        int mainAxis;
        double[] factor;
        Vector3d delta0 = new Vector3d();
        Vector3d delta1 = new Vector3d();
        Vector3d delta2 = new Vector3d();
        delta0.sub(coords[index1], coords[index0]);
        delta1.sub(coords[index2], coords[index0]);
        delta2.sub(coords[index2], coords[index1]);
        double len0 = delta0.lengthSquared();
        double len1 = delta1.lengthSquared();
        double len2 = delta2.lengthSquared();
        Vector3d longest = delta0;
        double maxLen = len0;
        if (len1 > maxLen) {
            longest = delta1;
            maxLen = len1;
        }
        if (len2 > maxLen) {
            longest = delta2;
        }
        if ((factor = new double[]{PickIntersection.getInterpFactorForBase(intPt, coords[index1], coords[index2], mainAxis = this.maxAxis(longest)), PickIntersection.getInterpFactorForBase(intPt, coords[index2], coords[index0], mainAxis), PickIntersection.getInterpFactorForBase(intPt, coords[index0], coords[index1], mainAxis)})[0] < 0.0 || factor[0] > 1.0) {
            base = index0;
            right = index1;
            left = index2;
            rightFactor = factor[2];
            leftFactor = 1.0 - factor[1];
        } else if (factor[1] < 0.0 || factor[1] > 1.0) {
            base = index1;
            right = index2;
            left = index0;
            rightFactor = factor[0];
            leftFactor = 1.0 - factor[2];
        } else {
            base = index2;
            right = index0;
            left = index1;
            rightFactor = factor[1];
            leftFactor = 1.0 - factor[0];
        }
        Point3d iLeft = new Point3d(leftFactor * coords[left].x + (1.0 - leftFactor) * coords[base].x, leftFactor * coords[left].y + (1.0 - leftFactor) * coords[base].y, leftFactor * coords[left].z + (1.0 - leftFactor) * coords[base].z);
        Point3d iRight = new Point3d(rightFactor * coords[right].x + (1.0 - rightFactor) * coords[base].x, rightFactor * coords[right].y + (1.0 - rightFactor) * coords[base].y, rightFactor * coords[right].z + (1.0 - rightFactor) * coords[base].z);
        delta0.sub(iLeft, iRight);
        int midAxis = this.maxAxis(delta0);
        double midFactor = PickIntersection.getInterpFactor(intPt, iRight, iLeft, midAxis);
        if (midFactor < 0.0) {
            if (!(midFactor + 1.0E-5 >= 0.0)) return false;
            midFactor = 0.0;
        } else if (midFactor > 1.0) {
            if (!(midFactor - 1.0E-5 <= 1.0)) return false;
            midFactor = 1.0;
        }
        this.interpWeights[base] = 1.0 - midFactor * leftFactor - rightFactor + midFactor * rightFactor;
        this.interpWeights[left] = midFactor * leftFactor;
        this.interpWeights[right] = rightFactor - midFactor * rightFactor;
        return true;
    }

    double[] getInterpWeights() {
        Point3d pt = this.getPointCoordinates();
        Point3d[] coordinates = this.getPrimitiveCoordinates();
        if (this.interpWeights != null) {
            return this.interpWeights;
        }
        this.interpWeights = new double[coordinates.length];
        switch (coordinates.length) {
            case 1: {
                this.interpWeights[0] = 1.0;
                break;
            }
            case 2: {
                double factor;
                Vector3d delta = new Vector3d();
                delta.sub(coordinates[1], coordinates[0]);
                int axis = this.maxAxis(delta);
                this.interpWeights[0] = factor = (double)PickIntersection.getInterpFactor(pt, coordinates[1], coordinates[0], axis);
                this.interpWeights[1] = 1.0 - factor;
                break;
            }
            case 3: {
                if (this.interpTriangle(0, 1, 2, coordinates, pt)) break;
                throw new RuntimeException("Interp point outside triangle");
            }
            case 4: {
                if (this.interpTriangle(0, 1, 2, coordinates, pt) || this.interpTriangle(0, 2, 3, coordinates, pt)) break;
                throw new RuntimeException("Interp point outside quad");
            }
            default: {
                throw new RuntimeException("Unexpected number of points.");
            }
        }
        return this.interpWeights;
    }

    private static float getInterpFactor(Point3d p, Point3d p1, Point3d p2, int axis) {
        float t;
        switch (axis) {
            case 1: {
                if (p1.x == p2.x) {
                    t = 0.0f;
                    break;
                }
                t = (float)((p1.x - p.x) / (p1.x - p2.x));
                break;
            }
            case 2: {
                if (p1.y == p2.y) {
                    t = 0.0f;
                    break;
                }
                t = (float)((p1.y - p.y) / (p1.y - p2.y));
                break;
            }
            case 3: {
                if (p1.z == p2.z) {
                    t = 0.0f;
                    break;
                }
                t = (float)((p1.z - p.z) / (p1.z - p2.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + axis + " (must be 0-2)");
            }
        }
        return t;
    }

    private static float getInterpFactorForBase(Point3d p, Point3d p1, Point3d p2, int axis) {
        float t;
        switch (axis) {
            case 1: {
                if (p1.x == p2.x) {
                    t = Float.MAX_VALUE;
                    break;
                }
                t = (float)((p1.x - p.x) / (p1.x - p2.x));
                break;
            }
            case 2: {
                if (p1.y == p2.y) {
                    t = Float.MAX_VALUE;
                    break;
                }
                t = (float)((p1.y - p.y) / (p1.y - p2.y));
                break;
            }
            case 3: {
                if (p1.z == p2.z) {
                    t = Float.MAX_VALUE;
                    break;
                }
                t = (float)((p1.z - p.z) / (p1.z - p2.z));
                break;
            }
            default: {
                throw new RuntimeException("invalid axis parameter " + axis + " (must be 0-2)");
            }
        }
        return t;
    }
}

