/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

abstract class GeometryDecompressor {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    static final int majorVersionNumber = 1;
    static final int minorVersionNumber = 0;
    static final int minorMinorVersionNumber = 2;
    private static final int GC_VERTEX = 64;
    private static final int GC_SET_NORM = 192;
    private static final int GC_SET_COLOR = 128;
    private static final int GC_MESH_B_R = 32;
    private static final int GC_SET_STATE = 24;
    private static final int GC_SET_TABLE = 16;
    private static final int GC_PASS_THROUGH = 8;
    private static final int GC_EOS = 0;
    private static final int GC_V_NO_OP = 1;
    private static final int GC_SKIP_8 = 7;
    private HuffmanTableEntry[][] gctables;
    private MeshBufferEntry[] meshBuffer;
    private int meshIndex = 15;
    private int meshState;
    private static final int USE_MESH_NORMAL = 1;
    private static final int USE_MESH_COLOR = 2;
    private short curX;
    private short curY;
    private short curZ;
    private short curR;
    private short curG;
    private short curB;
    private short curA;
    private int curSex;
    private int curOct;
    private int curU;
    private int curV;
    private Point3f curPos = new Point3f();
    private Vector3f curNorm = new Vector3f();
    private Color4f curColor = new Color4f();
    private int repCode;
    private boolean bundlingNorm;
    private boolean bundlingColor;
    private boolean doingAlpha;
    private int currentHeader = 0;
    private int nextHeader = 0;
    private int bitBuffer = 0;
    private int bitBufferCount = 32;
    private long startTime;
    private int vertexCount;
    private static final int[] BMASK;
    private byte[] gcData;
    private int gcIndex;
    private static final double[][][] gcNormals;
    private static final double NORMAL_MAX_Y_ANG = 0.615479709;
    private static final boolean printNormalTable = false;

    static {
        int[] nArray = new int[33];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 7;
        nArray[4] = 15;
        nArray[5] = 31;
        nArray[6] = 63;
        nArray[7] = 127;
        nArray[8] = 255;
        nArray[9] = 511;
        nArray[10] = 1023;
        nArray[11] = 2047;
        nArray[12] = 4095;
        nArray[13] = 8191;
        nArray[14] = 16383;
        nArray[15] = Short.MAX_VALUE;
        nArray[16] = 65535;
        nArray[17] = 131071;
        nArray[18] = 262143;
        nArray[19] = 524287;
        nArray[20] = 1048575;
        nArray[21] = 0x1FFFFF;
        nArray[22] = 0x3FFFFF;
        nArray[23] = 0x7FFFFF;
        nArray[24] = 0xFFFFFF;
        nArray[25] = 0x1FFFFFF;
        nArray[26] = 0x3FFFFFF;
        nArray[27] = 0x7FFFFFF;
        nArray[28] = 0xFFFFFFF;
        nArray[29] = 0x1FFFFFFF;
        nArray[30] = 0x3FFFFFFF;
        nArray[31] = Integer.MAX_VALUE;
        nArray[32] = -1;
        BMASK = nArray;
        gcNormals = new double[65][65][3];
        int i2 = 0;
        while (i2 < 65) {
            int j2 = 0;
            while (j2 < 65) {
                if (i2 + j2 <= 64) {
                    double psi = 0.615479709 * ((double)i2 / 64.0);
                    double th = Math.asin(Math.tan(0.615479709 * ((double)(64 - j2) / 64.0)));
                    double qnx = Math.cos(th) * Math.cos(psi);
                    double qny = Math.sin(psi);
                    double qnz = Math.sin(th) * Math.cos(psi);
                    int inx = (int)(qnx *= 16384.0);
                    qnx = inx;
                    int iny = (int)(qny *= 16384.0);
                    qny = iny;
                    int inz = (int)(qnz *= 16384.0);
                    qnz = inz;
                    GeometryDecompressor.gcNormals[i2][j2][0] = qnx /= 16384.0;
                    GeometryDecompressor.gcNormals[i2][j2][1] = qny /= 16384.0;
                    GeometryDecompressor.gcNormals[i2][j2][2] = qnz /= 16384.0;
                }
                ++j2;
            }
            ++i2;
        }
    }

    abstract void outputVertexFormat(boolean var1, boolean var2, boolean var3);

    abstract void outputVertex(Point3f var1, Vector3f var2, Color4f var3, int var4);

    abstract void outputColor(Color4f var1);

    abstract void outputNormal(Vector3f var1);

    GeometryDecompressor() {
        this.gctables = new HuffmanTableEntry[3][64];
        int i2 = 0;
        while (i2 < 64) {
            this.gctables[0][i2] = new HuffmanTableEntry();
            this.gctables[1][i2] = new HuffmanTableEntry();
            this.gctables[2][i2] = new HuffmanTableEntry();
            ++i2;
        }
        this.meshBuffer = new MeshBufferEntry[16];
        i2 = 0;
        while (i2 < 16) {
            this.meshBuffer[i2] = new MeshBufferEntry();
            ++i2;
        }
    }

    boolean checkVersion(int majorVersionNumber, int minorVersionNumber) {
        return majorVersionNumber < 1 || majorVersionNumber == 1 && minorVersionNumber <= 0;
    }

    void decompress(int start, int length, byte[] data) {
        if (start + length > data.length) {
            throw new ArrayIndexOutOfBoundsException(J3dUtilsI18N.getString("GeometryDecompressor0"));
        }
        this.gcData = data;
        this.gcIndex = start;
        this.bitBufferCount = 0;
        this.meshState = 0;
        this.bundlingNorm = false;
        this.bundlingColor = false;
        this.doingAlpha = false;
        this.repCode = 0;
        this.nextHeader = 1;
        while (this.gcIndex < start + length) {
            this.processDecompression();
        }
        while (this.bitBufferCount > 0) {
            this.processDecompression();
        }
    }

    private int getBits(int bitCount, String d2) {
        int bits;
        if (bitCount == 0) {
            return 0;
        }
        if (this.bitBufferCount == 0) {
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            this.bitBufferCount = 32;
        }
        if (this.bitBufferCount >= bitCount) {
            bits = this.bitBuffer >>> 32 - bitCount & BMASK[bitCount];
            this.bitBuffer <<= bitCount;
            this.bitBufferCount -= bitCount;
        } else {
            bits = this.bitBuffer >>> 32 - bitCount & BMASK[bitCount];
            bits >>>= bitCount - this.bitBufferCount;
            bits <<= bitCount - this.bitBufferCount;
            this.bitBuffer = (this.gcData[this.gcIndex++] & 0xFF) << 24 | (this.gcData[this.gcIndex++] & 0xFF) << 16 | (this.gcData[this.gcIndex++] & 0xFF) << 8 | this.gcData[this.gcIndex++] & 0xFF;
            bits |= this.bitBuffer >>> 32 - (bitCount - this.bitBufferCount) & BMASK[bitCount - this.bitBufferCount];
            this.bitBuffer <<= bitCount - this.bitBufferCount;
            this.bitBufferCount = 32 - (bitCount - this.bitBufferCount);
        }
        return bits;
    }

    private void processDecompression() {
        this.currentHeader = this.nextHeader;
        if ((this.currentHeader & 0xC0) == 64) {
            if (!this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(8, "header");
                int mbp = this.processDecompressionOpcode(0);
            } else if (this.bundlingNorm && !this.bundlingColor) {
                this.nextHeader = this.getBits(6, "normal");
                int mbp = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(mbp);
            } else if (!this.bundlingNorm && this.bundlingColor) {
                this.nextHeader = this.getBits(6, "color");
                int mbp = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(mbp);
            } else {
                this.nextHeader = this.getBits(6, "normal");
                int mbp = this.processDecompressionOpcode(0);
                this.currentHeader = this.nextHeader | 0xC0;
                this.nextHeader = this.getBits(6, "color");
                this.processDecompressionOpcode(mbp);
                this.currentHeader = this.nextHeader | 0x80;
                this.nextHeader = this.getBits(8, "header");
                this.processDecompressionOpcode(mbp);
            }
            this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
            this.meshState |= 1;
            this.meshState |= 2;
        } else {
            this.nextHeader = this.getBits(8, "header");
            this.processDecompressionOpcode(0);
        }
    }

    private int processDecompressionOpcode(int mbp) {
        if ((this.currentHeader & 0xC0) == 192) {
            this.processSetNormal(mbp);
        } else if ((this.currentHeader & 0xC0) == 128) {
            this.processSetColor(mbp);
        } else {
            if ((this.currentHeader & 0xC0) == 64) {
                return this.processVertex();
            }
            if ((this.currentHeader & 0xE0) == 32) {
                this.processMeshBR();
                this.outputVertex(this.curPos, this.curNorm, this.curColor, this.repCode);
                this.meshState |= 1;
                this.meshState |= 2;
            } else if ((this.currentHeader & 0xF8) == 24) {
                this.processSetState();
            } else if ((this.currentHeader & 0xF8) == 16) {
                this.processSetTable();
            } else if ((this.currentHeader & 0xFF) == 0) {
                this.processEos();
            } else if ((this.currentHeader & 0xFF) == 1) {
                this.processVNoop();
            } else if ((this.currentHeader & 0xFF) == 8) {
                this.processPassThrough();
            } else if ((this.currentHeader & 0xFF) == 7) {
                this.processSkip8();
            }
        }
        return 0;
    }

    private void processSetState() {
        int ii = this.getBits(3, "bundling");
        this.bundlingNorm = (this.currentHeader & 1) != 0;
        this.bundlingColor = (ii >>> 2 & 1) != 0;
        this.doingAlpha = (ii >>> 1 & 1) != 0;
        this.outputVertexFormat(this.bundlingNorm, this.bundlingColor, this.doingAlpha);
    }

    private void processSetTable() {
        int index = (this.currentHeader & 6) >>> 1;
        HuffmanTableEntry[] gct = this.gctables[index];
        int ii = this.getBits(15, "set table");
        int adr = (this.currentHeader & 1) << 6 | ii >>> 9 & 0x3F;
        int dataLength = ii >>> 5 & 0xF;
        if (dataLength == 0 && index != 2) {
            dataLength = 16;
        }
        int rightShift = ii & 0xF;
        int absolute = ii >>> 4 & 1;
        int tagLength = 6;
        while (tagLength > 0) {
            if (adr >> tagLength != 0) break;
            --tagLength;
        }
        adr = adr << 6 - tagLength & 0x3F;
        int i2 = 0;
        while (i2 < 1 << 6 - tagLength) {
            gct[adr + i2].tagLength = tagLength;
            gct[adr + i2].dataLength = dataLength;
            gct[adr + i2].rightShift = rightShift;
            gct[adr + i2].absolute = absolute;
            ++i2;
        }
    }

    private int processVertex() {
        int z;
        int y;
        int ii;
        this.meshState = 0;
        HuffmanTableEntry gct = this.gctables[0][this.currentHeader & 0x3F];
        int dataLen = gct.dataLength - gct.rightShift;
        if (6 - 3 * dataLen - gct.tagLength > 0) {
            int numBits = 6 - 3 * dataLen - gct.tagLength;
            int jj = this.currentHeader & BMASK[numBits];
            ii = this.getBits(3 - numBits, "repcode/mbp");
            ii |= jj << 3 - numBits;
        } else {
            ii = this.getBits(3, "repcode/mbp");
        }
        this.repCode = ii >>> 1;
        int mbp = ii & 1;
        int x = this.currentHeader & BMASK[6 - gct.tagLength];
        if (gct.tagLength + dataLen == 6) {
            y = this.getBits(dataLen, "y");
            z = this.getBits(dataLen, "z");
        } else if (gct.tagLength + dataLen < 6) {
            x >>= 6 - gct.tagLength - dataLen;
            y = this.currentHeader & BMASK[6 - gct.tagLength - dataLen];
            if (gct.tagLength + 2 * dataLen == 6) {
                z = this.getBits(dataLen, "z");
            } else if (gct.tagLength + 2 * dataLen < 6) {
                y >>= 6 - gct.tagLength - 2 * dataLen;
                z = this.currentHeader & BMASK[6 - gct.tagLength - 2 * dataLen];
                if (gct.tagLength + 3 * dataLen < 6) {
                    z >>= 6 - gct.tagLength - 3 * dataLen;
                } else if (gct.tagLength + 3 * dataLen > 6) {
                    ii = this.getBits(dataLen - (6 - gct.tagLength - 2 * dataLen), "z");
                    z = z << dataLen - (6 - gct.tagLength - 2 * dataLen) | ii;
                }
            } else {
                ii = this.getBits(dataLen - (6 - gct.tagLength - dataLen), "y");
                y = y << dataLen - (6 - gct.tagLength - dataLen) | ii;
                z = this.getBits(dataLen, "z");
            }
        } else {
            ii = this.getBits(dataLen - (6 - gct.tagLength), "x");
            x = x << dataLen - (6 - gct.tagLength) | ii;
            y = this.getBits(dataLen, "y");
            z = this.getBits(dataLen, "z");
        }
        x <<= 32 - dataLen;
        y <<= 32 - dataLen;
        z <<= 32 - dataLen;
        short dx = (short)((x >>= 32 - dataLen) << gct.rightShift);
        short dy = (short)((y >>= 32 - dataLen) << gct.rightShift);
        short dz = (short)((z >>= 32 - dataLen) << gct.rightShift);
        if (gct.absolute != 0) {
            this.curX = dx;
            this.curY = dy;
            this.curZ = dz;
        } else {
            this.curX = (short)(this.curX + dx);
            this.curY = (short)(this.curY + dy);
            this.curZ = (short)(this.curZ + dz);
        }
        if (mbp != 0) {
            this.meshIndex = this.meshIndex + 1 & 0xF;
            this.meshBuffer[this.meshIndex].x = this.curX;
            this.meshBuffer[this.meshIndex].y = this.curY;
            this.meshBuffer[this.meshIndex].z = this.curZ;
        }
        float fX = this.curX;
        fX = (float)((double)fX / 32768.0);
        float fY = this.curY;
        fY = (float)((double)fY / 32768.0);
        float fZ = this.curZ;
        fZ = (float)((double)fZ / 32768.0);
        this.curPos.set(fX, fY, fZ);
        return mbp;
    }

    private void processSetNormal(int mbp) {
        this.meshState &= 0xFFFFFFFE;
        HuffmanTableEntry gct = this.gctables[2][this.currentHeader & 0x3F];
        int dataLength = gct.dataLength - gct.rightShift;
        if (gct.absolute != 0) {
            int index = this.currentHeader & BMASK[6 - gct.tagLength];
            if (gct.tagLength != 0) {
                int ii = this.getBits(6 - (6 - gct.tagLength), "sex/oct");
                index = index << 6 - (6 - gct.tagLength) | ii;
            }
            this.curU = this.getBits(dataLength, "u");
            this.curV = this.getBits(dataLength, "v");
            this.curU <<= gct.rightShift;
            this.curV <<= gct.rightShift;
            this.curSex = index >> 3 & 7;
            this.curOct = index & 7;
        } else {
            int dv;
            int du = this.currentHeader & BMASK[6 - gct.tagLength];
            if (gct.tagLength + dataLength < 6) {
                du >>= 6 - gct.tagLength - dataLength;
                dv = this.currentHeader & BMASK[6 - gct.tagLength - dataLength];
                if (gct.tagLength + 2 * dataLength < 6) {
                    dv >>= 6 - gct.tagLength - 2 * dataLength;
                } else if (gct.tagLength + 2 * dataLength > 6) {
                    int ii = this.getBits(dataLength - (6 - gct.tagLength - dataLength), "dv");
                    dv = dv << dataLength - (6 - gct.tagLength - dataLength) | ii;
                }
            } else if (gct.tagLength + dataLength > 6) {
                int ii = this.getBits(dataLength - (6 - gct.tagLength), "du");
                du = du << dataLength - (6 - gct.tagLength) | ii;
                dv = this.getBits(dataLength, "dv");
            } else {
                dv = this.getBits(dataLength, "dv");
            }
            du <<= 32 - dataLength;
            du >>= 32 - dataLength;
            dv <<= 32 - dataLength;
            dv >>= 32 - dataLength;
            this.curU += (du <<= gct.rightShift);
            this.curV += (dv <<= gct.rightShift);
            if (this.curU < 0 || this.curV < 0 || this.curU + this.curV > 64) {
                if (this.curU < 0 && this.curV >= 0) {
                    this.curU = -this.curU;
                    switch (this.curSex) {
                        case 0: {
                            this.curSex = 4;
                            break;
                        }
                        case 1: {
                            this.curSex = 5;
                            break;
                        }
                        case 2: {
                            this.curSex = 3;
                            break;
                        }
                        case 3: {
                            this.curSex = 2;
                            break;
                        }
                        case 4: {
                            this.curSex = 0;
                            break;
                        }
                        case 5: {
                            this.curSex = 1;
                        }
                    }
                } else if (this.curU >= 0 && this.curV < 0) {
                    this.curV = -this.curV;
                    switch (this.curSex) {
                        case 1: 
                        case 5: {
                            this.curOct ^= 4;
                            break;
                        }
                        case 0: 
                        case 4: {
                            this.curOct ^= 2;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.curOct ^= 1;
                        }
                    }
                } else if (this.curU + this.curV > 64) {
                    this.curU = 64 - this.curU;
                    this.curV = 64 - this.curV;
                    switch (this.curSex) {
                        case 0: {
                            this.curSex = 2;
                            break;
                        }
                        case 1: {
                            this.curSex = 3;
                            break;
                        }
                        case 2: {
                            this.curSex = 0;
                            break;
                        }
                        case 3: {
                            this.curSex = 1;
                            break;
                        }
                        case 4: {
                            this.curSex = 5;
                            break;
                        }
                        case 5: {
                            this.curSex = 4;
                        }
                    }
                } else {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryDecompressor1"));
                }
            }
        }
        if (mbp != 0) {
            this.meshBuffer[this.meshIndex].sextant = (short)this.curSex;
            this.meshBuffer[this.meshIndex].octant = (short)this.curOct;
            this.meshBuffer[this.meshIndex].u = (short)this.curU;
            this.meshBuffer[this.meshIndex].v = (short)this.curV;
        }
        this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        if (!this.bundlingNorm) {
            this.outputNormal(this.curNorm);
        }
    }

    private void indexNormal(int sex, int oct, int u, int v, Vector3f n2) {
        float ny;
        float nz;
        float nx;
        if (sex > 5) {
            switch (oct & 1) {
                case 0: {
                    switch ((sex & 1) << 1 | (oct & 4) >> 2) {
                        case 0: {
                            nx = 1.0f;
                            nz = 0.0f;
                            ny = 0.0f;
                            break;
                        }
                        case 1: {
                            ny = 1.0f;
                            nz = 0.0f;
                            nx = 0.0f;
                            break;
                        }
                        default: {
                            nz = 1.0f;
                            ny = 0.0f;
                            nx = 0.0f;
                        }
                    }
                    sex = 0;
                    oct = (oct & 2) >> 1;
                    oct = oct << 2 | oct << 1 | oct;
                    break;
                }
                default: {
                    oct = (sex & 1) << 2 | oct >> 1;
                    sex = 0;
                    ny = nz = (float)(1.0 / Math.sqrt(3.0));
                    nx = nz;
                }
            }
            if ((oct & 1) != 0) {
                nz = -nz;
            }
            if ((oct & 2) != 0) {
                ny = -ny;
            }
            if ((oct & 4) != 0) {
                nx = -nx;
            }
        } else {
            float t;
            nx = (float)gcNormals[v][u][0];
            ny = (float)gcNormals[v][u][1];
            nz = (float)gcNormals[v][u][2];
            if ((sex & 4) != 0) {
                t = nx;
                nx = nz;
                nz = t;
            }
            if ((sex & 2) != 0) {
                t = ny;
                ny = nz;
                nz = t;
            }
            if ((sex & 1) != 0) {
                t = nx;
                nx = ny;
                ny = t;
            }
            if ((oct & 1) != 0) {
                nz = -nz;
            }
            if ((oct & 2) != 0) {
                ny = -ny;
            }
            if ((oct & 4) != 0) {
                nx = -nx;
            }
        }
        n2.set(nx, ny, nz);
    }

    private void processSetColor(int mbp) {
        int b2;
        int g2;
        this.meshState &= 0xFFFFFFFD;
        HuffmanTableEntry gct = this.gctables[1][this.currentHeader & 0x3F];
        int dataLength = gct.dataLength - gct.rightShift;
        int r = this.currentHeader & BMASK[6 - gct.tagLength];
        int a2 = 0;
        if (gct.tagLength + dataLength == 6) {
            g2 = this.getBits(dataLength, "g");
            b2 = this.getBits(dataLength, "b");
            if (this.doingAlpha) {
                a2 = this.getBits(dataLength, "a");
            }
        } else if (gct.tagLength + dataLength < 6) {
            r >>= 6 - gct.tagLength - dataLength;
            g2 = this.currentHeader & BMASK[6 - gct.tagLength - dataLength];
            if (gct.tagLength + 2 * dataLength == 6) {
                b2 = this.getBits(dataLength, "b");
                if (this.doingAlpha) {
                    a2 = this.getBits(dataLength, "a");
                }
            } else if (gct.tagLength + 2 * dataLength < 6) {
                g2 >>= 6 - gct.tagLength - 2 * dataLength;
                b2 = this.currentHeader & BMASK[6 - gct.tagLength - 2 * dataLength];
                if (gct.tagLength + 3 * dataLength == 6) {
                    if (this.doingAlpha) {
                        a2 = this.getBits(dataLength, "a");
                    }
                } else if (gct.tagLength + 3 * dataLength < 6) {
                    b2 >>= 6 - gct.tagLength - 3 * dataLength;
                    if (this.doingAlpha) {
                        a2 = this.currentHeader & BMASK[6 - gct.tagLength - 4 * dataLength];
                        if (gct.tagLength + 4 * dataLength < 6) {
                            a2 >>= 6 - gct.tagLength - 3 * dataLength;
                        } else if (gct.tagLength + 4 * dataLength > 6) {
                            int ii = this.getBits(dataLength - (6 - gct.tagLength - 3 * dataLength), "a");
                            a2 = a2 << dataLength - (6 - gct.tagLength - 3 * dataLength) | ii;
                        }
                    }
                } else {
                    int ii = this.getBits(dataLength - (6 - gct.tagLength - 2 * dataLength), "b");
                    b2 = b2 << dataLength - (6 - gct.tagLength - 2 * dataLength) | ii;
                    if (this.doingAlpha) {
                        a2 = this.getBits(dataLength, "a");
                    }
                }
            } else {
                int ii = this.getBits(dataLength - (6 - gct.tagLength - dataLength), "g");
                g2 = g2 << dataLength - (6 - gct.tagLength - dataLength) | ii;
                b2 = this.getBits(dataLength, "b");
                if (this.doingAlpha) {
                    a2 = this.getBits(dataLength, "a");
                }
            }
        } else {
            int ii = this.getBits(dataLength - (6 - gct.tagLength), "r");
            r = r << dataLength - (6 - gct.tagLength) | ii;
            g2 = this.getBits(dataLength, "g");
            b2 = this.getBits(dataLength, "b");
            if (this.doingAlpha) {
                a2 = this.getBits(dataLength, "a");
            }
        }
        r <<= 32 - dataLength;
        g2 <<= 32 - dataLength;
        b2 <<= 32 - dataLength;
        a2 <<= 32 - dataLength;
        short dr = (short)((r >>= 32 - dataLength) << gct.rightShift);
        short dg = (short)((g2 >>= 32 - dataLength) << gct.rightShift);
        short db = (short)((b2 >>= 32 - dataLength) << gct.rightShift);
        short da = (short)((a2 >>= 32 - dataLength) << gct.rightShift);
        if (gct.absolute != 0) {
            this.curR = dr;
            this.curG = dg;
            this.curB = db;
            if (this.doingAlpha) {
                this.curA = da;
            }
        } else {
            this.curR = (short)(this.curR + dr);
            this.curG = (short)(this.curG + dg);
            this.curB = (short)(this.curB + db);
            if (this.doingAlpha) {
                this.curA = (short)(this.curA + da);
            }
        }
        if (mbp != 0) {
            this.meshBuffer[this.meshIndex].r = this.curR;
            this.meshBuffer[this.meshIndex].g = this.curG;
            this.meshBuffer[this.meshIndex].b = this.curB;
            this.meshBuffer[this.meshIndex].a = this.curA;
        }
        float fR = this.curR;
        fR = (float)((double)fR / 32768.0);
        float fG = this.curG;
        fG = (float)((double)fG / 32768.0);
        float fB = this.curB;
        fB = (float)((double)fB / 32768.0);
        float fA = this.curA;
        fA = (float)((double)fA / 32768.0);
        this.curColor.set(fR, fG, fB, fA);
        if (!this.bundlingColor) {
            this.outputColor(this.curColor);
        }
    }

    private void processMeshBR() {
        int ii = this.getBits(1, "mbr");
        int index = this.currentHeader >>> 1 & 0xF;
        this.repCode = (this.currentHeader & 1) << 1 | ii;
        index = this.meshIndex - index & 0xF;
        MeshBufferEntry entry = this.meshBuffer[index];
        this.curX = entry.x;
        this.curY = entry.y;
        this.curZ = entry.z;
        this.curPos.set((float)this.curX / 32768.0f, (float)this.curY / 32768.0f, (float)this.curZ / 32768.0f);
        if (this.bundlingNorm && (this.meshState & 1) != 0) {
            this.curSex = entry.sextant;
            this.curOct = entry.octant;
            this.curU = entry.u;
            this.curV = entry.v;
            int normal = this.curSex << 15 | this.curOct << 12 | this.curU << 6 | this.curV;
            this.indexNormal(this.curSex, this.curOct, this.curU, this.curV, this.curNorm);
        }
        if (this.bundlingColor && (this.meshState & 2) != 0) {
            this.curR = entry.r;
            this.curG = entry.g;
            this.curB = entry.b;
            this.curColor.x = this.curR;
            this.curColor.x = (float)((double)this.curColor.x / 32768.0);
            this.curColor.y = this.curG;
            this.curColor.y = (float)((double)this.curColor.y / 32768.0);
            this.curColor.z = this.curB;
            this.curColor.z = (float)((double)this.curColor.z / 32768.0);
            if (this.doingAlpha) {
                this.curA = entry.a;
                this.curColor.w = this.curA;
                this.curColor.w = (float)((double)this.curColor.w / 32768.0);
            }
        }
        this.meshState = 0;
    }

    private void processEos() {
    }

    private void processVNoop() {
        int ct = this.getBits(5, "noop count");
        int ii = this.getBits(ct, "noop bits");
    }

    private void processPassThrough() {
        int ignore = this.getBits(24, "passthrough");
        ignore = this.getBits(32, "passthrough");
    }

    private void processSkip8() {
        int skip = this.getBits(8, "skip8");
    }

    private void benchmarkStart(int length) {
        this.vertexCount = 0;
        System.out.println(" GeometryDecompressor: decompressing " + length + " bytes...");
        this.startTime = System.currentTimeMillis();
    }

    private void benchmarkPrint(int length) {
        float t = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
        System.out.println("  done in " + t + " sec." + "\n" + "  decompressed " + this.vertexCount + " vertices at " + (float)this.vertexCount / t + " vertices/sec\n");
        System.out.print("  vertex data present: coords");
        int floatVertexSize = 12;
        if (this.bundlingNorm) {
            System.out.print(" normals");
            floatVertexSize += 12;
        }
        if (this.bundlingColor) {
            System.out.println(" colors");
            floatVertexSize += 12;
        }
        if (this.doingAlpha) {
            System.out.println(" alpha");
            floatVertexSize += 4;
        }
        System.out.println();
        System.out.println("  bytes of data in generalized strip output: " + this.vertexCount * floatVertexSize + "\n" + "  compression ratio: " + (float)length / (float)(this.vertexCount * floatVertexSize) + "\n");
    }

    static class HuffmanTableEntry {
        int tagLength;
        int dataLength;
        int rightShift;
        int absolute;

        HuffmanTableEntry() {
        }

        public String toString() {
            return " tag length: " + this.tagLength + " data length: " + this.dataLength + " shift: " + this.rightShift + " abs/rel: " + this.absolute;
        }
    }

    static class MeshBufferEntry {
        short x;
        short y;
        short z;
        short octant;
        short sextant;
        short u;
        short v;
        short r;
        short g;
        short b;
        short a;

        MeshBufferEntry() {
        }
    }
}

