/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import java.util.ArrayList;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.LineStripArray;
import org.jogamp.java3d.PointArray;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.utils.geometry.compression.GeneralizedStrip;
import org.jogamp.java3d.utils.geometry.compression.GeneralizedStripFlags;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

class GeneralizedVertexList
implements GeneralizedStripFlags {
    private ArrayList vertices;
    private boolean hasColor3 = false;
    private boolean hasColor4 = false;
    private boolean hasNormals = false;
    private int frontFace;
    int stripCount;
    int vertexCount;
    int triangleCount;
    int vertexFormat;

    GeneralizedVertexList(int vertexFormat, int frontFace, int initSize) {
        this.frontFace = frontFace;
        this.setVertexFormat(vertexFormat);
        this.vertices = initSize == 0 ? new ArrayList() : new ArrayList(initSize);
        this.stripCount = 0;
        this.vertexCount = 0;
        this.triangleCount = 0;
    }

    GeneralizedVertexList(int vertexFormat, int frontFace) {
        this(vertexFormat, frontFace, 0);
    }

    void setVertexFormat(int vertexFormat) {
        this.vertexFormat = vertexFormat;
        if ((vertexFormat & 2) != 0) {
            this.hasNormals = true;
        }
        if ((vertexFormat & 0xC) == 12) {
            this.hasColor4 = true;
        } else if ((vertexFormat & 4) == 4) {
            this.hasColor3 = true;
        }
    }

    void addVertex(Point3f pos, Vector3f norm, Color4f color, int flag) {
        this.vertices.add(new Vertex(pos, norm, color, flag));
    }

    int size() {
        return this.vertices.size();
    }

    @Override
    public int getFlagCount() {
        return this.vertices.size();
    }

    @Override
    public int getFlag(int index) {
        return ((Vertex)this.vertices.get((int)index)).flag;
    }

    private void copyVertexData(GeometryArray ga, GeneralizedStrip.IntList indices) {
        Point3f[] p3f = new Point3f[indices.count];
        if (this.hasNormals) {
            Vector3f[] v3f = new Vector3f[indices.count];
            if (this.hasColor3) {
                Color3f[] c3f = new Color3f[indices.count];
                int i2 = 0;
                while (i2 < indices.count) {
                    Vertex v = (Vertex)this.vertices.get(indices.ints[i2]);
                    p3f[i2] = v.coord;
                    v3f[i2] = v.normal;
                    c3f[i2] = v.color3;
                    ++i2;
                }
                ga.setColors(0, c3f);
            } else if (this.hasColor4) {
                Color4f[] c4f = new Color4f[indices.count];
                int i3 = 0;
                while (i3 < indices.count) {
                    Vertex v = (Vertex)this.vertices.get(indices.ints[i3]);
                    p3f[i3] = v.coord;
                    v3f[i3] = v.normal;
                    c4f[i3] = v.color4;
                    ++i3;
                }
                ga.setColors(0, c4f);
            } else {
                int i4 = 0;
                while (i4 < indices.count) {
                    Vertex v = (Vertex)this.vertices.get(indices.ints[i4]);
                    p3f[i4] = v.coord;
                    v3f[i4] = v.normal;
                    ++i4;
                }
            }
            ga.setNormals(0, v3f);
        } else if (this.hasColor3) {
            Color3f[] c3f = new Color3f[indices.count];
            int i5 = 0;
            while (i5 < indices.count) {
                Vertex v = (Vertex)this.vertices.get(indices.ints[i5]);
                p3f[i5] = v.coord;
                c3f[i5] = v.color3;
                ++i5;
            }
            ga.setColors(0, c3f);
        } else if (this.hasColor4) {
            Color4f[] c4f = new Color4f[indices.count];
            int i6 = 0;
            while (i6 < indices.count) {
                Vertex v = (Vertex)this.vertices.get(indices.ints[i6]);
                p3f[i6] = v.coord;
                c4f[i6] = v.color4;
                ++i6;
            }
            ga.setColors(0, c4f);
        } else {
            int i7 = 0;
            while (i7 < indices.count) {
                Vertex v = (Vertex)this.vertices.get(indices.ints[i7]);
                p3f[i7] = v.coord;
                ++i7;
            }
        }
        ga.setCoordinates(0, p3f);
    }

    PointArray toPointArray() {
        int size = this.vertices.size();
        if (size > 0) {
            PointArray pa = new PointArray(size, this.vertexFormat);
            GeneralizedStrip.IntList il = new GeneralizedStrip.IntList(size);
            il.fillAscending();
            this.copyVertexData(pa, il);
            this.vertexCount += size;
            return pa;
        }
        return null;
    }

    TriangleArray toTriangleArray() {
        int[] vertices = GeneralizedStrip.toTriangles(this, this.frontFace);
        if (vertices != null) {
            TriangleArray ta = new TriangleArray(vertices.length, this.vertexFormat);
            GeneralizedStrip.IntList il = new GeneralizedStrip.IntList(vertices);
            this.copyVertexData(ta, il);
            this.vertexCount += vertices.length;
            this.triangleCount += vertices.length / 3;
            return ta;
        }
        return null;
    }

    LineStripArray toLineStripArray() {
        GeneralizedStrip.StripArray stripArray = GeneralizedStrip.toLineStrips(this);
        if (stripArray != null) {
            LineStripArray lsa = new LineStripArray(stripArray.vertices.count, this.vertexFormat, stripArray.stripCounts.trim());
            this.copyVertexData(lsa, stripArray.vertices);
            this.vertexCount += stripArray.vertices.count;
            this.stripCount += stripArray.stripCounts.count;
            return lsa;
        }
        return null;
    }

    TriangleStripArray toTriangleStripArray() {
        GeneralizedStrip.StripArray stripArray = GeneralizedStrip.toTriangleStrips(this, this.frontFace);
        if (stripArray != null) {
            TriangleStripArray tsa = new TriangleStripArray(stripArray.vertices.count, this.vertexFormat, stripArray.stripCounts.trim());
            this.copyVertexData(tsa, stripArray.vertices);
            this.vertexCount += stripArray.vertices.count;
            this.stripCount += stripArray.stripCounts.count;
            return tsa;
        }
        return null;
    }

    GeometryStripArray[] toStripAndFanArrays() {
        GeneralizedStrip.StripArray[] stripArray = GeneralizedStrip.toStripsAndFans(this, this.frontFace);
        GeometryStripArray[] gsa = new GeometryStripArray[2];
        if (stripArray[0] != null) {
            gsa[0] = new TriangleStripArray(stripArray[0].vertices.count, this.vertexFormat, stripArray[0].stripCounts.trim());
            this.copyVertexData(gsa[0], stripArray[0].vertices);
            this.vertexCount += stripArray[0].vertices.count;
            this.stripCount += stripArray[0].stripCounts.count;
        }
        if (stripArray[1] != null) {
            gsa[1] = new TriangleFanArray(stripArray[1].vertices.count, this.vertexFormat, stripArray[1].stripCounts.trim());
            this.copyVertexData(gsa[1], stripArray[1].vertices);
            this.vertexCount += stripArray[1].vertices.count;
            this.stripCount += stripArray[1].stripCounts.count;
        }
        return gsa;
    }

    GeometryArray[] toStripAndTriangleArrays() {
        GeneralizedStrip.StripArray[] stripArray = GeneralizedStrip.toStripsAndTriangles(this, this.frontFace, 4, 12);
        GeometryArray[] ga = new GeometryArray[2];
        if (stripArray[0] != null) {
            ga[0] = new TriangleStripArray(stripArray[0].vertices.count, this.vertexFormat, stripArray[0].stripCounts.trim());
            this.copyVertexData(ga[0], stripArray[0].vertices);
            this.vertexCount += stripArray[0].vertices.count;
            this.stripCount += stripArray[0].stripCounts.count;
        }
        if (stripArray[1] != null) {
            ga[1] = new TriangleArray(stripArray[1].vertices.count, this.vertexFormat);
            this.copyVertexData(ga[1], stripArray[1].vertices);
            this.triangleCount += stripArray[1].vertices.count / 3;
        }
        return ga;
    }

    class Vertex {
        int flag;
        Point3f coord;
        Color3f color3;
        Color4f color4;
        Vector3f normal;

        Vertex(Point3f p, Vector3f n2, Color4f c2, int flag) {
            this.flag = flag;
            this.coord = new Point3f(p);
            if (GeneralizedVertexList.this.hasNormals) {
                this.normal = new Vector3f(n2);
            }
            if (GeneralizedVertexList.this.hasColor3) {
                this.color3 = new Color3f(c2.x, c2.y, c2.z);
            } else if (GeneralizedVertexList.this.hasColor4) {
                this.color4 = new Color4f(c2);
            }
        }
    }
}

