/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Basic;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Matrix4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

class Project {
    Project() {
    }

    static void projectFace(Triangulator triRef, int loopMin, int loopMax) {
        Vector3f normal = new Vector3f();
        Vector3f nr = new Vector3f();
        Project.determineNormal(triRef, triRef.loops[loopMin], normal);
        int j2 = loopMin + 1;
        if (j2 < loopMax) {
            int i2 = j2;
            while (i2 < loopMax) {
                Project.determineNormal(triRef, triRef.loops[i2], nr);
                if (Basic.dotProduct(normal, nr) < 0.0) {
                    Basic.invertVector(nr);
                }
                Basic.vectorAdd(normal, nr, normal);
                ++i2;
            }
            double d2 = Basic.lengthL2(normal);
            if (Numerics.gt(d2, 1.0E-8)) {
                Basic.divScalar(d2, normal);
            } else {
                normal.y = 0.0f;
                normal.x = 0.0f;
                normal.z = 1.0f;
            }
        }
        Project.projectPoints(triRef, loopMin, loopMax, normal);
    }

    static void determineNormal(Triangulator triRef, int ind, Vector3f normal) {
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        int ind0 = triRef.fetchPrevData(ind1);
        int i0 = triRef.fetchData(ind0);
        int ind2 = triRef.fetchNextData(ind1);
        int i2 = triRef.fetchData(ind2);
        Vector3f pq = new Vector3f();
        Basic.vectorSub(triRef.vertices[i0], triRef.vertices[i1], pq);
        Vector3f pr = new Vector3f();
        Basic.vectorSub(triRef.vertices[i2], triRef.vertices[i1], pr);
        Vector3f nr = new Vector3f();
        Basic.vectorProduct(pq, pr, nr);
        double d2 = Basic.lengthL2(nr);
        if (Numerics.gt(d2, 1.0E-8)) {
            Basic.divScalar(d2, nr);
            normal.set(nr);
        } else {
            normal.z = 0.0f;
            normal.y = 0.0f;
            normal.x = 0.0f;
        }
        pq.set(pr);
        ind1 = ind2;
        ind2 = triRef.fetchNextData(ind1);
        i2 = triRef.fetchData(ind2);
        while (ind1 != ind) {
            Basic.vectorSub(triRef.vertices[i2], triRef.vertices[i1], pr);
            Basic.vectorProduct(pq, pr, nr);
            d2 = Basic.lengthL2(nr);
            if (Numerics.gt(d2, 1.0E-8)) {
                Basic.divScalar(d2, nr);
                if (Basic.dotProduct(normal, nr) < 0.0) {
                    Basic.invertVector(nr);
                }
                Basic.vectorAdd(normal, nr, normal);
            }
            pq.set(pr);
            ind1 = ind2;
            ind2 = triRef.fetchNextData(ind1);
            i2 = triRef.fetchData(ind2);
        }
        d2 = Basic.lengthL2(normal);
        if (Numerics.gt(d2, 1.0E-8)) {
            Basic.divScalar(d2, normal);
        } else {
            normal.y = 0.0f;
            normal.x = 0.0f;
            normal.z = 1.0f;
        }
    }

    static void projectPoints(Triangulator triRef, int i1, int i2, Vector3f n3) {
        Matrix4f matrix = new Matrix4f();
        Point3f vtx = new Point3f();
        Vector3f n1 = new Vector3f();
        Vector3f n2 = new Vector3f();
        if ((double)Math.abs(n3.x) > 0.1 || (double)Math.abs(n3.y) > 0.1) {
            n1.x = -n3.y;
            n1.y = n3.x;
            n1.z = 0.0f;
        } else {
            n1.x = n3.z;
            n1.z = -n3.x;
            n1.y = 0.0f;
        }
        double d2 = Basic.lengthL2(n1);
        Basic.divScalar(d2, n1);
        Basic.vectorProduct(n1, n3, n2);
        d2 = Basic.lengthL2(n2);
        Basic.divScalar(d2, n2);
        matrix.m00 = n1.x;
        matrix.m01 = n1.y;
        matrix.m02 = n1.z;
        matrix.m03 = 0.0f;
        matrix.m10 = n2.x;
        matrix.m11 = n2.y;
        matrix.m12 = n2.z;
        matrix.m13 = 0.0f;
        matrix.m20 = n3.x;
        matrix.m21 = n3.y;
        matrix.m22 = n3.z;
        matrix.m23 = 0.0f;
        matrix.m30 = 0.0f;
        matrix.m31 = 0.0f;
        matrix.m32 = 0.0f;
        matrix.m33 = 1.0f;
        triRef.initPnts(20);
        int i3 = i1;
        while (i3 < i2) {
            int ind;
            int ind1 = ind = triRef.loops[i3];
            int j1 = triRef.fetchData(ind1);
            matrix.transform(triRef.vertices[j1], vtx);
            j1 = triRef.storePoint(vtx.x, vtx.y);
            triRef.updateIndex(ind1, j1);
            ind1 = triRef.fetchNextData(ind1);
            j1 = triRef.fetchData(ind1);
            while (ind1 != ind) {
                matrix.transform(triRef.vertices[j1], vtx);
                j1 = triRef.storePoint(vtx.x, vtx.y);
                triRef.updateIndex(ind1, j1);
                ind1 = triRef.fetchNextData(ind1);
                j1 = triRef.fetchData(ind1);
            }
            ++i3;
        }
    }
}

