/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.util.ArrayList;
import org.jogamp.java3d.utils.geometry.Edge;
import org.jogamp.java3d.utils.geometry.EdgeTable;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class NormalGenerator {
    private double creaseAngle;
    private ArrayList<ArrayList<Integer>> tally;
    private int[] coordInds;
    private int[] normalInds;
    private int[] colorInds;
    private int[][] texInds;
    private int[] stripCounts;
    private static long t1 = 0L;
    private static long t2 = 0L;
    private static long t3 = 0L;
    private static long t4 = 0L;
    private static long t5 = 0L;
    private static long t6 = 0L;
    private Triangulator tr = null;
    private int numTexSets;
    private static final int DEBUG = 0;

    private Vector3f[] calculatefacetNorms(GeometryInfo gi) {
        Point3f[] coordinates = gi.getCoordinates();
        Vector3f[] facetNorms = new Vector3f[this.coordInds.length / 3];
        Vector3f a2 = new Vector3f();
        Vector3f b2 = new Vector3f();
        if (gi.getOldPrim() != 2) {
            int t = 0;
            while (t < this.coordInds.length) {
                a2.sub(coordinates[this.coordInds[t + 2]], coordinates[this.coordInds[t + 1]]);
                b2.sub(coordinates[this.coordInds[t + 0]], coordinates[this.coordInds[t + 1]]);
                facetNorms[t / 3] = new Vector3f();
                facetNorms[t / 3].cross(a2, b2);
                facetNorms[t / 3].normalize();
                if (Float.isNaN(facetNorms[t / 3].x)) {
                    facetNorms[t / 3].x = 1.0f;
                    facetNorms[t / 3].z = 0.0f;
                    facetNorms[t / 3].y = 0.0f;
                }
                t += 3;
            }
        } else {
            int t = 0;
            while (t < this.coordInds.length) {
                a2.sub(coordinates[this.coordInds[t + 2]], coordinates[this.coordInds[t + 0]]);
                b2.sub(coordinates[this.coordInds[t + 5]], coordinates[this.coordInds[t + 1]]);
                facetNorms[t / 3] = new Vector3f();
                facetNorms[t / 3].cross(a2, b2);
                facetNorms[t / 3].normalize();
                if (Float.isNaN(facetNorms[t / 3].x)) {
                    facetNorms[t / 3].x = 1.0f;
                    facetNorms[t / 3].z = 0.0f;
                    facetNorms[t / 3].y = 0.0f;
                }
                facetNorms[t / 3 + 1] = new Vector3f(facetNorms[t / 3]);
                t += 6;
            }
        }
        return facetNorms;
    }

    private int createHardEdges(Vector3f[] facetNorms) {
        EdgeTable et = new EdgeTable(this.coordInds);
        this.tally = new ArrayList();
        int[] normalMap = new int[this.coordInds.length];
        int maxShare = 1;
        float threshold = (float)Math.cos(this.creaseAngle);
        int c2 = 0;
        while (c2 < this.coordInds.length) {
            normalMap[c2] = Integer.MAX_VALUE;
            ++c2;
        }
        c2 = 0;
        while (c2 < this.coordInds.length) {
            if (normalMap[c2] == Integer.MAX_VALUE) {
                boolean smooth;
                ArrayList<Integer> sharers = new ArrayList<Integer>();
                this.tally.add(sharers);
                sharers.add(new Integer(c2));
                normalMap[c2] = this.tally.size() - 1;
                boolean goingRight = true;
                Edge edge = new Edge(this.coordInds[c2], this.coordInds[(c2 + 1) % 3 == 0 ? c2 - 2 : c2 + 1]);
                int endVertex = this.coordInds[c2 % 3 == 0 ? c2 + 2 : c2 - 1];
                int cur = c2;
                do {
                    Integer tableVal;
                    if ((tableVal = et.get(edge.v2, edge.v1)) == null) {
                        smooth = false;
                    } else {
                        int n2 = tableVal;
                        float cosine = facetNorms[cur / 3].dot(facetNorms[n2 / 3]);
                        boolean bl = smooth = cosine > threshold;
                        if (smooth) {
                            int centerv;
                            int n3 = centerv = (n2 + 1) % 3 == 0 ? n2 - 2 : n2 + 1;
                            if (this.coordInds[c2] != this.coordInds[centerv]) {
                                int n4 = centerv = n2 % 3 == 0 ? n2 + 2 : n2 - 1;
                            }
                            if (normalMap[centerv] != Integer.MAX_VALUE) {
                                smooth = false;
                            } else {
                                normalMap[centerv] = this.tally.size() - 1;
                                sharers.add(new Integer(centerv));
                                if (sharers.size() > maxShare) {
                                    maxShare = sharers.size();
                                }
                                cur = n2;
                                if (goingRight) {
                                    edge.v2 = this.coordInds[cur];
                                } else {
                                    edge.v1 = this.coordInds[cur];
                                }
                            }
                        }
                    }
                    if (smooth || !goingRight) continue;
                    goingRight = false;
                    smooth = true;
                    cur = c2;
                    edge = new Edge(this.coordInds[c2 % 3 == 0 ? c2 + 2 : c2 - 1], this.coordInds[c2]);
                } while (smooth && (goingRight && edge.v2 != endVertex || !goingRight));
            }
            ++c2;
        }
        return maxShare;
    }

    private void calculateVertexNormals(GeometryInfo gi, Vector3f[] facetNorms, int maxShare) {
        Vector3f[] normals;
        if (this.creaseAngle != 0.0) {
            Vector3f[] fn = new Vector3f[maxShare];
            normals = new Vector3f[this.tally.size()];
            this.normalInds = new int[this.coordInds.length];
            int n2 = 0;
            while (n2 < this.tally.size()) {
                ArrayList<Integer> sharers = this.tally.get(n2);
                int fnsize = 0;
                normals[n2] = new Vector3f();
                int t = 0;
                while (t < sharers.size()) {
                    int v = sharers.get(t);
                    if (v != -1) {
                        int triangle = v / 3;
                        if (!Float.isNaN(facetNorms[triangle].x)) {
                            int f2 = 0;
                            while (f2 < fnsize) {
                                if (fn[f2].equals(facetNorms[triangle])) break;
                                ++f2;
                            }
                            this.normalInds[v] = n2;
                            if (f2 == fnsize) {
                                normals[n2].add(facetNorms[triangle]);
                                fn[fnsize++] = facetNorms[triangle];
                            }
                        }
                    }
                    ++t;
                }
                normals[n2].normalize();
                if (Float.isNaN(normals[n2].x)) {
                    normals[n2].x = 1.0f;
                    normals[n2].z = 0.0f;
                    normals[n2].y = 0.0f;
                }
                ++n2;
            }
        } else {
            normals = facetNorms;
            this.normalInds = new int[facetNorms.length * 3];
            int i2 = 0;
            while (i2 < facetNorms.length) {
                this.normalInds[i2 * 3 + 0] = i2;
                this.normalInds[i2 * 3 + 1] = i2;
                this.normalInds[i2 * 3 + 2] = i2;
                ++i2;
            }
        }
        gi.setNormals(normals);
    }

    private int[] triToQuadIndices(int[] oldList) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[oldList.length / 6 * 4];
        int q = 0;
        while (q < oldList.length / 6) {
            newList[q * 4 + 0] = oldList[q * 6 + 0];
            newList[q * 4 + 1] = oldList[q * 6 + 1];
            newList[q * 4 + 2] = oldList[q * 6 + 2];
            newList[q * 4 + 3] = oldList[q * 6 + 5];
            ++q;
        }
        return newList;
    }

    private void convertTriToQuad(GeometryInfo geom) {
        geom.setCoordinateIndices(this.triToQuadIndices(geom.getCoordinateIndices()));
        geom.setColorIndices(this.triToQuadIndices(geom.getColorIndices()));
        geom.setNormalIndices(this.triToQuadIndices(geom.getNormalIndices()));
        int num = geom.getTexCoordSetCount();
        int i2 = 0;
        while (i2 < num) {
            geom.setTextureCoordinateIndices(i2, this.triToQuadIndices(geom.getTextureCoordinateIndices(i2)));
            ++i2;
        }
        geom.setPrimitive(2);
    }

    private int[] triToFanIndices(int[] sc, int[] oldList, int numVerts) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[numVerts];
        int vert1 = 0;
        int n2 = 0;
        int f2 = 0;
        while (f2 < sc.length) {
            newList[n2++] = oldList[vert1++];
            newList[n2++] = oldList[vert1++];
            newList[n2++] = oldList[vert1++];
            int t = 3;
            while (t < sc[f2]) {
                newList[n2++] = oldList[vert1 + 2];
                vert1 += 3;
                ++t;
            }
            ++f2;
        }
        return newList;
    }

    private void convertTriToFan(GeometryInfo geom, int[] oldStripCounts) {
        int[] ni = geom.getNormalIndices();
        int tri = 0;
        ArrayList<Integer> newStripCounts = new ArrayList<Integer>(oldStripCounts.length + 100);
        int f2 = 0;
        while (f2 < oldStripCounts.length) {
            int stripCount = 3;
            int t = 0;
            while (t < oldStripCounts[f2] - 3) {
                if (ni[tri * 3] == ni[(tri + 1) * 3] && ni[tri * 3 + 2] == ni[(tri + 1) * 3 + 1]) {
                    ++stripCount;
                } else {
                    newStripCounts.add(new Integer(stripCount));
                    stripCount = 3;
                }
                ++tri;
                ++t;
            }
            ++tri;
            newStripCounts.add(new Integer(stripCount));
            ++f2;
        }
        int[] sc = new int[newStripCounts.size()];
        int i2 = 0;
        while (i2 < sc.length) {
            sc[i2] = (Integer)newStripCounts.get(i2);
            ++i2;
        }
        newStripCounts = null;
        int c2 = 0;
        int i3 = 0;
        while (i3 < sc.length) {
            c2 += sc[i3];
            ++i3;
        }
        geom.setCoordinateIndices(this.triToFanIndices(sc, geom.getCoordinateIndices(), c2));
        geom.setColorIndices(this.triToFanIndices(sc, geom.getColorIndices(), c2));
        geom.setNormalIndices(this.triToFanIndices(sc, geom.getNormalIndices(), c2));
        int num = geom.getTexCoordSetCount();
        int i4 = 0;
        while (i4 < num) {
            geom.setTextureCoordinateIndices(i4, this.triToFanIndices(sc, geom.getTextureCoordinateIndices(i4), c2));
            ++i4;
        }
        geom.setStripCounts(sc);
        geom.setPrimitive(3);
    }

    private int[] triToStripIndices(int[] sc, int[] oldList, int numVerts) {
        if (oldList == null) {
            return null;
        }
        int[] newList = new int[numVerts];
        int vert1 = 0;
        int n2 = 0;
        int f2 = 0;
        while (f2 < sc.length) {
            newList[n2++] = oldList[vert1++];
            newList[n2++] = oldList[vert1++];
            newList[n2++] = oldList[vert1++];
            int t = 3;
            while (t < sc[f2]) {
                newList[n2++] = oldList[vert1 + 2 - t % 2];
                vert1 += 3;
                ++t;
            }
            ++f2;
        }
        return newList;
    }

    private void convertTriToStrip(GeometryInfo geom, int[] oldStripCounts) {
        int[] ni = geom.getNormalIndices();
        int tri = 0;
        ArrayList<Integer> newStripCounts = new ArrayList<Integer>(oldStripCounts.length + 100);
        int f2 = 0;
        while (f2 < oldStripCounts.length) {
            int stripCount = 3;
            int t = 0;
            while (t < oldStripCounts[f2] - 3) {
                if (t % 2 == 0) {
                    if (ni[tri * 3 + 1] == ni[(tri + 1) * 3] && ni[tri * 3 + 2] == ni[(tri + 1) * 3 + 2]) {
                        ++stripCount;
                    } else {
                        newStripCounts.add(new Integer(stripCount));
                        stripCount = 3;
                        if (t < oldStripCounts[f2] - 4) {
                            newStripCounts.add(new Integer(3));
                            ++t;
                        }
                    }
                } else if (ni[tri * 3 + 1] == ni[(tri + 1) * 3 + 1] && ni[tri * 3 + 2] == ni[(tri + 1) * 3]) {
                    ++stripCount;
                } else {
                    newStripCounts.add(new Integer(stripCount));
                    stripCount = 3;
                }
                ++tri;
                ++t;
            }
            ++tri;
            newStripCounts.add(new Integer(stripCount));
            ++f2;
        }
        int[] sc = new int[newStripCounts.size()];
        int i2 = 0;
        while (i2 < sc.length) {
            sc[i2] = (Integer)newStripCounts.get(i2);
            ++i2;
        }
        newStripCounts = null;
        int c2 = 0;
        int i3 = 0;
        while (i3 < sc.length) {
            c2 += sc[i3];
            ++i3;
        }
        geom.setCoordinateIndices(this.triToStripIndices(sc, geom.getCoordinateIndices(), c2));
        geom.setColorIndices(this.triToStripIndices(sc, geom.getColorIndices(), c2));
        geom.setNormalIndices(this.triToStripIndices(sc, geom.getNormalIndices(), c2));
        int num = geom.getTexCoordSetCount();
        int i4 = 0;
        while (i4 < num) {
            geom.setTextureCoordinateIndices(i4, this.triToStripIndices(sc, geom.getTextureCoordinateIndices(i4), c2));
            ++i4;
        }
        geom.setStripCounts(sc);
        geom.setPrimitive(4);
    }

    void convertBackToOldPrim(GeometryInfo geom, int oldPrim, int[] oldStripCounts) {
        if (oldPrim == 1) {
            return;
        }
        switch (oldPrim) {
            case 2: {
                this.convertTriToQuad(geom);
                break;
            }
            case 3: {
                this.convertTriToFan(geom, oldStripCounts);
                break;
            }
            case 4: {
                this.convertTriToStrip(geom, oldStripCounts);
            }
        }
    }

    public void generateNormals(GeometryInfo gi) {
        gi.setNormals((Vector3f[])null);
        gi.setNormalIndices(null);
        long time = 0L;
        if (gi.getPrimitive() == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(gi);
        } else {
            gi.rememberOldPrim();
            gi.convertToIndexedTriangles();
        }
        this.coordInds = gi.getCoordinateIndices();
        this.colorInds = gi.getColorIndices();
        this.normalInds = gi.getNormalIndices();
        this.numTexSets = gi.getTexCoordSetCount();
        this.texInds = new int[this.numTexSets][];
        int i2 = 0;
        while (i2 < this.numTexSets) {
            this.texInds[i2] = gi.getTextureCoordinateIndices(i2);
            ++i2;
        }
        this.stripCounts = gi.getStripCounts();
        Vector3f[] facetNorms = this.calculatefacetNorms(gi);
        int maxShare = this.createHardEdges(facetNorms);
        this.calculateVertexNormals(gi, facetNorms, maxShare);
        gi.setCoordinateIndices(this.coordInds);
        gi.setColorIndices(this.colorInds);
        gi.setNormalIndices(this.normalInds);
        int i3 = 0;
        while (i3 < this.numTexSets) {
            gi.setTextureCoordinateIndices(i3, this.texInds[i3]);
            ++i3;
        }
        gi.setStripCounts(this.stripCounts);
    }

    public void setCreaseAngle(double radians) {
        if (radians > Math.PI) {
            radians = Math.PI;
        }
        if (radians < 0.0) {
            radians = 0.0;
        }
        this.creaseAngle = radians;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public NormalGenerator(double radians) {
        this.creaseAngle = radians;
    }

    public NormalGenerator() {
        this(0.767944870877505);
    }
}

