/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedGeometryStripArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.IndexedTriangleArray;
import org.jogamp.java3d.IndexedTriangleFanArray;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.internal.BufferWrapper;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.vecmath.Color3b;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4b;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.TexCoord4f;
import org.jogamp.vecmath.Vector3f;

class GeometryInfoGenerator {
    GeometryInfoGenerator() {
    }

    public static void create(GeometryInfo geomInfo, GeometryArray geomArray) {
        if (geomArray instanceof GeometryStripArray) {
            GeometryInfoGenerator.create(geomInfo, (GeometryStripArray)geomArray);
        } else if (geomArray instanceof TriangleArray) {
            geomInfo.reset(1);
            GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        } else if (geomArray instanceof QuadArray) {
            geomInfo.reset(2);
            GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        } else if (geomArray instanceof IndexedGeometryArray) {
            GeometryInfoGenerator.create(geomInfo, (IndexedGeometryArray)geomArray);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
    }

    private static void create(GeometryInfo geomInfo, GeometryStripArray geomArray) {
        if (geomArray instanceof TriangleFanArray) {
            geomInfo.reset(3);
        } else if (geomArray instanceof TriangleStripArray) {
            geomInfo.reset(4);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
        GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        GeometryInfoGenerator.processStripArray(geomInfo, geomArray);
    }

    private static void create(GeometryInfo geomInfo, IndexedGeometryArray geomArray) {
        if (geomArray instanceof IndexedQuadArray) {
            geomInfo.reset(2);
        } else if (geomArray instanceof IndexedTriangleArray) {
            geomInfo.reset(1);
        } else if (geomArray instanceof IndexedTriangleFanArray) {
            geomInfo.reset(3);
            GeometryInfoGenerator.processIndexStripArray(geomInfo, (IndexedGeometryStripArray)geomArray);
        } else if (geomArray instanceof IndexedTriangleStripArray) {
            geomInfo.reset(4);
            GeometryInfoGenerator.processIndexStripArray(geomInfo, (IndexedGeometryStripArray)geomArray);
        }
        GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        GeometryInfoGenerator.processIndexedArray(geomInfo, geomArray);
    }

    private static void processGeometryArray(GeometryInfo geomInfo, GeometryArray geomArray) {
        block153: {
            Object[] t;
            Object[] c2;
            Buffer bb;
            J3DBuffer buf;
            boolean nio;
            boolean byRef;
            int i2;
            int valid;
            int texSets;
            int vertexFormat;
            block161: {
                Color3f[] colors;
                block164: {
                    int initial;
                    block162: {
                        Object[] c3;
                        block163: {
                            block157: {
                                Color4f[] colors2;
                                block160: {
                                    int initial2;
                                    block158: {
                                        block159: {
                                            Point3f[] coords;
                                            block156: {
                                                int initial3;
                                                block154: {
                                                    Object[] c4;
                                                    block155: {
                                                        block152: {
                                                            Cloneable[] color;
                                                            int j2;
                                                            Cloneable[] tex;
                                                            int[] map;
                                                            float[] d2;
                                                            vertexFormat = geomArray.getVertexFormat();
                                                            texSets = geomArray.getTexCoordSetCount();
                                                            if (geomArray instanceof GeometryStripArray) {
                                                                GeometryStripArray gsa = (GeometryStripArray)geomArray;
                                                                int[] strips = new int[gsa.getNumStrips()];
                                                                gsa.getStripVertexCounts(strips);
                                                                valid = 0;
                                                                i2 = 0;
                                                                while (i2 < strips.length) {
                                                                    valid += strips[i2];
                                                                    ++i2;
                                                                }
                                                            } else {
                                                                valid = geomArray instanceof IndexedGeometryArray ? geomArray.getVertexCount() : geomArray.getValidVertexCount();
                                                            }
                                                            if ((vertexFormat & 0x100) == 0) break block152;
                                                            int wpv = 3;
                                                            if ((vertexFormat & 2) != 0) {
                                                                wpv += 3;
                                                            }
                                                            if ((vertexFormat & 0xC) == 12) {
                                                                wpv += 4;
                                                            } else if ((vertexFormat & 4) != 0) {
                                                                wpv += 3;
                                                            }
                                                            if ((vertexFormat & 0x20) != 0) {
                                                                wpv += 2 * texSets;
                                                            } else if ((vertexFormat & 0x40) != 0) {
                                                                wpv += 3 * texSets;
                                                            } else if ((vertexFormat & 0x400) != 0) {
                                                                wpv += 4 * texSets;
                                                            }
                                                            int initial4 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                                            if ((vertexFormat & 0x800) != 0) {
                                                                J3DBuffer b2 = geomArray.getInterleavedVertexBuffer();
                                                                FloatBuffer w = (FloatBuffer)b2.getBuffer();
                                                                d2 = new float[w.limit()];
                                                                w.position(0);
                                                                w.get(d2);
                                                            } else {
                                                                d2 = geomArray.getInterleavedVertices();
                                                            }
                                                            int offset = 0;
                                                            if ((vertexFormat & 0x20) != 0) {
                                                                geomInfo.setTextureCoordinateParams(texSets, 2);
                                                                map = new int[geomArray.getTexCoordSetMapLength()];
                                                                geomArray.getTexCoordSetMap(map);
                                                                geomInfo.setTexCoordSetMap(map);
                                                                i2 = 0;
                                                                while (i2 < texSets) {
                                                                    tex = new TexCoord2f[valid];
                                                                    j2 = 0;
                                                                    while (j2 < valid) {
                                                                        tex[j2] = new TexCoord2f(d2[wpv * (j2 + initial4) + offset], d2[wpv * (j2 + initial4) + offset + 1]);
                                                                        ++j2;
                                                                    }
                                                                    geomInfo.setTextureCoordinates(i2, (TexCoord2f[])tex);
                                                                    offset += 2;
                                                                    ++i2;
                                                                }
                                                            } else if ((vertexFormat & 0x40) != 0) {
                                                                geomInfo.setTextureCoordinateParams(texSets, 3);
                                                                map = new int[geomArray.getTexCoordSetMapLength()];
                                                                geomArray.getTexCoordSetMap(map);
                                                                geomInfo.setTexCoordSetMap(map);
                                                                i2 = 0;
                                                                while (i2 < texSets) {
                                                                    tex = new TexCoord3f[valid];
                                                                    j2 = 0;
                                                                    while (j2 < valid) {
                                                                        tex[j2] = new TexCoord3f(d2[wpv * (j2 + initial4) + offset], d2[wpv * (j2 + initial4) + offset + 1], d2[wpv * (j2 + initial4) + offset + 2]);
                                                                        ++j2;
                                                                    }
                                                                    geomInfo.setTextureCoordinates(i2, (TexCoord3f[])tex);
                                                                    offset += 3;
                                                                    ++i2;
                                                                }
                                                            } else if ((vertexFormat & 0x400) != 0) {
                                                                geomInfo.setTextureCoordinateParams(texSets, 4);
                                                                map = new int[geomArray.getTexCoordSetMapLength()];
                                                                geomArray.getTexCoordSetMap(map);
                                                                geomInfo.setTexCoordSetMap(map);
                                                                i2 = 0;
                                                                while (i2 < texSets) {
                                                                    tex = new TexCoord4f[valid];
                                                                    j2 = 0;
                                                                    while (j2 < valid) {
                                                                        tex[j2] = new TexCoord4f(d2[wpv * (j2 + initial4) + offset], d2[wpv * (j2 + initial4) + offset + 1], d2[wpv * (j2 + initial4) + offset + 2], d2[wpv * (j2 + initial4) + offset + 3]);
                                                                        ++j2;
                                                                    }
                                                                    geomInfo.setTextureCoordinates(i2, (TexCoord4f[])tex);
                                                                    offset += 4;
                                                                    ++i2;
                                                                }
                                                            }
                                                            if ((vertexFormat & 0xC) == 12) {
                                                                color = new Color4f[valid];
                                                                i2 = 0;
                                                                while (i2 < valid) {
                                                                    color[i2] = new Color4f(d2[wpv * (i2 + initial4) + offset], d2[wpv * (i2 + initial4) + offset + 1], d2[wpv * (i2 + initial4) + offset + 2], d2[wpv * (i2 + initial4) + offset + 3]);
                                                                    ++i2;
                                                                }
                                                                geomInfo.setColors((Color4f[])color);
                                                                offset += 4;
                                                            } else if ((vertexFormat & 4) != 0) {
                                                                color = new Color3f[valid];
                                                                i2 = 0;
                                                                while (i2 < valid) {
                                                                    color[i2] = new Color3f(d2[wpv * (i2 + initial4) + offset], d2[wpv * (i2 + initial4) + offset + 1], d2[wpv * (i2 + initial4) + offset + 2]);
                                                                    ++i2;
                                                                }
                                                                geomInfo.setColors((Color3f[])color);
                                                                offset += 3;
                                                            }
                                                            if ((vertexFormat & 2) != 0) {
                                                                Vector3f[] normals = new Vector3f[valid];
                                                                i2 = 0;
                                                                while (i2 < valid) {
                                                                    normals[i2] = new Vector3f(d2[wpv * (i2 + initial4) + offset], d2[wpv * (i2 + initial4) + offset + 1], d2[wpv * (i2 + initial4) + offset + 2]);
                                                                    ++i2;
                                                                }
                                                                geomInfo.setNormals(normals);
                                                                offset += 3;
                                                            }
                                                            Point3f[] coords2 = new Point3f[valid];
                                                            i2 = 0;
                                                            while (i2 < valid) {
                                                                coords2[i2] = new Point3f(d2[wpv * (i2 + initial4) + offset], d2[wpv * (i2 + initial4) + offset + 1], d2[wpv * (i2 + initial4) + offset + 2]);
                                                                ++i2;
                                                            }
                                                            geomInfo.setCoordinates(coords2);
                                                            break block153;
                                                        }
                                                        byRef = (vertexFormat & 0x80) != 0;
                                                        nio = (vertexFormat & 0x800) != 0;
                                                        coords = null;
                                                        if (!byRef) break block154;
                                                        initial3 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialCoordIndex() : 0;
                                                        if (!nio) break block155;
                                                        J3DBuffer buf2 = geomArray.getCoordRefBuffer();
                                                        switch (BufferWrapper.getBufferType(buf2)) {
                                                            case 3: {
                                                                Buffer bb2 = (FloatBuffer)buf2.getBuffer();
                                                                Object[] c5 = new float[valid * 3];
                                                                ((FloatBuffer)bb2).position(initial3 * 3);
                                                                ((FloatBuffer)bb2).get((float[])c5, 0, valid * 3);
                                                                coords = new Point3f[valid];
                                                                i2 = 0;
                                                                while (i2 < valid) {
                                                                    coords[i2] = new Point3f(c5[i2 * 3 + 0], c5[i2 * 3 + 1], c5[i2 * 3 + 2]);
                                                                    ++i2;
                                                                }
                                                                break block156;
                                                            }
                                                            case 4: {
                                                                Buffer bb2 = (DoubleBuffer)buf2.getBuffer();
                                                                Object[] c5 = new double[valid * 3];
                                                                ((DoubleBuffer)bb2).position(initial3 * 3);
                                                                ((DoubleBuffer)bb2).get((double[])c5, 0, valid * 3);
                                                                coords = new Point3f[valid];
                                                                i2 = 0;
                                                                while (i2 < valid) {
                                                                    coords[i2] = new Point3f(c5[i2 * 3 + 0], c5[i2 * 3 + 1], c5[i2 * 3 + 2]);
                                                                    ++i2;
                                                                }
                                                                break block0;
                                                            }
                                                        }
                                                        break block156;
                                                    }
                                                    if (geomArray.getCoordRef3f() != null) {
                                                        if (initial3 != 0) {
                                                            c4 = geomArray.getCoordRef3f();
                                                            coords = new Point3f[valid];
                                                            i2 = 0;
                                                            while (i2 < valid) {
                                                                coords[i2] = new Point3f((Point3f)c4[i2 + initial3]);
                                                                ++i2;
                                                            }
                                                        } else {
                                                            coords = geomArray.getCoordRef3f();
                                                        }
                                                    } else if (geomArray.getCoordRef3d() != null) {
                                                        c4 = geomArray.getCoordRef3d();
                                                        coords = new Point3f[valid];
                                                        i2 = 0;
                                                        while (i2 < valid) {
                                                            coords[i2] = new Point3f((Point3d)c4[i2 + initial3]);
                                                            ++i2;
                                                        }
                                                    } else if (geomArray.getCoordRefFloat() != null) {
                                                        c4 = geomArray.getCoordRefFloat();
                                                        coords = new Point3f[valid];
                                                        i2 = 0;
                                                        while (i2 < valid) {
                                                            coords[i2] = new Point3f((float)c4[(i2 + initial3) * 3], (float)c4[(i2 + initial3) * 3 + 1], (float)c4[(i2 + initial3) * 3 + 2]);
                                                            ++i2;
                                                        }
                                                    } else if (geomArray.getCoordRefDouble() != null) {
                                                        c4 = geomArray.getCoordRefDouble();
                                                        coords = new Point3f[valid];
                                                        i2 = 0;
                                                        while (i2 < valid) {
                                                            coords[i2] = new Point3f((float)c4[(i2 + initial3) * 3], (float)c4[(i2 + initial3) * 3 + 1], (float)c4[(i2 + initial3) * 3 + 2]);
                                                            ++i2;
                                                        }
                                                    }
                                                    break block156;
                                                }
                                                initial3 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                                coords = new Point3f[valid];
                                                i2 = 0;
                                                while (i2 < valid) {
                                                    coords[i2] = new Point3f();
                                                    ++i2;
                                                }
                                                geomArray.getCoordinates(initial3, coords);
                                            }
                                            geomInfo.setCoordinates(coords);
                                            if ((vertexFormat & 2) != 0) {
                                                int initial5;
                                                Vector3f[] normals = null;
                                                if (byRef) {
                                                    Object[] n2;
                                                    initial5 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialNormalIndex() : 0;
                                                    if (nio) {
                                                        buf = geomArray.getNormalRefBuffer();
                                                        if (BufferWrapper.getBufferType(buf) == 3) {
                                                            bb = (FloatBuffer)buf.getBuffer();
                                                            c2 = new float[valid * 3];
                                                            ((FloatBuffer)bb).position(initial5 * 3);
                                                            ((FloatBuffer)bb).get((float[])c2, 0, valid * 3);
                                                            normals = new Vector3f[valid];
                                                            i2 = 0;
                                                            while (i2 < valid) {
                                                                normals[i2] = new Vector3f(c2[i2 * 3 + 0], c2[i2 * 3 + 1], c2[i2 * 3 + 2]);
                                                                ++i2;
                                                            }
                                                        }
                                                    } else if (geomArray.getNormalRef3f() != null) {
                                                        if (initial5 != 0) {
                                                            n2 = geomArray.getNormalRef3f();
                                                            normals = new Vector3f[valid];
                                                            i2 = 0;
                                                            while (i2 < valid) {
                                                                normals[i2] = new Vector3f(n2[i2 + initial5]);
                                                                ++i2;
                                                            }
                                                        } else {
                                                            normals = geomArray.getNormalRef3f();
                                                        }
                                                    } else if (geomArray.getNormalRefFloat() != null) {
                                                        n2 = geomArray.getNormalRefFloat();
                                                        normals = new Vector3f[valid];
                                                        i2 = 0;
                                                        while (i2 < valid) {
                                                            normals[i2] = new Vector3f((float)n2[(i2 + initial5) * 3], (float)n2[(i2 + initial5) * 3 + 1], (float)n2[(i2 + initial5) * 3 + 2]);
                                                            ++i2;
                                                        }
                                                    }
                                                } else {
                                                    initial5 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                                    normals = new Vector3f[valid];
                                                    i2 = 0;
                                                    while (i2 < valid) {
                                                        normals[i2] = new Vector3f();
                                                        ++i2;
                                                    }
                                                    geomArray.getNormals(initial5, normals);
                                                }
                                                geomInfo.setNormals(normals);
                                            }
                                            if ((vertexFormat & 0xC) != 12) break block157;
                                            colors2 = null;
                                            if (!byRef) break block158;
                                            initial2 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialColorIndex() : 0;
                                            if (!nio) break block159;
                                            buf = geomArray.getColorRefBuffer();
                                            switch (BufferWrapper.getBufferType(buf)) {
                                                case 3: {
                                                    bb = (FloatBuffer)buf.getBuffer();
                                                    c2 = new float[valid * 4];
                                                    ((FloatBuffer)bb).position(initial2 * 4);
                                                    ((FloatBuffer)bb).get((float[])c2, 0, valid * 4);
                                                    colors2 = new Color4f[valid];
                                                    i2 = 0;
                                                    while (i2 < valid) {
                                                        colors2[i2] = new Color4f(c2[i2 * 4 + 0], c2[i2 * 4 + 1], c2[i2 * 4 + 2], c2[i2 * 4 + 3]);
                                                        ++i2;
                                                    }
                                                    break block160;
                                                }
                                                case 2: {
                                                    bb = (ByteBuffer)buf.getBuffer();
                                                    c2 = new byte[valid * 4];
                                                    ((ByteBuffer)bb).position(initial2 * 4);
                                                    ((ByteBuffer)bb).get((byte[])c2, 0, valid * 4);
                                                    colors2 = new Color4f[valid];
                                                    i2 = 0;
                                                    while (i2 < valid) {
                                                        colors2[i2] = new Color4f((float)(c2[i2 * 4 + 0] & 0xFF) / 255.0f, (float)(c2[i2 * 4 + 1] & 0xFF) / 255.0f, (float)(c2[i2 * 4 + 2] & 0xFF) / 255.0f, (float)(c2[i2 * 4 + 3] & 0xFF) / 255.0f);
                                                        ++i2;
                                                    }
                                                    break block4;
                                                }
                                            }
                                            break block160;
                                        }
                                        if (geomArray.getColorRef4f() != null) {
                                            if (initial2 != 0) {
                                                c3 = geomArray.getColorRef4f();
                                                colors2 = new Color4f[valid];
                                                i2 = 0;
                                                while (i2 < valid) {
                                                    colors2[i2] = new Color4f(c3[i2 + initial2]);
                                                    ++i2;
                                                }
                                            } else {
                                                colors2 = geomArray.getColorRef4f();
                                            }
                                        } else if (geomArray.getColorRefFloat() != null) {
                                            c3 = geomArray.getColorRefFloat();
                                            colors2 = new Color4f[valid];
                                            i2 = 0;
                                            while (i2 < valid) {
                                                colors2[i2] = new Color4f((float)c3[(i2 + initial2) * 4 + 0], (float)c3[(i2 + initial2) * 4 + 1], (float)c3[(i2 + initial2) * 4 + 2], (float)c3[(i2 + initial2) * 4 + 3]);
                                                ++i2;
                                            }
                                        } else if (geomArray.getColorRefByte() != null) {
                                            c3 = geomArray.getColorRefByte();
                                            colors2 = new Color4f[valid];
                                            i2 = 0;
                                            while (i2 < valid) {
                                                colors2[i2] = new Color4f((float)(c3[(i2 + initial2) * 4 + 0] & 0xFF) / 255.0f, (float)(c3[(i2 + initial2) * 4 + 1] & 0xFF) / 255.0f, (float)(c3[(i2 + initial2) * 4 + 2] & 0xFF) / 255.0f, (float)(c3[(i2 + initial2) * 4 + 3] & 0xFF) / 255.0f);
                                                ++i2;
                                            }
                                        } else if (geomArray.getColorRef4b() != null) {
                                            c3 = geomArray.getColorRef4b();
                                            colors2 = new Color4f[valid];
                                            i2 = 0;
                                            while (i2 < valid) {
                                                colors2[i2] = new Color4f((float)(((Color4b)((Object)c3[i2 + initial2])).x & 0xFF) / 255.0f, (float)(((Color4b)((Object)c3[i2 + initial2])).y & 0xFF) / 255.0f, (float)(((Color4b)((Object)c3[i2 + initial2])).z & 0xFF) / 255.0f, (float)(((Color4b)((Object)c3[i2 + initial2])).w & 0xFF) / 255.0f);
                                                ++i2;
                                            }
                                        }
                                        break block160;
                                    }
                                    initial2 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                    colors2 = new Color4f[valid];
                                    i2 = 0;
                                    while (i2 < valid) {
                                        colors2[i2] = new Color4f();
                                        ++i2;
                                    }
                                    geomArray.getColors(initial2, colors2);
                                }
                                geomInfo.setColors(colors2);
                                break block161;
                            }
                            if ((vertexFormat & 4) == 0) break block161;
                            colors = null;
                            if (!byRef) break block162;
                            initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialColorIndex() : 0;
                            if (!nio) break block163;
                            buf = geomArray.getColorRefBuffer();
                            switch (BufferWrapper.getBufferType(buf)) {
                                case 3: {
                                    bb = (FloatBuffer)buf.getBuffer();
                                    c2 = new float[valid * 3];
                                    ((FloatBuffer)bb).position(initial * 3);
                                    ((FloatBuffer)bb).get((float[])c2, 0, valid * 3);
                                    colors = new Color3f[valid];
                                    i2 = 0;
                                    while (i2 < valid) {
                                        colors[i2] = new Color3f(c2[i2 * 3 + 0], c2[i2 * 3 + 1], c2[i2 * 3 + 2]);
                                        ++i2;
                                    }
                                    break block164;
                                }
                                case 2: {
                                    bb = (ByteBuffer)buf.getBuffer();
                                    c2 = new byte[valid * 3];
                                    ((ByteBuffer)bb).position(initial * 3);
                                    ((ByteBuffer)bb).get((byte[])c2, 0, valid * 3);
                                    colors = new Color3f[valid];
                                    i2 = 0;
                                    while (i2 < valid) {
                                        colors[i2] = new Color3f((float)(c2[i2 * 3 + 0] & 0xFF) / 255.0f, (float)(c2[i2 * 3 + 1] & 0xFF) / 255.0f, (float)(c2[i2 * 3 + 2] & 0xFF) / 255.0f);
                                        ++i2;
                                    }
                                    break block8;
                                }
                            }
                            break block164;
                        }
                        if (geomArray.getColorRef3f() != null) {
                            if (initial != 0) {
                                c3 = geomArray.getColorRef3f();
                                colors = new Color3f[valid];
                                i2 = 0;
                                while (i2 < valid) {
                                    colors[i2] = new Color3f((Color3f)((Object)c3[i2 + initial]));
                                    ++i2;
                                }
                            } else {
                                colors = geomArray.getColorRef3f();
                            }
                        } else if (geomArray.getColorRefFloat() != null) {
                            c3 = geomArray.getColorRefFloat();
                            colors = new Color3f[valid];
                            i2 = 0;
                            while (i2 < valid) {
                                colors[i2] = new Color3f((float)c3[(i2 + initial) * 3 + 0], (float)c3[(i2 + initial) * 3 + 1], (float)c3[(i2 + initial) * 3 + 2]);
                                ++i2;
                            }
                        } else if (geomArray.getColorRefByte() != null) {
                            c3 = geomArray.getColorRefByte();
                            colors = new Color3f[valid];
                            i2 = 0;
                            while (i2 < valid) {
                                colors[i2] = new Color3f((float)(c3[(i2 + initial) * 3 + 0] & 0xFF) / 255.0f, (float)(c3[(i2 + initial) * 3 + 1] & 0xFF) / 255.0f, (float)(c3[(i2 + initial) * 3 + 2] & 0xFF) / 255.0f);
                                ++i2;
                            }
                        } else if (geomArray.getColorRef3b() != null) {
                            c3 = geomArray.getColorRef3b();
                            colors = new Color3f[valid];
                            i2 = 0;
                            while (i2 < valid) {
                                colors[i2] = new Color3f((float)(((Color3b)((Object)c3[i2 + initial])).x & 0xFF) / 255.0f, (float)(((Color3b)((Object)c3[i2 + initial])).y & 0xFF) / 255.0f, (float)(((Color3b)((Object)c3[i2 + initial])).z & 0xFF) / 255.0f);
                                ++i2;
                            }
                        }
                        break block164;
                    }
                    initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                    colors = new Color3f[valid];
                    i2 = 0;
                    while (i2 < valid) {
                        colors[i2] = new Color3f();
                        ++i2;
                    }
                    geomArray.getColors(initial, colors);
                }
                geomInfo.setColors(colors);
            }
            if ((vertexFormat & 0x400) != 0) {
                geomInfo.setTextureCoordinateParams(texSets, 4);
                i2 = 0;
                while (i2 < texSets) {
                    int j3;
                    int initial;
                    TexCoord4f[] tex = null;
                    if (byRef) {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialTexCoordIndex(i2) : 0;
                        if (nio) {
                            buf = geomArray.getTexCoordRefBuffer(i2);
                            if (BufferWrapper.getBufferType(buf) == 3) {
                                bb = (FloatBuffer)buf.getBuffer();
                                c2 = new float[valid * 4];
                                ((FloatBuffer)bb).position(initial * 4);
                                ((FloatBuffer)bb).get((float[])c2, 0, valid * 4);
                                tex = new TexCoord4f[valid];
                                j3 = 0;
                                while (j3 < valid) {
                                    tex[j3] = new TexCoord4f(c2[j3 * 4 + 0], c2[j3 * 4 + 1], c2[j3 * 4 + 2], c2[j3 * 4 + 3]);
                                    ++j3;
                                }
                            }
                        } else {
                            t = geomArray.getTexCoordRefFloat(i2);
                            tex = new TexCoord4f[valid];
                            j3 = 0;
                            while (j3 < valid) {
                                tex[j3] = new TexCoord4f(t[(j3 + initial) * 4], t[(j3 + initial) * 4 + 1], t[(j3 + initial) * 4 + 2], t[(j3 + initial) * 4 + 3]);
                                ++j3;
                            }
                        }
                    } else {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                        tex = new TexCoord4f[valid];
                        j3 = 0;
                        while (j3 < valid) {
                            tex[j3] = new TexCoord4f();
                            ++j3;
                        }
                        geomArray.getTextureCoordinates(i2, initial, tex);
                    }
                    geomInfo.setTextureCoordinates(i2, tex);
                    ++i2;
                }
                int[] map = new int[geomArray.getTexCoordSetMapLength()];
                geomArray.getTexCoordSetMap(map);
                geomInfo.setTexCoordSetMap(map);
            } else if ((vertexFormat & 0x40) != 0) {
                geomInfo.setTextureCoordinateParams(texSets, 3);
                i2 = 0;
                while (i2 < texSets) {
                    int j4;
                    int initial;
                    TexCoord3f[] tex = null;
                    if (byRef) {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialTexCoordIndex(i2) : 0;
                        if (nio) {
                            buf = geomArray.getTexCoordRefBuffer(i2);
                            if (BufferWrapper.getBufferType(buf) == 3) {
                                bb = (FloatBuffer)buf.getBuffer();
                                c2 = new float[valid * 3];
                                ((FloatBuffer)bb).position(initial * 3);
                                ((FloatBuffer)bb).get((float[])c2, 0, valid * 3);
                                tex = new TexCoord3f[valid];
                                j4 = 0;
                                while (j4 < valid) {
                                    tex[j4] = new TexCoord3f(c2[j4 * 3 + 0], c2[j4 * 3 + 1], c2[j4 * 3 + 2]);
                                    ++j4;
                                }
                            }
                        } else if (geomArray.getTexCoordRef3f(i2) != null) {
                            if (initial != 0) {
                                t = geomArray.getTexCoordRef3f(i2);
                                tex = new TexCoord3f[valid];
                                j4 = 0;
                                while (j4 < valid) {
                                    tex[j4] = new TexCoord3f((TexCoord3f)t[j4 + initial]);
                                    ++j4;
                                }
                            } else {
                                tex = geomArray.getTexCoordRef3f(i2);
                            }
                        } else if (geomArray.getTexCoordRefFloat(i2) != null) {
                            t = geomArray.getTexCoordRefFloat(i2);
                            tex = new TexCoord3f[valid];
                            j4 = 0;
                            while (j4 < valid) {
                                tex[j4] = new TexCoord3f(t[(j4 + initial) * 3], t[(j4 + initial) * 3 + 1], t[(j4 + initial) * 3 + 2]);
                                ++j4;
                            }
                        }
                    } else {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                        tex = new TexCoord3f[valid];
                        j4 = 0;
                        while (j4 < valid) {
                            tex[j4] = new TexCoord3f();
                            ++j4;
                        }
                        geomArray.getTextureCoordinates(i2, initial, tex);
                    }
                    geomInfo.setTextureCoordinates(i2, tex);
                    ++i2;
                }
                int[] map = new int[geomArray.getTexCoordSetMapLength()];
                geomArray.getTexCoordSetMap(map);
                geomInfo.setTexCoordSetMap(map);
            } else if ((vertexFormat & 0x20) != 0) {
                geomInfo.setTextureCoordinateParams(texSets, 2);
                i2 = 0;
                while (i2 < texSets) {
                    int j5;
                    int initial;
                    TexCoord2f[] tex = null;
                    if (byRef) {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialTexCoordIndex(i2) : 0;
                        if (nio) {
                            buf = geomArray.getTexCoordRefBuffer(i2);
                            if (BufferWrapper.getBufferType(buf) == 3) {
                                bb = (FloatBuffer)buf.getBuffer();
                                c2 = new float[valid * 2];
                                ((FloatBuffer)bb).position(initial * 2);
                                ((FloatBuffer)bb).get((float[])c2, 0, valid * 2);
                                tex = new TexCoord2f[valid];
                                j5 = 0;
                                while (j5 < valid) {
                                    tex[j5] = new TexCoord2f(c2[j5 * 2 + 0], c2[j5 * 2 + 1]);
                                    ++j5;
                                }
                            }
                        } else if (geomArray.getTexCoordRefFloat(i2) != null) {
                            t = geomArray.getTexCoordRefFloat(i2);
                            tex = new TexCoord2f[valid];
                            j5 = 0;
                            while (j5 < valid) {
                                tex[j5] = new TexCoord2f(t[(j5 + initial) * 2 + 0], t[(j5 + initial) * 2 + 1]);
                                ++j5;
                            }
                        } else if (geomArray.getTexCoordRef2f(i2) != null) {
                            if (initial != 0) {
                                t = geomArray.getTexCoordRef2f(i2);
                                tex = new TexCoord2f[valid];
                                j5 = 0;
                                while (j5 < valid) {
                                    tex[j5] = new TexCoord2f((TexCoord2f)t[j5 + initial]);
                                    ++j5;
                                }
                            } else {
                                tex = geomArray.getTexCoordRef2f(i2);
                            }
                        }
                    } else {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                        tex = new TexCoord2f[valid];
                        j5 = 0;
                        while (j5 < valid) {
                            tex[j5] = new TexCoord2f();
                            ++j5;
                        }
                        geomArray.getTextureCoordinates(i2, initial, tex);
                    }
                    geomInfo.setTextureCoordinates(i2, tex);
                    ++i2;
                }
                int[] map = new int[geomArray.getTexCoordSetMapLength()];
                geomArray.getTexCoordSetMap(map);
                geomInfo.setTexCoordSetMap(map);
            }
        }
    }

    private static void processIndexedArray(GeometryInfo geomInfo, IndexedGeometryArray geomArray) {
        block11: {
            int valid;
            int texSets;
            int vertexFormat;
            int initial;
            block10: {
                initial = geomArray.getInitialIndexIndex();
                vertexFormat = geomArray.getVertexFormat();
                texSets = geomArray.getTexCoordSetCount();
                if (geomArray instanceof IndexedGeometryStripArray) {
                    IndexedGeometryStripArray igsa = (IndexedGeometryStripArray)geomArray;
                    int[] strips = new int[igsa.getNumStrips()];
                    igsa.getStripIndexCounts(strips);
                    valid = 0;
                    int i2 = 0;
                    while (i2 < strips.length) {
                        valid += strips[i2];
                        ++i2;
                    }
                } else {
                    valid = geomArray.getValidIndexCount();
                }
                int[] coordI = new int[valid];
                geomArray.getCoordinateIndices(initial, coordI);
                geomInfo.setCoordinateIndices(coordI);
                if ((vertexFormat & 0x200) == 0) break block10;
                if ((vertexFormat & 2) != 0) {
                    geomInfo.setNormalIndices(coordI);
                }
                if ((vertexFormat & 4) != 0 || (vertexFormat & 0xC) != 0) {
                    geomInfo.setColorIndices(coordI);
                }
                if ((vertexFormat & 0x20) == 0 && (vertexFormat & 0x40) == 0 && (vertexFormat & 0x400) == 0) break block11;
                int i3 = 0;
                while (i3 < texSets) {
                    geomInfo.setTextureCoordinateIndices(i3, coordI);
                    ++i3;
                }
                break block11;
            }
            if ((vertexFormat & 2) != 0) {
                int[] normalI = new int[valid];
                geomArray.getNormalIndices(initial, normalI);
                geomInfo.setNormalIndices(normalI);
            }
            if ((vertexFormat & 4) != 0 || (vertexFormat & 0xC) != 0) {
                int[] colorI = new int[valid];
                geomArray.getColorIndices(initial, colorI);
                geomInfo.setColorIndices(colorI);
            }
            if ((vertexFormat & 0x20) != 0 || (vertexFormat & 0x40) != 0 || (vertexFormat & 0x400) != 0) {
                int i4 = 0;
                while (i4 < texSets) {
                    int[] texI = new int[valid];
                    geomArray.getTextureCoordinateIndices(i4, initial, texI);
                    geomInfo.setTextureCoordinateIndices(i4, texI);
                    ++i4;
                }
            }
        }
    }

    private static void processStripArray(GeometryInfo geomInfo, GeometryStripArray geomArray) {
        int[] strips = new int[geomArray.getNumStrips()];
        geomArray.getStripVertexCounts(strips);
        geomInfo.setStripCounts(strips);
    }

    private static void processIndexStripArray(GeometryInfo geomInfo, IndexedGeometryStripArray geomArray) {
        int[] strips = new int[geomArray.getNumStrips()];
        geomArray.getStripIndexCounts(strips);
        geomInfo.setStripCounts(strips);
    }
}

