/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point2f;

class Clean {
    Clean() {
    }

    static void initPUnsorted(Triangulator triRef, int number) {
        if (number > triRef.maxNumPUnsorted) {
            triRef.maxNumPUnsorted = number;
            triRef.pUnsorted = new Point2f[triRef.maxNumPUnsorted];
            int i2 = 0;
            while (i2 < triRef.maxNumPUnsorted) {
                triRef.pUnsorted[i2] = new Point2f();
                ++i2;
            }
        }
    }

    static int cleanPolyhedralFace(Triangulator triRef, int i1, int i2) {
        Clean.initPUnsorted(triRef, triRef.numPoints);
        int i3 = 0;
        while (i3 < triRef.numPoints) {
            triRef.pUnsorted[i3].set(triRef.points[i3]);
            ++i3;
        }
        Clean.sort(triRef.points, triRef.numPoints);
        i3 = 0;
        int j2 = 1;
        while (j2 < triRef.numPoints) {
            if (Clean.pComp(triRef.points[i3], triRef.points[j2]) != 0) {
                triRef.points[++i3] = triRef.points[j2];
            }
            ++j2;
        }
        int numSorted = i3 + 1;
        int removed = triRef.numPoints - numSorted;
        i3 = i1;
        while (i3 < i2) {
            int ind1 = triRef.loops[i3];
            int ind2 = triRef.fetchNextData(ind1);
            int index = triRef.fetchData(ind2);
            while (ind2 != ind1) {
                j2 = Clean.findPInd(triRef.points, numSorted, triRef.pUnsorted[index]);
                triRef.updateIndex(ind2, j2);
                ind2 = triRef.fetchNextData(ind2);
                index = triRef.fetchData(ind2);
            }
            j2 = Clean.findPInd(triRef.points, numSorted, triRef.pUnsorted[index]);
            triRef.updateIndex(ind2, j2);
            ++i3;
        }
        triRef.numPoints = numSorted;
        return removed;
    }

    static void sort(Point2f[] points, int numPts) {
        Point2f swap = new Point2f();
        int i2 = 0;
        while (i2 < numPts) {
            int j2 = i2 + 1;
            while (j2 < numPts) {
                if (Clean.pComp(points[i2], points[j2]) > 0) {
                    swap.set(points[i2]);
                    points[i2].set(points[j2]);
                    points[j2].set(swap);
                }
                ++j2;
            }
            ++i2;
        }
    }

    static int findPInd(Point2f[] sorted, int numPts, Point2f pnt) {
        int i2 = 0;
        while (i2 < numPts) {
            if (pnt.x == sorted[i2].x && pnt.y == sorted[i2].y) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    static int pComp(Point2f a2, Point2f b2) {
        if (a2.x < b2.x) {
            return -1;
        }
        if (a2.x > b2.x) {
            return 1;
        }
        if (a2.y < b2.y) {
            return -1;
        }
        if (a2.y > b2.y) {
            return 1;
        }
        return 0;
    }
}

