/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.BBox;
import org.jogamp.java3d.utils.geometry.Distance;
import org.jogamp.java3d.utils.geometry.Left;
import org.jogamp.java3d.utils.geometry.NoHash;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;

class Bridge {
    Bridge() {
    }

    static void constructBridges(Triangulator triRef, int loopMin, int loopMax) {
        int numDist;
        int numLeftMost;
        int[] i0 = new int[1];
        int[] ind0 = new int[1];
        int[] i1 = new int[1];
        int[] ind1 = new int[1];
        int[] iTmp = new int[1];
        int[] indTmp = new int[1];
        if (!triRef.noHashingEdges) {
            System.out.println("Bridge:constructBridges noHashingEdges is false");
        }
        if (loopMax <= loopMin) {
            System.out.println("Bridge:constructBridges loopMax<=loopMin");
        }
        if (loopMin < 0) {
            System.out.println("Bridge:constructBridges loopMin<0");
        }
        if (loopMax > triRef.numLoops) {
            System.out.println("Bridge:constructBridges loopMax>triRef.numLoops");
        }
        if ((numLeftMost = loopMax - loopMin - 1) > triRef.maxNumLeftMost) {
            triRef.maxNumLeftMost = numLeftMost;
            triRef.leftMost = new Left[numLeftMost];
        }
        Bridge.findLeftMostVertex(triRef, triRef.loops[loopMin], ind0, i0);
        int j2 = 0;
        int i2 = loopMin + 1;
        while (i2 < loopMax) {
            Bridge.findLeftMostVertex(triRef, triRef.loops[i2], indTmp, iTmp);
            triRef.leftMost[j2] = new Left();
            triRef.leftMost[j2].ind = indTmp[0];
            triRef.leftMost[j2].index = iTmp[0];
            ++j2;
            ++i2;
        }
        Bridge.sortLeft(triRef.leftMost, numLeftMost);
        triRef.maxNumDist = numDist = triRef.numPoints + 2 * triRef.numLoops;
        triRef.distances = new Distance[numDist];
        int k2 = 0;
        while (k2 < triRef.maxNumDist) {
            triRef.distances[k2] = new Distance();
            ++k2;
        }
        j2 = 0;
        while (j2 < numLeftMost) {
            Bridge.findBridge(triRef, ind0[0], i0[0], triRef.leftMost[j2].index, ind1, i1);
            if (i1[0] == triRef.leftMost[j2].index) {
                Bridge.simpleBridge(triRef, ind1[0], triRef.leftMost[j2].ind);
            } else {
                Bridge.insertBridge(triRef, ind1[0], i1[0], triRef.leftMost[j2].ind, triRef.leftMost[j2].index);
            }
            ++j2;
        }
    }

    static boolean findBridge(Triangulator triRef, int ind, int i2, int start, int[] ind1, int[] i1) {
        BBox bb;
        int ind2;
        int i22;
        int ind0;
        int i0;
        int k2;
        int numDist = 0;
        Distance[] old = null;
        ind1[0] = ind;
        i1[0] = i2;
        if (i1[0] == start) {
            return true;
        }
        if (numDist >= triRef.maxNumDist) {
            triRef.maxNumDist += 50;
            old = triRef.distances;
            triRef.distances = new Distance[triRef.maxNumDist];
            System.arraycopy(old, 0, triRef.distances, 0, old.length);
            k2 = old.length;
            while (k2 < triRef.maxNumDist) {
                triRef.distances[k2] = new Distance();
                ++k2;
            }
        }
        triRef.distances[numDist].dist = Numerics.baseLength(triRef.points[start], triRef.points[i1[0]]);
        triRef.distances[numDist].ind = ind1[0];
        ++numDist;
        ind1[0] = triRef.fetchNextData(ind1[0]);
        i1[0] = triRef.fetchData(ind1[0]);
        while (ind1[0] != ind) {
            if (i1[0] == start) {
                return true;
            }
            if (numDist >= triRef.maxNumDist) {
                triRef.maxNumDist += 50;
                old = triRef.distances;
                triRef.distances = new Distance[triRef.maxNumDist];
                System.arraycopy(old, 0, triRef.distances, 0, old.length);
                k2 = old.length;
                while (k2 < triRef.maxNumDist) {
                    triRef.distances[k2] = new Distance();
                    ++k2;
                }
            }
            triRef.distances[numDist].dist = Numerics.baseLength(triRef.points[start], triRef.points[i1[0]]);
            triRef.distances[numDist].ind = ind1[0];
            ++numDist;
            ind1[0] = triRef.fetchNextData(ind1[0]);
            i1[0] = triRef.fetchData(ind1[0]);
        }
        Bridge.sortDistance(triRef.distances, numDist);
        int j2 = 0;
        while (j2 < numDist) {
            boolean convex;
            boolean coneOk;
            ind1[0] = triRef.distances[j2].ind;
            i1[0] = triRef.fetchData(ind1[0]);
            if (i1[0] <= start && (coneOk = Numerics.isInCone(triRef, i0 = triRef.fetchData(ind0 = triRef.fetchPrevData(ind1[0])), i1[0], i22 = triRef.fetchData(ind2 = triRef.fetchNextData(ind1[0])), start, convex = triRef.getAngle(ind1[0]) > 0)) && !NoHash.noHashEdgeIntersectionExists(triRef, bb = new BBox(triRef, i1[0], start), -1, -1, ind1[0], -1)) {
                return true;
            }
            ++j2;
        }
        j2 = 0;
        while (j2 < numDist) {
            ind1[0] = triRef.distances[j2].ind;
            i1[0] = triRef.fetchData(ind1[0]);
            ind0 = triRef.fetchPrevData(ind1[0]);
            i0 = triRef.fetchData(ind0);
            ind2 = triRef.fetchNextData(ind1[0]);
            i22 = triRef.fetchData(ind2);
            bb = new BBox(triRef, i1[0], start);
            if (!NoHash.noHashEdgeIntersectionExists(triRef, bb, -1, -1, ind1[0], -1)) {
                return true;
            }
            ++j2;
        }
        ind1[0] = ind;
        i1[0] = i2;
        return false;
    }

    static void findLeftMostVertex(Triangulator triRef, int ind, int[] leftInd, int[] leftI) {
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        leftInd[0] = ind1;
        leftI[0] = i1;
        ind1 = triRef.fetchNextData(ind1);
        i1 = triRef.fetchData(ind1);
        while (ind1 != ind) {
            if (i1 < leftI[0]) {
                leftInd[0] = ind1;
                leftI[0] = i1;
            } else if (i1 == leftI[0] && triRef.getAngle(ind1) < 0) {
                leftInd[0] = ind1;
                leftI[0] = i1;
            }
            ind1 = triRef.fetchNextData(ind1);
            i1 = triRef.fetchData(ind1);
        }
    }

    static void simpleBridge(Triangulator triRef, int ind1, int ind2) {
        triRef.rotateLinks(ind1, ind2);
        int i1 = triRef.fetchData(ind1);
        int next = triRef.fetchNextData(ind1);
        int nxt = triRef.fetchData(next);
        int prev = triRef.fetchPrevData(ind1);
        int prv = triRef.fetchData(prev);
        int angle = Numerics.isConvexAngle(triRef, prv, i1, nxt, ind1);
        triRef.setAngle(ind1, angle);
        int i2 = triRef.fetchData(ind2);
        next = triRef.fetchNextData(ind2);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind2);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i2, nxt, ind2);
        triRef.setAngle(ind2, angle);
    }

    static void insertBridge(Triangulator triRef, int ind1, int i1, int ind3, int i3) {
        int ind2 = triRef.makeNode(i1);
        triRef.insertAfter(ind1, ind2);
        int vcntIndex = triRef.list[ind1].getCommonIndex();
        triRef.list[ind2].setCommonIndex(vcntIndex);
        int ind4 = triRef.makeNode(i3);
        triRef.insertAfter(ind3, ind4);
        vcntIndex = triRef.list[ind3].getCommonIndex();
        triRef.list[ind4].setCommonIndex(vcntIndex);
        triRef.splitSplice(ind1, ind2, ind3, ind4);
        int next = triRef.fetchNextData(ind1);
        int nxt = triRef.fetchData(next);
        int prev = triRef.fetchPrevData(ind1);
        int prv = triRef.fetchData(prev);
        int angle = Numerics.isConvexAngle(triRef, prv, i1, nxt, ind1);
        triRef.setAngle(ind1, angle);
        next = triRef.fetchNextData(ind2);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind2);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i1, nxt, ind2);
        triRef.setAngle(ind2, angle);
        next = triRef.fetchNextData(ind3);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind3);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i3, nxt, ind3);
        triRef.setAngle(ind3, angle);
        next = triRef.fetchNextData(ind4);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind4);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i3, nxt, ind4);
        triRef.setAngle(ind4, angle);
    }

    static int l_comp(Left a2, Left b2) {
        if (a2.index < b2.index) {
            return -1;
        }
        if (a2.index > b2.index) {
            return 1;
        }
        return 0;
    }

    static int d_comp(Distance a2, Distance b2) {
        if (a2.dist < b2.dist) {
            return -1;
        }
        if (a2.dist > b2.dist) {
            return 1;
        }
        return 0;
    }

    static void sortLeft(Left[] lefts, int numPts) {
        Left swap = new Left();
        int i2 = 0;
        while (i2 < numPts) {
            int j2 = i2 + 1;
            while (j2 < numPts) {
                if (Bridge.l_comp(lefts[i2], lefts[j2]) > 0) {
                    swap.copy(lefts[i2]);
                    lefts[i2].copy(lefts[j2]);
                    lefts[j2].copy(swap);
                }
                ++j2;
            }
            ++i2;
        }
    }

    static void sortDistance(Distance[] distances, int numPts) {
        Distance swap = new Distance();
        int i2 = 0;
        while (i2 < numPts) {
            int j2 = i2 + 1;
            while (j2 < numPts) {
                if (Bridge.d_comp(distances[i2], distances[j2]) > 0) {
                    swap.copy(distances[i2]);
                    distances[i2].copy(distances[j2]);
                    distances[j2].copy(swap);
                }
                ++j2;
            }
            ++i2;
        }
    }
}

