/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.compression;

import org.jogamp.java3d.utils.compression.CommandStream;
import org.jogamp.java3d.utils.compression.CompressionStream;
import org.jogamp.java3d.utils.compression.CompressionStreamElement;
import org.jogamp.java3d.utils.compression.HuffmanNode;
import org.jogamp.java3d.utils.compression.HuffmanTable;
import org.jogamp.vecmath.Vector3f;

class CompressionStreamNormal
extends CompressionStreamElement {
    private int u;
    private int v;
    private int specialOctant;
    private int specialSextant;
    private float normalX;
    private float normalY;
    private float normalZ;
    int octant;
    int sextant;
    boolean specialNormal;
    int uAbsolute;
    int vAbsolute;
    private static final int MAX_UV_BITS = 6;
    private static final int MAX_UV_ENTRIES = 64;
    private static final double[][][][] cgNormals = new double[7][65][65][3];
    private static final double MAX_Y_ANG = 0.615479709;
    private static final double UNITY_14 = 16384.0;
    private static final short[][] inverseSine = new short[7][];
    private static final short MAX_SIN_14BIT = 9459;

    static {
        CompressionStreamNormal.computeNormals();
        CompressionStreamNormal.computeInverseSineTables();
    }

    CompressionStreamNormal(CompressionStream stream, Vector3f normal) {
        this.normalX = normal.x;
        this.normalY = normal.y;
        this.normalZ = normal.z;
        stream.byteCount += 12;
    }

    private static void computeNormals() {
        int quant = 0;
        while (quant <= 6) {
            int n2 = 1 << quant;
            int j2 = 0;
            while (j2 <= n2) {
                int i2 = 0;
                while (i2 <= n2) {
                    if (i2 + j2 <= n2) {
                        double psi = 0.615479709 * ((double)j2 / (double)n2);
                        double th = Math.asin(Math.tan(0.615479709 * ((double)(n2 - i2) / (double)n2)));
                        double qnx = Math.cos(th) * Math.cos(psi);
                        double qny = Math.sin(psi);
                        double qnz = Math.sin(th) * Math.cos(psi);
                        int inx = (int)(qnx *= 16384.0);
                        qnx = inx;
                        int iny = (int)(qny *= 16384.0);
                        qny = iny;
                        int inz = (int)(qnz *= 16384.0);
                        qnz = inz;
                        CompressionStreamNormal.cgNormals[quant][j2][i2][0] = qnx /= 16384.0;
                        CompressionStreamNormal.cgNormals[quant][j2][i2][1] = qny /= 16384.0;
                        CompressionStreamNormal.cgNormals[quant][j2][i2][2] = qnz /= 16384.0;
                    }
                    ++i2;
                }
                ++j2;
            }
            ++quant;
        }
    }

    private static void computeInverseSineTables() {
        short[] sin14 = new short[65];
        int i2 = 0;
        while (i2 <= 64) {
            sin14[i2] = (short)(16384.0 * Math.sin((double)i2 * 0.615479709 / 64.0));
            ++i2;
        }
        int quant = 0;
        while (quant <= 6) {
            int deltaSin;
            switch (quant) {
                default: {
                    deltaSin = 64;
                    break;
                }
                case 5: {
                    deltaSin = 128;
                    break;
                }
                case 4: {
                    deltaSin = 256;
                    break;
                }
                case 3: {
                    deltaSin = 512;
                    break;
                }
                case 2: {
                    deltaSin = 1024;
                    break;
                }
                case 1: {
                    deltaSin = 2048;
                    break;
                }
                case 0: {
                    deltaSin = 4096;
                }
            }
            CompressionStreamNormal.inverseSine[quant] = new short[9459 / deltaSin + 1];
            int intSin = 0;
            int i3 = 0;
            while (i3 < inverseSine[quant].length) {
                double floatSin = (double)intSin / 16384.0;
                double floatAngle = Math.asin(floatSin);
                int intAngle = (int)(floatAngle / 0.615479709 * (double)(1 << quant));
                if (intAngle > 0 && Math.abs(sin14[intAngle << 6 - quant] - intSin) > Math.abs(sin14[intAngle - 1 << 6 - quant] - intSin)) {
                    --intAngle;
                }
                if (intAngle < 1 << quant && Math.abs(sin14[intAngle << 6 - quant] - intSin) > Math.abs(sin14[intAngle + 1 << 6 - quant] - intSin)) {
                    ++intAngle;
                }
                CompressionStreamNormal.inverseSine[quant][i3] = (short)intAngle;
                intSin += deltaSin;
                ++i3;
            }
            ++quant;
        }
    }

    @Override
    void quantize(CompressionStream stream, HuffmanTable huffmanTable) {
        double t;
        int quant = stream.normalQuant < 0 ? 0 : (stream.normalQuant > 6 ? 6 : stream.normalQuant);
        double nx = this.normalX;
        double ny = this.normalY;
        double nz = this.normalZ;
        this.octant = 0;
        this.sextant = 0;
        this.u = 0;
        this.v = 0;
        if (nx < 0.0) {
            this.octant |= 4;
            nx = -nx;
        }
        if (ny < 0.0) {
            this.octant |= 2;
            ny = -ny;
        }
        if (nz < 0.0) {
            this.octant |= 1;
            nz = -nz;
        }
        if (nx < ny) {
            this.sextant |= 1;
            t = nx;
            nx = ny;
            ny = t;
        }
        if (nz < ny) {
            this.sextant |= 2;
            t = ny;
            ny = nz;
            nz = t;
        }
        if (nx < nz) {
            this.sextant |= 4;
            t = nx;
            nx = nz;
            nz = t;
        }
        int yInt = (int)(ny * 16384.0);
        short yIndex = inverseSine[quant][yInt >> 12 - quant];
        int ii = 0;
        int jj = 0;
        int n2 = 1 << quant;
        double bestDot = -1.0;
        int j2 = yIndex - 1;
        while (j2 < yIndex + 1 && j2 <= n2) {
            if (j2 >= 0) {
                int i2 = 0;
                while (i2 <= n2) {
                    double dot;
                    if (i2 + j2 <= n2 && (dot = nx * cgNormals[quant][j2][i2][0] + ny * cgNormals[quant][j2][i2][1] + nz * cgNormals[quant][j2][i2][2]) > bestDot) {
                        bestDot = dot;
                        ii = i2;
                        jj = j2;
                    }
                    ++i2;
                }
            }
            ++j2;
        }
        this.u = ii << 6 - quant;
        this.v = jj << 6 - quant;
        this.specialNormal = false;
        if (this.u == 64 && this.v == 0) {
            if (this.sextant == 0 || this.sextant == 2) {
                this.specialSextant = 6;
                this.specialOctant = (this.octant & 4) != 0 ? 2 : 0;
            } else if (this.sextant == 3 || this.sextant == 1) {
                this.specialSextant = 6;
                this.specialOctant = 4 | ((this.octant & 2) != 0 ? 2 : 0);
            } else if (this.sextant == 5 || this.sextant == 4) {
                this.specialSextant = 7;
                this.specialOctant = (this.octant & 1) != 0 ? 2 : 0;
            }
            this.specialNormal = true;
            this.v = 0;
            this.u = 0;
        } else if (this.u == 0 && this.v == 64) {
            this.specialSextant = 6 | this.octant >> 2;
            this.specialOctant = (this.octant & 3) << 1 | 1;
            this.specialNormal = true;
            this.v = 0;
            this.u = 0;
        }
        int du = 0;
        int dv = 0;
        int uv64 = 64 >> 6 - quant;
        this.absolute = false;
        if (stream.firstNormal || stream.normalQuantChanged || stream.lastSpecialNormal || this.specialNormal) {
            this.absolute = true;
            stream.firstNormal = false;
            stream.normalQuantChanged = false;
        } else if (stream.lastOctant == this.octant && stream.lastSextant == this.sextant) {
            du = ii - stream.lastU;
            dv = jj - stream.lastV;
        } else if (stream.lastOctant != this.octant && stream.lastSextant == this.sextant && ((this.sextant == 1 || this.sextant == 5) && (stream.lastOctant & 3) == (this.octant & 3) || (this.sextant == 0 || this.sextant == 4) && (stream.lastOctant & 5) == (this.octant & 5) || (this.sextant == 2 || this.sextant == 3) && (stream.lastOctant & 6) == (this.octant & 6))) {
            du = ii - stream.lastU;
            dv = -jj - stream.lastV;
            if (dv < -uv64) {
                this.absolute = true;
            }
            if (jj == 0) {
                this.absolute = true;
            }
        } else if (stream.lastOctant == this.octant && stream.lastSextant != this.sextant && (this.sextant == 0 && stream.lastSextant == 4 || this.sextant == 4 && stream.lastSextant == 0 || this.sextant == 1 && stream.lastSextant == 5 || this.sextant == 5 && stream.lastSextant == 1 || this.sextant == 2 && stream.lastSextant == 3 || this.sextant == 3 && stream.lastSextant == 2)) {
            du = -ii - stream.lastU;
            dv = jj - stream.lastV;
            if (du < -uv64) {
                this.absolute = true;
            }
            if (ii == 0) {
                this.absolute = true;
            }
        } else if (stream.lastOctant == this.octant && stream.lastSextant != this.sextant && (this.sextant == 0 && stream.lastSextant == 2 || this.sextant == 2 && stream.lastSextant == 0 || this.sextant == 1 && stream.lastSextant == 3 || this.sextant == 3 && stream.lastSextant == 1 || this.sextant == 4 && stream.lastSextant == 5 || this.sextant == 5 && stream.lastSextant == 4)) {
            if (ii + jj != uv64 && ii != 0 && jj != 0) {
                du = uv64 - ii - stream.lastU;
                dv = uv64 - jj - stream.lastV;
                if (du >= uv64 || dv >= uv64) {
                    this.absolute = true;
                }
            } else {
                this.absolute = true;
            }
        } else {
            this.absolute = true;
        }
        if (!this.absolute) {
            this.u = du << 6 - quant;
            this.v = dv << 6 - quant;
        }
        this.computeLengthShift(this.u, this.v);
        if (this.absolute && this.length > 6) {
            this.length = 6;
        }
        huffmanTable.addNormalEntry(this.length, this.shift, this.absolute);
        stream.lastSextant = this.sextant;
        stream.lastOctant = this.octant;
        stream.lastU = ii;
        stream.lastV = jj;
        stream.lastSpecialNormal = this.specialNormal;
        this.uAbsolute = ii;
        this.vAbsolute = jj;
    }

    @Override
    void outputCommand(HuffmanTable table, CommandStream output) {
        this.outputNormal(table, output, 192, 8);
    }

    void outputSubcommand(HuffmanTable table, CommandStream output) {
        this.outputNormal(table, output, 0, 6);
    }

    private void outputNormal(HuffmanTable table, CommandStream output, int header, int headerLength) {
        HuffmanNode t = table.getNormalEntry(this.length, this.shift, this.absolute);
        int componentLength = t.dataLength - t.shift;
        int subcommandLength = 0;
        long normalSubcommand = 0L;
        if (this.absolute) {
            subcommandLength = t.tagLength + 6;
            normalSubcommand = this.specialNormal ? (long)(t.tag << 6 | this.specialSextant << 3 | this.specialOctant) : (long)(t.tag << 6 | this.sextant << 3 | this.octant);
        } else {
            subcommandLength = t.tagLength;
            normalSubcommand = t.tag;
        }
        this.u = this.u >> t.shift & (int)lengthMask[componentLength];
        this.v = this.v >> t.shift & (int)lengthMask[componentLength];
        normalSubcommand = normalSubcommand << 2 * componentLength | (long)(this.u << 1 * componentLength) | (long)(this.v << 0 * componentLength);
        if ((subcommandLength += 2 * componentLength) < 6) {
            header |= (int)(normalSubcommand << 6 - subcommandLength);
            subcommandLength = 0;
        } else {
            header |= (int)(normalSubcommand >>> subcommandLength - 6);
            subcommandLength -= 6;
        }
        output.addCommand(header, headerLength, normalSubcommand, subcommandLength);
    }

    public String toString() {
        String fixed = this.specialNormal ? " special normal, sextant " + this.specialSextant + " octant " + this.specialOctant : (this.absolute ? " sextant " + this.sextant + " octant " + this.octant + " u " + this.u + " v " + this.v : " du " + this.u + " dv " + this.v);
        return "normal: " + this.normalX + " " + this.normalY + " " + this.normalZ + "\n" + fixed + "\n" + " length " + this.length + " shift " + this.shift + (this.absolute ? " absolute" : " relative");
    }
}

