/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.compression;

import org.jogamp.java3d.utils.compression.CompressionStreamElement;

class CommandStream {
    static final int SET_NORM = 192;
    static final int SET_COLOR = 128;
    static final int VERTEX = 64;
    static final int MESH_B_R = 32;
    static final int SET_STATE = 24;
    static final int SET_TABLE = 16;
    static final int V_NO_OP = 1;
    static final int POSITION_TABLE = 0;
    static final int COLOR_TABLE = 1;
    static final int NORMAL_TABLE = 2;
    private byte[] bytes;
    private int byteOffset;
    private int bitOffset;
    private long lastBody;
    private int lastBodyLength;

    CommandStream() {
        this(65536);
    }

    CommandStream(int initSize) {
        this.bytes = new byte[initSize];
        this.clear();
    }

    void clear() {
        this.bytes[0] = 0;
        this.bitOffset = 0;
        this.byteOffset = 0;
        this.lastBody = 0L;
        this.lastBodyLength = 5;
    }

    void addCommand(int header, int headerLength, long body, int bodyLength) {
        this.addByte(header, headerLength);
        this.addLong(this.lastBody, this.lastBodyLength);
        this.lastBody = body;
        this.lastBodyLength = bodyLength;
    }

    private void addByte(int b2, int bitCount) {
        int bitsEmpty = 8 - this.bitOffset;
        b2 &= (int)CompressionStreamElement.lengthMask[bitCount];
        if (bitCount <= bitsEmpty) {
            int n2 = this.byteOffset;
            this.bytes[n2] = (byte)(this.bytes[n2] | b2 << bitsEmpty - bitCount);
            this.bitOffset += bitCount;
            return;
        }
        if (this.bytes.length == this.byteOffset + 1) {
            byte[] newBytes = new byte[this.bytes.length * 2];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
            this.bytes = newBytes;
        }
        this.bitOffset = bitCount - bitsEmpty;
        int n3 = this.byteOffset++;
        this.bytes[n3] = (byte)(this.bytes[n3] | b2 >>> this.bitOffset);
        this.bytes[this.byteOffset] = (byte)(b2 << 8 - this.bitOffset);
    }

    private void addLong(long l2, int bitCount) {
        int byteCount = bitCount / 8;
        int excessBits = bitCount - byteCount * 8;
        if (excessBits > 0) {
            this.addByte((int)(l2 >>> byteCount * 8), excessBits);
        }
        while (byteCount > 0) {
            this.addByte((int)(l2 >>> (byteCount - 1) * 8 & 0xFFL), 8);
            --byteCount;
        }
    }

    void end() {
        int padBits;
        this.addByte(1, 8);
        this.addLong(this.lastBody, this.lastBodyLength);
        int excessBytes = (this.byteOffset + 1) % 8;
        if (excessBytes == 0 && this.bitOffset == 8) {
            return;
        }
        this.addByte(1, 8);
        excessBytes = (this.byteOffset + 1) % 8;
        if (excessBytes == 0) {
            padBits = 8 - this.bitOffset;
        } else {
            int fillBytes = 8 - excessBytes;
            padBits = 8 * fillBytes + (8 - this.bitOffset);
        }
        if (padBits < 5) {
            padBits += 64;
        }
        if (padBits < 37) {
            this.addLong(padBits - 5 << padBits - 5, padBits);
            return;
        }
        this.addLong(0x980000L, 24);
        padBits -= 24;
        this.addByte(1, 8);
        this.addLong((padBits -= 8) - 5 << padBits - 5, padBits);
    }

    int getByteCount() {
        if (this.byteOffset + this.bitOffset == 0) {
            return 0;
        }
        return this.byteOffset + 1;
    }

    byte[] getBytes() {
        return this.bytes;
    }
}

