/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.vp;

import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnBehaviorPost;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.java3d.utils.behaviors.vp.ViewPlatformBehavior;
import org.jogamp.java3d.utils.universe.Viewer;
import org.jogamp.java3d.utils.universe.ViewingPlatform;

public abstract class ViewPlatformAWTBehavior
extends ViewPlatformBehavior
implements MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener {
    private static final boolean DEBUG = false;
    protected static final int POST_ID = 9998;
    protected WakeupOnElapsedFrames frameWakeup;
    protected WakeupOnBehaviorPost postWakeup;
    protected Transform3D targetTransform = new Transform3D();
    protected boolean motion = false;
    public static final int MOUSE_LISTENER = 1;
    public static final int MOUSE_MOTION_LISTENER = 2;
    public static final int KEY_LISTENER = 4;
    public static final int MOUSE_WHEEL_LISTENER = 8;
    protected Canvas3D[] canvases;
    private ArrayList eventQueue = new ArrayList();
    private int listenerFlags = 0;
    private boolean firstEvent = false;

    protected ViewPlatformAWTBehavior() {
    }

    protected ViewPlatformAWTBehavior(int listenerFlags) {
        this.setListenerFlags(listenerFlags);
    }

    public ViewPlatformAWTBehavior(Canvas3D c2, int listenerFlags) {
        if (c2 == null) {
            throw new NullPointerException();
        }
        this.canvases = new Canvas3D[]{c2};
        this.setListenerFlags(listenerFlags);
    }

    protected void setListenerFlags(int listenerFlags) {
        this.listenerFlags = listenerFlags;
    }

    @Override
    public void initialize() {
        this.frameWakeup = new WakeupOnElapsedFrames(0);
        this.postWakeup = new WakeupOnBehaviorPost(this, 9998);
        this.wakeupOn(this.postWakeup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Iterator<WakeupCriterion> behEnum) {
        boolean hadPost = false;
        while (behEnum.hasNext()) {
            WakeupCondition wakeup = behEnum.next();
            if (wakeup instanceof WakeupOnBehaviorPost) {
                hadPost = true;
                continue;
            }
            if (!(wakeup instanceof WakeupOnElapsedFrames)) continue;
            AWTEvent[] events = null;
            ArrayList arrayList = this.eventQueue;
            synchronized (arrayList) {
                events = this.eventQueue.toArray(new AWTEvent[this.eventQueue.size()]);
                this.eventQueue.clear();
            }
            this.processAWTEvents(events);
            if (!this.motion) continue;
            this.integrateTransforms();
        }
        if (this.motion || hadPost) {
            this.wakeupOn(this.frameWakeup);
        } else {
            this.wakeupOn(this.postWakeup);
        }
    }

    @Override
    public void setEnable(boolean state) {
        if (state == this.getEnable()) {
            return;
        }
        super.setEnable(state);
        if (this.canvases != null) {
            this.enableListeners(state);
        }
    }

    private void enableListeners(boolean enable) {
        block16: {
            int i2;
            block15: {
                int i3;
                if (!enable) break block15;
                this.firstEvent = true;
                if ((this.listenerFlags & 1) != 0) {
                    i3 = 0;
                    while (i3 < this.canvases.length) {
                        this.canvases[i3].addMouseListener(this);
                        ++i3;
                    }
                }
                if ((this.listenerFlags & 2) != 0) {
                    i3 = 0;
                    while (i3 < this.canvases.length) {
                        this.canvases[i3].addMouseMotionListener(this);
                        ++i3;
                    }
                }
                if ((this.listenerFlags & 8) != 0) {
                    i3 = 0;
                    while (i3 < this.canvases.length) {
                        this.canvases[i3].addMouseWheelListener(this);
                        ++i3;
                    }
                }
                if ((this.listenerFlags & 4) == 0) break block16;
                i3 = 0;
                while (i3 < this.canvases.length) {
                    this.canvases[i3].addKeyListener(this);
                    ++i3;
                }
                break block16;
            }
            if ((this.listenerFlags & 1) != 0) {
                i2 = 0;
                while (i2 < this.canvases.length) {
                    this.canvases[i2].removeMouseListener(this);
                    ++i2;
                }
            }
            if ((this.listenerFlags & 2) != 0) {
                i2 = 0;
                while (i2 < this.canvases.length) {
                    this.canvases[i2].removeMouseMotionListener(this);
                    ++i2;
                }
            }
            if ((this.listenerFlags & 8) != 0) {
                i2 = 0;
                while (i2 < this.canvases.length) {
                    this.canvases[i2].removeMouseWheelListener(this);
                    ++i2;
                }
            }
            if ((this.listenerFlags & 4) != 0) {
                i2 = 0;
                while (i2 < this.canvases.length) {
                    this.canvases[i2].removeKeyListener(this);
                    ++i2;
                }
            }
        }
    }

    @Override
    public void setViewingPlatform(ViewingPlatform vp) {
        super.setViewingPlatform(vp);
        if (vp == null) {
            this.enableListeners(false);
        } else {
            Viewer[] viewers;
            if (this.canvases != null) {
                this.enableListeners(false);
            }
            if ((viewers = vp.getViewers()) != null && viewers[0] != null) {
                this.canvases = viewers[0].getCanvas3Ds();
            }
            if (this.canvases == null || this.canvases[0] == null) {
                throw new IllegalStateException("No canvases available");
            }
            if (this.getEnable()) {
                this.enableListeners(true);
            }
        }
    }

    protected abstract void processAWTEvents(AWTEvent[] var1);

    protected abstract void integrateTransforms();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueAWTEvent(AWTEvent e2) {
        ArrayList arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(e2);
            if (this.firstEvent || this.eventQueue.size() == 1) {
                this.firstEvent = false;
                this.postId(9998);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void keyPressed(KeyEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        this.queueAWTEvent(e2);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        this.queueAWTEvent(e2);
    }
}

