/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.vp;

import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.behaviors.vp.ViewPlatformAWTBehavior;
import org.jogamp.java3d.utils.universe.ViewingPlatform;
import org.jogamp.vecmath.Matrix3d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class OrbitBehavior
extends ViewPlatformAWTBehavior {
    private Transform3D longditudeTransform = new Transform3D();
    private Transform3D latitudeTransform = new Transform3D();
    private Transform3D rotateTransform = new Transform3D();
    private Transform3D temp1 = new Transform3D();
    private Transform3D temp2 = new Transform3D();
    private Transform3D translation = new Transform3D();
    private Vector3d transVector = new Vector3d();
    private Vector3d distanceVector = new Vector3d();
    private Vector3d centerVector = new Vector3d();
    private Vector3d invertCenterVector = new Vector3d();
    private double longditude = 0.0;
    private double latitude = 0.0;
    private double startDistanceFromCenter = 20.0;
    private double distanceFromCenter = 20.0;
    private Point3d rotationCenter = new Point3d();
    private Matrix3d rotMatrix = new Matrix3d();
    private Transform3D currentXfm = new Transform3D();
    private int mouseX = 0;
    private int mouseY = 0;
    private double rotXFactor = 1.0;
    private double rotYFactor = 1.0;
    private double transXFactor = 1.0;
    private double transYFactor = 1.0;
    private double zoomFactor = 1.0;
    private double xtrans = 0.0;
    private double ytrans = 0.0;
    private double ztrans = 0.0;
    private boolean zoomEnabled = true;
    private boolean rotateEnabled = true;
    private boolean translateEnabled = true;
    private boolean reverseRotate = false;
    private boolean reverseTrans = false;
    private boolean reverseZoom = false;
    private boolean stopZoom = false;
    private boolean proportionalZoom = false;
    private double minRadius = 0.0;
    private int leftButton = 0;
    private int rightButton = 1;
    private int middleButton = 2;
    private float wheelZoomFactor = 50.0f;
    public static final int REVERSE_ROTATE = 16;
    public static final int REVERSE_TRANSLATE = 32;
    public static final int REVERSE_ZOOM = 64;
    public static final int REVERSE_ALL = 112;
    public static final int STOP_ZOOM = 256;
    public static final int DISABLE_ROTATE = 512;
    public static final int DISABLE_TRANSLATE = 1024;
    public static final int DISABLE_ZOOM = 2048;
    public static final int PROPORTIONAL_ZOOM = 4096;
    private static final int ROTATE = 0;
    private static final int TRANSLATE = 1;
    private static final int ZOOM = 2;
    private static final double NOMINAL_ZOOM_FACTOR = 0.01;
    private static final double NOMINAL_PZOOM_FACTOR = 1.0;
    private static final double NOMINAL_ROT_FACTOR = 0.01;
    private static final double NOMINAL_TRANS_FACTOR = 0.01;
    private double rotXMul = 0.01 * this.rotXFactor;
    private double rotYMul = 0.01 * this.rotYFactor;
    private double transXMul = 0.01 * this.transXFactor;
    private double transYMul = 0.01 * this.transYFactor;
    private double zoomMul = 0.01 * this.zoomFactor;

    public OrbitBehavior() {
        super(11);
    }

    public OrbitBehavior(Canvas3D c2) {
        this(c2, 0);
    }

    public OrbitBehavior(Canvas3D c2, int flags) {
        super(c2, 0xB | flags);
        if ((flags & 0x200) != 0) {
            this.rotateEnabled = false;
        }
        if ((flags & 0x800) != 0) {
            this.zoomEnabled = false;
        }
        if ((flags & 0x400) != 0) {
            this.translateEnabled = false;
        }
        if ((flags & 0x20) != 0) {
            this.reverseTrans = true;
        }
        if ((flags & 0x10) != 0) {
            this.reverseRotate = true;
        }
        if ((flags & 0x40) != 0) {
            this.reverseZoom = true;
        }
        if ((flags & 0x100) != 0) {
            this.stopZoom = true;
        }
        if ((flags & 0x1000) != 0) {
            this.proportionalZoom = true;
            this.zoomMul = 1.0 * this.zoomFactor;
        }
    }

    @Override
    protected synchronized void processAWTEvents(AWTEvent[] events) {
        this.motion = false;
        int i2 = 0;
        while (i2 < events.length) {
            if (events[i2] instanceof MouseEvent) {
                this.processMouseEvent((MouseEvent)events[i2]);
            }
            ++i2;
        }
    }

    protected void processMouseEvent(MouseEvent evt) {
        if (evt.getID() == 501) {
            this.mouseX = evt.getX();
            this.mouseY = evt.getY();
            this.motion = true;
        } else if (evt.getID() == 506) {
            int xchange = evt.getX() - this.mouseX;
            int ychange = evt.getY() - this.mouseY;
            if (this.rotate(evt)) {
                if (this.reverseRotate) {
                    this.longditude -= (double)xchange * this.rotXMul;
                    this.latitude -= (double)ychange * this.rotYMul;
                } else {
                    this.longditude += (double)xchange * this.rotXMul;
                    this.latitude += (double)ychange * this.rotYMul;
                }
            } else if (this.translate(evt)) {
                if (this.reverseTrans) {
                    this.xtrans -= (double)xchange * this.transXMul;
                    this.ytrans += (double)ychange * this.transYMul;
                } else {
                    this.xtrans += (double)xchange * this.transXMul;
                    this.ytrans -= (double)ychange * this.transYMul;
                }
            } else if (this.zoom(evt)) {
                this.doZoomOperations(ychange);
            }
            this.mouseX = evt.getX();
            this.mouseY = evt.getY();
            this.motion = true;
        } else if (evt.getID() != 502 && evt.getID() == 507 && this.zoom(evt) && evt instanceof MouseWheelEvent) {
            int zoom = (int)((float)((MouseWheelEvent)evt).getWheelRotation() * this.wheelZoomFactor);
            this.doZoomOperations(zoom);
            this.motion = true;
        }
    }

    private void doZoomOperations(int ychange) {
        this.distanceFromCenter = this.proportionalZoom ? (this.reverseZoom ? (this.distanceFromCenter - this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0 > this.minRadius ? (this.distanceFromCenter -= this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0) : this.minRadius) : (this.distanceFromCenter + this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0 > this.minRadius ? (this.distanceFromCenter += this.zoomMul * (double)ychange * this.distanceFromCenter / 100.0) : this.minRadius)) : (this.stopZoom ? (this.reverseZoom ? (this.distanceFromCenter - (double)ychange * this.zoomMul > this.minRadius ? (this.distanceFromCenter -= (double)ychange * this.zoomMul) : this.minRadius) : (this.distanceFromCenter + (double)ychange * this.zoomMul > this.minRadius ? (this.distanceFromCenter += (double)ychange * this.zoomMul) : this.minRadius)) : (this.reverseZoom ? (this.distanceFromCenter -= (double)ychange * this.zoomMul) : (this.distanceFromCenter += (double)ychange * this.zoomMul)));
    }

    @Override
    public void setViewingPlatform(ViewingPlatform vp) {
        super.setViewingPlatform(vp);
        if (vp != null) {
            this.resetView();
            this.integrateTransforms();
        }
    }

    private void resetView() {
        Vector3d centerToView = new Vector3d();
        this.targetTG.getTransform(this.targetTransform);
        this.targetTransform.get(this.rotMatrix, this.transVector);
        centerToView.sub(this.transVector, this.rotationCenter);
        this.startDistanceFromCenter = this.distanceFromCenter = centerToView.length();
        this.targetTransform.get(this.rotMatrix);
        this.rotateTransform.set(this.rotMatrix);
        this.temp1.set(centerToView);
        this.rotateTransform.invert();
        this.rotateTransform.mul(this.temp1);
        this.rotateTransform.get(centerToView);
        this.xtrans = centerToView.x;
        this.ytrans = centerToView.y;
        this.ztrans = centerToView.z;
        this.rotateTransform.set(this.rotMatrix);
    }

    @Override
    protected synchronized void integrateTransforms() {
        this.targetTG.getTransform(this.currentXfm);
        if (!this.targetTransform.equals(this.currentXfm)) {
            this.resetView();
        }
        this.longditudeTransform.rotY(this.longditude);
        this.latitudeTransform.rotX(this.latitude);
        this.rotateTransform.mul(this.rotateTransform, this.latitudeTransform);
        this.rotateTransform.mul(this.rotateTransform, this.longditudeTransform);
        this.distanceVector.z = this.distanceFromCenter - this.startDistanceFromCenter;
        this.temp1.set(this.distanceVector);
        this.temp1.mul(this.rotateTransform, this.temp1);
        this.transVector.x = this.rotationCenter.x + this.xtrans;
        this.transVector.y = this.rotationCenter.y + this.ytrans;
        this.transVector.z = this.rotationCenter.z + this.ztrans;
        this.translation.set(this.transVector);
        this.targetTransform.mul(this.temp1, this.translation);
        this.temp1.set(this.centerVector);
        this.temp1.mul(this.targetTransform);
        this.invertCenterVector.x = -this.centerVector.x;
        this.invertCenterVector.y = -this.centerVector.y;
        this.invertCenterVector.z = -this.centerVector.z;
        this.temp2.set(this.invertCenterVector);
        this.targetTransform.mul(this.temp1, this.temp2);
        this.targetTG.setTransform(this.targetTransform);
        this.longditude = 0.0;
        this.latitude = 0.0;
    }

    public synchronized void setRotationCenter(Point3d center) {
        Point3d centerDelta = new Point3d();
        centerDelta.sub(this.centerVector, center);
        Transform3D invRot = new Transform3D(this.rotateTransform);
        invRot.invert();
        invRot.transform(centerDelta);
        this.xtrans += centerDelta.x;
        this.ytrans += centerDelta.y;
        this.ztrans += centerDelta.z;
        this.rotationCenter.x = center.x;
        this.rotationCenter.y = center.y;
        this.rotationCenter.z = center.z;
        this.centerVector.set(this.rotationCenter);
    }

    public void RotationCenter(Object[] center) {
        if (center.length != 1 || !(center[0] instanceof Point3d)) {
            throw new IllegalArgumentException("RotationCenter must be a single Point3d");
        }
        this.setRotationCenter((Point3d)center[0]);
    }

    public void getRotationCenter(Point3d center) {
        center.x = this.rotationCenter.x;
        center.y = this.rotationCenter.y;
        center.z = this.rotationCenter.z;
    }

    public synchronized void setRotFactors(double xfactor, double yfactor) {
        this.rotXFactor = xfactor;
        this.rotYFactor = yfactor;
        this.rotXMul = 0.01 * xfactor;
        this.rotYMul = 0.01 * yfactor;
    }

    public void RotFactors(Object[] factors) {
        if (factors.length != 2 || !(factors[0] instanceof Double) || !(factors[1] instanceof Double)) {
            throw new IllegalArgumentException("RotFactors must be two Doubles");
        }
        this.setRotFactors((Double)factors[0], (Double)factors[1]);
    }

    public synchronized void setRotXFactor(double xfactor) {
        this.rotXFactor = xfactor;
        this.rotXMul = 0.01 * xfactor;
    }

    public void RotXFactor(Object[] xFactor) {
        if (xFactor.length != 1 || !(xFactor[0] instanceof Double)) {
            throw new IllegalArgumentException("RotXFactor must be a Double");
        }
        this.setRotXFactor((Double)xFactor[0]);
    }

    public synchronized void setRotYFactor(double yfactor) {
        this.rotYFactor = yfactor;
        this.rotYMul = 0.01 * yfactor;
    }

    public void RotYFactor(Object[] yFactor) {
        if (yFactor.length != 1 || !(yFactor[0] instanceof Double)) {
            throw new IllegalArgumentException("RotYFactor must be a Double");
        }
        this.setRotYFactor((Double)yFactor[0]);
    }

    public synchronized void setTransFactors(double xfactor, double yfactor) {
        this.transXFactor = xfactor;
        this.transYFactor = yfactor;
        this.transXMul = 0.01 * xfactor;
        this.transYMul = 0.01 * yfactor;
    }

    public void TransFactors(Object[] factors) {
        if (factors.length != 2 || !(factors[0] instanceof Double) || !(factors[1] instanceof Double)) {
            throw new IllegalArgumentException("TransFactors must be two Doubles");
        }
        this.setTransFactors((Double)factors[0], (Double)factors[1]);
    }

    public synchronized void setTransXFactor(double xfactor) {
        this.transXFactor = xfactor;
        this.transXMul = 0.01 * xfactor;
    }

    public void TransXFactor(Object[] xFactor) {
        if (xFactor.length != 1 || !(xFactor[0] instanceof Double)) {
            throw new IllegalArgumentException("TransXFactor must be a Double");
        }
        this.setTransXFactor((Double)xFactor[0]);
    }

    public synchronized void setTransYFactor(double yfactor) {
        this.transYFactor = yfactor;
        this.transYMul = 0.01 * yfactor;
    }

    public void TransYFactor(Object[] yFactor) {
        if (yFactor.length != 1 || !(yFactor[0] instanceof Double)) {
            throw new IllegalArgumentException("TransYFactor must be a Double");
        }
        this.setTransYFactor((Double)yFactor[0]);
    }

    public synchronized void setZoomFactor(double zfactor) {
        this.zoomFactor = zfactor;
        this.zoomMul = this.proportionalZoom ? 1.0 * zfactor : 0.01 * zfactor;
    }

    public void ZoomFactor(Object[] zFactor) {
        if (zFactor.length != 1 || !(zFactor[0] instanceof Double)) {
            throw new IllegalArgumentException("ZoomFactor must be a Double");
        }
        this.setZoomFactor((Double)zFactor[0]);
    }

    public double getRotXFactor() {
        return this.rotXFactor;
    }

    public double getRotYFactor() {
        return this.rotYFactor;
    }

    public double getTransXFactor() {
        return this.transXFactor;
    }

    public double getTransYFactor() {
        return this.transYFactor;
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public synchronized void setRotateEnable(boolean enabled) {
        this.rotateEnabled = enabled;
    }

    public void RotateEnable(Object[] enabled) {
        if (enabled.length != 1 || !(enabled[0] instanceof Boolean)) {
            throw new IllegalArgumentException("RotateEnable must be Boolean");
        }
        this.setRotateEnable((Boolean)enabled[0]);
    }

    public synchronized void setZoomEnable(boolean enabled) {
        this.zoomEnabled = enabled;
    }

    public void ZoomEnable(Object[] enabled) {
        if (enabled.length != 1 || !(enabled[0] instanceof Boolean)) {
            throw new IllegalArgumentException("ZoomEnable must be Boolean");
        }
        this.setZoomEnable((Boolean)enabled[0]);
    }

    public synchronized void setTranslateEnable(boolean enabled) {
        this.translateEnabled = enabled;
    }

    public void TranslateEnable(Object[] enabled) {
        if (enabled.length != 1 || !(enabled[0] instanceof Boolean)) {
            throw new IllegalArgumentException("TranslateEnable must be Boolean");
        }
        this.setTranslateEnable((Boolean)enabled[0]);
    }

    public boolean getRotateEnable() {
        return this.rotateEnabled;
    }

    public boolean getZoomEnable() {
        return this.zoomEnabled;
    }

    public boolean getTranslateEnable() {
        return this.translateEnabled;
    }

    boolean rotate(MouseEvent evt) {
        if (this.rotateEnabled) {
            if (this.leftButton == 0 && !evt.isAltDown() && !evt.isMetaDown()) {
                return true;
            }
            if (this.middleButton == 0 && evt.isAltDown() && !evt.isMetaDown()) {
                return true;
            }
            if (this.rightButton == 0 && !evt.isAltDown() && evt.isMetaDown()) {
                return true;
            }
        }
        return false;
    }

    boolean zoom(MouseEvent evt) {
        if (this.zoomEnabled) {
            if (evt instanceof MouseWheelEvent) {
                return true;
            }
            if (this.leftButton == 2 && !evt.isAltDown() && !evt.isMetaDown()) {
                return true;
            }
            if (this.middleButton == 2 && evt.isAltDown() && !evt.isMetaDown()) {
                return true;
            }
            if (this.rightButton == 2 && !evt.isAltDown() && evt.isMetaDown()) {
                return true;
            }
        }
        return false;
    }

    boolean translate(MouseEvent evt) {
        if (this.translateEnabled) {
            if (this.leftButton == 1 && !evt.isAltDown() && !evt.isMetaDown()) {
                return true;
            }
            if (this.middleButton == 1 && evt.isAltDown() && !evt.isMetaDown()) {
                return true;
            }
            if (this.rightButton == 1 && !evt.isAltDown() && evt.isMetaDown()) {
                return true;
            }
        }
        return false;
    }

    public synchronized void setMinRadius(double r) {
        if (r < 0.0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("OrbitBehavior1"));
        }
        this.minRadius = r;
    }

    public void MinRadius(Object[] r) {
        if (r.length != 1 || !(r[0] instanceof Double)) {
            throw new IllegalArgumentException("MinRadius must be a Double");
        }
        this.setMinRadius((Double)r[0]);
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setReverseTranslate(boolean state) {
        this.reverseTrans = state;
    }

    public void ReverseTranslate(Object[] state) {
        if (state.length != 1 || !(state[0] instanceof Boolean)) {
            throw new IllegalArgumentException("ReverseTranslate must be Boolean");
        }
        this.setReverseTranslate((Boolean)state[0]);
    }

    public void setReverseRotate(boolean state) {
        this.reverseRotate = state;
    }

    public void ReverseRotate(Object[] state) {
        if (state.length != 1 || !(state[0] instanceof Boolean)) {
            throw new IllegalArgumentException("ReverseRotate must be Boolean");
        }
        this.setReverseRotate((Boolean)state[0]);
    }

    public void setReverseZoom(boolean state) {
        this.reverseZoom = state;
    }

    public void ReverseZoom(Object[] state) {
        if (state.length != 1 || !(state[0] instanceof Boolean)) {
            throw new IllegalArgumentException("ReverseZoom must be Boolean");
        }
        this.setReverseZoom((Boolean)state[0]);
    }

    public synchronized void setProportionalZoom(boolean state) {
        this.proportionalZoom = state;
        this.zoomMul = state ? 1.0 * this.zoomFactor : 0.01 * this.zoomFactor;
    }

    public void ProportionalZoom(Object[] state) {
        if (state.length != 1 || !(state[0] instanceof Boolean)) {
            throw new IllegalArgumentException("ProportionalZoom must be Boolean");
        }
        this.setProportionalZoom((Boolean)state[0]);
    }
}

