/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.sensor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.behaviors.sensor.SensorButtonListener;
import org.jogamp.java3d.utils.behaviors.sensor.SensorEvent;
import org.jogamp.java3d.utils.behaviors.sensor.SensorReadListener;
import org.jogamp.java3d.utils.timer.J3DTimer;

public class SensorEventAgent {
    private long t0 = 0L;
    private Object source = null;
    private SensorEvent e = new SensorEvent();
    private List bindingsList = new ArrayList();
    private SensorBinding[] bindings = new SensorBinding[0];
    private boolean listsDirty = false;

    public SensorEventAgent(Object source) {
        this.source = source;
    }

    private SensorBinding getSensorBinding(Sensor sensor) {
        int i2 = 0;
        while (i2 < this.bindingsList.size()) {
            SensorBinding sb = (SensorBinding)this.bindingsList.get(i2);
            if (sb.sensor == sensor) {
                return sb;
            }
            ++i2;
        }
        return null;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, int button, SensorButtonListener buttonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (button >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + button + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        SensorButtonListener[] listeners = new SensorButtonListener[sb.buttons.length];
        listeners[button] = buttonListener;
        SensorButtonBinding sbb = new SensorButtonBinding(listeners, true);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, SensorButtonListener buttonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        SensorButtonListener[] listeners = new SensorButtonListener[sb.buttons.length];
        int i2 = 0;
        while (i2 < sb.buttons.length) {
            listeners[i2] = buttonListener;
            ++i2;
        }
        SensorButtonBinding sbb = new SensorButtonBinding(listeners, true);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListeners(Sensor sensor, SensorButtonListener[] buttonListeners) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        if (sb.buttons.length != buttonListeners.length) {
            throw new IllegalArgumentException("\nbuttonListeners length " + buttonListeners.length + " must equal sensor button count " + sb.buttons.length);
        }
        SensorButtonBinding sbb = new SensorButtonBinding(buttonListeners, false);
        sb.buttonBindingsList.add(sbb);
        this.listsDirty = true;
    }

    public SensorButtonListener[] getSensorButtonListeners(Sensor sensor, int button) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (button >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + button + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return null;
        }
        ArrayList<SensorButtonListener> listeners = new ArrayList<SensorButtonListener>();
        int i2 = 0;
        while (i2 < sb.buttonBindingsList.size()) {
            SensorButtonBinding sbb = (SensorButtonBinding)sb.buttonBindingsList.get(i2);
            if (sbb.listeners[button] != null) {
                listeners.add(sbb.listeners[button]);
            }
            ++i2;
        }
        if (listeners.size() == 0) {
            return null;
        }
        return listeners.toArray(new SensorButtonListener[listeners.size()]);
    }

    private void removeSensorButtonListener(SensorBinding sb, SensorButtonListener listener) {
        Iterator i2 = sb.buttonBindingsList.iterator();
        while (i2.hasNext()) {
            int instanceCount = 0;
            SensorButtonBinding sbb = (SensorButtonBinding)i2.next();
            int j2 = 0;
            while (j2 < sbb.listeners.length) {
                if (sbb.listeners[j2] == listener) {
                    sbb.listeners[j2] = null;
                } else if (sbb.listeners[j2] != null) {
                    ++instanceCount;
                }
                ++j2;
            }
            if (instanceCount != 0) continue;
            i2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(Sensor sensor, SensorButtonListener listener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return;
        }
        this.removeSensorButtonListener(sb, listener);
        if (sb.buttonBindingsList.size() == 0 && sb.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(SensorButtonListener listener) {
        Iterator i2 = this.bindingsList.iterator();
        while (i2.hasNext()) {
            SensorBinding sb = (SensorBinding)i2.next();
            this.removeSensorButtonListener(sb, listener);
            if (sb.buttonBindingsList.size() != 0 || sb.readBindingsList.size() != 0) continue;
            i2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void addSensorReadListener(Sensor sensor, SensorReadListener readListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            sb = new SensorBinding(sensor);
            this.bindingsList.add(sb);
        }
        sb.readBindingsList.add(readListener);
        this.listsDirty = true;
    }

    public SensorReadListener[] getSensorReadListeners(Sensor sensor) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return null;
        }
        if (sb.readBindingsList.size() == 0) {
            return null;
        }
        return sb.readBindingsList.toArray(new SensorReadListener[sb.readBindingsList.size()]);
    }

    private void removeSensorReadListener(SensorBinding sb, SensorReadListener listener) {
        Iterator i2 = sb.readBindingsList.iterator();
        while (i2.hasNext()) {
            if ((SensorReadListener)i2.next() != listener) continue;
            i2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(Sensor sensor, SensorReadListener listener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sb = this.getSensorBinding(sensor);
        if (sb == null) {
            return;
        }
        this.removeSensorReadListener(sb, listener);
        if (sb.buttonBindingsList.size() == 0 && sb.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(SensorReadListener listener) {
        Iterator i2 = this.bindingsList.iterator();
        while (i2.hasNext()) {
            SensorBinding sb = (SensorBinding)i2.next();
            this.removeSensorReadListener(sb, listener);
            if (sb.buttonBindingsList.size() != 0 || sb.readBindingsList.size() != 0) continue;
            i2.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorBinding(Sensor sensor) {
        Iterator i2 = this.bindingsList.iterator();
        while (i2.hasNext()) {
            SensorBinding sb = (SensorBinding)i2.next();
            if (sb.sensor != sensor) continue;
            i2.remove();
            break;
        }
        this.listsDirty = true;
    }

    public Sensor[] getSensors() {
        if (this.bindingsList.size() == 0) {
            return null;
        }
        Sensor[] s = new Sensor[this.bindingsList.size()];
        int i2 = 0;
        while (i2 < this.bindingsList.size()) {
            s[i2] = ((SensorBinding)this.bindingsList.get((int)i2)).sensor;
            ++i2;
        }
        return s;
    }

    private synchronized void updateArrays() {
        this.bindings = this.bindingsList.toArray(new SensorBinding[this.bindingsList.size()]);
        int i2 = 0;
        while (i2 < this.bindings.length) {
            this.bindings[i2].updateArrays();
            ++i2;
        }
    }

    public void dispatchEvents() {
        long t1 = this.t0;
        this.t0 = J3DTimer.getValue();
        if (this.listsDirty) {
            this.updateArrays();
            this.listsDirty = false;
        }
        int k2 = 0;
        while (k2 < this.bindings.length) {
            SensorBinding sb = this.bindings[k2];
            Sensor s = sb.sensor;
            Transform3D read = sb.read;
            int[] buttons = sb.buttons;
            int dragButton = 0;
            boolean callReadListeners = true;
            boolean callDraggedListener = false;
            s.getRead(read);
            s.lastButtons(buttons);
            int j2 = 0;
            while (j2 < sb.buttonBindings.length) {
                SensorButtonBinding sbb = sb.buttonBindings[j2];
                int i2 = 0;
                while (i2 < buttons.length) {
                    if (sbb.listeners[i2] != null) {
                        if (sbb.prevButtons[i2]) {
                            if (buttons[i2] == 0) {
                                this.e.set(this.source, 2, s, read, buttons, i2, this.t0, t1);
                                sbb.listeners[i2].released(this.e);
                                sbb.prevButtons[i2] = false;
                                --sbb.buttonsHandled;
                            } else {
                                callDraggedListener = true;
                                dragButton = i2;
                            }
                            callReadListeners = false;
                        } else if (buttons[i2] == 1 && (sbb.buttonsHandled == 0 || sbb.multiButton)) {
                            this.e.set(this.source, 1, s, read, buttons, i2, this.t0, t1);
                            sbb.listeners[i2].pressed(this.e);
                            sbb.prevButtons[i2] = true;
                            ++sbb.buttonsHandled;
                            callReadListeners = false;
                        }
                    }
                    ++i2;
                }
                if (callDraggedListener) {
                    this.e.set(this.source, 3, s, read, buttons, -1, this.t0, t1);
                    sbb.listeners[dragButton].dragged(this.e);
                }
                ++j2;
            }
            if (callReadListeners) {
                this.e.set(this.source, 4, s, read, buttons, -1, this.t0, t1);
                int r = 0;
                while (r < sb.readBindings.length) {
                    sb.readBindings[r].read(this.e);
                    ++r;
                }
            }
            ++k2;
        }
    }

    public String toString() {
        String s = "SensorEventAgent@" + Integer.toHexString(this.hashCode());
        s = String.valueOf(s) + "\nsensor bindings:\n\n";
        int i2 = 0;
        while (i2 < this.bindingsList.size()) {
            s = String.valueOf(s) + ((SensorBinding)this.bindingsList.get(i2)).toString() + "\n";
            ++i2;
        }
        return s;
    }

    private static class SensorBinding {
        Sensor sensor = null;
        int[] buttons = null;
        Transform3D read = null;
        List buttonBindingsList = new ArrayList();
        SensorButtonBinding[] buttonBindings = new SensorButtonBinding[0];
        List readBindingsList = new ArrayList();
        SensorReadListener[] readBindings = new SensorReadListener[0];

        SensorBinding(Sensor sensor) {
            this.sensor = sensor;
            this.buttons = new int[sensor.getSensorButtonCount()];
            this.read = new Transform3D();
        }

        void updateArrays() {
            this.buttonBindings = this.buttonBindingsList.toArray(new SensorButtonBinding[this.buttonBindingsList.size()]);
            this.readBindings = this.readBindingsList.toArray(new SensorReadListener[this.readBindingsList.size()]);
        }

        public String toString() {
            String s = new String();
            s = "sensor " + this.sensor + "\nbutton listener arrays:\n";
            int i2 = 0;
            while (i2 < this.buttonBindingsList.size()) {
                s = String.valueOf(s) + (SensorButtonBinding)this.buttonBindingsList.get(i2);
                ++i2;
            }
            s = String.valueOf(s) + "read listeners:\n";
            i2 = 0;
            while (i2 < this.readBindingsList.size()) {
                s = String.valueOf(s) + "  " + (SensorReadListener)this.readBindingsList.get(i2) + "\n";
                ++i2;
            }
            return s;
        }
    }

    private static class SensorButtonBinding {
        int buttonsHandled = 0;
        boolean[] prevButtons = null;
        boolean multiButton = false;
        SensorButtonListener[] listeners = null;

        SensorButtonBinding(SensorButtonListener[] listeners, boolean multiButtonEnable) {
            this.prevButtons = new boolean[listeners.length];
            this.listeners = new SensorButtonListener[listeners.length];
            int i2 = 0;
            while (i2 < listeners.length) {
                this.prevButtons[i2] = false;
                this.listeners[i2] = listeners[i2];
                ++i2;
            }
            this.multiButton = multiButtonEnable;
        }

        public String toString() {
            String s = new String();
            s = "  length " + this.listeners.length + ", mutual exclusion " + !this.multiButton + "\n";
            int i2 = 0;
            while (i2 < this.listeners.length) {
                s = String.valueOf(s) + "    " + (this.listeners[i2] == null ? "null" : this.listeners[i2].toString()) + "\n";
                ++i2;
            }
            return s;
        }
    }
}

