/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.sensor;

import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.vecmath.AxisAngle4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class SensorBeamEcho
extends Shape3D {
    public SensorBeamEcho(Point3d hotspot, double baseWidth, boolean enableLighting) {
        int vertexFormat;
        if (hotspot.distance(new Point3d()) == 0.0) {
            throw new IllegalArgumentException("\nBeam echo can't have hotspot at origin");
        }
        Vector3f axis = new Vector3f((float)hotspot.x, (float)hotspot.y, (float)hotspot.z);
        Vector3f axis1 = new Vector3f();
        axis1.normalize(axis);
        Vector3f normal = new Vector3f(0.0f, 1.0f, 0.0f);
        normal.cross(axis1, normal);
        if (normal.lengthSquared() < 0.5f) {
            normal.set(0.0f, 0.0f, 1.0f);
            normal.cross(axis1, normal);
        }
        normal.normalize();
        int divisions = 18;
        Point3f[] cap0 = new Point3f[divisions];
        Point3f[] cap1 = new Point3f[divisions];
        Vector3f[] capNormals = new Vector3f[divisions];
        Vector3f cap0Normal = new Vector3f(axis1);
        Vector3f cap1Normal = new Vector3f(axis1);
        cap0Normal.negate();
        AxisAngle4f aa4f = new AxisAngle4f(axis1, (float)(-Math.PI) / ((float)divisions / 2.0f));
        Transform3D t3d = new Transform3D();
        t3d.set(aa4f);
        float halfWidth = (float)baseWidth / 2.0f;
        int i2 = 0;
        while (i2 < divisions) {
            capNormals[i2] = new Vector3f(normal);
            cap0[i2] = new Point3f(normal);
            cap0[i2].scale(halfWidth);
            cap1[i2] = new Point3f(cap0[i2]);
            cap1[i2].add(axis);
            t3d.transform(normal);
            ++i2;
        }
        int vertexCount = 2 + 4 * divisions;
        Point3f[] vertices = new Point3f[vertexCount];
        Vector3f[] normals = new Vector3f[vertexCount];
        int i3 = 0;
        while (i3 < divisions) {
            vertices[i3 * 2] = cap0[i3];
            vertices[i3 * 2 + 1] = cap1[i3];
            normals[i3 * 2] = capNormals[i3];
            normals[i3 * 2 + 1] = capNormals[i3];
            ++i3;
        }
        vertices[divisions * 2] = cap0[0];
        vertices[divisions * 2 + 1] = cap1[0];
        normals[divisions * 2] = capNormals[0];
        normals[divisions * 2 + 1] = capNormals[0];
        int v = (divisions + 1) * 2;
        vertices[v] = cap0[0];
        normals[v++] = cap0Normal;
        int j2 = 1;
        int k2 = divisions - 1;
        while (j2 <= k2) {
            vertices[v] = cap0[j2++];
            normals[v++] = cap0Normal;
            if (j2 > k2) break;
            vertices[v] = cap0[k2--];
            normals[v++] = cap0Normal;
        }
        vertices[v] = cap1[0];
        normals[v++] = cap1Normal;
        j2 = 1;
        k2 = divisions - 1;
        while (j2 <= k2) {
            vertices[v] = cap1[k2--];
            normals[v++] = cap1Normal;
            if (j2 > k2) break;
            vertices[v] = cap1[j2++];
            normals[v++] = cap1Normal;
        }
        Material m2 = new Material();
        m2.setCapability(0);
        m2.setCapability(1);
        if (enableLighting) {
            vertexFormat = 3;
            m2.setLightingEnable(true);
        } else {
            vertexFormat = 1;
            m2.setLightingEnable(false);
        }
        int[] stripCounts = new int[]{2 + 2 * divisions, divisions, divisions};
        TriangleStripArray tsa = new TriangleStripArray(vertexCount, vertexFormat, stripCounts);
        tsa.setCoordinates(0, vertices);
        if (enableLighting) {
            tsa.setNormals(0, normals);
        }
        Appearance a2 = new Appearance();
        a2.setMaterial(m2);
        a2.setCapability(0);
        a2.setCapability(1);
        TransparencyAttributes ta = new TransparencyAttributes();
        ta.setCapability(0);
        ta.setCapability(1);
        ta.setCapability(2);
        ta.setCapability(3);
        ta.setCapability(4);
        ta.setCapability(5);
        a2.setTransparencyAttributes(ta);
        a2.setCapability(10);
        a2.setCapability(11);
        this.setGeometry(tsa);
        this.setAppearance(a2);
        this.setCapability(14);
        this.setCapability(15);
    }
}

