/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.picking;

import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Link;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Switch;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class PickObject {
    public static final int SHAPE3D = 1;
    public static final int MORPH = 2;
    public static final int PRIMITIVE = 4;
    public static final int LINK = 8;
    public static final int GROUP = 16;
    public static final int TRANSFORM_GROUP = 32;
    public static final int BRANCH_GROUP = 64;
    public static final int SWITCH = 128;
    public static final int USE_GEOMETRY = 256;
    public static final int USE_BOUNDS = 512;
    BranchGroup pickRoot;
    Canvas3D canvas;
    Point3d origin = new Point3d();
    Vector3d direction = new Vector3d();
    PickRay pickRay = new PickRay();
    SceneGraphPath sceneGraphPath = null;
    SceneGraphPath[] sceneGraphPathArr = null;
    int pickBy;
    static final boolean debug = false;
    private double[] distance;
    private int[] position;

    public PickObject(Canvas3D c2, BranchGroup root) {
        this.pickRoot = root;
        this.canvas = c2;
    }

    public PickShape generatePickRay(int xpos, int ypos) {
        Transform3D motion = new Transform3D();
        Point3d eyePosn = new Point3d();
        Point3d mousePosn = new Point3d();
        Vector3d mouseVec = new Vector3d();
        this.canvas.getCenterEyeInImagePlate(eyePosn);
        this.canvas.getPixelLocationInImagePlate(xpos, ypos, mousePosn);
        if (this.canvas.getView().getProjectionPolicy() == 0) {
            eyePosn.x = mousePosn.x;
            eyePosn.y = mousePosn.y;
        }
        this.canvas.getImagePlateToVworld(motion);
        motion.transform(eyePosn);
        motion.transform(mousePosn);
        mouseVec.sub(mousePosn, eyePosn);
        mouseVec.normalize();
        this.pickRay.set(eyePosn, mouseVec);
        return this.pickRay;
    }

    public SceneGraphPath[] pickAll(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath[] pickAllSorted(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAllSorted(this.pickRay);
        return this.sceneGraphPathArr;
    }

    public SceneGraphPath pickAny(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPath = this.pickRoot.pickAny(this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath pickClosest(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPath = this.pickRoot.pickClosest(this.pickRay);
        return this.sceneGraphPath;
    }

    public SceneGraphPath[] pickAll(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickAll(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomAll(xpos, ypos);
        }
        return null;
    }

    public SceneGraphPath[] pickAllSorted(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickAllSorted(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomAllSorted(xpos, ypos);
        }
        return null;
    }

    public SceneGraphPath pickAny(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickAny(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomAny(xpos, ypos);
        }
        return null;
    }

    public SceneGraphPath pickClosest(int xpos, int ypos, int flag) {
        if (flag == 512) {
            return this.pickClosest(xpos, ypos);
        }
        if (flag == 256) {
            return this.pickGeomClosest(xpos, ypos);
        }
        return null;
    }

    private SceneGraphPath[] pickGeomAll(int xpos, int ypos) {
        int cnt = 0;
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] found = new boolean[this.sceneGraphPathArr.length];
        int i2 = 0;
        while (i2 < this.sceneGraphPathArr.length) {
            Node obj = this.sceneGraphPathArr[i2].getObject();
            if (obj instanceof Shape3D) {
                found[i2] = ((Shape3D)obj).intersect(this.sceneGraphPathArr[i2], this.pickRay);
            } else if (obj instanceof Morph) {
                found[i2] = ((Morph)obj).intersect(this.sceneGraphPathArr[i2], this.pickRay);
            }
            if (found[i2]) {
                ++cnt;
            }
            ++i2;
        }
        if (cnt == 0) {
            return null;
        }
        SceneGraphPath[] newSceneGraphPathArr = new SceneGraphPath[cnt];
        cnt = 0;
        i2 = 0;
        while (i2 < this.sceneGraphPathArr.length) {
            if (found[i2]) {
                newSceneGraphPathArr[cnt++] = this.sceneGraphPathArr[i2];
            }
            ++i2;
        }
        return newSceneGraphPathArr;
    }

    private SceneGraphPath[] pickGeomAllSorted(int xpos, int ypos) {
        int cnt = 0;
        double[] dist = new double[1];
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        if (this.sceneGraphPathArr == null) {
            return null;
        }
        boolean[] found = new boolean[this.sceneGraphPathArr.length];
        double[] distArr = new double[this.sceneGraphPathArr.length];
        int i2 = 0;
        while (i2 < this.sceneGraphPathArr.length) {
            Node obj = this.sceneGraphPathArr[i2].getObject();
            if (obj instanceof Shape3D) {
                found[i2] = ((Shape3D)obj).intersect(this.sceneGraphPathArr[i2], this.pickRay, dist);
                distArr[i2] = dist[0];
            } else if (obj instanceof Morph) {
                found[i2] = ((Morph)obj).intersect(this.sceneGraphPathArr[i2], this.pickRay, dist);
                distArr[i2] = dist[0];
            }
            if (found[i2]) {
                ++cnt;
            }
            ++i2;
        }
        if (cnt == 0) {
            return null;
        }
        SceneGraphPath[] newSceneGraphPathArr = new SceneGraphPath[cnt];
        this.distance = new double[cnt];
        cnt = 0;
        i2 = 0;
        while (i2 < this.sceneGraphPathArr.length) {
            if (found[i2]) {
                newSceneGraphPathArr[cnt] = this.sceneGraphPathArr[i2];
                this.distance[cnt++] = distArr[i2];
            }
            ++i2;
        }
        return this.sort(newSceneGraphPathArr);
    }

    private SceneGraphPath pickGeomClosest(int xpos, int ypos) {
        SceneGraphPath[] sgpArr = this.pickGeomAllSorted(xpos, ypos);
        if (sgpArr == null) {
            return null;
        }
        return sgpArr[0];
    }

    private SceneGraphPath pickGeomAny(int xpos, int ypos) {
        this.pickRay = (PickRay)this.generatePickRay(xpos, ypos);
        this.sceneGraphPathArr = this.pickRoot.pickAll(this.pickRay);
        int i2 = 0;
        while (i2 < this.sceneGraphPathArr.length) {
            Node obj = this.sceneGraphPathArr[i2].getObject();
            if (obj instanceof Shape3D ? ((Shape3D)obj).intersect(this.sceneGraphPathArr[i2], this.pickRay) : obj instanceof Morph && ((Morph)obj).intersect(this.sceneGraphPathArr[i2], this.pickRay)) {
                return this.sceneGraphPathArr[i2];
            }
            ++i2;
        }
        return null;
    }

    private SceneGraphPath[] sort(SceneGraphPath[] sgpArr) {
        if (sgpArr == null) {
            return null;
        }
        SceneGraphPath[] sorted = new SceneGraphPath[sgpArr.length];
        this.position = new int[sgpArr.length];
        int i2 = 0;
        while (i2 < sgpArr.length) {
            this.position[i2] = i2;
            ++i2;
        }
        this.quicksort(0, this.distance.length - 1);
        i2 = 0;
        while (i2 < this.distance.length) {
            sorted[i2] = sgpArr[this.position[i2]];
            ++i2;
        }
        return sorted;
    }

    private final void quicksort(int l2, int r) {
        int i2 = l2;
        int j2 = r;
        double k2 = this.distance[(l2 + r) / 2];
        while (true) {
            if (this.distance[i2] < k2) {
                ++i2;
                continue;
            }
            while (k2 < this.distance[j2]) {
                --j2;
            }
            if (i2 <= j2) {
                double tmp = this.distance[i2];
                this.distance[i2] = this.distance[j2];
                this.distance[j2] = tmp;
                int p = this.position[i2];
                this.position[i2] = this.position[j2];
                this.position[j2] = p;
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (l2 < j2) {
            this.quicksort(l2, j2);
        }
        if (l2 < r) {
            this.quicksort(i2, r);
        }
    }

    public Node pickNode(SceneGraphPath sgPath, int flags) {
        if (sgPath != null) {
            Node pickedNode = sgPath.getObject();
            if (pickedNode instanceof Shape3D && (flags & 1) != 0) {
                return pickedNode;
            }
            if (pickedNode instanceof Morph && (flags & 2) != 0) {
                return pickedNode;
            }
            int j2 = sgPath.nodeCount() - 1;
            while (j2 >= 0) {
                pickedNode = sgPath.getNode(j2);
                if (pickedNode instanceof Primitive && (flags & 4) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof Link && (flags & 8) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof Switch && (flags & 0x80) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof TransformGroup && (flags & 0x20) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof BranchGroup && (flags & 0x40) != 0) {
                    return pickedNode;
                }
                if (pickedNode instanceof Group && (flags & 0x10) != 0) {
                    return pickedNode;
                }
                --j2;
            }
            if (pickedNode == null) {
                // empty if block
            }
        }
        return null;
    }

    public Node pickNode(SceneGraphPath sgPath, int flags, int occurrence) {
        int curCnt = 0;
        if (sgPath != null) {
            Node pickedNode = sgPath.getObject();
            if (pickedNode instanceof Shape3D && (flags & 1) != 0) {
                return pickedNode;
            }
            if (pickedNode instanceof Morph && (flags & 2) != 0) {
                return pickedNode;
            }
            int j2 = 0;
            while (j2 < sgPath.nodeCount()) {
                pickedNode = sgPath.getNode(j2);
                if (pickedNode instanceof Group && (flags & 0x10) != 0 ? ++curCnt == occurrence : (pickedNode instanceof BranchGroup && (flags & 0x40) != 0 ? ++curCnt == occurrence : (pickedNode instanceof TransformGroup && (flags & 0x20) != 0 ? ++curCnt == occurrence : (pickedNode instanceof Primitive && (flags & 4) != 0 ? ++curCnt == occurrence : pickedNode instanceof Link && (flags & 8) != 0 && ++curCnt == occurrence)))) {
                    return pickedNode;
                }
                ++j2;
            }
            if (pickedNode == null) {
                // empty if block
            }
        }
        return null;
    }
}

