/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.audio;

import org.jogamp.java3d.SoundException;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.vecmath.Point2f;

public class DistanceAttenuation {
    static final int DOUBLE_DISTANCE_HALF_GAIN = 1;

    public void fillDistanceAttenuation(float unitDistance, float unitGain, Point2f[] distanceAttenuation) {
        if (distanceAttenuation == null) {
            throw new SoundException(J3dUtilsI18N.getString("DistanceAttenuation0"));
        }
        int length = distanceAttenuation.length;
        distanceAttenuation[0].x = 0.0f;
        distanceAttenuation[0].y = unitGain;
        float nextDistance = unitDistance;
        float nextGain = unitGain;
        int i2 = 1;
        while (i2 < length) {
            distanceAttenuation[i2].x = nextDistance;
            distanceAttenuation[i2].y = nextGain;
            nextDistance *= 2.0f;
            nextGain *= 0.5f;
            ++i2;
        }
    }

    public void fillDistanceAttenuation(float innerRadius, float maxConstantGain, float unitDistance, float unitGain, int curveType, Point2f[] distanceAttenuation) {
        if (distanceAttenuation == null) {
            throw new SoundException(J3dUtilsI18N.getString("DistanceAttenuation0"));
        }
        int length = distanceAttenuation.length;
        distanceAttenuation[0].x = innerRadius;
        distanceAttenuation[0].y = maxConstantGain;
        float nextDistance = unitDistance;
        float nextGain = unitGain;
        int i2 = 1;
        while (i2 < length) {
            distanceAttenuation[i2].x = innerRadius + nextDistance;
            distanceAttenuation[i2].y = nextGain;
            nextDistance *= 2.0f;
            nextGain *= 0.5f;
            ++i2;
        }
    }

    public void fillDistanceAttenuation(float innerRadius, float maxConstantGain, float unitDistance, float unitGain, float outerRadius, float minConstantGain, int curveType, Point2f[] distanceAttenuation) {
    }
}

