/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.util.Vector;
import org.jogamp.java3d.loaders.lw3d.LwoSurface;
import org.jogamp.java3d.loaders.lw3d.ParserObject;
import org.jogamp.vecmath.Vector3f;

class ShapeHolder
extends ParserObject {
    Vector facetSizesList;
    Vector facetIndicesList;
    int[] facetIndicesArray;
    int currentNumIndices = 0;
    int numSurf;
    int numVerts;
    int[] facetIndices;
    int[] facetSizes;
    int[] normalIndices;
    float[] normalCoords;
    float[] coordsArray;

    ShapeHolder() {
    }

    ShapeHolder(int debugVals) {
        super(debugVals);
    }

    void printGeometryData(LwoSurface surface) {
        int indicesIndex = 0;
        System.out.println("\nPolygon Data:");
        System.out.println("  Surface color = " + surface.color);
        System.out.println("  Surface diffuse = " + surface.diffuseColor);
        int i2 = 0;
        while (i2 < this.facetSizes.length) {
            int polySize = this.facetSizes[i2];
            System.out.println("Facet of size " + polySize);
            int j2 = 0;
            while (j2 < polySize) {
                int coordIndex = 3 * this.facetIndices[indicesIndex++];
                System.out.println("x, y, z = " + this.coordsArray[coordIndex] + ", " + this.coordsArray[coordIndex + 1] + ", " + this.coordsArray[coordIndex + 2]);
                ++j2;
            }
            ++i2;
        }
    }

    void createArrays(boolean reverseWinding) {
        this.debugOutputLn(1, "createArrays()");
        this.facetIndices = new int[this.currentNumIndices];
        if (reverseWinding) {
            int facetBeginIndex = 0;
            int facetIndex = 0;
            while (facetIndex < this.facetSizesList.size()) {
                int currFaceSize = (Integer)this.facetSizesList.elementAt(facetIndex);
                int[] tempFace = new int[currFaceSize];
                int j2 = 0;
                while (j2 < currFaceSize) {
                    this.facetIndices[facetBeginIndex + j2] = this.facetIndicesArray[facetBeginIndex + currFaceSize - j2 - 1];
                    ++j2;
                }
                facetBeginIndex += currFaceSize;
                ++facetIndex;
            }
        } else {
            int i2 = 0;
            while (i2 < this.facetIndices.length) {
                this.facetIndices[i2] = this.facetIndicesArray[i2];
                ++i2;
            }
        }
        this.debugOutputLn(8, "facetIndices.len and coordsArray.len = " + this.facetIndices.length + ", " + this.coordsArray.length);
        if ((Integer)this.facetSizesList.elementAt(0) < 3) {
            this.debugOutputLn(8, "Using direct geometry because facetIndices is of size " + this.facetIndices.length + " and coordsArray is of length " + this.coordsArray.length);
            float[] newCoordsArray = new float[this.facetIndices.length * 3];
            int newCoordsIndex = 0;
            int i3 = 0;
            while (i3 < this.facetIndices.length) {
                newCoordsArray[newCoordsIndex++] = this.coordsArray[this.facetIndices[i3] * 3];
                newCoordsArray[newCoordsIndex++] = this.coordsArray[this.facetIndices[i3] * 3 + 1];
                newCoordsArray[newCoordsIndex++] = this.coordsArray[this.facetIndices[i3] * 3 + 2];
                ++i3;
            }
            this.coordsArray = newCoordsArray;
            this.facetIndices = null;
        }
        this.facetSizes = new int[this.facetSizesList.size()];
        int i4 = 0;
        while (i4 < this.facetSizes.length) {
            this.facetSizes[i4] = (Integer)this.facetSizesList.elementAt(i4);
            ++i4;
        }
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
    }

    void nullify() {
        this.facetSizesList = null;
        this.facetIndicesList = null;
        this.facetIndicesArray = null;
        this.facetSizes = null;
        this.facetIndices = null;
        this.normalCoords = null;
        this.normalIndices = null;
    }

    void calcNormals() {
        this.debugOutputLn(1, "calcNormals()");
        this.debugOutputLn(8, "coordsLength, facetsizes.len = " + this.coordsArray.length + ", " + this.facetSizes.length);
        if (this.facetSizes[0] > 2) {
            if (this.facetIndices != null) {
                this.normalIndices = new int[this.facetIndices.length];
                this.normalCoords = new float[this.facetIndices.length * 3];
            } else {
                this.normalCoords = new float[this.coordsArray.length];
            }
            this.debugOutputLn(8, "normalCoords, incides len = " + this.normalCoords.length + ", " + (this.facetIndices == null ? 0 : this.normalIndices.length));
            int facetIndex = 0;
            int tempIndex = -1;
            int i2 = 0;
            while (i2 < this.facetSizes.length) {
                Vector3f norm;
                int currFacetSize = this.facetSizes[i2];
                if (currFacetSize < 3) {
                    norm = new Vector3f(0.0f, 0.0f, 1.0f);
                } else {
                    int index3;
                    int index2;
                    int index1;
                    if (this.facetIndices != null) {
                        index1 = this.facetIndices[facetIndex];
                        index2 = this.facetIndices[facetIndex + 1];
                        index3 = this.facetIndices[facetIndex + 2];
                    } else {
                        index1 = facetIndex;
                        index2 = facetIndex + 1;
                        index3 = facetIndex + 2;
                    }
                    Vector3f v1 = new Vector3f(this.coordsArray[index2 * 3] - this.coordsArray[index1 * 3], this.coordsArray[index2 * 3 + 1] - this.coordsArray[index1 * 3 + 1], this.coordsArray[index2 * 3 + 2] - this.coordsArray[index1 * 3 + 2]);
                    Vector3f v2 = new Vector3f(this.coordsArray[index3 * 3] - this.coordsArray[index1 * 3], this.coordsArray[index3 * 3 + 1] - this.coordsArray[index1 * 3 + 1], this.coordsArray[index3 * 3 + 2] - this.coordsArray[index1 * 3 + 2]);
                    norm = new Vector3f();
                    norm.cross(v1, v2);
                    norm.normalize(norm);
                }
                int j2 = 0;
                while (j2 < currFacetSize) {
                    int normIndex = facetIndex + j2;
                    this.normalCoords[normIndex * 3] = norm.x;
                    this.normalCoords[normIndex * 3 + 1] = norm.y;
                    this.normalCoords[normIndex * 3 + 2] = norm.z;
                    if (this.facetIndices != null) {
                        this.normalIndices[normIndex] = normIndex;
                    }
                    ++j2;
                }
                facetIndex += currFacetSize;
                ++i2;
            }
        }
        this.debugOutputLn(1, "done with calcNormals()");
    }
}

