/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.loaders.IncorrectFormatException;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.EnvelopeHandler;
import org.jogamp.java3d.loaders.lw3d.J3dLwoParser;
import org.jogamp.java3d.loaders.lw3d.Lw3dLoader;
import org.jogamp.java3d.loaders.lw3d.LwsFrame;
import org.jogamp.java3d.loaders.lw3d.LwsMotion;
import org.jogamp.java3d.loaders.lw3d.LwsPrimitive;
import org.jogamp.java3d.loaders.lw3d.SequenceReader;
import org.jogamp.java3d.loaders.lw3d.TextfileParser;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Vector3f;

class LwsObject
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;
    Vector shapeList = null;
    boolean hasPivot = false;
    TransformGroup pivotTransGroup = null;
    URL urlName;
    String protocol;
    int fileType;

    LwsObject(StreamTokenizer st, boolean loadObject, int firstFrame, int totalFrames, float totalTime, Lw3dLoader loader, int debugVals) throws FileNotFoundException, ParsingErrorException {
        this.debugPrinter.setValidOutput(debugVals);
        this.parent = -1;
        this.fileType = loader.getFileType();
        try {
            block19: {
                block18: {
                    if (!loadObject) break block18;
                    this.fileName = this.getString(st);
                    String path = null;
                    switch (loader.getFileType()) {
                        case 2: {
                            path = loader.getBasePath();
                            if (path == null) {
                                path = loader.getInternalBasePath();
                            }
                            if (path != null) {
                                this.fileName = this.getQualifiedFilename(path, this.fileName);
                                break;
                            }
                            break block19;
                        }
                        case 1: {
                            path = "";
                            URL pathUrl = loader.getBaseUrl();
                            if (pathUrl != null) {
                                path = pathUrl.toString();
                                this.protocol = pathUrl.getProtocol();
                            } else {
                                path = loader.getInternalBaseUrl();
                                this.protocol = new URL(path).getProtocol();
                            }
                            this.urlName = this.getQualifiedURL(path, this.fileName);
                        }
                    }
                    break block19;
                }
                this.objName = this.getString(st);
            }
            this.skip(st, "ShowObject", 2);
            this.debugOutputLn(8, "skipped showobject, about to get objectmotion");
            this.getAndCheckString(st, "ObjectMotion");
            this.debugOutputLn(8, "got string " + st.sval);
            this.motion = new LwsMotion(st, firstFrame, totalFrames, totalTime, debugVals);
            this.debugOutputLn(8, "got motion");
            boolean hasParent = false;
            while (!this.isCurrentToken(st, "ShadowOptions")) {
                if (!hasParent && this.isCurrentToken(st, "ParentObject")) {
                    this.parent = (int)this.getNumber(st);
                    hasParent = true;
                } else if (this.isCurrentToken(st, "PivotPoint")) {
                    this.hasPivot = true;
                    float x = (float)this.getNumber(st);
                    float y = (float)this.getNumber(st);
                    float z = (float)this.getNumber(st);
                    Vector3f pivotPoint = new Vector3f(-x, -y, z);
                    Transform3D pivotTransform = new Transform3D();
                    pivotTransform.set(pivotPoint);
                    this.pivotTransGroup = new TransformGroup(pivotTransform);
                    this.pivotTransGroup.setCapability(18);
                } else if (this.isCurrentToken(st, "ObjDissolve")) {
                    EnvelopeHandler envelopeHandler = new EnvelopeHandler(st, totalFrames, totalTime);
                }
                st.nextToken();
            }
            this.getNumber(st);
            this.debugOutputLn(8, "done with LwsObject constructor");
        }
        catch (MalformedURLException e2) {
            throw new FileNotFoundException(e2.getMessage());
        }
        catch (IOException e3) {
            throw new ParsingErrorException(e3.getMessage());
        }
        catch (NumberFormatException e4) {
            throw new ParsingErrorException("Expected a number, got " + e4.getMessage());
        }
    }

    String getQualifiedFilename(String pathname, String filename) throws FileNotFoundException {
        String pathname2 = "";
        if (filename.indexOf(File.separator) == 0) {
            int index = filename.lastIndexOf(File.separator);
            if (index != -1) {
                pathname2 = filename.substring(0, index + 1);
                filename = filename.substring(index + 1);
            } else {
                return null;
            }
        }
        try {
            if (new File(String.valueOf(pathname2) + filename).exists()) {
                return String.valueOf(pathname2) + filename;
            }
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        if (new File(String.valueOf(pathname2) + filename.toLowerCase()).exists()) {
            return String.valueOf(pathname2) + filename.toLowerCase();
        }
        if (new File(String.valueOf(pathname) + filename).exists()) {
            return String.valueOf(pathname) + filename;
        }
        if (new File(String.valueOf(pathname) + filename.toLowerCase()).exists()) {
            return String.valueOf(pathname) + filename.toLowerCase();
        }
        if (new File(filename).exists()) {
            return filename;
        }
        if (new File(filename.toLowerCase()).exists()) {
            return filename.toLowerCase();
        }
        if (pathname.equals(File.separator) || pathname == null || pathname.equals("")) {
            throw new FileNotFoundException(filename);
        }
        StringBuffer newPathName = new StringBuffer(128);
        StringTokenizer st = new StringTokenizer(pathname, File.separator);
        int tokenCount = st.countTokens() - 1;
        if (pathname.startsWith(File.separator)) {
            newPathName.append(File.separator);
        }
        int i2 = 0;
        while (i2 < tokenCount) {
            String directory = st.nextToken();
            newPathName.append(directory);
            newPathName.append(File.separator);
            ++i2;
        }
        String newPath = newPathName.toString();
        return this.getQualifiedFilename(newPath, filename);
    }

    URL getQualifiedURL(String path, String file) throws MalformedURLException {
        URL url = null;
        try {
            url = new URL(String.valueOf(path) + file);
            url.getContent();
            return url;
        }
        catch (IOException iOException) {
            try {
                url = new URL(file);
                url.getContent();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                url = new URL(String.valueOf(this.protocol) + ":" + file);
                url.getContent();
                return url;
            }
            catch (IOException ex) {
                throw new MalformedURLException(String.valueOf(path) + file);
            }
        }
    }

    int getParent() {
        return this.parent;
    }

    void addChild(LwsPrimitive child) {
        this.debugOutputLn(1, "addChild()");
        if (this.objectTransform != null) {
            this.debugOutputLn(8, "objectTransform = " + this.objectTransform);
            if (child.getObjectNode() != null) {
                this.debugOutputLn(8, "child has object node");
                if (this.hasPivot) {
                    this.pivotTransGroup.addChild(child.getObjectNode());
                } else {
                    this.objectTransform.addChild(child.getObjectNode());
                }
            }
        }
    }

    void createJava3dObject(LwsObject cloneObject, int loadBehaviors) throws IncorrectFormatException, ParsingErrorException, FileNotFoundException {
        String seqToken = new String("_sequence_");
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        LwsFrame firstFrame = this.motion.getFirstFrame();
        firstFrame.setMatrix(mat);
        Transform3D t1 = new Transform3D();
        t1.set(mat);
        this.objectTransform = new TransformGroup(t1);
        this.objectTransform.setCapability(18);
        if (this.fileName != null && this.fileName.indexOf(seqToken) != -1) {
            int index = this.fileName.indexOf(seqToken);
            String seqFilename = this.fileName.substring(index += seqToken.length());
            int endIndex = seqFilename.indexOf(".lwo");
            if (endIndex != -1) {
                seqFilename = seqFilename.substring(0, endIndex);
            }
            if (new File(seqFilename).exists()) {
                SequenceReader sr = new SequenceReader(seqFilename, this.motion.totalTime, this.motion.totalFrames);
                sr.printLines();
                sr.createJava3dObjects(this.debugPrinter.getValidOutput(), loadBehaviors);
                TransformGroup g2 = sr.getObjectNode();
                if (g2 != null) {
                    this.objectTransform.addChild(g2);
                }
                this.objectBehavior = sr.getObjectBehaviors();
                return;
            }
        }
        if (this.fileName != null || this.urlName != null) {
            Iterator e2;
            if (cloneObject == null) {
                this.debugOutputLn(2, "About to load binary file for " + this.fileName);
                J3dLwoParser objParser = null;
                switch (this.fileType) {
                    case 2: {
                        objParser = new J3dLwoParser(this.fileName, this.debugPrinter.getValidOutput());
                        break;
                    }
                    case 1: {
                        objParser = new J3dLwoParser(this.urlName, this.debugPrinter.getValidOutput());
                    }
                }
                objParser.createJava3dGeometry();
                if (this.hasPivot) {
                    this.objectTransform.addChild(this.pivotTransGroup);
                }
                if (objParser.getJava3dShapeList() != null) {
                    this.shapeList = objParser.getJava3dShapeList();
                    e2 = this.shapeList.iterator();
                    while (e2.hasNext()) {
                        if (!this.hasPivot || this.pivotTransGroup == null) {
                            this.objectTransform.addChild((Shape3D)e2.next());
                            continue;
                        }
                        this.pivotTransGroup.addChild((Shape3D)e2.next());
                    }
                }
            } else {
                this.debugOutputLn(8, "Cloning shapes");
                Vector cloneShapeList = cloneObject.getShapeList();
                e2 = cloneShapeList.iterator();
                while (e2.hasNext()) {
                    this.debugOutputLn(8, "   shape clone");
                    Shape3D shape = (Shape3D)e2.next();
                    Shape3D cloneShape = (Shape3D)shape.cloneTree();
                    this.objectTransform.addChild(cloneShape);
                }
            }
        }
        this.objectBehavior = new Vector();
        if (loadBehaviors != 0) {
            this.motion.createJava3dBehaviors(this.objectTransform);
            Behavior b2 = this.motion.getBehaviors();
            if (b2 != null) {
                this.objectBehavior.addElement(b2);
            }
        }
    }

    Vector getShapeList() {
        return this.shapeList;
    }

    @Override
    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    @Override
    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        this.debugOutputLn(2, "  OBJECT vals: ");
        this.debugOutputLn(2, "   fileName = " + this.fileName);
        this.debugOutputLn(2, "   objName = " + this.objName);
        this.motion.printVals();
    }
}

