/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.StreamTokenizer;
import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.loaders.lw3d.LightIntensityPathInterpolator;
import org.jogamp.java3d.loaders.lw3d.LwsEnvelope;
import org.jogamp.java3d.loaders.lw3d.LwsEnvelopeFrame;
import org.jogamp.vecmath.Point3d;

class LwsEnvelopeLightIntensity
extends LwsEnvelope {
    LwsEnvelopeLightIntensity(StreamTokenizer st, int frames, float time) {
        super(st, frames, time);
    }

    void createJava3dBehaviors(Object target) {
        if (this.numFrames <= 1) {
            this.behaviors = null;
        } else {
            long alphaAtOne = 0L;
            int loopCount = this.loop ? -1 : 1;
            loopCount = -1;
            this.debugOutputLn(2, "totalTime = " + this.totalTime);
            this.debugOutputLn(2, "loopCount = " + loopCount);
            float animTime = 1000.0f * this.totalTime * (float)(this.frames[this.numFrames - 1].getFrameNum() / (double)this.totalFrames);
            this.debugOutputLn(2, " anim time: " + animTime);
            this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
            this.debugOutputLn(2, " lastFrame = " + this.frames[this.numFrames - 1].getFrameNum());
            if (!this.loop) {
                alphaAtOne = (long)(1000.0 * (double)this.totalTime - (double)animTime);
            }
            Alpha theAlpha = new Alpha(loopCount, 1, 0L, 0L, (long)animTime, 0L, alphaAtOne, 0L, 0L, 0L);
            float[] knots = new float[this.numFrames];
            float[] values = new float[this.numFrames];
            int i2 = 0;
            while (i2 < this.numFrames) {
                values[i2] = (float)this.frames[i2].getValue();
                knots[i2] = (float)this.frames[i2].getFrameNum() / (float)this.frames[this.numFrames - 1].getFrameNum();
                this.debugOutputLn(2, "value, knot = " + values[i2] + ", " + knots[i2]);
                ++i2;
            }
            LightIntensityPathInterpolator l2 = new LightIntensityPathInterpolator(theAlpha, knots, values, target);
            if (l2 != null) {
                this.behaviors = l2;
                BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
                this.behaviors.setSchedulingBounds(bounds);
                ((TransformGroup)target).setCapability(18);
                ((TransformGroup)target).addChild(this.behaviors);
            }
        }
    }

    @Override
    Behavior getBehaviors() {
        return this.behaviors;
    }

    @Override
    LwsEnvelopeFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    @Override
    void printVals() {
        this.debugOutputLn(2, "   name = " + this.name);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        int i2 = 0;
        while (i2 < this.numFrames) {
            this.debugOutputLn(2, "       FRAME " + i2);
            this.frames[i2].printVals();
            ++i2;
        }
    }
}

