/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Texture2D;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.ImageScaler;
import org.jogamp.java3d.loaders.lw3d.LWOBFileReader;
import org.jogamp.java3d.loaders.lw3d.ParserObject;
import org.jogamp.java3d.loaders.lw3d.TargaReader;
import org.jogamp.java3d.utils.image.TextureLoader;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Vector3f;

class LwoTexture
extends ParserObject {
    LWOBFileReader theReader;
    int red = 255;
    int green = 255;
    int blue = 255;
    Color3f color;
    Color3f diffuseColor;
    Color3f specularColor;
    Color3f emissiveColor;
    Image theImage = null;
    String imageFile = null;
    Vector3f textureSize = new Vector3f(1.0f, 1.0f, 1.0f);
    Vector3f textureCenter = new Vector3f(0.0f, 0.0f, 0.0f);
    int textureAxis;
    int flags = 0;
    String type;
    String mappingType;
    String nextToken = null;
    static Hashtable imageTable = new Hashtable();
    static Hashtable textureTable = new Hashtable();

    LwoTexture(LWOBFileReader reader, int length, String typename, int debugVals) throws FileNotFoundException {
        super(debugVals);
        this.debugOutputLn(1, "Constructor");
        this.theReader = reader;
        this.type = typename;
        this.readTexture(length);
    }

    String getNextToken() {
        return this.nextToken;
    }

    boolean isHandled() {
        if ((this.type.equals("CTEX") || this.type.equals("DTEX")) && this.theImage != null) {
            return true;
        }
        this.debugOutputLn(8, "failed isHandled(), type, theImage = " + this.type + ", " + this.theImage);
        return false;
    }

    Texture getTexture() {
        this.debugOutputLn(1, "getTexture()");
        if (this.theImage == null) {
            return null;
        }
        Texture2D t2d = (Texture2D)textureTable.get(this.theImage);
        if (t2d == null) {
            ImageScaler scaler = new ImageScaler((BufferedImage)this.theImage);
            BufferedImage scaledImage = (BufferedImage)scaler.getScaledImage();
            TextureLoader tl = new TextureLoader(scaledImage);
            t2d = (Texture2D)tl.getTexture();
            textureTable.put(this.theImage, t2d);
        }
        return t2d;
    }

    String getType() {
        return this.type;
    }

    Color3f getColor() {
        return this.color;
    }

    Image getImage() {
        return this.theImage;
    }

    Vector3f getTextureSize() {
        return this.textureSize;
    }

    int getTextureAxis() {
        return this.textureAxis;
    }

    Vector3f getTextureCenter() {
        return this.textureCenter;
    }

    String getMappingType() {
        return this.mappingType;
    }

    void readTexture(int length) throws FileNotFoundException, ParsingErrorException {
        this.debugOutputLn(1, "readTexture()");
        int surfStopMarker = this.theReader.getMarker() + length;
        this.mappingType = this.theReader.getString();
        this.debugOutputLn(2, "mappingType = " + this.mappingType);
        String tokenString = this.theReader.getToken();
        while (tokenString != null && this.theReader.getMarker() < surfStopMarker) {
            this.debugOutputLn(2, "  tokenString = " + tokenString);
            this.debugOutputLn(2, "  marker, stop = " + this.theReader.getMarker() + ", " + surfStopMarker);
            if (tokenString.endsWith("TEX") || !tokenString.startsWith("T") || tokenString.equals("TRAN")) {
                this.nextToken = tokenString;
                return;
            }
            int fieldLength = this.theReader.getShortInt();
            this.debugOutputLn(2, "  fl = " + fieldLength);
            if (tokenString.equals("TFLG")) {
                this.debugOutputLn(64, "Not yet handling: " + tokenString);
                this.flags = this.theReader.getShortInt();
                this.textureAxis = this.flags & 7;
                this.debugOutputLn(64, "val = " + this.flags);
            } else if (tokenString.equals("TCLR")) {
                this.debugOutputLn(64, "Not yet handling: " + tokenString);
                try {
                    this.red = this.theReader.read();
                    this.green = this.theReader.read();
                    this.blue = this.theReader.read();
                    this.theReader.read();
                }
                catch (IOException e2) {
                    throw new ParsingErrorException(e2.getMessage());
                }
                this.debugOutputLn(64, "val = " + this.red + ", " + this.green + ", " + this.blue);
            } else if (tokenString.equals("TIMG")) {
                this.debugOutputLn(64, "Not yet handling: " + tokenString);
                this.imageFile = this.theReader.getString();
                this.debugOutputLn(2, "imageFile = " + this.imageFile);
                if (this.imageFile.indexOf("none") == -1 && (this.theImage = (Image)imageTable.get(this.imageFile)) == null) {
                    try {
                        TargaReader tr = new TargaReader(this.imageFile, this.debugPrinter.getValidOutput());
                        this.theImage = tr.getImage();
                        imageTable.put(this.imageFile, this.theImage);
                    }
                    catch (FileNotFoundException e3) {
                        this.debugOutputLn(64, "Image File skipped: " + this.imageFile);
                    }
                }
                this.debugOutputLn(64, "val = __" + this.imageFile + "__");
            } else if (tokenString.equals("TWRP")) {
                this.debugOutputLn(64, "Not yet handling: " + tokenString);
                int widthWrap = this.theReader.getShortInt();
                int heightWrap = this.theReader.getShortInt();
                this.debugOutputLn(64, "val = " + widthWrap + ", " + heightWrap);
            } else if (tokenString.equals("TCTR")) {
                this.debugOutputLn(64, "Not yet handling: " + tokenString);
                this.textureCenter.x = this.theReader.getFloat();
                this.textureCenter.y = this.theReader.getFloat();
                this.textureCenter.z = this.theReader.getFloat();
                this.debugOutputLn(64, "val = " + this.textureCenter);
            } else if (tokenString.equals("TSIZ")) {
                this.debugOutputLn(64, "Not yet handling: " + tokenString);
                this.textureSize.x = this.theReader.getFloat();
                this.textureSize.y = this.theReader.getFloat();
                this.textureSize.z = this.theReader.getFloat();
                this.debugOutputLn(64, "val = " + this.textureSize);
            } else {
                this.debugOutputLn(64, "unrecognized token: " + tokenString);
                this.theReader.skipLength(fieldLength);
            }
            if (this.theReader.getMarker() >= surfStopMarker) continue;
            tokenString = this.theReader.getToken();
        }
    }
}

