/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import org.jogamp.java3d.loaders.IncorrectFormatException;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.LWOBFileReader;
import org.jogamp.java3d.loaders.lw3d.LwoSurface;
import org.jogamp.java3d.loaders.lw3d.ParserObject;
import org.jogamp.java3d.loaders.lw3d.ShapeHolder;

class LwoParser
extends ParserObject {
    LWOBFileReader theReader;
    int currLength;
    float[] coordsArray;
    float[] normalCoordsArray;
    int[] facetIndicesArray;
    int[] facetSizesArray;
    int[] normalIndicesArray;
    int red = 255;
    int green = 255;
    int blue = 255;
    float diffuse = 0.0f;
    float specular = 0.0f;
    float transparency = 0.0f;
    float luminosity = 0.0f;
    int gloss = 128;
    Vector surfNameList = null;
    Vector surfaceList = new Vector(200);
    Vector shapeList = new Vector(200);

    LwoParser(String fileName, int debugVals) throws FileNotFoundException {
        super(debugVals);
        this.debugOutputLn(1, "parser()");
        long start = System.currentTimeMillis();
        this.theReader = new LWOBFileReader(fileName);
        this.debugOutputLn(32, " file opened in " + (System.currentTimeMillis() - start));
        this.parseFile();
    }

    LwoParser(URL url, int debugVals) throws FileNotFoundException {
        super(debugVals);
        this.debugOutputLn(1, "parser()");
        try {
            long start = System.currentTimeMillis();
            this.theReader = new LWOBFileReader(url);
            this.debugOutputLn(32, " file opened in " + (System.currentTimeMillis() - start));
        }
        catch (IOException ex) {
            throw new FileNotFoundException(url.toString());
        }
        this.parseFile();
    }

    int skipDetailPolygons(int numPolys) throws ParsingErrorException {
        this.debugOutputLn(1, "skipDetailPolygons(), numPolys = " + numPolys);
        int lengthRead = 0;
        try {
            int polyNum = 0;
            while (polyNum < numPolys) {
                this.debugOutputLn(2, "polyNum = " + polyNum);
                int numVerts = this.theReader.getShortInt();
                this.theReader.skip(numVerts * 2 + 2);
                lengthRead += numVerts * 2 + 4;
                ++polyNum;
            }
        }
        catch (IOException e2) {
            this.debugOutputLn(16, "Exception in reading detail polys: " + e2);
            throw new ParsingErrorException(e2.getMessage());
        }
        return lengthRead;
    }

    ShapeHolder getAppropriateShape(int numSurf, int numVerts) {
        for (ShapeHolder shape : this.shapeList) {
            if (shape.numSurf != numSurf || shape.numVerts != numVerts && (shape.numVerts <= 3 || numVerts <= 3)) continue;
            return shape;
        }
        return null;
    }

    void getPols(int length) {
        this.debugOutputLn(1, "getPols(len), len = " + length);
        int lengthRead = 0;
        int prevNumVerts = -1;
        int prevNumSurf = 0;
        Vector<Integer> facetSizesList = new Vector<Integer>(length / 6);
        int[] facetIndicesArray = new int[length / 2];
        ShapeHolder shape = new ShapeHolder(this.debugPrinter.getValidOutput());
        this.debugOutputLn(2, "new shape = " + shape);
        shape.coordsArray = this.coordsArray;
        shape.facetSizesList = facetSizesList;
        shape.facetIndicesArray = facetIndicesArray;
        this.shapeList.addElement(shape);
        boolean firstTime = true;
        while (lengthRead < length) {
            int numVerts = this.theReader.getShortInt();
            lengthRead += 2;
            int[] intArray = new int[numVerts];
            int i2 = 0;
            while (i2 < numVerts) {
                intArray[i2] = this.theReader.getShortInt();
                lengthRead += 2;
                ++i2;
            }
            int numSurf = this.theReader.getShortInt();
            lengthRead += 2;
            long startTimeBuff = 0L;
            long startTimeList = 0L;
            if (!(firstTime || numSurf == prevNumSurf && (numVerts == prevNumVerts || prevNumVerts >= 3 && numVerts >= 3))) {
                shape = this.getAppropriateShape(numSurf, numVerts);
                if (shape == null) {
                    facetSizesList = new Vector<Integer>(length / 6);
                    facetIndicesArray = new int[length / 2];
                    shape = new ShapeHolder(this.debugPrinter.getValidOutput());
                    shape.coordsArray = this.coordsArray;
                    shape.facetSizesList = facetSizesList;
                    shape.facetIndicesArray = facetIndicesArray;
                    shape.numSurf = numSurf;
                    shape.numVerts = numVerts;
                    this.shapeList.addElement(shape);
                } else {
                    facetSizesList = shape.facetSizesList;
                    facetIndicesArray = shape.facetIndicesArray;
                }
            } else {
                shape.numSurf = numSurf;
                shape.numVerts = numVerts;
            }
            prevNumVerts = numVerts;
            prevNumSurf = numSurf;
            facetSizesList.addElement(new Integer(numVerts));
            boolean currPtr = false;
            System.arraycopy(intArray, 0, facetIndicesArray, shape.currentNumIndices, numVerts);
            shape.currentNumIndices += numVerts;
            if (numSurf < 0) {
                int numPolys = this.theReader.getShortInt();
                lengthRead += this.skipDetailPolygons(numPolys);
                shape.numSurf = ~shape.numSurf & 0xFFFF;
                if (shape.numSurf == 0) {
                    shape.numSurf = 1;
                }
            }
            firstTime = false;
        }
    }

    void getSrfs(int length) {
        String surfName = new String();
        this.surfNameList = new Vector(length / 2);
        boolean lengthRead = false;
        int stopMarker = this.theReader.getMarker() + length;
        boolean surfIndex = false;
        while (this.theReader.getMarker() < stopMarker) {
            this.debugOutputLn(2, "marker, stop = " + this.theReader.getMarker() + ", " + stopMarker);
            this.debugOutputLn(8, "About to call getString");
            surfName = this.theReader.getString();
            this.debugOutputLn(2, "Surfname = " + surfName);
            this.surfNameList.addElement(surfName);
        }
    }

    void getPnts(int length) throws ParsingErrorException {
        int numVerts = length / 12;
        this.coordsArray = new float[numVerts * 3];
        this.theReader.getVerts(this.coordsArray, numVerts);
    }

    void getSurf(int length) throws FileNotFoundException {
        this.debugOutputLn(1, "getSurf()");
        LwoSurface surf = new LwoSurface(this.theReader, length, this.debugPrinter.getValidOutput());
        this.surfaceList.addElement(surf);
    }

    int parseFile() throws FileNotFoundException, IncorrectFormatException {
        this.debugOutputLn(1, "parseFile()");
        int length = 0;
        int lengthRead = 0;
        int fileLength = 100000;
        long loopStartTime = System.currentTimeMillis();
        String tokenString = this.theReader.getToken();
        while (tokenString != null && lengthRead < fileLength) {
            long startTime = System.currentTimeMillis();
            length = this.theReader.getInt();
            lengthRead += 4;
            if (tokenString.equals("FORM")) {
                fileLength = length + 4;
                length = 0;
                tokenString = this.theReader.getToken();
                lengthRead += 4;
                if (!tokenString.equals("LWOB")) {
                    throw new IncorrectFormatException("File not of FORM-length-LWOB format");
                }
            } else if (tokenString.equals("PNTS")) {
                this.getPnts(length);
                this.debugOutputLn(32, "done with " + tokenString + " in " + (System.currentTimeMillis() - startTime));
            } else if (tokenString.equals("POLS")) {
                this.getPols(length);
                this.debugOutputLn(32, "done with " + tokenString + " in " + (System.currentTimeMillis() - startTime));
            } else if (tokenString.equals("SRFS")) {
                this.getSrfs(length);
                this.debugOutputLn(32, "done with " + tokenString + " in " + (System.currentTimeMillis() - startTime));
            } else if (tokenString.equals("CRVS")) {
                this.theReader.skipLength(length);
            } else if (tokenString.equals("PCHS")) {
                this.theReader.skipLength(length);
            } else if (tokenString.equals("SURF")) {
                this.getSurf(length);
                this.debugOutputLn(32, "done with " + tokenString + " in " + (System.currentTimeMillis() - startTime));
            } else if (!tokenString.equals("LWOB")) {
                this.theReader.skipLength(length);
            }
            if ((lengthRead += length) >= fileLength) continue;
            tokenString = this.theReader.getToken();
            lengthRead += 4;
        }
        this.debugOutputLn(32, "done with parseFile in " + (System.currentTimeMillis() - loopStartTime));
        return 0;
    }

    static void main(String[] args) {
        String fileName = args.length == 0 ? "cube.obj" : args[0];
        try {
            LwoParser lwoParser = new LwoParser(fileName, 0);
        }
        catch (FileNotFoundException e2) {
            System.err.println(e2.getMessage());
            e2.printStackTrace();
            System.exit(1);
        }
    }
}

