/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.audioengines;

import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.audioengines.AuralParameters;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class Sample {
    protected static final boolean debugFlag = false;
    protected static final boolean internalErrors = false;
    public static final int NULL_SAMPLE = -1;
    protected MediaContainer soundData = null;
    protected int soundType = -1;
    protected float gain = 1.0f;
    protected float rateScaleFactor = 1.0f;
    protected int loopCount = 0;
    public static final int DURATION_UNKNOWN = -1;
    protected long duration = -1L;
    protected int numberOfChannels = 0;
    protected boolean mute = false;
    protected Transform3D vworldXfrm = new Transform3D();
    protected boolean vwXfrmFlag = false;
    protected Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    protected double[] attenuationDistance = null;
    protected float[] attenuationGain = null;
    protected int dirtyFlags = 65535;
    protected Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
    protected double[] backAttenuationDistance = null;
    protected float[] backAttenuationGain = null;
    protected double[] angularDistance = new double[]{0.0, 1.5707963267948966};
    protected float[] angularGain = new float[]{1.0f, 0.0f};
    public static final int NO_FILTERING = -1;
    public static final int LOW_PASS = 1;
    protected int angularFilterType = -1;
    protected float[] angularFilterCutoff = new float[]{-1.0f, -1.0f};
    protected float obstructionGain = 1.0f;
    protected int obstructionFilterType = -1;
    protected float obstructionFilterCutoff = -1.0f;
    protected float occlusionGain = 1.0f;
    protected int occlusionFilterType = -1;
    protected float occlusionFilterCutoff = -1.0f;

    protected void debugPrint(String message) {
    }

    protected void debugPrintln(String message) {
    }

    public long getDuration() {
        return 0L;
    }

    public long getStartTime() {
        return 0L;
    }

    public int getNumberOfChannelsUsed() {
        return 0;
    }

    public void setDirtyFlags(int flags) {
        this.dirtyFlags = flags;
    }

    public int getDirtyFlags() {
        return this.dirtyFlags;
    }

    public void setSoundType(int type) {
        this.soundType = type;
    }

    public int getSoundType() {
        return this.soundType;
    }

    public void setSoundData(MediaContainer ref) {
        this.soundData = ref;
    }

    public MediaContainer getSoundData() {
        return this.soundData;
    }

    public void setMuteFlag(boolean flag) {
        this.mute = flag;
    }

    public boolean getMuteFlag() {
        return this.mute;
    }

    public void setVWrldXfrmFlag(boolean flag) {
        this.vwXfrmFlag = flag;
    }

    public boolean getVWrldXfrmFlag() {
        return this.vwXfrmFlag;
    }

    public void setGain(float scaleFactor) {
        this.gain = scaleFactor;
    }

    public float getGain() {
        return this.gain;
    }

    public void setLoopCount(int count) {
        this.loopCount = count;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setPosition(Point3d position) {
        this.position.set(position);
    }

    public void setDistanceGain(double[] frontDistance, float[] frontAttenuationScaleFactor, double[] backDistance, float[] backAttenuationScaleFactor) {
        int i2;
        int size;
        if (frontDistance != null) {
            size = frontDistance.length;
            this.attenuationDistance = new double[size];
            this.attenuationGain = new float[size];
            i2 = 0;
            while (i2 < size) {
                this.attenuationDistance[i2] = frontDistance[i2];
                this.attenuationGain[i2] = frontAttenuationScaleFactor[i2];
                ++i2;
            }
        } else {
            this.attenuationDistance = null;
            this.attenuationGain = null;
        }
        if (backDistance != null && frontDistance != null) {
            size = backDistance.length;
            this.backAttenuationDistance = new double[size];
            this.backAttenuationGain = new float[size];
            i2 = 0;
            while (i2 < size) {
                this.backAttenuationDistance[i2] = backDistance[i2];
                this.backAttenuationGain[i2] = backAttenuationScaleFactor[i2];
                ++i2;
            }
        } else {
            this.backAttenuationDistance = null;
            this.backAttenuationGain = null;
        }
    }

    public void setDirection(Vector3d direction) {
        this.direction.set(direction);
    }

    public void setAngularAttenuation(int filterType, double[] angle, float[] attenuationScaleFactor, float[] filterCutoff) {
        if (angle != null) {
            int size = angle.length;
            this.angularDistance = new double[size];
            this.angularGain = new float[size];
            this.angularFilterCutoff = (float[])(filterType != -1 && filterCutoff != null ? new float[size] : null);
            int i2 = 0;
            while (i2 < size) {
                this.angularDistance[i2] = angle[i2];
                this.angularGain[i2] = attenuationScaleFactor[i2];
                if (filterType != -1) {
                    this.angularFilterCutoff[i2] = filterCutoff[i2];
                }
                ++i2;
            }
            this.angularFilterType = filterType;
        } else {
            this.angularDistance = null;
            this.angularGain = null;
            this.angularFilterCutoff = null;
            this.angularFilterType = -1;
        }
    }

    public void setRateScaleFactor(float scaleFactor) {
        this.rateScaleFactor = scaleFactor;
    }

    public float getRateScaleFactor() {
        return this.rateScaleFactor;
    }

    public void setObstructionGain(float scaleFactor) {
        this.obstructionGain = scaleFactor;
    }

    public float getObstructionGain() {
        return this.obstructionGain;
    }

    public void setObstructionFilter(float cutoffFrequency) {
        this.obstructionFilterType = 1;
        this.obstructionFilterCutoff = cutoffFrequency;
    }

    public void setOcclusionGain(float scaleFactor) {
        this.occlusionGain = scaleFactor;
    }

    public float getOcclusionGain() {
        return this.occlusionGain;
    }

    public void setOcclusionFilter(float cutoffFrequency) {
        this.occlusionFilterType = 1;
        this.occlusionFilterCutoff = cutoffFrequency;
    }

    public void clear() {
        this.soundData = null;
        this.soundType = -1;
        this.gain = 1.0f;
        this.loopCount = 0;
        this.duration = -1L;
        this.numberOfChannels = 0;
        this.vworldXfrm.setIdentity();
        this.vwXfrmFlag = false;
        this.position.set(0.0f, 0.0f, 0.0f);
        this.attenuationDistance = null;
        this.attenuationGain = null;
        this.direction.set(0.0f, 0.0f, 1.0f);
        this.backAttenuationDistance = null;
        this.backAttenuationGain = null;
        if (this.angularDistance != null) {
            this.angularDistance[0] = 0.0;
            this.angularDistance[1] = 1.5707963705062866;
        }
        if (this.angularGain != null) {
            this.angularGain[0] = 1.0f;
            this.angularGain[1] = 0.0f;
        }
        this.angularFilterType = -1;
        if (this.angularFilterCutoff != null) {
            this.angularFilterCutoff[0] = -1.0f;
            this.angularFilterCutoff[1] = -1.0f;
        }
        this.obstructionGain = 1.0f;
        this.obstructionFilterType = -1;
        this.obstructionFilterCutoff = -1.0f;
        this.occlusionGain = 1.0f;
        this.occlusionFilterType = -1;
        this.occlusionFilterCutoff = -1.0f;
    }

    public void render(int dirtyFlags, View view, AuralParameters attribs) {
    }
}

