/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.WakeupOnElapsedTime;

class WakeupOnElapsedTimeHeap
implements Cloneable {
    WakeupOnElapsedTime[] data;
    int size = 0;

    WakeupOnElapsedTimeHeap(int initCapacity) {
        this.data = new WakeupOnElapsedTime[initCapacity + 1];
    }

    WakeupOnElapsedTimeHeap() {
        this(10);
    }

    final int size() {
        return this.size;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final WakeupOnElapsedTime getMin() {
        return this.data[1];
    }

    final void insert(WakeupOnElapsedTime key) {
        if (this.data.length == this.size + 1) {
            WakeupOnElapsedTime[] oldData = this.data;
            this.data = new WakeupOnElapsedTime[oldData.length << 1];
            System.arraycopy(oldData, 0, this.data, 0, oldData.length);
        }
        int i2 = ++this.size;
        int parentIdx = i2 >> 1;
        WakeupOnElapsedTime parentKey = this.data[parentIdx];
        long time = key.triggeredTime;
        while (i2 > 1 && parentKey.triggeredTime > time) {
            this.data[i2] = parentKey;
            i2 = parentIdx;
            parentKey = this.data[parentIdx >>= 1];
        }
        this.data[i2] = key;
    }

    final void extract(BehaviorRetained behav) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.data[i2].behav != behav) continue;
            this.extract(i2);
        }
    }

    final boolean extract(WakeupOnElapsedTime wakeup) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.data[i2] != wakeup) continue;
            this.extract(i2);
            return true;
        }
        return false;
    }

    final WakeupOnElapsedTime extractMin() {
        return this.extract(1);
    }

    final WakeupOnElapsedTime extract(int i2) {
        WakeupOnElapsedTime min = this.data[i2];
        this.data[i2] = this.data[this.size];
        this.data[this.size] = null;
        --this.size;
        while (true) {
            int l2 = i2 << 1;
            int r = l2 + 1;
            int smallest = l2 <= this.size && this.data[l2].triggeredTime < this.data[i2].triggeredTime ? l2 : i2;
            if (r <= this.size && this.data[r].triggeredTime < this.data[smallest].triggeredTime) {
                smallest = r;
            }
            if (smallest == i2) break;
            WakeupOnElapsedTime temp = this.data[smallest];
            this.data[smallest] = this.data[i2];
            this.data[i2] = temp;
            i2 = smallest;
        }
        return min;
    }

    final void trimToSize() {
        if (this.data.length > this.size + 1) {
            WakeupOnElapsedTime[] oldData = this.data;
            this.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(oldData, 0, this.data, 0, this.data.length);
        }
    }

    protected final Object clone() {
        try {
            WakeupOnElapsedTimeHeap heap = (WakeupOnElapsedTimeHeap)super.clone();
            heap.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(this.data, 0, heap.data, 0, this.size + 1);
            return heap;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[ ");
        if (this.size > 0) {
            sb.append(this.data[1]);
        }
        for (int i2 = 2; i2 <= this.size; ++i2) {
            sb.append("," + this.data[i2]);
        }
        sb.append(" ]");
        return sb.toString();
    }
}

