/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Vector;
import org.jogamp.java3d.BHLeafInterface;
import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.BehaviorStructure;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.MorphRetained;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.OrientedShape3DRetained;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SharedGroupRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupIndexedList;

public final class WakeupOnCollisionEntry
extends WakeupCriterion {
    static final int COND_IN_GS_LIST = 0;
    static final int COLLIDEENTRY_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    public static final int USE_GEOMETRY = 10;
    public static final int USE_BOUNDS = 11;
    static final int GROUP = 23;
    static final int BOUNDINGLEAF = 25;
    static final int SHAPE = 11;
    static final int MORPH = 10;
    static final int ORIENTEDSHAPE3D = 28;
    static final int BOUND = 0;
    int accuracyMode;
    NodeRetained armingNode;
    Bounds vwcBounds = null;
    BoundingLeafRetained boundingLeaf = null;
    UnorderList geometryAtoms = null;
    int nodeType;
    SceneGraphPath armingPath = null;
    Bounds armingBounds = null;
    Bounds collidingBounds = null;
    SceneGraphPath collidingPath = null;

    public WakeupOnCollisionEntry(SceneGraphPath armingPath) {
        this(armingPath, 11);
    }

    public WakeupOnCollisionEntry(SceneGraphPath armingPath, int speedHint) {
        this(new SceneGraphPath(armingPath), speedHint, null);
    }

    public WakeupOnCollisionEntry(Node armingNode) {
        this(armingNode, 11);
    }

    public WakeupOnCollisionEntry(Node armingNode, int speedHint) {
        this(new SceneGraphPath(null, armingNode), speedHint, null);
    }

    public WakeupOnCollisionEntry(Bounds armingBounds) {
        this(null, 11, (Bounds)armingBounds.clone());
    }

    WakeupOnCollisionEntry(SceneGraphPath armingPath, int speedHint, Bounds armingBounds) {
        if (armingPath != null) {
            this.armingNode = (NodeRetained)armingPath.getObject().retained;
            this.nodeType = WakeupOnCollisionEntry.getNodeType(this.armingNode, armingPath, "WakeupOnCollisionEntry");
            this.armingPath = armingPath;
            WakeupOnCollisionEntry.validateSpeedHint(speedHint, "WakeupOnCollisionEntry4");
        } else {
            this.armingBounds = armingBounds;
            this.nodeType = 0;
        }
        this.accuracyMode = speedHint;
        WakeupIndexedList.init(this, 2);
    }

    public SceneGraphPath getArmingPath() {
        return this.armingPath != null ? new SceneGraphPath(this.armingPath) : null;
    }

    public Bounds getArmingBounds() {
        return this.armingBounds != null ? (Bounds)this.armingBounds.clone() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SceneGraphPath getTriggeringPath() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry5"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry5"));
            }
        }
        return this.collidingPath != null ? new SceneGraphPath(this.collidingPath) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bounds getTriggeringBounds() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry6"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnCollisionEntry6"));
            }
        }
        return this.collidingBounds != null ? (Bounds)this.collidingBounds.clone() : null;
    }

    static int getNodeType(NodeRetained armingNode, SceneGraphPath armingPath, String s) throws IllegalArgumentException {
        if (!armingPath.validate()) {
            throw new IllegalArgumentException(J3dI18N.getString(s + "7"));
        }
        if (armingNode.inBackgroundGroup) {
            throw new IllegalArgumentException(J3dI18N.getString(s + "1"));
        }
        if (armingNode instanceof OrientedShape3DRetained) {
            return 28;
        }
        if (armingNode instanceof Shape3DRetained) {
            return 11;
        }
        if (armingNode instanceof MorphRetained) {
            return 10;
        }
        if (armingNode instanceof GroupRetained) {
            return 23;
        }
        if (armingNode instanceof BoundingLeafRetained) {
            return 25;
        }
        throw new IllegalArgumentException(J3dI18N.getString(s + "0"));
    }

    static void validateSpeedHint(int speedHint, String s) throws IllegalArgumentException {
        if (speedHint != 10 && speedHint != 11) {
            throw new IllegalArgumentException(J3dI18N.getString(s));
        }
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        switch (this.nodeType) {
            case 11: 
            case 28: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                Shape3DRetained shape = (Shape3DRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(shape.getMirrorShape(this.armingPath)));
                break;
            }
            case 10: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                MorphRetained morph = (MorphRetained)this.armingNode;
                this.geometryAtoms.add(Shape3DRetained.getGeomAtom(morph.getMirrorShape(this.armingPath)));
                break;
            }
            case 25: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                this.boundingLeaf = ((BoundingLeafRetained)this.armingNode).mirrorBoundingLeaf;
                break;
            }
            case 0: {
                this.vwcBounds = (Bounds)this.armingBounds.clone();
                this.armingNode = this.behav;
                break;
            }
            case 23: {
                if (!this.armingNode.source.isLive()) {
                    return;
                }
                if (this.accuracyMode != 10) break;
                if (this.geometryAtoms == null) {
                    this.geometryAtoms = new UnorderList(1, GeometryAtom.class);
                }
                ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
            }
        }
        this.behav.universe.geometryStructure.addWakeupOnCollision(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        this.vwcBounds = null;
        if (this.geometryAtoms != null) {
            this.geometryAtoms.clear();
        }
        this.boundingLeaf = null;
        this.behav.universe.geometryStructure.removeWakeupOnCollision(this);
    }

    void setTarget(BHLeafInterface leaf) {
        Bounds bound;
        SceneGraphPath path;
        if (leaf instanceof GeometryAtom) {
            GeometryAtom geomAtom = (GeometryAtom)leaf;
            Shape3DRetained shape = geomAtom.source;
            path = WakeupOnCollisionEntry.getSceneGraphPath(shape.sourceNode, shape.key, shape.getCurrentLocalToVworld(0));
            bound = WakeupOnCollisionEntry.getTriggeringBounds(shape);
        } else {
            GroupRetained group = (GroupRetained)leaf;
            path = WakeupOnCollisionEntry.getSceneGraphPath(group);
            bound = WakeupOnCollisionEntry.getTriggeringBounds(group);
        }
        if (path != null) {
            this.collidingPath = path;
            this.collidingBounds = bound;
        }
    }

    void updateCollisionBounds(boolean reEvaluateGAs) {
        if (this.nodeType == 23) {
            GroupRetained group = (GroupRetained)this.armingNode;
            this.vwcBounds = group.collisionBound != null ? (Bounds)group.collisionBound.clone() : group.getEffectiveBounds();
            group.transformBounds(this.armingPath, this.vwcBounds);
        } else if (this.nodeType == 0) {
            this.vwcBounds.transform(this.armingBounds, this.behav.getCurrentLocalToVworld());
        }
        if (reEvaluateGAs && this.nodeType == 23 && this.accuracyMode == 10) {
            this.geometryAtoms.clear();
            ((GroupRetained)this.armingNode).searchGeometryAtoms(this.geometryAtoms);
        }
    }

    static Bounds getTriggeringBounds(Shape3DRetained mirrorShape) {
        NodeRetained node = mirrorShape.sourceNode;
        if (node instanceof Shape3DRetained) {
            Shape3DRetained shape = (Shape3DRetained)node;
            if (shape.collisionBound == null) {
                return shape.getEffectiveBounds();
            }
            return shape.collisionBound;
        }
        MorphRetained morph = (MorphRetained)node;
        if (morph.collisionBound == null) {
            return morph.getEffectiveBounds();
        }
        return morph.collisionBound;
    }

    static Bounds getTriggeringBounds(GroupRetained group) {
        if (group.collisionBound == null) {
            return group.getEffectiveBounds();
        }
        return group.collisionBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath getSceneGraphPath(GroupRetained group) {
        Transform3D transform = null;
        GroupRetained srcGroup = group.sourceNode;
        Object object = srcGroup.universe.sceneGraphLock;
        synchronized (object) {
            if (group.key == null) {
                transform = srcGroup.getCurrentLocalToVworld();
            } else {
                HashKey[] keys = srcGroup.localToVworldKeys;
                if (keys == null) {
                    return null;
                }
                transform = srcGroup.getCurrentLocalToVworld(group.key);
            }
            return WakeupOnCollisionEntry.getSceneGraphPath(srcGroup, group.key, transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SceneGraphPath getSceneGraphPath(NodeRetained startNode, HashKey key, Transform3D transform) {
        Object object = startNode.universe.sceneGraphLock;
        synchronized (object) {
            NodeRetained target = startNode;
            UnorderList path = new UnorderList(5, Node.class);
            NodeRetained nodeR = target;
            Locale locale = nodeR.locale;
            if (nodeR.inSharedGroup) {
                key = key != null ? new HashKey(key) : new HashKey(startNode.localToVworldKeys[0]);
            }
            do {
                if (nodeR.source.getCapability(0)) {
                    path.add(nodeR.source);
                }
                if (nodeR instanceof SharedGroupRetained) {
                    String nodeId = key.getLastNodeId();
                    Vector<NodeRetained> parents = ((SharedGroupRetained)nodeR).parents;
                    NodeRetained prevNodeR = nodeR;
                    for (int i2 = parents.size() - 1; i2 >= 0; --i2) {
                        NodeRetained linkR = parents.get(i2);
                        if (!linkR.nodeId.equals(nodeId)) continue;
                        nodeR = linkR;
                        break;
                    }
                    if (nodeR != prevNodeR) continue;
                    return null;
                }
                if (!(nodeR instanceof GroupRetained) || !((GroupRetained)nodeR).collisionTarget) continue;
                target = nodeR;
                transform = key == null ? nodeR.getCurrentLocalToVworld(null) : nodeR.getCurrentLocalToVworld(key);
            } while ((nodeR = nodeR.parent) != null);
            Node[] nodes = target == startNode ? (Node[])path.toArray(false) : (Node[])path.toArray(target);
            SceneGraphPath sgpath = new SceneGraphPath(locale, nodes, (Node)target.source);
            sgpath.setTransform(transform);
            return sgpath;
        }
    }

    @Override
    void setTriggered() {
        if (this.collidingPath != null) {
            super.setTriggered();
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
    }
}

