/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Hashtable;
import org.jogamp.java3d.CapabilityNotSetException;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.TextureUnitStateRetained;

public class TextureUnitState
extends NodeComponent {
    public static final int ALLOW_STATE_READ = 0;
    public static final int ALLOW_STATE_WRITE = 1;
    private static final int[] readCapabilities = new int[]{0};

    public TextureUnitState() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public TextureUnitState(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        this.setDefaultReadCapabilities(readCapabilities);
        ((TextureUnitStateRetained)this.retained).initTexture(texture);
        ((TextureUnitStateRetained)this.retained).initTextureAttributes(textureAttributes);
        ((TextureUnitStateRetained)this.retained).initTexCoordGeneration(texCoordGeneration);
    }

    @Override
    void createRetained() {
        this.retained = new TextureUnitStateRetained();
        this.retained.setSource(this);
    }

    public void set(Texture texture, TextureAttributes textureAttributes, TexCoordGeneration texCoordGeneration) {
        TextureRetained texRetained;
        ImageComponent[] images;
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState0"));
        }
        if (texture != null && (images = (texRetained = (TextureRetained)texture.retained).getImages()) != null) {
            for (int i2 = 0; i2 < images.length; ++i2) {
                this.validateImageIllegalSharing(images[i2]);
            }
        }
        ((TextureUnitStateRetained)this.retained).setTextureUnitState(texture, textureAttributes, texCoordGeneration);
    }

    public void setTexture(Texture texture) {
        TextureRetained texRetained;
        ImageComponent[] images;
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState0"));
        }
        if (texture != null && (images = (texRetained = (TextureRetained)texture.retained).getImages()) != null) {
            for (int i2 = 0; i2 < images.length; ++i2) {
                this.validateImageIllegalSharing(images[i2]);
            }
        }
        ((TextureUnitStateRetained)this.retained).setTexture(texture);
    }

    public Texture getTexture() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState1"));
        }
        return ((TextureUnitStateRetained)this.retained).getTexture();
    }

    public void setTextureAttributes(TextureAttributes textureAttributes) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState2"));
        }
        ((TextureUnitStateRetained)this.retained).setTextureAttributes(textureAttributes);
    }

    public TextureAttributes getTextureAttributes() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState3"));
        }
        return ((TextureUnitStateRetained)this.retained).getTextureAttributes();
    }

    public void setTexCoordGeneration(TexCoordGeneration texCoordGeneration) {
        if (this.isLiveOrCompiled() && !this.getCapability(1)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState4"));
        }
        ((TextureUnitStateRetained)this.retained).setTexCoordGeneration(texCoordGeneration);
    }

    public TexCoordGeneration getTexCoordGeneration() {
        if (this.isLiveOrCompiled() && !this.getCapability(0)) {
            throw new CapabilityNotSetException(J3dI18N.getString("TextureUnitState5"));
        }
        return ((TextureUnitStateRetained)this.retained).getTexCoordGeneration();
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        TextureUnitState ts = new TextureUnitState();
        ts.duplicateNodeComponent(this);
        return ts;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        Hashtable hashtable = originalNodeComponent.nodeHashtable;
        TextureUnitStateRetained app = (TextureUnitStateRetained)originalNodeComponent.retained;
        TextureUnitStateRetained rt = (TextureUnitStateRetained)this.retained;
        rt.setTexture((Texture)this.getNodeComponent(app.getTexture(), forceDuplicate, hashtable));
        rt.setTextureAttributes((TextureAttributes)this.getNodeComponent(app.getTextureAttributes(), forceDuplicate, hashtable));
        rt.setTexCoordGeneration((TexCoordGeneration)this.getNodeComponent(app.getTexCoordGeneration(), forceDuplicate, hashtable));
    }

    @Override
    boolean duplicateChild() {
        if (this.getDuplicateOnCloneTree()) {
            return true;
        }
        TextureUnitStateRetained rt = (TextureUnitStateRetained)this.retained;
        NodeComponent nc = rt.getTexture();
        if (nc != null && nc.duplicateChild()) {
            return true;
        }
        nc = rt.getTextureAttributes();
        if (nc != null && nc.getDuplicateOnCloneTree()) {
            return true;
        }
        nc = rt.getTexCoordGeneration();
        return nc != null && nc.getDuplicateOnCloneTree();
    }
}

